/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkMonitor
extends HttpServlet {
    private static boolean collectStats = true;
    private static HashMap<String, NetworkMonitor> stats = new HashMap();
    int maxHistory = 600;
    LinkedList<StatsData> history = new LinkedList();
    float throughput;
    float totalResponseTime;

    public static boolean isCollectStats() {
        return collectStats;
    }

    public static void setCollectStats(boolean aCollectStats) {
        collectStats = aCollectStats;
    }

    public static Set<String> getInstanceNames() {
        return stats.keySet();
    }

    public static NetworkMonitor getInstance(String name) {
        NetworkMonitor answer = stats.get(name = name.toLowerCase());
        if (answer == null) {
            answer = new NetworkMonitor();
            stats.put(name, answer);
        }
        return answer;
    }

    public long start() {
        if (!NetworkMonitor.isCollectStats()) {
            return 0L;
        }
        return System.currentTimeMillis();
    }

    public synchronized void end(long start) {
        if (NetworkMonitor.isCollectStats()) {
            long rs = 0L;
            this.throughput += 1.0f;
            if (start != 0L) {
                rs = System.currentTimeMillis() - start;
                this.totalResponseTime += (float)rs;
            }
            StatsData sd = this.getNewStats(rs);
            if (this.history.isEmpty()) {
                this.history.addLast(sd);
            } else {
                StatsData hsd = this.history.getLast();
                if (hsd != null && hsd.equals(sd)) {
                    hsd.updateStatsData(sd);
                } else {
                    if (hsd != null) {
                        long hsdTime = hsd.getTime();
                        while (hsdTime < sd.getTime() - 1L) {
                            this.history.addLast(new StatsData(hsdTime++));
                        }
                    }
                    this.history.addLast(sd);
                    while (this.history.size() > this.maxHistory) {
                        this.history.removeFirst();
                    }
                }
            }
        }
    }

    public void reset() {
        this.throughput = 0.0f;
        this.totalResponseTime = 0.0f;
    }

    private StatsData getNewStats(long responsetime) {
        long currentTime = System.currentTimeMillis();
        long seconds = currentTime / 1000L;
        StatsData sd = new StatsData(seconds);
        sd.addResponseTimes(responsetime);
        return sd;
    }

    public float[] getHistoryResponseTime() {
        float[] rs = null;
        if (this.history.isEmpty()) {
            rs = new float[]{0.0f};
        } else {
            int size = this.history.size();
            rs = new float[size];
            for (StatsData s : this.history) {
                rs[size - 1] = s.getCount() == 0L ? (float)s.getResponseTimes() : (float)s.getResponseTimes() / (float)s.getCount();
                --size;
            }
        }
        return rs;
    }

    public float[] getHistoryThroughput() {
        float[] rs = null;
        if (this.history.isEmpty()) {
            rs = new float[]{0.0f};
        } else {
            int size = this.history.size();
            rs = new float[size];
            for (StatsData s : this.history) {
                rs[size - 1] = s.getCount();
                --size;
            }
        }
        return rs;
    }

    public float responseTime() {
        if (this.throughput > 0.0f) {
            return this.totalResponseTime / this.throughput;
        }
        return 0.0f;
    }

    public float getLastHistoryResponseTime() {
        StatsData sd = this.history.getLast();
        if (sd != null) {
            float ans = sd.getResponseTimes();
            return ans / (float)sd.getCount();
        }
        return 0.0f;
    }

    public float throughput() {
        return this.throughput;
    }

    public float getLastHistoryThroughput() {
        StatsData sd = this.history.getLast();
        if (sd != null) {
            return sd.getCount();
        }
        return 0.0f;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        NetworkMonitor sm = null;
        String path = req.getRequestURI();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        path = path.substring(path.lastIndexOf(47) + 1).toLowerCase();
        PrintWriter writer = res.getWriter();
        res.setHeader("content-type", "text/html");
        if (path != null && path.endsWith("entitlementmonitor")) {
            ((Writer)writer).write(stats.keySet().toString());
        } else {
            sm = stats.get(path);
            if (sm != null) {
                float[] rs = sm.getHistoryResponseTime();
                float[] th = sm.getHistoryThroughput();
                ((Writer)writer).write(path);
                ((Writer)writer).write("<br>responsetime=[");
                for (float f : rs) {
                    ((Writer)writer).write(Float.toString(f));
                    ((Writer)writer).write(44);
                }
                ((Writer)writer).write("]<br>throughput=[");
                for (float f : th) {
                    ((Writer)writer).write(Float.toString(f));
                    ((Writer)writer).write(44);
                }
                ((Writer)writer).write(93);
            } else {
                ((Writer)writer).write("Unknow StatsMonitor: " + path);
            }
        }
    }

    public class StatsData {
        private String time;
        private long seconds;
        private long responseTimes;
        private long count;

        protected StatsData(long seconds) {
            this.seconds = seconds;
            this.time = Long.toString(seconds);
        }

        public boolean updateStatsData(StatsData s) {
            if (this.time.equals(s.time)) {
                this.responseTimes += s.responseTimes;
                this.count += s.count;
                return true;
            }
            return false;
        }

        public long getResponseTimes() {
            return this.responseTimes;
        }

        public void addResponseTimes(long responseTimes) {
            this.responseTimes += responseTimes;
            ++this.count;
        }

        public long getCount() {
            return this.count;
        }

        public long getTime() {
            return this.seconds;
        }

        public boolean equals(Object o) {
            if (o instanceof StatsData) {
                StatsData s = (StatsData)o;
                return s.time.equals(this.time);
            }
            return false;
        }

        public int hashCode() {
            return this.time.hashCode();
        }
    }
}

