/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.client;

import com.iplanet.services.comm.client.NotificationHandler;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.share.NotificationSet;
import com.iplanet.services.comm.share.PLLBundle;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.common.RequestUtils;
import com.sun.identity.shared.locale.L10NMessageImpl;
import java.io.IOException;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PLLNotificationServlet
extends HttpServlet {
    public void init() throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            RequestUtils.checkContentLength(request);
        }
        catch (L10NMessageImpl e) {
            ISLocaleContext localeContext = new ISLocaleContext();
            localeContext.setLocale(request);
            Locale locale = localeContext.getLocale();
            throw new ServletException(e.getL10NMessage(locale));
        }
        int length = request.getContentLength();
        if (length == -1) {
            throw new ServletException(PLLBundle.getString("unknownLength"));
        }
        byte[] reqData = new byte[length];
        ServletInputStream in = request.getInputStream();
        int rlength = 0;
        int offset = 0;
        while (rlength != length) {
            int r = in.read(reqData, offset, length - offset);
            if (r == -1) {
                throw new ServletException(PLLBundle.getString("readRequestError"));
            }
            rlength += r;
            offset += r;
        }
        String xml = new String(reqData, 0, length, "UTF-8");
        ServletOutputStream out = response.getOutputStream();
        try {
            try {
                this.handleNotification(xml);
                out.print("OK");
            }
            catch (ServletException e) {
                out.print("NOT OK");
            }
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream out = response.getOutputStream();
        out.print("OpenSSO");
        out.flush();
    }

    private void handleNotification(String notificationXML) throws ServletException {
        NotificationSet set = NotificationSet.parseXML(notificationXML);
        Vector nots = set.getNotifications();
        if (nots.size() != 0) {
            String serviceid = set.getServiceID();
            NotificationHandler ns = PLLClient.getNotificationHandler(serviceid);
            if (ns == null) {
                throw new ServletException(PLLBundle.getString("noNotificationHandler") + serviceid);
            }
            ns.process(nots);
        }
    }
}

