/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.UI;

import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.common.RequestUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.L10NMessageImpl;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoginLogoutMapping
extends HttpServlet {
    private static boolean isProductInitialize = false;
    private static final String bundleName = "amAuthUI";
    private static final String CANNOT_INIT_AUTH = "cannotInitAuth";
    ServletConfig config = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
        this.init(config.getServletContext());
    }

    public void init(ServletContext servletCtx) throws ServletException {
        boolean initialized;
        if (isProductInitialize && !(initialized = this.initializeAuth(servletCtx))) {
            Locale locale = Locale.getDefault();
            ResourceBundle rb = ResourceBundle.getBundle(bundleName, locale);
            throw new ServletException(rb.getString(CANNOT_INIT_AUTH));
        }
    }

    public static void setProductInitialized(boolean initialized) {
        isProductInitialize = initialized;
    }

    public boolean initializeAuth(ServletContext servletCtx) {
        AuthD authD = AuthD.getAuth();
        if (authD == null) {
            return false;
        }
        authD.setServletContext(servletCtx);
        if (Debug.getInstance((String)"amLoginLogoutMapping").messageEnabled()) {
            Debug.getInstance((String)"amLoginLogoutMapping").message("LoginLogoutMapping.initializeAuth: Initializing AdminTokenAction to use AuthN");
        }
        AdminTokenAction.getInstance().authenticationInitialized();
        return true;
    }

    public void destroy() {
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            RequestUtils.checkContentLength(request);
        }
        catch (L10NMessageImpl e) {
            ISLocaleContext localeContext = new ISLocaleContext();
            localeContext.setLocale(request);
            Locale locale = localeContext.getLocale();
            if (Debug.getInstance((String)"amLoginLogoutMapping").messageEnabled()) {
                Debug.getInstance((String)"amLoginLogoutMapping").message("LoginLogoutMapping: " + e.getL10NMessage(locale));
            }
            throw new ServletException(e.getL10NMessage(locale));
        }
        String servletPath = request.getServletPath();
        String forwardUrl = "";
        if (servletPath.equals("/login")) {
            forwardUrl = "/UI/Login";
        } else if (servletPath.equals("/logout")) {
            forwardUrl = "/UI/Logout";
        }
        RequestDispatcher dispatcher = this.config.getServletContext().getRequestDispatcher(forwardUrl);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }
}

