/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.share;

import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class RequestSetParser {
    private Document document;
    protected static Debug debug = Debug.getInstance((String)"amComm");

    public RequestSetParser(Document xmlDoc) {
        this.document = xmlDoc;
    }

    public RequestSetParser(String xmlString) {
        this.document = XMLUtils.toDOMDocument((String)xmlString, (Debug)debug);
    }

    public RequestSet parseXML() {
        if (this.document == null) {
            return null;
        }
        Element reqSetElem = this.document.getDocumentElement();
        RequestSet reqSet = new RequestSet();
        this.setRequestSetAttributes(reqSetElem, reqSet);
        NodeList requests = reqSetElem.getElementsByTagName("Request");
        if (requests == null) {
            return reqSet;
        }
        int nodeLen = requests.getLength();
        for (int i = 0; i < nodeLen; ++i) {
            reqSet.addRequest(this.parseRequestElement((Element)requests.item(i)));
        }
        return reqSet;
    }

    private void setRequestSetAttributes(Element elem, RequestSet requestSet) {
        String temp = elem.getAttribute("vers");
        if (temp != null) {
            requestSet.setRequestSetVersion(temp);
        }
        if ((temp = elem.getAttribute("svcid")) != null) {
            requestSet.setServiceID(temp);
        }
        if ((temp = elem.getAttribute("reqid")) != null) {
            requestSet.setRequestSetID(temp);
        }
    }

    private Request parseRequestElement(Element elem) {
        Node text;
        Request req = new Request();
        String temp = elem.getAttribute("dtdid");
        if (temp != null) {
            req.setDtdID(temp);
        }
        if ((temp = elem.getAttribute("sid")) != null) {
            req.setSessionID(temp);
        }
        if ((text = elem.getFirstChild()) != null) {
            req.setContent(text.getNodeValue());
        }
        return req;
    }
}

