/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.providers.dpro.SSOProviderImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Map;

public class CLILogin {
    String host = null;
    String domain = null;
    String userId = null;
    String passwd = null;
    String gotoUrl = "console";
    String protocol = "http";
    String cookie = null;
    String cookieValue = null;
    SSOToken ssotoken = null;

    public CLILogin(String host, String domain, String userId, String passwd) {
        this.host = host;
        this.domain = domain;
        this.userId = userId;
        this.passwd = passwd;
    }

    public boolean isLoggedIn() {
        return this.isSessionValid();
    }

    public String getSessionId() {
        return this.cookieValue;
    }

    public SSOToken getToken() {
        return this.ssotoken;
    }

    public boolean isSessionValid() {
        return this.validateSession(this.cookieValue);
    }

    public String getURL(URL url) {
        String str = null;
        try {
            str = CLILogin.urlAccess(url, this.cookie, true);
        }
        catch (Exception e) {
            System.out.println("Exception in getURL");
        }
        return str;
    }

    public Map getCookies() {
        return null;
    }

    public void logout() {
        try {
            if (this.ssotoken != null) {
                SSOProviderImpl manager = new SSOProviderImpl();
                manager.destroyToken(this.ssotoken);
            }
            this.cookieValue = null;
            this.ssotoken = null;
            this.cookie = null;
        }
        catch (SSOException e) {
            System.out.println(e.getMessage());
        }
    }

    public boolean login() {
        if (this.host == null || this.domain == null || this.userId == null || this.passwd == null) {
            return false;
        }
        boolean loggedin = false;
        try {
            URL url = new URL(this.protocol + "://" + this.host + "/login/LDAP?goto=" + this.gotoUrl);
            this.cookie = CLILogin.getCookie(url);
            int index = this.cookie.indexOf("=");
            int index1 = this.cookie.indexOf(";");
            this.cookieValue = this.cookie.substring(index + 1, index1);
            if (this.cookieValue == null) {
                return false;
            }
            System.out.println("Cookie = " + this.cookie);
            System.out.println("CookieVal = " + this.cookieValue);
            url = new URL(this.protocol + "://" + this.host + "/login/LDAP");
            CLILogin.authenticate(url, this.cookie, this.userId, this.passwd);
            System.out.println("===== validate session after authenticate ===");
            this.cookieValue = CLILogin.convertCookie(this.cookieValue);
            loggedin = this.isSessionValid();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (!loggedin) {
            this.logout();
        }
        return loggedin;
    }

    private boolean validateSession(String cookieValue) {
        if (cookieValue == null) {
            return false;
        }
        try {
            SSOProviderImpl manager = new SSOProviderImpl();
            this.ssotoken = manager.createSSOToken(cookieValue);
            if (manager.isValidToken(this.ssotoken)) {
                System.out.println("Valid session for " + this.ssotoken.getProperty("Principal"));
                return true;
            }
            System.out.println("Invalid session");
            return false;
        }
        catch (SSOException e) {
            System.out.println(e.getMessage());
            return false;
        }
    }

    private static String getCookie(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        String cookie = connection.getHeaderField("Set-cookie");
        if (cookie == null) {
            System.out.println("No cookies in HTTP request, server down ?" + url);
            return null;
        }
        connection.disconnect();
        return cookie;
    }

    private static void authenticate(URL url, String cookie, String userName, String passWord) throws IOException, ProtocolException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Cookie", cookie);
        HttpURLConnection.setFollowRedirects(false);
        PrintWriter out = new PrintWriter(connection.getOutputStream());
        out.print("TOKEN0=" + userName + "&TOKEN1=" + passWord);
        out.close();
        new BufferedReader(new InputStreamReader(connection.getInputStream()));
    }

    private static String urlAccess(URL url, String cookie, boolean print) throws IOException, ProtocolException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Cookie", cookie);
        String strOutput = null;
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        if (print) {
            int len;
            StringBuffer in_buf = new StringBuffer();
            char[] buf = new char[1024];
            while ((len = in.read(buf, 0, buf.length)) != -1) {
                in_buf.append(buf, 0, len);
            }
            strOutput = in_buf.toString();
            System.out.print(strOutput);
        }
        return strOutput;
    }

    private static String convertCookie(String cookie) {
        int temp;
        while ((temp = cookie.indexOf("%25")) != -1) {
            String newCookie;
            cookie = newCookie = cookie.substring(0, temp) + "%" + cookie.substring(temp + 3);
        }
        return cookie;
    }
}

