/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.configuration;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.FQDNUrl;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AgentConfiguration {
    public static final String AGENT_TYPE_J2EE = "J2EEAgent";
    public static final String AGENT_TYPE_WEB = "WebAgent";
    public static final String AGENT_TYPE_2_DOT_2_AGENT = "2.2_Agent";
    public static final String AGENT_TYPE_AGENT_AUTHENTICATOR = "SharedAgent";
    public static final String ATTR_NAME_PWD = "userpassword";
    public static final String ATTR_NAME_FREE_FORM = "com.sun.identity.agents.config.freeformproperties";
    public static final String ATTR_CONFIG_REPO = "com.sun.identity.agents.config.repository.location";
    public static final String VAL_CONFIG_REPO_LOCAL = "local";
    public static final String AGENT_ROOT_URL = "agentRootURL=";
    public static String DEVICE_KEY = "sunIdentityServerDeviceKeyValue";
    private static final String AGENT_LOCAL_PROPERTIES = "agentlocaleprop";
    private static Map localAgentProperties;
    private static final Pattern patternArray;

    private AgentConfiguration() {
    }

    public static Set getAgentTypes() throws SMSException, SSOException {
        Set names;
        HashSet agentTypes = new HashSet();
        ServiceSchema ss = AgentConfiguration.getOrganizationSchema();
        if (ss != null && (names = ss.getSubSchemaNames()) != null && !names.isEmpty()) {
            agentTypes.addAll(names);
        }
        return agentTypes;
    }

    private static void validateAgentType(String type) throws ConfigurationException {
        AgentConfiguration.validateAgentType(type, false);
    }

    private static void validateAgentType(String type, boolean isGroup) throws ConfigurationException {
        try {
            Set types = AgentConfiguration.getAgentTypes();
            if (isGroup) {
                types.remove(AGENT_TYPE_2_DOT_2_AGENT);
            }
            if (!types.contains(type)) {
                Object[] param = new Object[]{type};
                throw new ConfigurationException("agent.invalid.type", param);
            }
        }
        catch (SMSException e) {
            throw new ConfigurationException(e.getMessage());
        }
        catch (SSOException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    public static void createAgentGroup(SSOToken ssoToken, String realm, String agentGroupName, String agentType, Map attrValues) throws IdRepoException, SSOException, SMSException, ConfigurationException {
        AgentConfiguration.createAgentGroupEx(ssoToken, realm, agentGroupName, agentType, attrValues, null, null);
    }

    public static void createAgentGroup(SSOToken ssoToken, String realm, String agentGroupName, String agentType, Map attrValues, String serverURL, String agentURL) throws IdRepoException, SSOException, SMSException, MalformedURLException, ConfigurationException {
        if (serverURL == null || serverURL.trim().length() == 0) {
            throw new ConfigurationException("create.agent.invalid.server.url", null);
        }
        FQDNUrl urlAgent = null;
        if (agentURL != null && agentURL.trim().length() > 0) {
            urlAgent = new FQDNUrl(agentURL);
        }
        AgentConfiguration.createAgentGroupEx(ssoToken, realm, agentGroupName, agentType, attrValues, new FQDNUrl(serverURL), urlAgent);
    }

    private static void createAgentGroupEx(SSOToken ssoToken, String realm, String agentGroupName, String agentType, Map attrValues, FQDNUrl serverURL, FQDNUrl agentURL) throws IdRepoException, SSOException, SMSException, ConfigurationException {
        if (agentGroupName == null || agentGroupName.trim().length() == 0) {
            throw new ConfigurationException("create.agent.group.missing.name", null);
        }
        AgentConfiguration.validateAgentType(agentType, true);
        AMIdentityRepository amir = new AMIdentityRepository(ssoToken, realm);
        Map attributeValues = AgentConfiguration.parseAttributeMap(agentType, attrValues);
        if (attributeValues.containsKey(ATTR_NAME_PWD)) {
            throw new ConfigurationException("create.agent.group.cannot.have.password", null);
        }
        HashSet<String> setAgentType = new HashSet<String>(2);
        setAgentType.add(agentType);
        attributeValues.put("AgentType", setAgentType);
        Map inheritedValues = AgentConfiguration.getDefaultValues(agentType, true);
        inheritedValues.putAll(attributeValues);
        if (serverURL != null || agentURL != null) {
            AgentConfiguration.tagswapAttributeValues(inheritedValues, agentType, serverURL, agentURL);
        }
        amir.createIdentity(IdType.AGENTGROUP, agentGroupName, inheritedValues);
    }

    public static void createAgent(SSOToken ssoToken, String realm, String agentName, String agentType, Map attrValues, String serverURL, String agentURL) throws IdRepoException, SSOException, SMSException, MalformedURLException, ConfigurationException {
        if (serverURL == null || serverURL.trim().length() == 0) {
            throw new ConfigurationException("create.agent.invalid.server.url", null);
        }
        if (agentURL == null || agentURL.trim().length() == 0) {
            throw new ConfigurationException("create.agent.invalid.agent.url", null);
        }
        AgentConfiguration.createAgentEx(ssoToken, realm, agentName, agentType, attrValues, new FQDNUrl(serverURL), new FQDNUrl(agentURL));
    }

    public static void createAgentLocal(SSOToken ssoToken, String realm, String agentName, String agentType, Map attrValues, String agentURL) throws IdRepoException, SSOException, SMSException, MalformedURLException, ConfigurationException {
        if (agentURL == null || agentURL.trim().length() == 0) {
            throw new ConfigurationException("create.agent.invalid.agent.url", null);
        }
        AgentConfiguration.createAgentEx(ssoToken, realm, agentName, agentType, attrValues, null, new FQDNUrl(agentURL));
    }

    public static void createAgent(SSOToken ssoToken, String realm, String agentName, String agentType, Map attrValues) throws IdRepoException, SSOException, SMSException, ConfigurationException {
        AgentConfiguration.createAgentEx(ssoToken, realm, agentName, agentType, attrValues, null, null);
    }

    private static void createAgentEx(SSOToken ssoToken, String realm, String agentName, String agentType, Map attrValues, FQDNUrl serverURL, FQDNUrl agentURL) throws IdRepoException, SSOException, SMSException, ConfigurationException {
        HashMap<String, String> map;
        if (agentName == null || agentName.trim().length() == 0) {
            throw new ConfigurationException("create.agent.missing.name", null);
        }
        AgentConfiguration.validateAgentType(agentType);
        AMIdentityRepository amir = new AMIdentityRepository(ssoToken, realm);
        Map attributeValues = AgentConfiguration.parseAttributeMap(agentType, attrValues);
        HashSet<String> setAgentType = new HashSet<String>(2);
        setAgentType.add(agentType);
        attributeValues.put("AgentType", setAgentType);
        Map inheritedValues = AgentConfiguration.getDefaultValues(agentType, false);
        inheritedValues.putAll(attributeValues);
        if (serverURL == null) {
            map = new HashMap<String, String>(2);
            map.put("SERVER_PORT", "80");
            AgentConfiguration.tagswapAttributeValues(attributeValues, map);
        }
        if (agentURL == null) {
            map = new HashMap(2);
            map.put("AGENT_PORT", "80");
            AgentConfiguration.tagswapAttributeValues(attributeValues, map);
        }
        if (serverURL != null || agentURL != null) {
            AgentConfiguration.tagswapAttributeValues(inheritedValues, agentType, serverURL, agentURL);
        }
        amir.createIdentity(IdType.AGENTONLY, agentName, inheritedValues);
    }

    private static void addAgentRootURLKey(String agentType, Map map) throws ConfigurationException {
        Set values;
        if ((agentType.equals(AGENT_TYPE_J2EE) || agentType.equals(AGENT_TYPE_WEB) || agentType.equals(AGENT_TYPE_AGENT_AUTHENTICATOR)) && (values = (Set)map.get(DEVICE_KEY)) != null && !values.isEmpty()) {
            HashSet<String> newValues = new HashSet<String>();
            Iterator i = values.iterator();
            while (i.hasNext()) {
                String val = AGENT_ROOT_URL + (String)i.next();
                AgentConfiguration.validateAgentRootURL(val);
                newValues.add(val);
            }
            map.put(DEVICE_KEY, newValues);
        }
    }

    public static void validateAgentRootURLs(Map map) throws ConfigurationException {
        if (map == null) {
            return;
        }
        Set values = (Set)map.get(DEVICE_KEY);
        if (values != null && !values.isEmpty()) {
            Iterator i = values.iterator();
            while (i.hasNext()) {
                AgentConfiguration.validateAgentRootURL((String)i.next());
            }
        }
    }

    private static void validateAgentRootURL(String value) throws ConfigurationException {
        String[] strs = value.split("=", 2);
        String key = strs[0] + "=";
        if (strs.length == 1 || !key.equalsIgnoreCase(AGENT_ROOT_URL)) {
            return;
        }
        if (!key.equals(AGENT_ROOT_URL)) {
            throw new ConfigurationException("agent.root.url.starts.with", null);
        }
        if (!value.endsWith("/")) {
            throw new ConfigurationException("agent.root.url.ends.with", null);
        }
        String urlStr = strs[1];
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            Object[] param = new Object[]{urlStr};
            throw new ConfigurationException("agent.root.url.invalid", param);
        }
        int port = url.getPort();
        if (port == -1) {
            throw new ConfigurationException("agent.root.url.missing.port", null);
        }
        if (port < 1 || port > 65535) {
            Object[] param = new Object[]{Integer.toString(port)};
            throw new ConfigurationException("agent.root.url.port.out.of.range", param);
        }
        String hostName = url.getHost();
        try {
            InetAddress.getByName(hostName);
        }
        catch (UnknownHostException e) {
            Object[] param = new Object[]{hostName};
            throw new ConfigurationException("agent.root.url.unknown.host", param);
        }
    }

    public static void tagswapAttributeValues(Map attributeValues, String agentType, FQDNUrl serverURL, FQDNUrl agentURL) throws ConfigurationException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (serverURL != null) {
            if (!serverURL.isValid()) {
                throw new ConfigurationException("create.agent.invalid.server.url", null);
            }
            if (!serverURL.isFullyQualified()) {
                throw new ConfigurationException("create.agent.server.url.not.fqdn", null);
            }
            String uri = serverURL.getURI();
            if (uri.length() == 0) {
                throw new ConfigurationException("create.agent.invalid.server.url.missing.uri", null);
            }
            String port = serverURL.getPort();
            if (port.equals("-1")) {
                throw new ConfigurationException("create.agent.invalid.server.url.missing.port", null);
            }
            map.put("SERVER_PROTO", serverURL.getProtocol());
            map.put("SERVER_HOST", serverURL.getHost());
            map.put("SERVER_PORT", port);
            map.put("AM_SERVICES_DEPLOY_URI", uri);
        }
        if (agentURL != null) {
            String uri;
            String port = agentURL.getPort();
            map.put("AGENT_PROTO", agentURL.getProtocol());
            map.put("AGENT_HOST", agentURL.getHost());
            map.put("AGENT_PORT", port);
            if (agentType.equals(AGENT_TYPE_J2EE)) {
                if (!agentURL.isValid()) {
                    throw new ConfigurationException("create.agent.invalid.agent.url", null);
                }
                if (!agentURL.isFullyQualified()) {
                    throw new ConfigurationException("create.agent.invalid.agent.url", null);
                }
                uri = agentURL.getURI();
                if (uri.length() == 0) {
                    throw new ConfigurationException("create.agent.invalid.agent.url.missing.uri", null);
                }
                map.put("AGENT_APP_URI", uri);
                String logFileName = agentURL.getHost();
                logFileName = "amAgent_" + logFileName.replaceAll("\\.", "_") + "_" + port + ".log";
                map.put("AUDIT_LOG_FILENAME", logFileName);
            } else if (agentType.equals(AGENT_TYPE_WEB)) {
                uri = agentURL.getURI();
                if (uri.length() > 0) {
                    throw new ConfigurationException("create.agent.invalid.agent.url.uri.not.required", null);
                }
                map.put("AGENT_APP_URI", uri);
                String logFileName = agentURL.getHost();
                logFileName = "amAgent_" + logFileName.replaceAll("\\.", "_") + "_" + port + ".log";
                map.put("AUDIT_LOG_FILENAME", logFileName);
            }
        }
        AgentConfiguration.tagswapAttributeValues(attributeValues, map);
        if (agentURL != null) {
            AgentConfiguration.addAgentRootURLKey(agentType, attributeValues);
        }
    }

    private static void tagswapAttributeValues(Map attributeValues, Map tagswapInfo) {
        for (String attrName : attributeValues.keySet()) {
            Set values = (Set)attributeValues.get(attrName);
            HashSet<String> newValues = new HashSet<String>(values.size() * 2);
            for (String value : values) {
                newValues.add(AgentConfiguration.tagswap(tagswapInfo, value));
            }
            values.clear();
            values.addAll(newValues);
        }
    }

    private static String tagswap(Map map, String value) {
        for (String k : map.keySet()) {
            value = value.replaceAll("@" + k + "@", (String)map.get(k));
        }
        return value;
    }

    public static void updateAgent(SSOToken ssoToken, String realm, String agentName, Map attrValues, boolean bSet) throws IdRepoException, SSOException, SMSException, ConfigurationException {
        AMIdentity amid = new AMIdentity(ssoToken, agentName, IdType.AGENTONLY, realm, null);
        if (!amid.isExists()) {
            Object[] param = new String[]{agentName};
            throw new ConfigurationException("agent.does.not.exists", param);
        }
        String agentType = AgentConfiguration.getAgentType(amid);
        Map attributeValues = AgentConfiguration.parseAttributeMap(agentType, attrValues);
        if (!bSet) {
            Map origValues = amid.getAttributes(attributeValues.keySet());
            for (String attrName : attributeValues.keySet()) {
                attributeValues.put(attrName, AgentConfiguration.updateAttrValues(agentType, attrName, (Set)origValues.get(attrName), (Set)attributeValues.get(attrName)));
            }
        }
        amid.setAttributes(attributeValues);
        amid.store();
    }

    private static Set updateAttrValues(String agentType, String attrName, Set origValues, Set newValues) throws SMSException, SSOException {
        AttributeSchema as = AgentConfiguration.getAgentAttributeSchema(attrName, agentType);
        return as.getType().equals(AttributeSchema.Type.LIST) ? AgentConfiguration.updateAttrValues(origValues, newValues) : newValues;
    }

    private static Set updateAttrValues(Set origValues, Set newValues) {
        if (origValues == null || origValues.isEmpty()) {
            return newValues;
        }
        HashSet<String> set = new HashSet<String>();
        set.addAll(origValues);
        for (String val : newValues) {
            int idx;
            if (val.startsWith("[") && (idx = val.indexOf(93)) != -1) {
                String key = val.substring(0, idx + 1);
                AgentConfiguration.removeEntryByKey(set, key);
            }
            set.add(val);
        }
        return set;
    }

    private static boolean removeEntryByKey(Set set, String key) {
        boolean bRemoved = false;
        String match = key + "=";
        Iterator i = set.iterator();
        while (i.hasNext() && !bRemoved) {
            String val = (String)i.next();
            if (!val.startsWith(match)) continue;
            i.remove();
            bRemoved = true;
        }
        return bRemoved;
    }

    public static void updateAgentGroup(SSOToken ssoToken, String realm, String agentGroupName, Map attrValues) throws IdRepoException, SSOException, SMSException, ConfigurationException {
        AgentConfiguration.updateAgentGroup(ssoToken, realm, agentGroupName, attrValues, true);
    }

    public static void updateAgentGroup(SSOToken ssoToken, String realm, String agentGroupName, Map attrValues, boolean bSet) throws IdRepoException, SSOException, SMSException, ConfigurationException {
        AMIdentity amid = new AMIdentity(ssoToken, agentGroupName, IdType.AGENTGROUP, realm, null);
        String agentType = AgentConfiguration.getAgentType(amid);
        Map attributeValues = AgentConfiguration.parseAttributeMap(agentType, attrValues);
        if (attributeValues.containsKey(ATTR_NAME_PWD)) {
            throw new ConfigurationException("update.agent.group.cannot.have.password", null);
        }
        if (!bSet) {
            Map origValues = amid.getAttributes(attributeValues.keySet());
            for (String attrName : attributeValues.keySet()) {
                attributeValues.put(attrName, AgentConfiguration.updateAttrValues(agentType, attrName, (Set)origValues.get(attrName), (Set)attributeValues.get(attrName)));
            }
        }
        amid.setAttributes(attributeValues);
        amid.store();
    }

    public static Set getAgentAttributeSchemas(String agentTypeName) throws SMSException, SSOException {
        ServiceSchema ssType;
        Set attrs;
        HashSet attrSchemas = new HashSet();
        ServiceSchema ss = AgentConfiguration.getOrganizationSchema();
        if (ss != null && (attrs = (ssType = ss.getSubSchema(agentTypeName)).getAttributeSchemas()) != null && !attrs.isEmpty()) {
            attrSchemas.addAll(attrs);
        }
        Iterator i = attrSchemas.iterator();
        while (i.hasNext()) {
            AttributeSchema as = (AttributeSchema)i.next();
            if (!as.getType().equals(AttributeSchema.Type.VALIDATOR)) continue;
            i.remove();
        }
        return attrSchemas;
    }

    private static Set getAgentAttributeSchemaNames(String agentTypeName) throws SMSException, SSOException {
        Set attrSchemas = AgentConfiguration.getAgentAttributeSchemas(agentTypeName);
        HashSet<String> names = new HashSet<String>(attrSchemas.size() * 2);
        for (AttributeSchema as : attrSchemas) {
            names.add(as.getName());
        }
        return names;
    }

    public static Map getAgentGroupAttributes(SSOToken ssoToken, String realm, String agentGroupName) throws IdRepoException, SMSException, SSOException {
        AMIdentity amid = new AMIdentity(ssoToken, agentGroupName, IdType.AGENTGROUP, realm, null);
        Map values = amid.getAttributes();
        if (values != null) {
            values.remove(ATTR_NAME_PWD);
        }
        return AgentConfiguration.unparseAttributeMap(AgentConfiguration.getAgentType(amid), values);
    }

    public static Map getAgentAttributes(SSOToken ssoToken, String realm, String agentName) throws IdRepoException, SMSException, SSOException {
        AMIdentity amid = new AMIdentity(ssoToken, agentName, IdType.AGENTONLY, realm, null);
        return AgentConfiguration.getAgentAttributes(amid, true);
    }

    public static Map getAgentAttributes(SSOToken ssoToken, String realm, String agentName, boolean bInherit) throws IdRepoException, SMSException, SSOException {
        IdType type = bInherit ? IdType.AGENT : IdType.AGENTONLY;
        AMIdentity amid = new AMIdentity(ssoToken, agentName, type, realm, null);
        return AgentConfiguration.getAgentAttributes(amid, true);
    }

    public static Map getAgentAttributes(AMIdentity amid, boolean reformat) throws IdRepoException, SMSException, SSOException {
        HashMap values = amid.getAttributes();
        String agentType = AgentConfiguration.getAgentType(amid);
        if (AgentConfiguration.supportLocalProperties(agentType) && AgentConfiguration.isPropertiesLocallyStored(amid)) {
            Set localProp = AgentConfiguration.getLocalPropertyNames(agentType);
            HashMap temp = new HashMap(localProp.size() * 2);
            for (String key : localProp) {
                temp.put(key, values.get(key));
            }
            values = temp;
        }
        return reformat ? AgentConfiguration.unparseAttributeMap(agentType, values) : AgentConfiguration.correctAttributeNames(agentType, values);
    }

    private static boolean isPropertiesLocallyStored(AMIdentity amid) throws IdRepoException, SSOException {
        boolean isLocal = false;
        Set setRepo = amid.getAttribute(ATTR_CONFIG_REPO);
        if (setRepo != null && !setRepo.isEmpty()) {
            String repo = (String)setRepo.iterator().next();
            isLocal = repo.equalsIgnoreCase(VAL_CONFIG_REPO_LOCAL);
        }
        return isLocal;
    }

    private static String getAgentType(AMIdentity amid) throws IdRepoException, SSOException {
        Set setType = amid.getAttribute("AgentType");
        return setType != null && !setType.isEmpty() ? (String)setType.iterator().next() : "";
    }

    private static Map parseAttributeMap(String agentType, Map attrValues) throws SMSException, SSOException {
        HashMap dummy = new HashMap();
        dummy.putAll(attrValues);
        HashMap<String, Set> result = new HashMap<String, Set>();
        Set attributeSchemas = AgentConfiguration.getAgentAttributeSchemas(agentType);
        if (attributeSchemas != null && !attributeSchemas.isEmpty()) {
            for (AttributeSchema as : attributeSchemas) {
                Set values = AgentConfiguration.parseAttributeMap(as, dummy);
                if (values == null) continue;
                result.put(as.getName(), values);
            }
        }
        if (!dummy.isEmpty()) {
            HashSet<String> freeForm = new HashSet<String>();
            for (String name : dummy.keySet()) {
                Set values = (Set)dummy.get(name);
                Iterator j = values.iterator();
                while (j.hasNext()) {
                    freeForm.add(name + "=" + (String)j.next());
                }
            }
            result.put(ATTR_NAME_FREE_FORM, freeForm);
        }
        return result;
    }

    private static Set parseAttributeMap(AttributeSchema as, Map attrValues) {
        HashSet<String> results = null;
        String attrName = as.getName();
        if (as.getType().equals(AttributeSchema.Type.LIST)) {
            HashSet<String> keysToDelete = new HashSet<String>();
            for (String key : attrValues.keySet()) {
                Set set;
                if (key.equals(attrName)) {
                    if (results == null) {
                        results = new HashSet<String>();
                    }
                    if ((set = (Set)attrValues.get(key)) != null && !set.isEmpty()) {
                        results.addAll(set);
                    }
                    keysToDelete.add(key);
                    continue;
                }
                if (!key.startsWith(attrName + "[")) continue;
                if (results == null) {
                    results = new HashSet();
                }
                String v = (set = (Set)attrValues.get(key)) != null && !set.isEmpty() ? (String)set.iterator().next() : "";
                results.add(key.substring(attrName.length()) + "=" + v);
                keysToDelete.add(key);
            }
            Iterator<Object> i = keysToDelete.iterator();
            while (i.hasNext()) {
                attrValues.remove(i.next());
            }
        } else {
            results = (HashSet<String>)attrValues.remove(attrName);
        }
        return results;
    }

    private static Map correctAttributeNames(String agentType, Map attrValues) throws SMSException, SSOException {
        HashMap<String, Set> result = new HashMap<String, Set>();
        Set asNames = AgentConfiguration.getAgentAttributeSchemaNames(agentType);
        if (asNames != null && !asNames.isEmpty()) {
            for (String name : asNames) {
                Set values = (Set)attrValues.get(name);
                if (values == null) continue;
                result.put(name, values);
            }
        } else {
            result.putAll(attrValues);
        }
        return result;
    }

    private static Map unparseAttributeMap(String agentType, Map attrValues) throws SMSException, SSOException {
        HashMap<String, Set> result = new HashMap<String, Set>();
        Set asNames = AgentConfiguration.getAgentAttributeSchemaNames(agentType);
        Set asListType = AgentConfiguration.getAttributesSchemaNames(agentType, AttributeSchema.Type.LIST);
        Set asValidatorType = AgentConfiguration.getAttributesSchemaNames(agentType, AttributeSchema.Type.VALIDATOR);
        if (asListType == null) {
            asListType = Collections.EMPTY_SET;
        }
        if (asValidatorType == null) {
            asValidatorType = Collections.EMPTY_SET;
        }
        if (asNames != null && !asNames.isEmpty()) {
            for (String name : asNames) {
                Set values = (Set)attrValues.get(name);
                if (values == null || values.isEmpty()) continue;
                if (name.equals(ATTR_NAME_FREE_FORM)) {
                    AgentConfiguration.handleFreeFormAttrValues(values, result);
                    continue;
                }
                if (asValidatorType.contains(name)) continue;
                if (asListType.contains(name)) {
                    for (String val : values) {
                        HashSet<String> set;
                        int idx = val.indexOf("]");
                        int idx1 = -1;
                        if (idx != -1) {
                            idx1 = val.indexOf("=", idx + 1);
                        }
                        if (idx != -1 && idx < idx1 && AgentConfiguration.onlySpacesInBetween(val, idx, idx1)) {
                            set = new HashSet(2);
                            set.add(val.substring(idx1 + 1));
                            String indice = val.substring(0, idx + 1);
                            indice = indice.replaceAll("=", "\\\\=");
                            result.put(name + indice, set);
                            continue;
                        }
                        set = new HashSet<String>(2);
                        set.add(val);
                        result.put(name, set);
                    }
                    continue;
                }
                result.put(name, values);
            }
        } else {
            result.putAll(attrValues);
        }
        return result;
    }

    private static boolean onlySpacesInBetween(String s, int start, int end) {
        boolean onlySpaces = true;
        for (int i = start + 1; i < end && onlySpaces; ++i) {
            onlySpaces = s.charAt(i) == ' ';
        }
        return onlySpaces;
    }

    private static void handleFreeFormAttrValues(Set values, Map result) {
        for (String val : values) {
            Matcher m = patternArray.matcher(val);
            if (m.find()) {
                HashSet<String> set = new HashSet<String>(2);
                set.add(m.group(2));
                result.put(m.group(1), set);
                continue;
            }
            int idx = val.indexOf("=");
            if (idx == -1) continue;
            HashSet<String> set = new HashSet<String>(2);
            set.add(val.substring(idx + 1));
            result.put(val.substring(0, idx), set);
        }
    }

    public static Set getAttributesSchemaNames(AMIdentity amid, AttributeSchema.Syntax syntax) throws SMSException, SSOException, IdRepoException {
        HashSet<String> results = new HashSet<String>();
        Set attributeSchemas = AgentConfiguration.getAgentAttributeSchemas(AgentConfiguration.getAgentType(amid));
        if (attributeSchemas != null && !attributeSchemas.isEmpty()) {
            for (AttributeSchema as : attributeSchemas) {
                if (!as.getSyntax().equals(syntax)) continue;
                results.add(as.getName());
            }
        }
        return results;
    }

    private static Set getAttributesSchemaNames(AMIdentity amid) throws SMSException, SSOException, IdRepoException {
        HashSet<String> results = new HashSet<String>();
        Set attributeSchemas = AgentConfiguration.getAgentAttributeSchemas(AgentConfiguration.getAgentType(amid));
        if (attributeSchemas != null && !attributeSchemas.isEmpty()) {
            for (AttributeSchema as : attributeSchemas) {
                results.add(as.getName());
            }
        }
        return results;
    }

    public static Set getAttributesSchemaNames(String agentType, AttributeSchema.Type type) throws SMSException, SSOException {
        HashSet<String> results = new HashSet<String>();
        Set attributeSchemas = AgentConfiguration.getAgentAttributeSchemas(agentType);
        if (attributeSchemas != null && !attributeSchemas.isEmpty()) {
            for (AttributeSchema as : attributeSchemas) {
                if (!as.getType().equals(type)) continue;
                results.add(as.getName());
            }
        }
        return results;
    }

    public static String getResourceBundleName() throws SMSException, SSOException {
        Object ss = null;
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        ServiceSchemaManager ssm = new ServiceSchemaManager("AgentService", adminToken);
        return ssm != null ? ssm.getI18NFileName() : "";
    }

    private static ServiceSchema getOrganizationSchema() throws SMSException, SSOException {
        ServiceSchema ss = null;
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        ServiceSchemaManager ssm = new ServiceSchemaManager("AgentService", adminToken);
        if (ssm != null) {
            ss = ssm.getSchema(SchemaType.ORGANIZATION);
        }
        return ss;
    }

    public static Map getDefaultValues(String agentType, boolean bGroup) throws SMSException, SSOException {
        HashMap<String, Set> mapDefault = new HashMap<String, Set>();
        Set attributeSchemas = AgentConfiguration.getAgentAttributeSchemas(agentType);
        if (attributeSchemas != null && !attributeSchemas.isEmpty()) {
            for (AttributeSchema as : attributeSchemas) {
                mapDefault.put(as.getName(), as.getDefaultValues());
            }
        }
        if (bGroup) {
            mapDefault.remove(ATTR_NAME_PWD);
        }
        return mapDefault;
    }

    public static Map getChoiceValues(String name, String agentType) throws SMSException, SSOException {
        String[] cValues;
        HashMap<String, String> choiceValues = new HashMap<String, String>();
        AttributeSchema as = AgentConfiguration.getAgentAttributeSchema(name, agentType);
        if (as != null && (cValues = as.getChoiceValues()) != null) {
            for (int i = 0; i < cValues.length; ++i) {
                String v = cValues[i];
                choiceValues.put(as.getChoiceValueI18NKey(v), v);
            }
        }
        return choiceValues;
    }

    public static AttributeSchema getAgentAttributeSchema(String name, String agentTypeName) throws SMSException, SSOException {
        AttributeSchema as = null;
        ServiceSchema ss = AgentConfiguration.getOrganizationSchema();
        if (ss != null) {
            ServiceSchema ssType = ss.getSubSchema(agentTypeName);
            as = ssType.getAttributeSchema(name);
        }
        return as;
    }

    public static Set getInheritedAttributeNames(AMIdentity amid) throws IdRepoException, SSOException, SMSException {
        String agentType = AgentConfiguration.getAgentType(amid);
        Set attributeSchemaNames = AgentConfiguration.getAgentAttributeSchemaNames(agentType);
        Map values = AgentConfiguration.getAgentAttributes(amid, false);
        if (values != null && !values.isEmpty()) {
            attributeSchemaNames.removeAll(values.keySet());
        }
        return attributeSchemaNames;
    }

    public static void updateInheritance(AMIdentity amid, Map inherit) throws IdRepoException, SSOException, SMSException {
        HashSet<String> toInherit = new HashSet<String>();
        HashSet<String> notToInherit = new HashSet<String>();
        for (String attrName : inherit.keySet()) {
            String flag = (String)inherit.get(attrName);
            if (flag.equals("1")) {
                toInherit.add(attrName);
                continue;
            }
            notToInherit.add(attrName);
        }
        Map origValues = AgentConfiguration.getAgentAttributes(amid, false);
        Map values = amid.getAttributes(toInherit);
        if (!values.isEmpty()) {
            amid.removeAttributes(values.keySet());
        }
        String agentType = AgentConfiguration.getAgentType(amid);
        Map attrSchemas = AgentConfiguration.getAttributeSchemas(agentType, notToInherit);
        HashMap<String, Set> resetValues = new HashMap<String, Set>(notToInherit.size() * 2);
        for (String attrName : notToInherit) {
            if (origValues.get(attrName) != null) continue;
            AttributeSchema as = (AttributeSchema)attrSchemas.get(attrName);
            Set defaultValues = as.getDefaultValues();
            if (defaultValues == null) {
                resetValues.put(attrName, Collections.EMPTY_SET);
                continue;
            }
            resetValues.put(attrName, defaultValues);
        }
        if (!resetValues.isEmpty()) {
            amid.setAttributes(resetValues);
            amid.store();
        }
    }

    public static Map getAttributeSchemas(String agentType, Collection names) throws SMSException, SSOException {
        HashMap<String, AttributeSchema> map = new HashMap<String, AttributeSchema>();
        Set attributeSchema = AgentConfiguration.getAgentAttributeSchemas(agentType);
        for (AttributeSchema as : attributeSchema) {
            if (!names.contains(as.getName())) continue;
            map.put(as.getName(), as);
        }
        return map;
    }

    public static ResourceBundle getServiceResourceBundle(Locale locale) throws SMSException, SSOException {
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        ServiceSchemaManager ssm = new ServiceSchemaManager("AgentService", adminToken);
        String rbName = ssm.getI18NFileName();
        return ResourceBundle.getBundle(rbName, locale);
    }

    public static void AddAgentToGroup(AMIdentity group, AMIdentity agent) throws IdRepoException, SSOException, ConfigurationException {
        if (!group.isExists()) {
            Object[] param = new String[]{group.getName()};
            throw new ConfigurationException("cannot.add.agent.to.group.group.does.not.exist", param);
        }
        if (!agent.isExists()) {
            Object[] param = new String[]{agent.getName()};
            throw new ConfigurationException("cannot.add.agent.to.group.agent.does.not.exist", param);
        }
        String agentType = AgentConfiguration.getAgentType(agent);
        String agentGroupType = AgentConfiguration.getAgentType(group);
        if (AgentConfiguration.supportLocalProperties(agentType) && AgentConfiguration.isPropertiesLocallyStored(agent)) {
            String agentName = agent.getName();
            Object[] param = new String[]{agentName};
            throw new ConfigurationException("cannot.add.agent.to.group.proeprties.locally.stored", param);
        }
        if (!agentType.equals(agentGroupType)) {
            String agentName = agent.getName();
            String groupName = group.getName();
            Object[] param = new String[]{agentName, groupName};
            throw new ConfigurationException("cannot.add.agent.to.group.type.mismatched", param);
        }
        group.addMember(agent);
    }

    public static boolean supportLocalProperties(String agentType) {
        return localAgentProperties.containsKey(agentType);
    }

    public static Set getLocalPropertyNames(String agentType) {
        return (Set)localAgentProperties.get(agentType);
    }

    public static void deleteAgentGroups(SSOToken ssoToken, String realm, Set agentGroups) throws IdRepoException, SSOException, SMSException {
        if (agentGroups != null && !agentGroups.isEmpty()) {
            for (AMIdentity group : agentGroups) {
                AgentConfiguration.unheritPropertyValues(group);
            }
            AMIdentityRepository repo = new AMIdentityRepository(ssoToken, realm);
            repo.deleteIdentities(agentGroups);
        }
    }

    private static void unheritPropertyValues(AMIdentity group) throws IdRepoException, SSOException, SMSException {
        Set agents = group.getMembers(IdType.AGENTONLY);
        if (agents != null && !agents.isEmpty()) {
            for (AMIdentity agent : agents) {
                AgentConfiguration.unheritPropertyValues(group, agent);
            }
        }
    }

    private static void unheritPropertyValues(AMIdentity group, AMIdentity agent) throws SMSException, SSOException, IdRepoException {
        Set attributeSchemas = AgentConfiguration.getAttributesSchemaNames(group);
        Map groupProperties = group.getAttributes();
        HashMap map = new HashMap();
        map.putAll(groupProperties);
        map.putAll(agent.getAttributes());
        agent.setAttributes(AgentConfiguration.correctAttributeNames(map, attributeSchemas));
        agent.store();
    }

    private static Map correctAttributeNames(Map attrValues, Set attributeSchemaNames) {
        HashMap results = new HashMap();
        HashMap<String, String> mapCase = new HashMap<String, String>();
        for (String string : attributeSchemaNames) {
            mapCase.put(string.toLowerCase(), string);
        }
        for (Map.Entry entry : attrValues.entrySet()) {
            String correctedKey = (String)mapCase.get(entry.getKey());
            if (correctedKey == null) continue;
            results.put(correctedKey, entry.getValue());
        }
        return results;
    }

    public static boolean setAgentGroup(SSOToken ssoToken, String realm, String universalId, String groupName) throws IdRepoException, SSOException, SMSException {
        AMIdentity amid = IdUtils.getIdentity(ssoToken, universalId);
        return AgentConfiguration.setAgentGroup(ssoToken, realm, amid, groupName);
    }

    public static boolean setAgentGroup(SSOToken ssoToken, String realm, AMIdentity amid, String groupName) throws IdRepoException, SSOException, SMSException {
        AMIdentity newGroup = null;
        if (groupName != null && groupName.length() > 0) {
            newGroup = new AMIdentity(ssoToken, groupName, IdType.AGENTGROUP, realm, null);
        }
        return AgentConfiguration.setAgentGroup(amid, newGroup);
    }

    public static boolean setAgentGroup(AMIdentity amid, AMIdentity newGroup) throws IdRepoException, SSOException, SMSException {
        boolean bSet = false;
        Set groups = amid.getMemberships(IdType.AGENTGROUP);
        if (groups != null && !groups.isEmpty()) {
            if (newGroup != null) {
                if (!groups.contains(newGroup)) {
                    newGroup.addMember(amid);
                    bSet = true;
                }
            } else {
                AMIdentity group = (AMIdentity)groups.iterator().next();
                AgentConfiguration.unheritPropertyValues(group, amid);
                group.removeMember(amid);
                bSet = true;
            }
        } else if (newGroup != null) {
            newGroup.addMember(amid);
            bSet = true;
        }
        return bSet;
    }

    public static boolean removeAgentGroup(AMIdentity amid, AMIdentity groupToRemove) throws IdRepoException, SSOException, SMSException {
        boolean bRemoved = false;
        Set groups = amid.getMemberships(IdType.AGENTGROUP);
        if (groups != null && !groups.isEmpty() && groupToRemove != null && groups.contains(groupToRemove)) {
            AgentConfiguration.unheritPropertyValues(groupToRemove, amid);
            groupToRemove.removeMember(amid);
            bRemoved = true;
        }
        return bRemoved;
    }

    static {
        patternArray = Pattern.compile("(.+?\\[.*?\\]\\s*?)=(.*)");
        localAgentProperties = new HashMap();
        ResourceBundle rb = ResourceBundle.getBundle(AGENT_LOCAL_PROPERTIES);
        Enumeration<String> e = rb.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            HashSet<String> set = new HashSet<String>();
            String value = rb.getString(key);
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreTokens()) {
                set.add(st.nextToken());
            }
            localAgentProperties.put(key, set);
        }
    }
}

