/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idsvcs.rest;

import com.sun.identity.idsvcs.Attribute;
import com.sun.identity.idsvcs.GeneralFailure;
import com.sun.identity.idsvcs.IdentityDetails;
import com.sun.identity.idsvcs.ObjectNotFound;
import com.sun.identity.idsvcs.Token;
import com.sun.identity.idsvcs.UserDetails;
import com.sun.identity.idsvcs.rest.Marshaller;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;

public class MarshallerFactory {
    public static MarshallerFactory XML = new MarshallerFactory("XML");
    public static MarshallerFactory PROPS = new MarshallerFactory("PROPS");
    private Map _map = new HashMap();
    private String protocol;

    private MarshallerFactory(String protocol) {
        this.protocol = protocol;
        if (protocol.equals("XML")) {
            this._map.put(Token.class, XMLTokenMarshaller.class);
            this._map.put(UserDetails.class, XMLUserDetailsMarshaller.class);
            this._map.put(Boolean.class, XMLBooleanMarshaller.class);
            this._map.put(String.class, XMLStringMarshaller.class);
            this._map.put(String[].class, XMLStringArrayMarshaller.class);
            this._map.put(IdentityDetails.class, XMLIdentityDetailsMarshaller.class);
            this._map.put(List.class, PropertiesListMarshaller.class);
            this._map.put(GeneralFailure.class, XMLGeneralFailureMarshaller.class);
            this._map.put(ObjectNotFound.class, XMLObjectNotFoundMarshaller.class);
            this._map.put(Throwable.class, XMLThrowableMarshaller.class);
        } else if (protocol.equals("PROPS")) {
            this._map.put(Token.class, PropertiesTokenMarshaller.class);
            this._map.put(UserDetails.class, PropertiesUserDetailsMarshaller.class);
            this._map.put(Boolean.class, PropertiesBooleanMarshaller.class);
            this._map.put(String.class, PropertiesStringMarshaller.class);
            this._map.put(String[].class, PropertiesStringArrayMarshaller.class);
            this._map.put(IdentityDetails.class, PropertiesIdentityDetailsMarshaller.class);
            this._map.put(IdentityDetails[].class, PropertiesIdentityDetailsArrayMarshaller.class);
            this._map.put(List.class, PropertiesListMarshaller.class);
            this._map.put(GeneralFailure.class, PropertiesGeneralFailureMarshaller.class);
            this._map.put(ObjectNotFound.class, PropertiesObjectNotFoundMarshaller.class);
            this._map.put(Throwable.class, PropertiesThrowableMarshaller.class);
        }
    }

    Map getMarshallerMap() {
        return this._map;
    }

    public Marshaller newInstance(Class type) {
        Class clazz;
        Marshaller ret = null;
        if (this._map == null) {
            this._map = this.getMarshallerMap();
        }
        if ((clazz = (Class)this._map.get(type)) == null) {
            throw new IllegalArgumentException();
        }
        try {
            ret = (Marshaller)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public String getProtocol() {
        return this.protocol;
    }

    static class PropertiesStringArrayMarshaller
    implements Marshaller {
        PropertiesStringArrayMarshaller() {
        }

        public void marshall(Writer wrt, Object value) throws Exception {
            assert (wrt != null && value != null);
            this.marshall(new PrintWriter(wrt), "", (String[])value);
        }

        public void marshall(PrintWriter wrt, String prefix, String[] value) throws Exception {
            if (value != null && value.length > 0) {
                PropertiesStringMarshaller stringMarshaller = new PropertiesStringMarshaller();
                for (int i = 0; i < value.length; ++i) {
                    stringMarshaller.marshall(wrt, prefix, value[i]);
                }
            }
        }
    }

    static class PropertiesStringMarshaller
    implements Marshaller {
        PropertiesStringMarshaller() {
        }

        public void marshall(Writer wrt, Object value) throws Exception {
            assert (wrt != null && value != null);
            this.marshall(new PrintWriter(wrt), "", (String)value);
        }

        public void marshall(PrintWriter wrt, String prefix, String value) throws Exception {
            wrt.print(prefix);
            wrt.print("string=");
            wrt.println(value);
        }
    }

    static class PropertiesBooleanMarshaller
    implements Marshaller {
        PropertiesBooleanMarshaller() {
        }

        public void marshall(Writer wrt, Object value) throws Exception {
            assert (wrt != null && value != null);
            this.marshall(new PrintWriter(wrt), "", (Boolean)value);
        }

        public void marshall(PrintWriter wrt, String prefix, Boolean value) throws Exception {
            wrt.print(prefix);
            wrt.print("boolean=");
            wrt.println(value.toString());
        }
    }

    static class PropertiesObjectNotFoundMarshaller
    implements Marshaller {
        PropertiesObjectNotFoundMarshaller() {
        }

        public void marshall(Writer wrt, Object value) {
            assert (wrt != null && value != null);
            this.marshall(new PrintWriter(wrt), "", (ObjectNotFound)value);
        }

        public void marshall(PrintWriter wrt, String prefix, ObjectNotFound value) {
            String msg = value.getMessage();
            wrt.print(prefix);
            wrt.print("exception.name=");
            if (msg != null && msg.length() > 0) {
                wrt.print(value.getClass().getName());
                wrt.println(" " + msg);
            } else {
                wrt.println(value.getClass().getName());
            }
        }
    }

    static class PropertiesThrowableMarshaller
    implements Marshaller {
        PropertiesThrowableMarshaller() {
        }

        public void marshall(Writer wrt, Object value) {
            assert (wrt != null && value != null);
            this.marshall(new PrintWriter(wrt), "", (Throwable)value);
        }

        public void marshall(PrintWriter wrt, String prefix, Throwable value) {
            String msg = value.getMessage();
            wrt.print(prefix);
            wrt.print("exception.name=");
            if (msg != null && msg.length() > 0) {
                wrt.print(value.getClass().getName());
                wrt.println(" " + msg);
            } else {
                wrt.println(value.getClass().getName());
            }
        }
    }

    static class PropertiesGeneralFailureMarshaller
    implements Marshaller {
        PropertiesGeneralFailureMarshaller() {
        }

        public void marshall(Writer wrt, Object value) {
            assert (wrt != null && value != null);
            this.marshall(new PrintWriter(wrt), "", (GeneralFailure)value);
        }

        public void marshall(PrintWriter wrt, String prefix, GeneralFailure value) {
            String msg = value.getMessage();
            wrt.print(prefix);
            wrt.print("exception.name=");
            if (msg != null && msg.length() > 0) {
                wrt.print(value.getClass().getName());
                wrt.println(" " + msg);
            } else {
                wrt.println(value.getClass().getName());
            }
        }
    }

    static class PropertiesListMarshaller
    implements Marshaller {
        PropertiesListMarshaller() {
        }

        public void marshall(Writer wrt, Object value) throws Exception {
            assert (wrt != null && value != null);
            this.marshall(new PrintWriter(wrt), "", (List)value);
        }

        public void marshall(PrintWriter wrt, String prefix, List value) throws Exception {
            String prfx = prefix + "list.";
            if (value != null) {
                for (Object nextObj : value) {
                    Marshaller mar = PROPS.newInstance(nextObj.getClass());
                    Class[] params = new Class[]{XMLStreamWriter.class, nextObj.getClass()};
                    Method m = mar.getClass().getMethod("marshall", params);
                    Object[] objs = new Object[]{wrt, value};
                    m.invoke((Object)mar, objs);
                }
            }
        }
    }

    static class PropertiesIdentityDetailsArrayMarshaller
    implements Marshaller {
        PropertiesIdentityDetailsArrayMarshaller() {
        }

        public void marshall(Writer wrt, Object value) throws Exception {
            assert (wrt != null && value != null);
            this.marshall(new PrintWriter(wrt), "", (IdentityDetails[])value);
        }

        public void marshall(PrintWriter wrt, String prefix, IdentityDetails[] value) throws Exception {
            String prfx = prefix + "identitydetails";
            if (value != null && value.length > 0) {
                PropertiesIdentityDetailsMarshaller detailsMarshaller = new PropertiesIdentityDetailsMarshaller();
                for (int i = 0; i < value.length; ++i) {
                    wrt.println(prfx + "=");
                    detailsMarshaller.marshall(wrt, prefix, value[i]);
                }
            }
        }
    }

    static class PropertiesIdentityDetailsMarshaller
    implements Marshaller {
        PropertiesIdentityDetailsMarshaller() {
        }

        public void marshall(Writer wrt, Object value) throws Exception {
            assert (wrt != null && value != null);
            this.marshall(new PrintWriter(wrt), "", (IdentityDetails)value);
        }

        public void marshall(PrintWriter wrt, String prefix, IdentityDetails details) throws Exception {
            String prfx = prefix + "identitydetails.";
            if (details != null) {
                wrt.print(prfx);
                wrt.print("name=");
                wrt.println(details.getName());
                wrt.print(prfx);
                wrt.print("type=");
                wrt.println(details.getType());
                wrt.print(prfx);
                wrt.print("realm=");
                wrt.println(details.getRealm());
                String[] roles = details.getRoles();
                for (int i = 0; roles != null && i < roles.length; ++i) {
                    wrt.print(prfx);
                    wrt.print("role=");
                    wrt.println(roles[i]);
                }
                String[] groups = details.getGroups();
                for (int i = 0; groups != null && i < groups.length; ++i) {
                    wrt.print(prfx);
                    wrt.print("group=");
                    wrt.println(groups[i]);
                }
                String[] members = details.getMembers();
                for (int i = 0; members != null && i < members.length; ++i) {
                    wrt.print(prfx);
                    wrt.print("member=");
                    wrt.println(members[i]);
                }
                PropertiesAttributeMarshaller attrMarshaller = new PropertiesAttributeMarshaller();
                Attribute[] atts = details.getAttributes();
                for (int i = 0; atts != null && i < atts.length; ++i) {
                    Attribute attr = atts[i];
                    wrt.print(prfx);
                    wrt.println("attribute=");
                    attrMarshaller.marshall(wrt, prfx, attr);
                }
            }
        }
    }

    static class PropertiesUserDetailsMarshaller
    implements Marshaller {
        PropertiesUserDetailsMarshaller() {
        }

        public void marshall(Writer wrt, Object value) throws Exception {
            assert (wrt != null);
            this.marshall(new PrintWriter(wrt), "", (UserDetails)value);
        }

        public void marshall(PrintWriter wrt, String prefix, UserDetails ud) throws Exception {
            String prfx = prefix + "userdetails.";
            if (ud != null) {
                PropertiesTokenMarshaller tokenMarshaller = new PropertiesTokenMarshaller();
                tokenMarshaller.marshall(wrt, prfx, ud.getToken());
                String[] rols = ud.getRoles();
                for (int i = 0; rols != null && i < rols.length; ++i) {
                    String v = rols[i];
                    wrt.print(prfx);
                    wrt.print("role=");
                    wrt.println(v);
                }
                PropertiesAttributeMarshaller attrMarshaller = new PropertiesAttributeMarshaller();
                Attribute[] atts = ud.getAttributes();
                for (int i = 0; atts != null && i < atts.length; ++i) {
                    Attribute attr = atts[i];
                    attrMarshaller.marshall(wrt, prfx, attr);
                }
            }
        }
    }

    static class PropertiesAttributeMarshaller
    implements Marshaller {
        PropertiesAttributeMarshaller() {
        }

        public void marshall(Writer wrt, Object value) throws Exception {
            assert (wrt != null);
            this.marshall(new PrintWriter(wrt), "", (Attribute)value);
        }

        public void marshall(PrintWriter wrt, String prefix, Attribute attr) throws Exception {
            String prfx = prefix + "attribute.";
            wrt.print(prfx);
            if (attr != null) {
                wrt.print("name=");
                wrt.println(attr.getName());
                String[] vals = attr.getValues();
                for (int i = 0; vals != null && i < vals.length; ++i) {
                    String value = vals[i];
                    wrt.print(prfx);
                    wrt.print("value=");
                    wrt.println(value);
                }
            }
        }
    }

    static class PropertiesTokenMarshaller
    implements Marshaller {
        PropertiesTokenMarshaller() {
        }

        public void marshall(Writer wrt, Object value) throws Exception {
            assert (wrt != null);
            this.marshall(new PrintWriter(wrt), "", (Token)value);
        }

        public void marshall(PrintWriter wrt, String prefix, Token value) throws Exception {
            wrt.print(prefix);
            wrt.print("token.id=");
            if (value != null) {
                wrt.println(value.getId());
            }
        }
    }

    static class XMLStringArrayMarshaller
    implements Marshaller {
        XMLStringArrayMarshaller() {
        }

        public void marshall(Writer wrt, Object value) throws Exception {
            assert (wrt != null);
            XMLOutputFactory xmlFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xwrt = xmlFactory.createXMLStreamWriter(wrt);
            xwrt.writeStartDocument();
            this.marshall(xwrt, (String[])value);
            xwrt.writeEndDocument();
        }

        public void marshall(XMLStreamWriter wrt, String[] value) throws Exception {
            wrt.writeStartElement("result");
            if (value != null) {
                for (int i = 0; i < value.length; ++i) {
                    wrt.writeStartElement("string");
                    wrt.writeCharacters(value[i]);
                    wrt.writeEndElement();
                }
            }
            wrt.writeEndElement();
        }
    }

    static class XMLStringMarshaller
    implements Marshaller {
        XMLStringMarshaller() {
        }

        public void marshall(Writer wrt, Object value) throws Exception {
            assert (wrt != null && value != null);
            XMLOutputFactory xmlFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xwrt = xmlFactory.createXMLStreamWriter(wrt);
            xwrt.writeStartDocument();
            this.marshall(xwrt, (String)value);
            xwrt.writeEndDocument();
        }

        public void marshall(XMLStreamWriter wrt, String value) throws Exception {
            assert (value != null);
            wrt.writeStartElement("result");
            wrt.writeAttribute("string", value);
            wrt.writeEndElement();
        }
    }

    static class XMLBooleanMarshaller
    implements Marshaller {
        XMLBooleanMarshaller() {
        }

        public void marshall(Writer wrt, Object value) throws Exception {
            assert (wrt != null && value != null);
            XMLOutputFactory xmlFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xwrt = xmlFactory.createXMLStreamWriter(wrt);
            xwrt.writeStartDocument();
            this.marshall(xwrt, (Boolean)value);
            xwrt.writeEndDocument();
        }

        public void marshall(XMLStreamWriter wrt, Boolean value) throws Exception {
            String token = value.toString();
            assert (token != null && token.length() != 0);
            wrt.writeStartElement("result");
            wrt.writeAttribute("boolean", token);
            wrt.writeEndElement();
        }
    }

    static class XMLListMarshaller
    implements Marshaller {
        Writer wrt;

        XMLListMarshaller() {
        }

        public void marshall(Writer wrt, Object value) throws Exception {
            assert (wrt != null && value != null);
            this.wrt = wrt;
            XMLOutputFactory xmlFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xwrt = xmlFactory.createXMLStreamWriter(wrt);
            xwrt.writeStartDocument();
            this.marshall(xwrt, (List)value);
            xwrt.writeEndDocument();
        }

        public void marshall(XMLStreamWriter wrt, List value) throws Exception {
            wrt.writeStartElement("List");
            if (value != null) {
                for (Object nextObj : value) {
                    Marshaller mar = XML.newInstance(nextObj.getClass());
                    Class[] params = new Class[]{XMLStreamWriter.class, nextObj.getClass()};
                    Method m = mar.getClass().getMethod("marshall", params);
                    Object[] objs = new Object[]{wrt, value};
                    m.invoke((Object)mar, objs);
                }
            }
            wrt.writeEndElement();
        }
    }

    static class XMLIdentityDetailsMarshaller
    implements Marshaller {
        XMLIdentityDetailsMarshaller() {
        }

        public void marshall(Writer wrt, Object value) throws Exception {
            assert (wrt != null);
            XMLOutputFactory xmlFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xwrt = xmlFactory.createXMLStreamWriter(wrt);
            xwrt.writeStartDocument();
            this.marshall(xwrt, (IdentityDetails)value);
            xwrt.writeEndDocument();
        }

        public void marshall(XMLStreamWriter wrt, IdentityDetails value) throws Exception {
            wrt.writeStartElement("identitydetails");
            if (value != null) {
                String name = value.getName();
                wrt.writeStartElement("name");
                wrt.writeAttribute("value", name);
                wrt.writeEndElement();
                String identityType = value.getType();
                wrt.writeStartElement("type");
                wrt.writeAttribute("value", identityType);
                wrt.writeEndElement();
                String realm = value.getRealm();
                wrt.writeStartElement("realm");
                wrt.writeAttribute("value", realm);
                wrt.writeEndElement();
                String[] roles = value.getRoles();
                for (int i = 0; roles != null && i < roles.length; ++i) {
                    wrt.writeStartElement("role");
                    wrt.writeAttribute("id", roles[i]);
                    wrt.writeEndElement();
                }
                String[] groups = value.getGroups();
                for (int i = 0; groups != null && i < groups.length; ++i) {
                    wrt.writeStartElement("group");
                    wrt.writeAttribute("id", groups[i]);
                    wrt.writeEndElement();
                }
                String[] members = value.getMembers();
                for (int i = 0; members != null && i < members.length; ++i) {
                    wrt.writeStartElement("member");
                    wrt.writeAttribute("id", members[i]);
                    wrt.writeEndElement();
                }
                XMLAttributeMarshaller attrMarshaller = new XMLAttributeMarshaller();
                Attribute[] vals = value.getAttributes();
                for (int i = 0; vals != null && i < vals.length; ++i) {
                    Attribute attr = vals[i];
                    attrMarshaller.marshall(wrt, attr);
                }
            }
            wrt.writeEndElement();
        }
    }

    static class XMLUserDetailsMarshaller
    implements Marshaller {
        XMLUserDetailsMarshaller() {
        }

        public void marshall(Writer wrt, Object value) throws Exception {
            assert (wrt != null);
            XMLOutputFactory xmlFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xwrt = xmlFactory.createXMLStreamWriter(wrt);
            xwrt.writeStartDocument();
            this.marshall(xwrt, (UserDetails)value);
            xwrt.writeEndDocument();
        }

        public void marshall(XMLStreamWriter wrt, UserDetails value) throws Exception {
            wrt.writeStartElement("userdetails");
            if (value != null) {
                Token token = value.getToken();
                XMLTokenMarshaller mar = new XMLTokenMarshaller();
                mar.marshall(wrt, token);
                String[] values = value.getRoles();
                for (int i = 0; values != null && i < values.length; ++i) {
                    String role = values[i];
                    wrt.writeStartElement("role");
                    wrt.writeAttribute("id", role);
                    wrt.writeEndElement();
                }
                XMLAttributeMarshaller attrMarshaller = new XMLAttributeMarshaller();
                Attribute[] vals = value.getAttributes();
                for (int i = 0; vals != null && i < vals.length; ++i) {
                    Attribute attr = vals[i];
                    attrMarshaller.marshall(wrt, attr);
                }
            }
            wrt.writeEndElement();
        }
    }

    static class XMLObjectNotFoundMarshaller
    implements Marshaller {
        XMLObjectNotFoundMarshaller() {
        }

        public void marshall(Writer wrt, Object value) throws Exception {
            assert (wrt != null && value != null);
            XMLOutputFactory xmlFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xwrt = xmlFactory.createXMLStreamWriter(wrt);
            xwrt.writeStartDocument();
            this.marshall(xwrt, (ObjectNotFound)value);
            xwrt.writeEndDocument();
        }

        public void marshall(XMLStreamWriter wrt, ObjectNotFound onf) throws Exception {
            wrt.writeStartElement("exception");
            wrt.writeAttribute("name", onf.getClass().getName());
            String msg = onf.getMessage();
            if (msg != null) {
                wrt.writeAttribute("message", onf.getMessage());
            }
            wrt.writeEndElement();
        }
    }

    static class XMLThrowableMarshaller
    implements Marshaller {
        XMLThrowableMarshaller() {
        }

        public void marshall(Writer wrt, Object value) throws Exception {
            assert (wrt != null && value != null);
            XMLOutputFactory xmlFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xwrt = xmlFactory.createXMLStreamWriter(wrt);
            xwrt.writeStartDocument();
            this.marshall(xwrt, (Throwable)value);
            xwrt.writeEndDocument();
        }

        public void marshall(XMLStreamWriter wrt, Throwable thr) throws Exception {
            wrt.writeStartElement("exception");
            wrt.writeAttribute("name", thr.getClass().getName());
            String msg = thr.getMessage();
            if (msg != null) {
                wrt.writeAttribute("message", thr.getMessage());
            }
            wrt.writeEndElement();
        }
    }

    static class XMLGeneralFailureMarshaller
    implements Marshaller {
        XMLGeneralFailureMarshaller() {
        }

        public void marshall(Writer wrt, Object value) throws Exception {
            assert (wrt != null);
            XMLOutputFactory xmlFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xwrt = xmlFactory.createXMLStreamWriter(wrt);
            xwrt.writeStartDocument();
            this.marshall(xwrt, (GeneralFailure)value);
            xwrt.writeEndDocument();
        }

        public void marshall(XMLStreamWriter wrt, GeneralFailure gf) throws Exception {
            assert (gf != null);
            wrt.writeStartElement("exception");
            wrt.writeAttribute("name", gf.getClass().getName());
            String msg = gf.getMessage();
            if (msg != null) {
                wrt.writeAttribute("message", gf.getMessage());
            }
            wrt.writeEndElement();
        }
    }

    static class XMLAttributeMarshaller
    implements Marshaller {
        XMLAttributeMarshaller() {
        }

        public void marshall(Writer wrt, Object value) throws Exception {
            assert (wrt != null);
            XMLOutputFactory xmlFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xwrt = xmlFactory.createXMLStreamWriter(wrt);
            xwrt.writeStartDocument();
            this.marshall(xwrt, (Attribute)value);
            xwrt.writeEndDocument();
        }

        public void marshall(XMLStreamWriter wrt, Attribute attr) throws Exception {
            assert (wrt != null && attr != null);
            wrt.writeStartElement("attribute");
            if (attr != null) {
                wrt.writeAttribute("name", attr.getName());
                String[] vals = attr.getValues();
                for (int i = 0; vals != null && i < vals.length; ++i) {
                    String val = vals[i];
                    wrt.writeStartElement("value");
                    wrt.writeCharacters(val);
                    wrt.writeEndElement();
                }
            }
            wrt.writeEndElement();
        }
    }

    static class XMLTokenMarshaller
    implements Marshaller {
        XMLTokenMarshaller() {
        }

        public void marshall(Writer wrt, Object value) throws Exception {
            assert (wrt != null);
            XMLOutputFactory xmlFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xwrt = xmlFactory.createXMLStreamWriter(wrt);
            xwrt.writeStartDocument();
            this.marshall(xwrt, (Token)value);
            xwrt.writeEndDocument();
        }

        public void marshall(XMLStreamWriter wrt, Token value) throws Exception {
            String token = value != null ? value.getId() : null;
            wrt.writeStartElement("token");
            if (token != null) {
                wrt.writeAttribute("id", token);
            }
            wrt.writeEndElement();
        }
    }
}

