/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.password.ui.model;

import com.sun.identity.common.AccountLockoutInfo;
import com.sun.identity.common.ISAccountLockout;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.password.ui.model.PWResetModelImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PWResetAccountLockout {
    private static Map pwResetFailHash = Collections.synchronizedMap(new HashMap());
    private int userWarningCount = 0;
    private PWResetModelImpl model = null;
    private ISAccountLockout isAccountLockout;

    public PWResetAccountLockout(PWResetModelImpl model) {
        this.model = model;
        this.isAccountLockout = new ISAccountLockout(model.isPasswordResetFailureLockoutEnabled(), model.getPasswordResetFailureLockoutTime(), model.getPasswordResetFailureLockoutCount(), model.getPasswordResetLockoutNotification(), model.getPasswordResetLockoutUserWarningCount(), model.getPasswordResetLockoutAttributeName(), model.getPasswordResetLockoutAttributeValue(), model.getPasswordResetFailureLockoutDuration(), 1, null, "amPasswordResetModuleMsgs");
    }

    public void invalidAnswer(AMIdentity amid) {
        if (!this.isAccountLockout.isLockoutEnabled()) {
            this.model.debugMessage("Password Reset Lockout feature is disabled.");
            return;
        }
        AccountLockoutInfo pwLockoutInfo = (AccountLockoutInfo)pwResetFailHash.get(amid.getUniversalId());
        pwLockoutInfo = this.isAccountLockout.invalidPasswd(amid, pwLockoutInfo);
        if (this.isAccountLockout.isAccountLocked(amid)) {
            pwResetFailHash.remove(amid.getUniversalId());
            this.userWarningCount = -1;
        } else {
            pwResetFailHash.put(amid.getUniversalId(), pwLockoutInfo);
        }
    }

    public int getWarnUserCount(String userDN) {
        AccountLockoutInfo acInfo = (AccountLockoutInfo)pwResetFailHash.get(userDN);
        return acInfo != null ? acInfo.getWarningCount() : this.userWarningCount;
    }

    public void removeUserLockoutEntry(String userDN) {
        pwResetFailHash.remove(userDN);
        this.userWarningCount = 0;
    }

    public boolean isLockout(String userDN) {
        boolean locked = false;
        AccountLockoutInfo acInfo = (AccountLockoutInfo)pwResetFailHash.get(userDN);
        if (acInfo != null && this.isAccountLockout.isMemoryLocking() && acInfo.isLockout() && !(locked = this.isAccountLockout.isLockedOut(acInfo))) {
            this.removeUserLockoutEntry(userDN);
        }
        return locked;
    }
}

