/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMEntryExistsException;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.common.IComplianceServices;
import com.iplanet.am.sdk.ldap.CommonUtils;
import com.iplanet.am.sdk.ldap.DCTreeServicesImpl;
import com.iplanet.am.sdk.ldap.DirectoryServicesFactory;
import com.iplanet.am.sdk.ldap.EmailNotificationHelper;
import com.iplanet.am.sdk.ldap.NamingAttributeManager;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.AssignableDynamicGroup;
import com.iplanet.ums.DynamicGroup;
import com.iplanet.ums.EntryNotFoundException;
import com.iplanet.ums.Guid;
import com.iplanet.ums.ManagedRole;
import com.iplanet.ums.Organization;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.Resource;
import com.iplanet.ums.StaticGroup;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.iplanet.ums.User;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.shared.ldap.util.RDN;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ComplianceServicesImpl
implements AMConstants,
IComplianceServices {
    private static Map roleToGroupMap = new HashMap();
    private static Map groupToRoleMap = new HashMap();
    private static Map deletedOrg = new HashMap();
    protected static final String ADMIN_GROUPS_ENABLED_ATTR = "iplanet-am-admin-console-compliance-admin-groups";
    protected static final String COMPLIANCE_USER_DELETION_ATTR = "iplanet-am-admin-console-compliance-user-deletion";
    private static String USER_STATUS_ATTRIBUTE = "inetuserstatus";
    private static String GROUP_STATUS_ATTRIBUTE = "inetgroupstatus";
    private static String ORG_STATUS_ATTRIBUTE = "inetdomainstatus";
    private static String RESOURCE_STATUS_ATTRIBUTE = "icsstatus";
    private static String DEFAULT_DELETED_ORG_FILTER = "(&(sunPreferredDomain=%V)(inetDomainStatus=deleted)(objectclass=sunManagedOrganization))";
    private static String DEFAULT_DELETED_GROUP_FILTER = "(&(inetgroupstatus=deleted)(objectclass=iplanet-am-managed-group))";
    private static String DEFAULT_DELETED_USER_FILTER = "(&(inetUserStatus=deleted)(objectclass=inetorgperson))";
    private static String DEFAULT_DELETED_OBJECT_FILTER = "(|(objectclass=*)(objectclass=ldapsubentry))";
    private static String DEFAULT_DELETED_RESOURCE_FILTER = "(&(objectclass=icsCalendarResource)(icsStatus = deleted))";
    private static String rootSuffix;
    protected static ServiceSchema gsc;
    static Debug debug;
    static SSOToken internalToken;

    private void addAttributesToEntry(SSOToken token, String dn, AttrSet attrSet) throws UMSException {
        PersistentObject po = UMSObject.getObjectHandle(token, new Guid(dn));
        int size = attrSet.size();
        for (int i = 0; i < size; ++i) {
            Attr attr = attrSet.elementAt(i);
            po.modify(attr, 0);
        }
        po.save();
    }

    private void removeAttributesFromEntry(SSOToken token, String dn, AttrSet attrSet) throws UMSException {
        PersistentObject po = UMSObject.getObjectHandle(token, new Guid(dn));
        int size = attrSet.size();
        for (int i = 0; i < size; ++i) {
            Attr attr = attrSet.elementAt(i);
            po.modify(attr, 1);
        }
        po.save();
    }

    private String getGroupFromRoleDN(DN dn) {
        String groupName = (String)roleToGroupMap.get(dn.toString());
        if (groupName == null) {
            String roleName = ((RDN)dn.getRDNs().firstElement()).getValues()[0];
            groupName = (String)roleToGroupMap.get(roleName);
            if (debug.messageEnabled()) {
                debug.message("Compliance.getGroupRoleFromDN():Role Name: " + roleName + " Group Name: " + groupName);
            }
        }
        return groupName;
    }

    private String getRoleFromGroupDN(DN dn) {
        String groupName = dn.explodeDN(true)[0];
        String roleName = (String)groupToRoleMap.get(groupName);
        if (debug.messageEnabled()) {
            debug.message("Compliance.getRoleFromGroupDN: Obtained group to role mapping: " + groupName + " ::" + roleName);
        }
        if (roleName == null) {
            if (debug.messageEnabled()) {
                debug.message("Compliance.getRoleFromGroupDN Group: " + dn.toString() + "is not an admin group");
            }
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("Compliance.getRoleFromGroupDN:Role Name: " + roleName + " Group Name: " + groupName);
        }
        return roleName;
    }

    protected void verifyAndLinkRoleToGroup(SSOToken token, Guid[] membersGuid, String roleDN) throws AMException {
        DN dn = new DN(roleDN);
        String groupName = this.getGroupFromRoleDN(dn);
        if (groupName != null) {
            String orgDN = dn.getParent().toString();
            String groupDN = NamingAttributeManager.getNamingAttribute(9) + "=" + groupName + ",ou=Groups," + orgDN;
            String groupRDN = NamingAttributeManager.getNamingAttribute(9) + "=" + groupName;
            try {
                AssignableDynamicGroup group = (AssignableDynamicGroup)UMSObject.getObject(token, new Guid(groupDN));
                group.addMembers(membersGuid);
                Attr[] attrs = new Attr[]{new Attr("adminrole", groupRDN)};
                AttrSet attrSet = new AttrSet(attrs);
                int numMembers = membersGuid.length;
                for (int i = 0; i < numMembers; ++i) {
                    this.addAttributesToEntry(token, membersGuid[i].getDn(), attrSet);
                }
            }
            catch (EntryNotFoundException ex) {
                debug.error("Compliance.verifyAndLinkRoleToGroup: Admin groups are missing");
            }
            catch (UMSException ue) {
                debug.error("Compliance.verifyAndLinkRoleToGroup(): ", (Throwable)ue);
                throw new AMException(AMSDKBundle.getString("771"), "771");
            }
        }
    }

    protected void verifyAndUnLinkRoleToGroup(SSOToken token, Set members, String roleDN) throws AMException {
        DN dn = new DN(roleDN);
        String groupName = this.getGroupFromRoleDN(dn);
        if (groupName != null) {
            String orgDN = dn.getParent().toString();
            String groupDN = NamingAttributeManager.getNamingAttribute(9) + "=" + groupName + ",ou=Groups," + orgDN;
            String groupRDN = NamingAttributeManager.getNamingAttribute(9) + "=" + groupName;
            Attr[] attrs = new Attr[]{new Attr("adminrole", groupRDN)};
            AttrSet attrSet = new AttrSet(attrs);
            Iterator itr = members.iterator();
            try {
                AssignableDynamicGroup group = (AssignableDynamicGroup)UMSObject.getObject(token, new Guid(groupDN));
                while (itr.hasNext()) {
                    String memberDN = (String)itr.next();
                    this.removeAttributesFromEntry(token, memberDN, attrSet);
                    group.removeMember(new Guid(memberDN));
                }
            }
            catch (EntryNotFoundException ex) {
                debug.error("Compliance.verifyAndUnLinkRoleToGroup: Admin groups are missing");
            }
            catch (UMSException ue) {
                debug.error("Compliance.verifyAndUnLinkRoleToGroup(): ", (Throwable)ue);
                throw new AMException(AMSDKBundle.getString("772"), "772");
            }
        }
    }

    protected void verifyAndLinkGroupToRole(SSOToken token, Guid[] membersGuid, String groupDN) throws AMException {
        DN dn = new DN(groupDN);
        String roleName = this.getRoleFromGroupDN(dn);
        if (roleName != null) {
            String orgDN = dn.getParent().getParent().toString();
            String roleDN = NamingAttributeManager.getNamingAttribute(6) + "=" + roleName + "," + orgDN;
            if (debug.messageEnabled()) {
                debug.message("Compliance.verifyAndLinkGroupToRole Linking group: " + groupDN + " to role :" + roleDN);
            }
            try {
                ManagedRole role = (ManagedRole)UMSObject.getObject(token, new Guid(roleDN));
                role.addMembers(membersGuid);
            }
            catch (EntryNotFoundException ex) {
                debug.error("Compliance.verifyAndLinkGroupToRole: Admin groups are missing");
            }
            catch (UMSException ue) {
                debug.error("Compliance.verifyAndLinkGroupToRole():", (Throwable)ue);
                Object[] args = new Object[]{roleDN};
                throw new AMException(AMSDKBundle.getString("972", args), "771", args);
            }
        }
    }

    protected void verifyAndUnLinkGroupToRole(SSOToken token, Set members, String groupDN) throws AMException {
        DN dn = new DN(groupDN);
        String roleName = this.getRoleFromGroupDN(dn);
        if (roleName != null) {
            String orgDN = dn.getParent().getParent().toString();
            String roleDN = NamingAttributeManager.getNamingAttribute(6) + "=" + roleName + "," + orgDN;
            if (debug.messageEnabled()) {
                debug.message("Compliance.verifyAndUnlinkGroupToRole(): Unlinking group: " + groupDN + " to role :" + roleDN);
            }
            Iterator itr = members.iterator();
            try {
                ManagedRole role = (ManagedRole)UMSObject.getObject(token, new Guid(roleDN));
                while (itr.hasNext()) {
                    String memberDN = (String)itr.next();
                    role.removeMember(new Guid(memberDN));
                }
            }
            catch (EntryNotFoundException ex) {
                debug.error("Compliance.verifyAndUnLinkGroupToRole: Admin groups are missing");
            }
            catch (UMSException ue) {
                debug.error("Compliance.verifyAndUnLinkGroupToRole(): ", (Throwable)ue);
                Object[] args = new Object[]{roleDN};
                throw new AMException(AMSDKBundle.getString("972", args), "772", args);
            }
        }
    }

    protected void verifyAttributes(AttrSet attrSet) throws AMException {
        String userStatus = attrSet.getValue(USER_STATUS_ATTRIBUTE);
        if (userStatus != null && userStatus.equalsIgnoreCase("deleted")) {
            debug.warning("Compliance.verifyAttributes(): " + USER_STATUS_ATTRIBUTE + ": " + userStatus);
            throw new AMException(AMSDKBundle.getString("327"), "327");
        }
    }

    protected AttrSet verifyAndGetAttributes(PersistentObject po, String[] attributeNames) throws AMException {
        AttrSet retAttrSet;
        boolean found = false;
        int numAttrs = attributeNames.length;
        String[] fetchAttributes = new String[numAttrs + 1];
        for (int i = 0; i < numAttrs; ++i) {
            if (attributeNames[i].equalsIgnoreCase(USER_STATUS_ATTRIBUTE)) {
                found = true;
                break;
            }
            fetchAttributes[i] = attributeNames[i];
        }
        if (!found) {
            fetchAttributes[i] = USER_STATUS_ATTRIBUTE;
        } else {
            fetchAttributes = attributeNames;
        }
        try {
            retAttrSet = po.getAttributes(fetchAttributes);
        }
        catch (UMSException ue) {
            debug.error("Compliance.verifyAndGetAttributes(): ", (Throwable)ue);
            throw new AMException(AMSDKBundle.getString("330"), "330");
        }
        this.verifyAttributes(retAttrSet);
        if (!found) {
            retAttrSet.remove(USER_STATUS_ATTRIBUTE);
        }
        return retAttrSet;
    }

    protected void checkIfDeletedUser(SSOToken token, String userDN) throws AMEntryExistsException {
        String attrValue;
        Attr attr;
        String[] userAttribute = new String[]{USER_STATUS_ATTRIBUTE};
        try {
            PersistentObject po = UMSObject.getObject(token, new Guid(userDN), userAttribute);
            attr = po.getAttribute(USER_STATUS_ATTRIBUTE);
        }
        catch (UMSException ue) {
            if (debug.messageEnabled()) {
                debug.message("Compliance.checkIfDeletedUser(): ", (Throwable)ue);
            }
            return;
        }
        if (attr != null && (attrValue = attr.getValue()) != null && attrValue.equalsIgnoreCase("deleted")) {
            debug.warning("Compliance.checkIfDeletedUser(): deleted user entry: " + userDN);
            throw new AMEntryExistsException(AMSDKBundle.getString("329"), "329");
        }
    }

    protected void checkIfDeletedOrg(SSOToken token, String orgDN) throws AMEntryExistsException {
        Attr attr;
        try {
            PersistentObject po = UMSObject.getObject(token, new Guid(orgDN));
            attr = po.getAttribute(ORG_STATUS_ATTRIBUTE);
        }
        catch (UMSException ue) {
            if (debug.messageEnabled()) {
                debug.message("Compliance.checkIfDeletedOrg(): ", (Throwable)ue);
            }
            return;
        }
        if (attr != null && attr.size() != 0 && attr.contains("deleted")) {
            debug.warning("Compliance.checkIfDeletedOrg(): deleted org entry: " + orgDN);
            throw new AMEntryExistsException(AMSDKBundle.getString("361"), "361");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAncestorOrgDeleted(SSOToken token, String dn, int profileType) throws AMException {
        if (debug.messageEnabled()) {
            debug.message("Compliance.isAncestorOrgDeleted->  checking from... " + dn);
        }
        String tdn = new DN(dn).toRFCString().toLowerCase();
        if (profileType == 2 && deletedOrg.containsKey(tdn) && ((Boolean)deletedOrg.get(tdn)).booleanValue()) {
            return true;
        }
        if (profileType != 2) {
            tdn = DirectoryServicesFactory.getInstance().getOrganizationDN(internalToken, dn);
        }
        while (!tdn.equalsIgnoreCase(rootSuffix)) {
            if (debug.messageEnabled()) {
                debug.message("Compliance.isAncestorOrgDeleted-> Checking for deleted status of " + tdn);
            }
            if (deletedOrg.containsKey(tdn)) {
                return (Boolean)deletedOrg.get(tdn);
            }
            try {
                Map map;
                PersistentObject po = UMSObject.getObject(internalToken, new Guid(tdn));
                Attr attr = po.getAttribute(ORG_STATUS_ATTRIBUTE);
                if (debug.messageEnabled() && attr != null) {
                    debug.message("Compliance.isAncestorOrgDeleted-> " + ORG_STATUS_ATTRIBUTE + "=" + attr.toString());
                }
                if (attr != null && attr.size() != 0 && attr.contains("deleted")) {
                    if (debug.messageEnabled()) {
                        debug.message("isAncestorOrgDeleted: caching org: " + tdn + " as deleted");
                    }
                    map = deletedOrg;
                    synchronized (map) {
                        deletedOrg.put(tdn, Boolean.TRUE);
                    }
                    return true;
                }
                if (debug.messageEnabled()) {
                    debug.message("isAncestorOrgDeleted: caching org: " + tdn + " as active");
                }
                map = deletedOrg;
                synchronized (map) {
                    deletedOrg.put(tdn, Boolean.FALSE);
                }
            }
            catch (UMSException umse) {
                debug.error("Compliance.isAncestorOrgDeleted-> UMSException", (Throwable)umse);
                return false;
            }
            tdn = DirectoryServicesFactory.getInstance().getOrganizationDN(token, dn);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanDeletedOrgCache(String orgDN) {
        String tdn = orgDN;
        while (!tdn.equalsIgnoreCase(rootSuffix)) {
            if (deletedOrg.containsKey(tdn)) {
                Map map = deletedOrg;
                synchronized (map) {
                    deletedOrg.remove(tdn);
                }
            }
            tdn = new DN(tdn).getParent().toRFCString().toLowerCase();
        }
    }

    public void verifyAndDeleteObject(SSOToken token, String profileDN) throws AMException {
        try {
            EmailNotificationHelper mailer = null;
            Map attributes = null;
            Guid guid = new Guid(profileDN);
            PersistentObject po = UMSObject.getObject(token, guid);
            if (po instanceof User) {
                Attr attr = new Attr(USER_STATUS_ATTRIBUTE, "deleted");
                if (debug.messageEnabled()) {
                    debug.message("Compliance:verifyAndDeleteObject: Soft-delete mode, setting inetuserstatus to deleted. profileDN=" + profileDN);
                }
                po.modify(attr, 2);
                po.save();
                mailer = new EmailNotificationHelper(profileDN);
                if (mailer != null) {
                    mailer.setUserDeleteNotificationList();
                    attributes = DirectoryServicesFactory.getInstance().getAttributes(token, profileDN, 1);
                    if (mailer.isPresentUserDeleteNotificationList()) {
                        mailer.sendUserDeleteNotification(attributes);
                    }
                }
                return;
            }
            if (po instanceof Resource) {
                Attr attr = new Attr(RESOURCE_STATUS_ATTRIBUTE, "deleted");
                if (debug.messageEnabled()) {
                    debug.message("Compliance:verifyAndDeleteObject: Soft-delete mode, setting icsstatus to deleted");
                }
                po.modify(attr, 2);
                po.save();
                return;
            }
            if (po instanceof StaticGroup || po instanceof AssignableDynamicGroup || po instanceof DynamicGroup) {
                Attr attr = new Attr(GROUP_STATUS_ATTRIBUTE, "deleted");
                if (debug.messageEnabled()) {
                    debug.message("Compliance:verifyAndDeleteObject: Soft-delete mode, setting inetgroupstatus to deleted");
                }
                po.modify(attr, 2);
                po.save();
                return;
            }
            if (po instanceof Organization) {
                if (debug.messageEnabled()) {
                    debug.message("Compliance:verifyAndDeleteObject: Soft-delete mode, setting inetdomainstatus to deleted");
                }
                Attr attr = new Attr(ORG_STATUS_ATTRIBUTE, "deleted");
                po.modify(attr, 2);
                po.save();
                DCTreeServicesImpl dcTreeImpl = (DCTreeServicesImpl)DirectoryServicesFactory.getInstance().getDCTreeServicesImpl();
                if (dcTreeImpl.isRequired()) {
                    dcTreeImpl.updateDomainStatus(token, profileDN, "deleted");
                }
            } else {
                UMSObject.removeObject(token, guid);
            }
        }
        catch (UMSException ue) {
            debug.error("Compliance.deleteObject(): ", (Throwable)ue);
            throw new AMException(AMSDKBundle.getString("773"), "773");
        }
        catch (SSOException se) {
            debug.error("Compliance.deleteObject(): ", (Throwable)((Object)se));
            throw new AMException(AMSDKBundle.getString("773"), "773");
        }
    }

    public static boolean isAdminGroupsEnabled(String orgDN) throws AMException {
        if (!ComplianceServicesImpl.isUnderRootSuffix(orgDN)) {
            return false;
        }
        try {
            if (gsc == null) {
                ServiceSchemaManager scm = new ServiceSchemaManager("iPlanetAMAdminConsoleService", internalToken);
                gsc = scm.getGlobalSchema();
            }
            Map attrMap = gsc.getReadOnlyAttributeDefaults();
            Set values = (Set)attrMap.get(ADMIN_GROUPS_ENABLED_ATTR);
            boolean enabled = false;
            if (values == null || values.isEmpty()) {
                enabled = false;
            } else {
                String val = (String)values.iterator().next();
                enabled = val.equalsIgnoreCase("true");
            }
            if (debug.messageEnabled()) {
                debug.message("Compliance.isAdminGroupsEnabled = " + enabled);
            }
            return enabled;
        }
        catch (SMSException ex) {
            debug.error(AMSDKBundle.getString("357"), (Throwable)ex);
            throw new AMException(AMSDKBundle.getString("357"), "357");
        }
        catch (SSOException ex) {
            debug.error(AMSDKBundle.getString("357"), (Throwable)((Object)ex));
            throw new AMException(AMSDKBundle.getString("357"), "357");
        }
    }

    protected static boolean isUnderRootSuffix(String objDN) {
        if (objDN == null || objDN.length() == 0) {
            return true;
        }
        DN rootDN = new DN(rootSuffix);
        DN objectDN = new DN(objDN);
        return rootDN.equals(objectDN) || rootDN.equals(objectDN.getParent());
    }

    protected void createAdminGroups(SSOToken token, PersistentObject org) throws AMException, SSOException {
        String gcDN = NamingAttributeManager.getNamingAttribute(4) + "=groups," + org.getDN();
        AttrSet attrSet = new AttrSet();
        Attr attr = new Attr("objectclass", "inetadmin");
        attrSet.add(attr);
        attr = new Attr("adminrole", "DomainAdministrators");
        attrSet.add(attr);
        Map attributes = CommonUtils.attrSetToMap(attrSet);
        DirectoryServicesFactory.getInstance().createEntry(token, "DomainAdministrators", 12, gcDN, attributes);
        attrSet = new AttrSet();
        attr = new Attr("objectclass", "inetadmin");
        attrSet.add(attr);
        attr = new Attr("adminrole", "DomainAdministrators");
        attrSet.add(attr);
        attributes = CommonUtils.attrSetToMap(attrSet);
        DirectoryServicesFactory.getInstance().createEntry(token, "DomainHelpDeskAdministrators", 12, gcDN, attributes);
    }

    public static boolean isComplianceUserDeletionEnabled() throws AMException {
        try {
            if (gsc == null) {
                ServiceSchemaManager scm = new ServiceSchemaManager("iPlanetAMAdminConsoleService", internalToken);
                gsc = scm.getGlobalSchema();
            }
            Map attrMap = gsc.getReadOnlyAttributeDefaults();
            Set values = (Set)attrMap.get(COMPLIANCE_USER_DELETION_ATTR);
            boolean enabled = false;
            if (values == null || values.isEmpty()) {
                enabled = false;
            } else {
                String val = (String)values.iterator().next();
                enabled = val.equalsIgnoreCase("true");
            }
            if (debug.messageEnabled()) {
                debug.message("Compliance.isComplianceUserDeletionEnabled = " + enabled);
            }
            return enabled;
        }
        catch (SMSException ex) {
            debug.error(AMSDKBundle.getString("359"), (Throwable)ex);
            throw new AMException(AMSDKBundle.getString("359"), "359");
        }
        catch (SSOException ex) {
            debug.error(AMSDKBundle.getString("359"), (Throwable)((Object)ex));
            throw new AMException(AMSDKBundle.getString("359"), "359");
        }
    }

    public String getDeletedObjectFilter(int objectType) throws AMException, SSOException {
        Set values = new HashSet();
        try {
            Map attrMap;
            if (gsc == null) {
                ServiceSchemaManager scm = new ServiceSchemaManager("iPlanetAMAdminConsoleService", internalToken);
                gsc = scm.getGlobalSchema();
            }
            if ((attrMap = gsc.getAttributeDefaults()) != null) {
                values = (Set)attrMap.get("iplanet-am-admin-console-special-search-filters");
            }
            if (debug.messageEnabled()) {
                debug.message("Compliance.getDeletedObjectSearchFilter = " + values.toString());
            }
        }
        catch (SMSException ex) {
            debug.error(AMSDKBundle.getString("359"), (Throwable)ex);
            throw new AMException(AMSDKBundle.getString("359"), "359");
        }
        catch (SSOException ex) {
            debug.error(AMSDKBundle.getString("359"), (Throwable)((Object)ex));
            throw new AMException(AMSDKBundle.getString("359"), "359");
        }
        String org_filter = null;
        String group_filter = null;
        String user_filter = null;
        String def_filter = null;
        String res_filter = null;
        for (String thisFilter : values) {
            if (thisFilter.startsWith("Organization=")) {
                org_filter = thisFilter.substring(13);
                continue;
            }
            if (thisFilter.startsWith("Group=")) {
                group_filter = thisFilter.substring(6);
                continue;
            }
            if (thisFilter.startsWith("User=")) {
                user_filter = thisFilter.substring(5);
                continue;
            }
            if (thisFilter.startsWith("Misc=")) {
                def_filter = thisFilter.substring(5);
                continue;
            }
            if (!thisFilter.startsWith("Resource=")) continue;
            res_filter = thisFilter.substring(9);
        }
        org_filter = org_filter == null ? DEFAULT_DELETED_ORG_FILTER : org_filter;
        group_filter = group_filter == null ? DEFAULT_DELETED_GROUP_FILTER : group_filter;
        user_filter = user_filter == null ? DEFAULT_DELETED_USER_FILTER : user_filter;
        def_filter = def_filter == null ? DEFAULT_DELETED_OBJECT_FILTER : def_filter;
        res_filter = res_filter == null ? DEFAULT_DELETED_RESOURCE_FILTER : res_filter;
        switch (objectType) {
            case 2: {
                return org_filter;
            }
            case 1: {
                return user_filter;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return group_filter;
            }
            case 21: {
                return res_filter;
            }
        }
        return "(|" + org_filter + group_filter + user_filter + def_filter + res_filter + ")";
    }

    static {
        gsc = null;
        debug = CommonUtils.debug;
        internalToken = CommonUtils.getInternalToken();
        rootSuffix = AMStoreConnection.getAMSdkBaseDN();
        if (rootSuffix == null || rootSuffix == "") {
            debug.error("com.iplanet.am.rootsuffix property value should not be null");
        }
    }
}

