/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums.cos;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.Guid;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.cos.COSNotFoundException;
import com.iplanet.ums.cos.COSTemplate;
import com.iplanet.ums.cos.ICOSDefinition;
import java.util.ArrayList;
import java.util.Collection;

public class DirectCOSDefinition
extends PersistentObject
implements ICOSDefinition {
    private static final Class _class = DirectCOSDefinition.class;
    private static I18n i18n = I18n.getInstance("amSDK");

    public DirectCOSDefinition() {
    }

    public DirectCOSDefinition(AttrSet attrSet) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet);
    }

    public DirectCOSDefinition(CreationTemplate template, AttrSet attrSet) throws UMSException {
        super(template, attrSet);
    }

    public void setName(String name) {
        this.setAttribute(new Attr("cn", name));
    }

    public String getName() {
        String attributeValue = null;
        Attr attribute = this.getAttribute(this.getNamingAttribute());
        if (attribute != null) {
            attributeValue = attribute.getValue();
        }
        return attributeValue;
    }

    public void addCOSAttribute(String attrName, int qualifier) throws UMSException {
        StringBuffer attrStr = new StringBuffer();
        if (qualifier < 0 || qualifier > 2) {
            String msg = i18n.getString("cos-bad_cos_attr_qualifier");
            throw new UMSException(msg);
        }
        attrStr.append(attrName);
        attrStr.append(" ");
        attrStr.append(ICOSDefinition.qualifiers[qualifier]);
        this.modify("cosAttribute", attrStr.toString(), 0);
    }

    public void removeCOSAttribute(String attrName) {
        this.modify(new Attr("cosAttribute", attrName), 1);
    }

    public String[] getCOSAttributes() {
        Attr attr = this.getAttribute("cosAttribute");
        return attr.getStringValues();
    }

    public void setCOSSpecifier(String cosSpecifier) {
        this.setAttribute(new Attr("cosSpecifier", cosSpecifier));
    }

    public String getCOSSpecifier() {
        String attributeValue = null;
        Attr attribute = this.getAttribute("cosSpecifier");
        if (attribute != null) {
            attributeValue = attribute.getValue();
        }
        return attributeValue;
    }

    public void addCOSTemplate(COSTemplate cosTemplate) throws UMSException {
        if (this.getGuid() == null) {
            String msg = i18n.getString("cos-definition_not_persistent");
            throw new UMSException(msg);
        }
        if (this.getAttribute("cosTemplateDn") == null) {
            this.modify(new Attr("cosTemplateDn", this.getGuid().getDn()), 0);
            this.save();
        }
        this.addChild(cosTemplate);
    }

    public void removeCOSTemplate(String name) throws UMSException {
        Guid tGuid = new Guid("cn=" + name + "," + this.getGuid());
        this.removeChild(tGuid);
    }

    public void removeCOSTemplates() throws UMSException {
        ArrayList aList = (ArrayList)this.getCOSTemplates();
        for (int i = 0; i < aList.size(); ++i) {
            COSTemplate cosTemplate = (COSTemplate)aList.get(i);
            cosTemplate.remove();
        }
    }

    public COSTemplate getCOSTemplate(String name) throws COSNotFoundException, UMSException {
        COSTemplate cosTemplate = null;
        String[] resultAttributes = new String[]{"*"};
        SearchResults sr = this.search("(cn=" + name + ")", resultAttributes, null);
        while (sr.hasMoreElements()) {
            cosTemplate = (COSTemplate)sr.next();
            sr.abandon();
        }
        if (cosTemplate == null) {
            String msg = i18n.getString("cos-cos_template_not_found");
            throw new COSNotFoundException(msg);
        }
        return cosTemplate;
    }

    public Collection getCOSTemplates() throws UMSException {
        COSTemplate cosTemplate = null;
        ArrayList<COSTemplate> cosTemplates = new ArrayList<COSTemplate>();
        String[] resultAttributes = new String[]{"*"};
        SearchResults sr = this.search("(objectclass=costemplate)", resultAttributes, null);
        while (sr.hasMoreElements()) {
            cosTemplate = (COSTemplate)sr.next();
            cosTemplates.add(cosTemplate);
        }
        return cosTemplates;
    }
}

