/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base.model;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOToken;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMResBundleCacher;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.Logger;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ResourceBundle;
import java.util.logging.Level;

public class AMAdminLog {
    private static Debug debug = Debug.getInstance((String)"amConsole");
    private static final String accessLogFile = "amConsole.access";
    private static final String errorLogFile = "amConsole.error";
    private static AMAdminLog instance = new AMAdminLog();
    private Logger accessLogger = null;
    private Logger errorLogger = null;
    private java.util.Locale locale = null;
    private SSOToken ssoToken = null;
    private ResourceBundle resBundle = null;
    private boolean logStatus = false;

    private AMAdminLog() {
        this.getSuperAdminSSOToken();
        String status = SystemProperties.get("com.iplanet.am.logstatus");
        this.logStatus = status.equalsIgnoreCase("Active");
        if (this.logStatus) {
            this.accessLogger = (Logger)Logger.getLogger(accessLogFile);
            this.errorLogger = (Logger)Logger.getLogger(errorLogFile);
            String lstr = SystemProperties.get("com.iplanet.am.locale");
            this.locale = Locale.getLocale((String)lstr);
            this.resBundle = AMResBundleCacher.getBundle("amConsole", this.locale);
        }
    }

    private void getSuperAdminSSOToken() {
        this.ssoToken = (SSOToken)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return AMAdminUtils.getSuperAdminSSOToken();
                }
                catch (SecurityException e) {
                    debug.error("AMAdminLog.getSuperAdminSSOToken", (Throwable)e);
                    return null;
                }
            }
        });
    }

    public static AMAdminLog getInstance() {
        return instance;
    }

    public void doLog(LogRecord rec) {
        if (rec != null) {
            if (rec.getLevel().equals(Level.INFO)) {
                this.doLog(this.accessLogger, rec);
            } else {
                this.doLog(this.errorLogger, rec);
            }
        }
    }

    private void doLog(Logger logger, LogRecord rec) {
        if (logger == null) {
            if (this.logStatus) {
                debug.error("AMAdminLog.doLog - no logger. Would have logged: " + rec.getMessage());
            }
        } else {
            try {
                logger.log(rec, this.ssoToken);
            }
            catch (Exception log) {
                debug.error("AMAdminLog.doLog - problem writing to log " + log.getMessage());
            }
        }
    }
}

