/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base.model;

import com.iplanet.sso.SSOException;
import com.sun.identity.console.base.AMViewConfig;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.base.model.AMServiceProfileModel;
import com.sun.identity.console.delegation.model.DelegationConfig;
import com.sun.identity.console.property.PropertyXMLBuilder;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class AMServiceProfileModelImpl
extends AMModelBase
implements AMServiceProfileModel {
    protected PropertyXMLBuilder xmlBuilder;
    private static Set DISPLAY_SCHEMA_TYPES = new HashSet();
    protected String serviceName;

    public AMServiceProfileModelImpl(HttpServletRequest req, String serviceName, Map map) throws AMConsoleException {
        super(req, map);
        this.serviceName = serviceName;
        try {
            this.xmlBuilder = new PropertyXMLBuilder(serviceName, this.getDisplaySchemaTypes(), this);
            if (serviceName.equals("iPlanetAMAdminConsoleService") && ServiceManager.isRealmEnabled()) {
                AMViewConfig config = AMViewConfig.getInstance();
                this.xmlBuilder.discardAttribute(config.getRealmEnableHiddenConsoleAttrNames());
            }
        }
        catch (SMSException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public Set getDisplaySchemaTypes() {
        return DISPLAY_SCHEMA_TYPES;
    }

    public String getPageTitle() {
        return this.getLocalizedServiceName(this.serviceName);
    }

    protected ServiceSchemaManager getServiceSchemaManager() {
        return this.xmlBuilder.getServiceSchemaManager();
    }

    public String getPropertySheetXML(String realmName, String viewbeanClassName, String serviceName) throws AMConsoleException {
        DelegationConfig dConfig = DelegationConfig.getInstance();
        boolean canModify = dConfig.hasPermission(realmName, serviceName, "MODIFY", this, viewbeanClassName);
        if (!canModify) {
            this.xmlBuilder.setAllAttributeReadOnly(true);
        }
        try {
            return this.xmlBuilder.getXML(realmName);
        }
        catch (SMSException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public Map getAttributeValues() {
        String[] param = new String[]{this.serviceName};
        this.logEvent("ATTEMPT_READ_ALL_GLOBAL_DEFAULT_ATTRIBUTE_VALUES", param);
        Set attributeSchemas = this.xmlBuilder.getAttributeSchemas();
        HashMap<String, Object> values = new HashMap<String, Object>(attributeSchemas.size() * 2);
        for (AttributeSchema as : attributeSchemas) {
            AttributeSchema.UIType uiType = as.getUIType();
            if (uiType != null && (uiType.equals(AttributeSchema.UIType.NAME_VALUE_LIST) || uiType.equals(AttributeSchema.UIType.BUTTON) || uiType.equals(AttributeSchema.UIType.LINK))) continue;
            AttributeSchema.Type type = as.getType();
            if (type == AttributeSchema.Type.MULTIPLE_CHOICE || type == AttributeSchema.Type.SINGLE_CHOICE) {
                HashMap<String, Set> tmp = new HashMap<String, Set>(4);
                tmp.put("choices", AMAdminUtils.toSet(as.getChoiceValues()));
                tmp.put("values", as.getDefaultValues());
                values.put(as.getName(), tmp);
            }
            values.put(as.getName(), as.getDefaultValues());
        }
        this.logEvent("SUCCEED_READ_ALL_GLOBAL_DEFAULT_ATTRIBUTE_VALUES", param);
        return values;
    }

    public Set getAttributeValues(String name) {
        boolean found = false;
        Set values = null;
        Set attributeSchemas = this.xmlBuilder.getAttributeSchemas();
        String[] params = new String[]{this.serviceName, name};
        this.logEvent("ATTEMPT_READ_GLOBAL_DEFAULT_ATTRIBUTE_VALUES", params);
        Iterator i = attributeSchemas.iterator();
        while (i.hasNext() && !found) {
            AttributeSchema as = (AttributeSchema)i.next();
            if (!as.getName().equals(name)) continue;
            values = as.getDefaultValues();
            found = true;
        }
        if (found) {
            this.logEvent("SUCCEED_READ_GLOBAL_DEFAULT_ATTRIBUTE_VALUES", params);
        } else {
            this.logEvent("FAILED_READ_GLOBAL_DEFAULT_ATTRIBUTE_VALUES", params);
        }
        return values == null ? Collections.EMPTY_SET : values;
    }

    public void setAttributeValues(Map map) throws AMConsoleException {
        HashSet attributeSchemas = new HashSet();
        attributeSchemas.addAll(this.xmlBuilder.getAttributeSchemas());
        this.addMoreAttributeSchemasForModification(attributeSchemas);
        HashMap<ServiceSchema, HashMap<String, Set>> mapSvcSchemaToMapNameToValues = new HashMap<ServiceSchema, HashMap<String, Set>>();
        for (AttributeSchema as : attributeSchemas) {
            String name = as.getName();
            Set values = (Set)map.get(name);
            if (values == null) continue;
            ServiceSchema ss = as.getServiceSchema();
            HashMap<String, Set> m = (HashMap<String, Set>)mapSvcSchemaToMapNameToValues.get(ss);
            if (m == null) {
                m = new HashMap<String, Set>();
                mapSvcSchemaToMapNameToValues.put(ss, m);
            }
            m.put(name, values);
        }
        if (!mapSvcSchemaToMapNameToValues.isEmpty()) {
            for (ServiceSchema ss : mapSvcSchemaToMapNameToValues.keySet()) {
                this.setDefaultValues(ss, (Map)mapSvcSchemaToMapNameToValues.get(ss));
            }
        }
    }

    private void setDefaultValues(ServiceSchema ss, Map map) throws AMConsoleException {
        String csvNames = AMFormatUtils.toCommaSeparatedFormat(map.keySet());
        String[] params = new String[]{this.serviceName, csvNames};
        this.logEvent("ATTEMPT_WRITE_GLOBAL_DEFAULT_ATTRIBUTE_VALUES", params);
        try {
            ss.setAttributeDefaults(map);
            this.logEvent("SUCCEED_WRITE_GLOBAL_DEFAULT_ATTRIBUTE_VALUES", params);
        }
        catch (SMSException e) {
            String[] paramsEx = new String[]{this.serviceName, csvNames, this.getErrorString(e)};
            this.logEvent("SMS_EXCEPTION_WRITE_GLOBAL_DEFAULT_ATTRIBUTE_VALUES", paramsEx);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{this.serviceName, csvNames, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("SSO_EXCEPTION_WRITE_GLOBAL_DEFAULT_ATTRIBUTE_VALUES", paramsEx);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    protected void addMoreAttributeSchemasForModification(Set attributeSchemas) {
    }

    public String getPropertiesViewBean(String name) {
        Set attributeSchemas = this.xmlBuilder.getAttributeSchemas();
        String url = null;
        Iterator iter = attributeSchemas.iterator();
        while (iter.hasNext() && url == null) {
            AttributeSchema as = (AttributeSchema)iter.next();
            if (!as.getName().equals(name)) continue;
            url = as.getPropertiesViewBeanURL();
        }
        return url;
    }

    static {
        DISPLAY_SCHEMA_TYPES.add(SchemaType.GLOBAL);
        DISPLAY_SCHEMA_TYPES.add(SchemaType.ORGANIZATION);
        DISPLAY_SCHEMA_TYPES.add(SchemaType.DYNAMIC);
    }
}

