/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.session;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.AMConsoleConfig;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.components.view.html.SerializedField;
import com.sun.identity.console.session.SMViewBeanBase;
import com.sun.identity.console.session.model.SMProfileModel;
import com.sun.identity.console.session.model.SMProfileModelImpl;
import com.sun.identity.console.session.model.SMSessionCache;
import com.sun.identity.console.session.model.SMSessionData;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class SMProfileViewBean
extends SMViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/session/SMProfile.jsp";
    private static final String TF_FILTER = "tfFilter";
    private static final String BTN_SEARCH = "btnSearch";
    private static final String TBL_SESSIONS = "tblSessions";
    private static final String TBL_BUTTON_INVALIDATE = "tblButtonInvalidate";
    private static final String TBL_COL_USER_ID = "tblColUserId";
    private static final String TBL_COL_TIME_LEFT = "tblColTimeLeft";
    private static final String TBL_COL_MAX_SESSION_TIME = "tblColMaxSessionTime";
    private static final String TBL_COL_IDLE_TIME = "tblColIdleTime";
    private static final String TBL_COL_MAX_IDLE_TIME = "tblColMaxIdleTime";
    private static final String TBL_DATA_USER_ID = "tblDataUserId";
    private static final String TBL_DATA_TIME_LEFT = "tblDataTimeLeft";
    private static final String TBL_DATA_MAX_SESSION_TIME = "tblDataMaxSessionTime";
    private static final String TBL_DATA_IDLE_TIME = "tblDataIdleTime";
    private static final String TBL_DATA_MAX_IDLE_TIME = "tblDataMaxIdleTime";
    private static final String TBL_DATA_SESSION_ID = "sessionId";
    private static final String PAGETITLE = "pgtitle";
    public static final String CHILD_SERVER_NAME_HREF = "serverNameHref";
    public static final String CHILD_SERVER_NAME_MENU = "serverNameMenu";
    private static final String LOGOUT_URL = "logoutUrl";
    private static final String SERVER_NAME = "SERVER_NAME";
    private CCActionTableModel tblModel = null;
    private CCPageTitleModel ptModel;
    protected int curPage = 0;
    private boolean validSession = true;

    public SMProfileViewBean() {
        super("SMProfile");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.createTableModel();
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/simplePageTitle.xml"));
        this.registerChildren();
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(TF_FILTER, CCTextField.class);
        this.registerChild(BTN_SEARCH, CCButton.class);
        this.registerChild(PAGETITLE, CCPageTitle.class);
        this.registerChild(TBL_SESSIONS, CCActionTable.class);
        this.registerChild(CHILD_SERVER_NAME_HREF, CCHref.class);
        this.registerChild(CHILD_SERVER_NAME_MENU, CCDropDownMenu.class);
        this.registerChild(LOGOUT_URL, CCStaticTextField.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.tblModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        if (name.equals(TBL_SESSIONS)) {
            SerializedField szCache = (SerializedField)this.getChild("szCache");
            this.populateTableModel((List)szCache.getSerializedObj());
            view = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tblModel, name);
        } else if (name.equals(PAGETITLE)) {
            view = new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name);
        } else if (this.tblModel.isChildSupported(name)) {
            view = this.tblModel.createChild((View)this, name);
        } else if (name.equals(CHILD_SERVER_NAME_MENU)) {
            view = new CCDropDownMenu((ContainerView)this, name, null);
        } else {
            if (name.equals(LOGOUT_URL)) {
                return new CCStaticTextField((ContainerView)this, LOGOUT_URL, (Object)"");
            }
            view = name.equals(CHILD_SERVER_NAME_HREF) ? new CCHref((ContainerView)this, name, null) : super.createChild(name);
        }
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        if (this.validSession) {
            super.beginDisplay(event);
            SMProfileModel model = (SMProfileModel)this.getModel();
            Map map = model.getServerNames();
            OptionList optList = new OptionList();
            CCDropDownMenu child = (CCDropDownMenu)this.getChild(CHILD_SERVER_NAME_MENU);
            String value = (String)child.getValue();
            if (map != null && !map.isEmpty()) {
                for (String str : map.keySet()) {
                    String val = (String)map.get(str);
                    optList.add(str, val);
                    if (value != null) continue;
                    child.setValue((Object)val);
                }
            }
            child.setOptions(optList);
            value = (String)child.getValue();
            model.setProfileServerName(value);
            SMSessionCache cache = null;
            try {
                cache = model.getSessionCache(this.getFilterString());
                if (cache != null) {
                    this.populateTableModel(cache.getSessions());
                    String errorMessage = cache.getErrorMessage();
                    if (errorMessage != null && errorMessage.length() > 0) {
                        this.setInlineAlertMessage("warning", "message.warning", errorMessage);
                    }
                }
            }
            catch (AMConsoleException ae) {
                this.setInlineAlertMessage("error", "message.error", ae.getMessage());
            }
            if (cache == null) {
                this.populateTableModel(Collections.EMPTY_LIST);
            }
            this.setPageSessionAttribute(SERVER_NAME, (Serializable)((Object)value));
        }
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = this.getRequestContext().getRequest();
        return new SMProfileModelImpl(req, this.getPageSessionAttributes());
    }

    private void createTableModel() {
        this.tblModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblSMSessions.xml"));
        this.tblModel.setTitleLabel("label.items");
        this.tblModel.setActionValue(TBL_BUTTON_INVALIDATE, (Object)"button.invalidate");
        this.tblModel.setActionValue(TBL_COL_USER_ID, (Object)"table.session.userid.column.name");
        this.tblModel.setActionValue(TBL_COL_TIME_LEFT, (Object)"table.session.timeleft.column.name");
        this.tblModel.setActionValue(TBL_COL_MAX_SESSION_TIME, (Object)"table.session.maxsessiontime.column.name");
        this.tblModel.setActionValue(TBL_COL_IDLE_TIME, (Object)"table.session.idletime.column.name");
        this.tblModel.setActionValue(TBL_COL_MAX_IDLE_TIME, (Object)"table.session.maxidletime.column.name");
    }

    protected String getFilterString() {
        String filter = (String)this.getDisplayFieldValue(TF_FILTER);
        if (filter == null) {
            filter = "*";
        } else if ((filter = filter.trim()).length() == 0) {
            filter = "*";
        }
        this.setDisplayFieldValue(TF_FILTER, filter);
        return filter;
    }

    private void populateTableModel(List sessionList) {
        SMProfileModel model = (SMProfileModel)this.getModel();
        this.tblModel.clearAll();
        this.tblModel.setMaxRows(model.getPageSize());
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        if (sessionList != null && !sessionList.isEmpty()) {
            for (int i = 0; i < sessionList.size(); ++i) {
                SMSessionData sData = (SMSessionData)sessionList.get(i);
                this.tblModel.appendRow();
                this.tblModel.setValue(TBL_DATA_SESSION_ID, (Object)sData.getId());
                this.tblModel.setValue(TBL_DATA_USER_ID, (Object)sData.getUserId());
                this.tblModel.setValue(TBL_DATA_TIME_LEFT, (Object)String.valueOf(sData.getTimeRemain()));
                this.tblModel.setValue(TBL_DATA_MAX_SESSION_TIME, (Object)String.valueOf(sData.getMaxSessionTime()));
                this.tblModel.setValue(TBL_DATA_IDLE_TIME, (Object)String.valueOf(sData.getIdleTime()));
                this.tblModel.setValue(TBL_DATA_MAX_IDLE_TIME, (Object)String.valueOf(sData.getMaxIdleTime()));
            }
            szCache.setValue((Serializable)((Object)sessionList));
        } else {
            szCache.setValue(null);
        }
    }

    public void handleBtnSearchRequest(RequestInvocationEvent event) {
        SMProfileModel model = (SMProfileModel)this.getModel();
        String serverName = (String)this.getPageSessionAttribute(SERVER_NAME);
        model.setProfileServerName(serverName);
        this.forwardTo();
    }

    public void handleTblButtonInvalidateRequest(RequestInvocationEvent event) throws ModelControlException {
        SMProfileModel model = (SMProfileModel)this.getModel();
        String serverName = (String)this.getPageSessionAttribute(SERVER_NAME);
        model.setProfileServerName(serverName);
        CCActionTable child = (CCActionTable)this.getChild(TBL_SESSIONS);
        child.restoreStateData();
        Integer[] selected = this.tblModel.getSelectedRows();
        ArrayList<String> names = new ArrayList<String>(selected.length * 2);
        for (int i = 0; i < selected.length; ++i) {
            this.tblModel.setRowIndex(selected[i].intValue());
            names.add((String)this.tblModel.getValue(TBL_DATA_SESSION_ID));
        }
        boolean error = false;
        List failList = null;
        try {
            failList = model.invalidateSessions(names, this.getFilterString());
        }
        catch (AMConsoleException e) {
            error = true;
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        if (error || failList == null || !failList.isEmpty()) {
            // empty if block
        }
        if (!model.isSessionValid()) {
            this.validSession = false;
        }
        this.forwardTo();
    }

    public void handleServerNameHrefRequest(RequestInvocationEvent event) {
        String value = this.getDisplayFieldValue(CHILD_SERVER_NAME_MENU) != null ? (String)this.getDisplayFieldValue(CHILD_SERVER_NAME_MENU) : "";
        this.forwardTo();
    }

    public boolean beginToLogoutDisplay(ChildDisplayEvent event) {
        boolean display = false;
        if (!this.validSession) {
            HttpServletRequest req = this.getRequestContext().getRequest();
            AMConsoleConfig config = AMConsoleConfig.getInstance();
            this.setDisplayFieldValue(LOGOUT_URL, config.getLogoutURL(req));
            display = true;
        }
        return display;
    }
}

