/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.EntitlementConfiguration;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.Privilege;
import com.sun.identity.entitlement.PrivilegeIndexStore;
import com.sun.identity.entitlement.util.DebugFactory;
import com.sun.identity.entitlement.util.PrivilegeSearchFilter;
import com.sun.identity.shared.debug.IDebug;
import java.security.Principal;
import java.util.Date;
import java.util.Set;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrivilegeManager {
    public static final IDebug debug = DebugFactory.getDebug("Entitlement");
    public static final Subject superAdminSubject = new Subject();
    private String realm;
    private Subject adminSubject;

    public static PrivilegeManager getInstance(String realm, Subject subject) {
        EntitlementConfiguration ec = EntitlementConfiguration.getInstance(subject, realm);
        if (!ec.migratedToEntitlementService()) {
            throw new UnsupportedOperationException("Updating of DITs is required before using the entitlement service");
        }
        PrivilegeManager pm = null;
        try {
            Class<?> clazz = Class.forName("com.sun.identity.entitlement.opensso.PolicyPrivilegeManager");
            pm = (PrivilegeManager)clazz.newInstance();
            pm.initialize(realm, subject);
        }
        catch (ClassNotFoundException e) {
            debug.error("PrivilegeManager.getInstance", (Throwable)e);
        }
        catch (InstantiationException e) {
            debug.error("PrivilegeManager.getInstance", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            debug.error("PrivilegeManager.getInstance", (Throwable)e);
        }
        return pm;
    }

    protected PrivilegeManager() {
    }

    public void initialize(String realm, Subject subject) {
        this.realm = realm;
        this.adminSubject = subject;
    }

    public abstract Privilege getPrivilege(String var1) throws EntitlementException;

    private void validatePrivilege(Privilege privilege) throws EntitlementException {
        String pName = privilege.getName();
        if (pName == null || pName.trim().length() == 0) {
            throw new EntitlementException(3);
        }
        if (privilege.getEntitlement() == null) {
            throw new EntitlementException(4);
        }
        privilege.validateSubject(privilege.getSubject());
    }

    public void addPrivilege(Privilege privilege) throws EntitlementException {
        String principalName;
        this.validatePrivilege(privilege);
        Date date = new Date();
        privilege.validateResourceNames(this.adminSubject, this.realm);
        privilege.setCreationDate(date.getTime());
        privilege.setLastModifiedDate(date.getTime());
        Set<Principal> principals = this.adminSubject.getPrincipals();
        String string = principalName = principals != null && !principals.isEmpty() ? principals.iterator().next().getName() : null;
        if (principalName != null) {
            privilege.setCreatedBy(principalName);
            privilege.setLastModifiedBy(principalName);
        }
    }

    public void removePrivilege(String privilegeName) throws EntitlementException {
    }

    public void modifyPrivilege(Privilege privilege) throws EntitlementException {
        this.validatePrivilege(privilege);
        privilege.validateResourceNames(this.adminSubject, this.realm);
        Privilege origPrivilege = this.getPrivilege(privilege.getName());
        if (origPrivilege != null) {
            privilege.setCreatedBy(origPrivilege.getCreatedBy());
            privilege.setCreationDate(origPrivilege.getCreationDate());
        }
        Date date = new Date();
        privilege.setLastModifiedDate(date.getTime());
        Set<Principal> principals = this.adminSubject.getPrincipals();
        if (principals != null && !principals.isEmpty()) {
            privilege.setLastModifiedBy(principals.iterator().next().getName());
        }
    }

    public Set<String> searchPrivilegeNames(Set<PrivilegeSearchFilter> filter, int searchSizeLimit, int searchTimeLimit) throws EntitlementException {
        PrivilegeIndexStore pis = PrivilegeIndexStore.getInstance(this.adminSubject, this.realm);
        return pis.searchPrivilegeNames(filter, true, searchSizeLimit, false, false);
    }

    public Set<String> searchPrivilegeNames(Set<PrivilegeSearchFilter> filter) throws EntitlementException {
        PrivilegeIndexStore pis = PrivilegeIndexStore.getInstance(this.adminSubject, this.realm);
        return pis.searchPrivilegeNames(filter, true, 0, false, false);
    }

    public String getRealm() {
        return this.realm;
    }

    public abstract String getPrivilegeXML(String var1) throws EntitlementException;

    protected Subject getAdminSubject() {
        return this.adminSubject;
    }
}

