/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.EntitlementSubject;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.SubjectAttributesManager;
import com.sun.identity.entitlement.SubjectDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.security.AdminTokenAction;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicySubject
implements EntitlementSubject {
    private String name;
    private String className;
    private Set<String> values;
    private boolean exclusive;

    public PolicySubject() {
    }

    public PolicySubject(String name, String className, Set<String> values, boolean exclusive) {
        this.name = name;
        this.className = className;
        this.values = values;
        this.exclusive = exclusive;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public Set<String> getValues() {
        return this.values;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public void setState(String state) {
        try {
            JSONObject jo = new JSONObject(state);
            this.name = jo.optString("name");
            this.className = jo.optString("className");
            this.exclusive = jo.optBoolean("exclusive");
            this.values = this.getValues((JSONArray)jo.opt("values"));
        }
        catch (JSONException ex) {
            PrivilegeManager.debug.error("PolicySubject.setState", (Throwable)ex);
        }
    }

    private Set<String> getValues(JSONArray jo) throws JSONException {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < jo.length(); ++i) {
            result.add(jo.getString(i));
        }
        return result;
    }

    @Override
    public String getState() {
        JSONObject jo = new JSONObject();
        try {
            jo.put("name", (Object)this.name);
            jo.put("className", (Object)this.className);
            jo.put("exclusive", this.exclusive);
            jo.put("values", this.values);
            return jo.toString(2);
        }
        catch (JSONException ex) {
            PrivilegeManager.debug.error("PolicySubject.getState", (Throwable)ex);
            return "";
        }
    }

    @Override
    public Map<String, Set<String>> getSearchIndexAttributes() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(4);
        HashSet<String> set = new HashSet<String>();
        set.add("all");
        map.put("identity:", set);
        return map;
    }

    @Override
    public Set<String> getRequiredAttributeNames() {
        return Collections.EMPTY_SET;
    }

    @Override
    public SubjectDecision evaluate(String realm, SubjectAttributesManager mgr, Subject subject, String resourceName, Map<String, Set<String>> environment) throws EntitlementException {
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            PolicyManager pm = new PolicyManager(adminToken, realm);
            com.sun.identity.policy.interfaces.Subject sbj = (com.sun.identity.policy.interfaces.Subject)Class.forName(this.className).newInstance();
            sbj.initialize(pm.getPolicyConfig());
            sbj.setValues(this.values);
            SSOToken token = PolicySubject.getSSOToken(subject);
            boolean result = token == null ? true : sbj.isMember(token) ^ this.exclusive;
            return new SubjectDecision(result, Collections.EMPTY_MAP);
        }
        catch (SSOException ex) {
            throw new EntitlementException(508, (Throwable)((Object)ex));
        }
        catch (PolicyException ex) {
            throw new EntitlementException(508, (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new EntitlementException(508, (Throwable)ex);
        }
        catch (InstantiationException ex) {
            throw new EntitlementException(508, (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new EntitlementException(508, (Throwable)ex);
        }
    }

    private static SSOToken getSSOToken(Subject subject) {
        if (subject == null) {
            return null;
        }
        Set<Object> privateCred = subject.getPrivateCredentials();
        for (Object o : privateCred) {
            if (!(o instanceof SSOToken)) continue;
            return (SSOToken)o;
        }
        return null;
    }

    @Override
    public boolean isIdentity() {
        return true;
    }
}

