/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.iplanet.am.util.ThreadPoolException;
import com.iplanet.log.ConnectionException;
import com.iplanet.log.DriverLoadException;
import com.iplanet.log.NullLocationException;
import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.log.AMLogException;
import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.handlers.FormatterInitException;
import com.sun.identity.log.handlers.LoggingThread;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.monitoring.Agent;
import com.sun.identity.monitoring.SsoServerLoggingHdlrEntryImpl;
import com.sun.identity.monitoring.SsoServerLoggingSvcImpl;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class DBHandler
extends Handler {
    private LogManager lmanager = LogManagerUtil.getLogManager();
    private String driver;
    private String databaseURL;
    private Connection conn = null;
    private String tableName;
    private Formatter formatter;
    private String userName;
    private String password;
    private int recCountLimit;
    private int recMaxDBMem = 2;
    private LinkedList recordBuffer;
    private TimeBufferingTask bufferTask;
    private boolean timeBufferingEnabled = false;
    private SsoServerLoggingSvcImpl logServiceImplForMonitoring = (SsoServerLoggingSvcImpl)Agent.getLoggingSvcMBean();
    private SsoServerLoggingHdlrEntryImpl dbLogHandlerForMonitoring = null;
    private boolean connectionToDBLost = false;
    private boolean isMySQL = false;
    private String oraDataType;
    private String mysqlDataType;
    private int dbFieldMax = 0;
    private static LoggingThread threadPool = LoggingThread.getInstance();

    private void configure() throws NullLocationException, FormatterInitException {
        String status;
        String recMaxDBMemStr;
        String cname = DBHandler.class.getName();
        this.setFilter(null);
        try {
            this.setEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Debug.error(this.tableName + ":DBHandler: unsupportedEncodingException ", e);
        }
        String bufferSize = this.lmanager.getProperty("iplanet-am-logging-buffer-size");
        if (bufferSize != null && bufferSize.length() > 0) {
            try {
                this.recCountLimit = Integer.parseInt(bufferSize);
            }
            catch (NumberFormatException nfe) {
                Debug.warning(this.tableName + ":DBHandler: NumberFormatException ", nfe);
                if (Debug.messageEnabled()) {
                    Debug.message(this.tableName + ":DBHandler: Setting buffer size to 1");
                }
                this.recCountLimit = 1;
            }
        } else {
            Debug.warning(this.tableName + ":DBHandler: Invalid buffer size: " + bufferSize);
            if (Debug.messageEnabled()) {
                Debug.message(this.tableName + ":DBHandler: Setting buffer size to 1");
            }
            this.recCountLimit = 1;
        }
        if ((recMaxDBMemStr = this.lmanager.getProperty("sun-am-logging-db-max-in-mem")) != null && recMaxDBMemStr.length() > 0) {
            try {
                this.recMaxDBMem = Integer.parseInt(recMaxDBMemStr);
            }
            catch (NumberFormatException nfe) {
                Debug.warning(this.tableName + ":DBHandler:recMaxDBMem (" + recMaxDBMemStr + "): NumberFormatException ", nfe);
                if (Debug.messageEnabled()) {
                    Debug.message(this.tableName + ":DBHandler: Setting Max DB Mem Buffer Size to 2x (" + 2 * this.recCountLimit + ") the Buffer Size (" + this.recCountLimit + ")");
                }
                this.recMaxDBMem = 2 * this.recCountLimit;
            }
        } else {
            Debug.warning(this.tableName + ":DBHandler: Invalid buffer size: " + bufferSize);
            if (Debug.messageEnabled()) {
                Debug.message(this.tableName + ":DBHandler: Defaulting Max DB Mem Buffer Size " + "to 2x Buffer Size");
            }
            this.recMaxDBMem = 2 * this.recCountLimit;
        }
        if (this.recMaxDBMem < this.recCountLimit) {
            Debug.warning(this.tableName + ":DBHandler:Maximum DB memory buffer size < Buffer Size, " + "setting to buffer size (" + this.recCountLimit + ")");
            this.recMaxDBMem = this.recCountLimit;
        }
        if ((status = this.lmanager.getProperty("iplanet-am-logging-time-buffering-status")) != null && status.equalsIgnoreCase("ON")) {
            this.timeBufferingEnabled = true;
        }
        this.oraDataType = this.lmanager.getProperty("sun-am-logging-oradbdata-fieldtype");
        this.mysqlDataType = this.lmanager.getProperty("sun-am-logging-mysqldbdata-fieldtype");
        this.databaseURL = this.lmanager.getProperty("iplanet-am-logging-location");
        if (this.databaseURL == null || this.databaseURL.length() == 0) {
            throw new NullLocationException("Database URL location is null");
        }
        String strFormatter = LogManager.FORMATTER;
        if (strFormatter == null || strFormatter.length() == 0) {
            throw new FormatterInitException("Unable To Initialize DBFormatter");
        }
        this.userName = this.lmanager.getProperty("iplanet-am-logging-db-user");
        if (this.userName == null || this.userName.length() == 0) {
            throw new NullLocationException("userName is null");
        }
        this.password = this.lmanager.getProperty("iplanet-am-logging-db-password");
        if (this.password == null || this.password.length() == 0) {
            throw new NullLocationException("password not provided");
        }
        this.driver = this.lmanager.getProperty("iplanet-am-logging-db-driver");
        if (this.driver == null || this.driver.length() == 0) {
            throw new NullLocationException("driver not provided");
        }
        if (this.driver.toLowerCase().indexOf("oracle") != -1) {
            this.isMySQL = false;
        } else if (this.driver.toLowerCase().indexOf("mysql") != -1) {
            this.isMySQL = true;
        } else {
            this.isMySQL = false;
            Debug.warning(this.tableName + ":DBHandler:configure:assuming driver: '" + this.driver + "' is Oracle-compatible.");
        }
        try {
            Class<?> clz = Class.forName(strFormatter);
            this.formatter = (Formatter)clz.newInstance();
            this.setFormatter(this.formatter);
        }
        catch (Exception e) {
            Debug.error(this.tableName + ":DBHandler: Could not load Formatter", e);
            throw new FormatterInitException("Unable To Initialize DBFormatter " + e.getMessage());
        }
    }

    private void connectToDatabase(String userName, String password) throws ConnectionException, DriverLoadException {
        if (Agent.isRunning() && this.dbLogHandlerForMonitoring != null) {
            this.dbLogHandlerForMonitoring.incHandlerConnectionRequests(1);
        }
        try {
            Class.forName(this.driver);
            this.conn = DriverManager.getConnection(this.databaseURL, userName, password);
        }
        catch (ClassNotFoundException e) {
            Debug.error(this.tableName + ":DBHandler: ClassNotFoundException " + e.getMessage());
            if (Agent.isRunning() && this.dbLogHandlerForMonitoring != null) {
                this.dbLogHandlerForMonitoring.incHandlerConnectionsFailed(1);
            }
            throw new DriverLoadException(e.getMessage());
        }
        catch (SQLException sqle) {
            Debug.error(this.tableName + ":DBHandler: ConnectionException (" + sqle.getErrorCode() + "): " + sqle.getMessage());
            if (Agent.isRunning() && this.dbLogHandlerForMonitoring != null) {
                this.dbLogHandlerForMonitoring.incHandlerConnectionsFailed(1);
            }
            throw new ConnectionException(sqle.getMessage());
        }
        if (Agent.isRunning() && this.dbLogHandlerForMonitoring != null) {
            this.dbLogHandlerForMonitoring.incHandlerConnectionsMade(1);
        }
    }

    private void reconnectToDatabase() throws ConnectionException, DriverLoadException {
        if (Agent.isRunning() && this.dbLogHandlerForMonitoring != null) {
            this.dbLogHandlerForMonitoring.incHandlerConnectionRequests(1);
        }
        try {
            Class.forName(this.driver);
            this.conn = DriverManager.getConnection(this.databaseURL, this.userName, this.password);
        }
        catch (ClassNotFoundException e) {
            if (Agent.isRunning() && this.dbLogHandlerForMonitoring != null) {
                this.dbLogHandlerForMonitoring.incHandlerConnectionsFailed(1);
            }
            throw new DriverLoadException(e.getMessage());
        }
        catch (SQLException sqle) {
            Debug.error(this.tableName + ":DBHandler:reconnect (" + sqle.getErrorCode() + "): " + sqle.getMessage());
            if (Agent.isRunning() && this.dbLogHandlerForMonitoring != null) {
                this.dbLogHandlerForMonitoring.incHandlerConnectionsFailed(1);
            }
            throw new ConnectionException(sqle.getMessage());
        }
        if (Agent.isRunning() && this.dbLogHandlerForMonitoring != null) {
            this.dbLogHandlerForMonitoring.incHandlerConnectionsMade(1);
        }
    }

    public DBHandler(String tableName) {
        if (tableName == null || tableName.length() == 0) {
            return;
        }
        this.tableName = tableName = tableName.replace('.', '_');
        try {
            this.configure();
        }
        catch (NullLocationException nle) {
            Debug.error(tableName + ":DBHandler: Null Location", nle);
        }
        catch (FormatterInitException fie) {
            Debug.error(tableName + ":DBHandler: Unable to Initialize formatter", fie);
        }
        String stat = this.lmanager.getProperty("logstatus");
        if (Debug.messageEnabled()) {
            Debug.message("DBHandler:tableName = " + tableName + ", LOG_STATUS = " + stat);
        }
        if (stat != null & !stat.startsWith("INACTIVE")) {
            this.connectionToDBLost = true;
            try {
                this.connectToDatabase(this.userName, this.password);
                this.connectionToDBLost = false;
                this.createTable(tableName);
            }
            catch (SQLException sqe) {
                Debug.error(tableName + ":DBHandler: sql operation unsuccessful (" + sqe.getErrorCode() + "): " + sqe.getMessage());
            }
            catch (ConnectionException ce) {
                Debug.error(tableName + ":DBHandler: Could not connect to database:" + ce.getMessage());
            }
            catch (DriverLoadException dle) {
                Debug.error(tableName + ":DBHandler: Could not load driver", dle);
            }
            catch (UnsupportedEncodingException use) {
                Debug.error(tableName + ":DBHandler: Unsupported Encoding: " + use.getMessage());
            }
            this.connectionToDBLost = false;
        }
        this.recordBuffer = new LinkedList();
        if (this.timeBufferingEnabled) {
            this.startTimeBufferingThread();
        }
        if (Agent.isRunning()) {
            this.dbLogHandlerForMonitoring = this.logServiceImplForMonitoring.getHandler("DB Handler");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord logRecord) {
        if (Agent.isRunning() && this.dbLogHandlerForMonitoring != null) {
            this.dbLogHandlerForMonitoring.incHandlerRequestCount(1);
        }
        if (!this.isLoggable(logRecord)) {
            return;
        }
        DBHandler dBHandler = this;
        synchronized (dBHandler) {
            this.recordBuffer.add(logRecord);
            if (this.recordBuffer.size() >= this.recCountLimit) {
                if (Debug.messageEnabled()) {
                    Debug.message(this.tableName + ":DBHandler:.publish(): got " + this.recordBuffer.size() + " records, Limit " + this.recCountLimit + " writing all");
                }
                this.nonBlockingFlush();
            }
        }
    }

    private String getColString() {
        String cols = this.getFormatter().getHead(this);
        if (Debug.messageEnabled()) {
            Debug.message("cols = " + cols);
        }
        StringBuffer colStrBuffer = new StringBuffer(1000);
        if (cols != null) {
            colStrBuffer.append("insert into ").append(this.tableName).append(" (").append(cols).append(")").append(" values (");
        } else {
            colStrBuffer.append("insert into ").append(this.tableName).append(" values (");
        }
        return colStrBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nonBlockingFlush() {
        Object tabelName = null;
        LinkedList tempBuffer = null;
        DBHandler dBHandler = this;
        synchronized (dBHandler) {
            if (this.recordBuffer.size() <= 0) {
                if (Debug.messageEnabled()) {
                    Debug.message(this.tableName + ":DBHandler:flush: no records in buffer to write");
                }
                return;
            }
            this.tableName = this.getTableName();
            if (this.tableName == null) {
                Debug.error(this.tableName + ":DBHandler:flush:NullLocationException: table name is" + " null");
                int recordsToBeDropped = this.recordBuffer.size();
                this.recordBuffer.clear();
                if (Agent.isRunning() && this.dbLogHandlerForMonitoring != null) {
                    this.dbLogHandlerForMonitoring.incHandlerDroppedCount(recordsToBeDropped);
                }
                return;
            }
            tempBuffer = this.recordBuffer;
            this.recordBuffer = new LinkedList();
        }
        LogTask task = new LogTask(tempBuffer);
        try {
            threadPool.run(task);
        }
        catch (ThreadPoolException ex) {
            DBHandler dBHandler2 = this;
            synchronized (dBHandler2) {
                task.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object tabelName = null;
        DBHandler dBHandler = this;
        synchronized (dBHandler) {
            if (this.recordBuffer.size() <= 0) {
                return;
            }
            this.tableName = this.getTableName();
            if (this.tableName == null) {
                int recordsToBeDropped = this.recordBuffer.size();
                this.recordBuffer.clear();
                if (Agent.isRunning() && this.dbLogHandlerForMonitoring != null) {
                    this.dbLogHandlerForMonitoring.incHandlerDroppedCount(recordsToBeDropped);
                }
                return;
            }
            if (this.conn == null || this.connectionToDBLost) {
                try {
                    this.reconnectToDatabase();
                }
                catch (DriverLoadException dle) {
                    this.clearBuffer(this.recordBuffer);
                    throw new AMLogException("Could not load DB driver '" + this.driver + "'");
                }
                catch (ConnectionException ce) {
                    this.clearBuffer(this.recordBuffer);
                    throw new AMLogException("Connection to DB failed");
                }
                this.connectionToDBLost = false;
                try {
                    this.createTable(this.tableName);
                }
                catch (SQLException se) {
                }
                catch (UnsupportedEncodingException usee) {
                    // empty catch block
                }
            }
            Statement stmt = null;
            try {
                stmt = this.conn.createStatement();
            }
            catch (SQLException se) {
                try {
                    this.conn.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
                this.connectionToDBLost = true;
                try {
                    this.reconnectToDatabase();
                }
                catch (DriverLoadException dle) {
                    this.clearBuffer(this.recordBuffer);
                    throw new AMLogException("Could not load DB driver '" + this.driver + "'");
                }
                catch (ConnectionException ce) {
                    this.clearBuffer(this.recordBuffer);
                    throw new AMLogException("Connection to DB failed");
                }
                this.connectionToDBLost = false;
                try {
                    this.createTable(this.tableName);
                }
                catch (SQLException sqle) {
                }
                catch (UnsupportedEncodingException usee) {
                    // empty catch block
                }
                try {
                    stmt = this.conn.createStatement();
                }
                catch (SQLException sqle) {
                    throw new AMLogException("createStatement failure");
                }
            }
            String vals = null;
            int rbsz = this.recordBuffer.size();
            Formatter formatter = this.getFormatter();
            Iterator iter = this.recordBuffer.iterator();
            while (iter.hasNext()) {
                vals = formatter.format((LogRecord)iter.next());
                StringBuffer insertStringBuffer = new StringBuffer(2000);
                insertStringBuffer.append(this.getColString()).append(vals).append(")");
                String insertStr = insertStringBuffer.toString();
                try {
                    stmt.executeUpdate(insertStr);
                    if (!Agent.isRunning() || this.dbLogHandlerForMonitoring == null) continue;
                    this.dbLogHandlerForMonitoring.incHandlerSuccessCount(1);
                }
                catch (SQLException sqle) {
                    int sqleErrCode = sqle.getErrorCode();
                    boolean tableDoesNotExist = false;
                    if (this.isMySQL && sqleErrCode == 1146 || !this.isMySQL && sqleErrCode == 942) {
                        try {
                            this.createTable(this.tableName);
                        }
                        catch (SQLException se) {
                        }
                        catch (UnsupportedEncodingException usee) {
                            // empty catch block
                        }
                        try {
                            stmt.executeUpdate(insertStr);
                            continue;
                        }
                        catch (SQLException sqle2) {
                            throw new AMLogException("executeUpdate failure");
                        }
                    }
                    if (this.isMySQL && sqleErrCode == 0 || !this.isMySQL && (sqleErrCode == 17002 || sqleErrCode == 17410)) {
                        try {
                            this.conn.close();
                        }
                        catch (SQLException ex) {
                            // empty catch block
                        }
                        this.connectionToDBLost = true;
                        try {
                            this.reconnectToDatabase();
                        }
                        catch (DriverLoadException dle) {
                            this.clearBuffer(this.recordBuffer);
                            throw new AMLogException("Reconnection to DB failed");
                        }
                        catch (ConnectionException ce) {
                            this.clearBuffer(this.recordBuffer);
                            throw new AMLogException("Reconnection to DB failed");
                        }
                        this.connectionToDBLost = false;
                        try {
                            this.createTable(this.tableName);
                            stmt = this.conn.createStatement();
                            stmt.executeUpdate(insertStr);
                            if (!Agent.isRunning() || this.dbLogHandlerForMonitoring == null) continue;
                            this.dbLogHandlerForMonitoring.incHandlerSuccessCount(1);
                            continue;
                        }
                        catch (SQLException sqe) {
                            this.clearBuffer(this.recordBuffer);
                            throw new AMLogException("executeUpdate failure");
                        }
                        catch (UnsupportedEncodingException usee) {
                            this.clearBuffer(this.recordBuffer);
                            throw new AMLogException("executeUpdate failure");
                        }
                    }
                    this.clearBuffer(this.recordBuffer);
                    throw new AMLogException("executeUpdate failure");
                }
            }
            this.recordBuffer.clear();
            try {
                stmt.close();
            }
            catch (SQLException se) {
                // empty catch block
            }
        }
    }

    public void close() {
        try {
            this.flush();
        }
        catch (AMLogException ale) {
            Debug.error(this.tableName + ":DBHandler:close/flush error: " + ale.getMessage());
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException ce) {
                Debug.error(this.tableName + ":DBHandler: Unable To Close Connection", ce);
            }
        }
        this.stopBufferTimer();
    }

    private void setTableName(String tableName) {
        this.tableName = tableName;
    }

    private String getTableName() {
        return this.tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearBuffer(LinkedList buffer) {
        DBHandler dBHandler = this;
        synchronized (dBHandler) {
            int reccnt = this.recordBuffer.size();
            if (buffer != this.recordBuffer) {
                reccnt += buffer.size();
            }
            if (reccnt > this.recMaxDBMem) {
                int removeCount = reccnt - this.recMaxDBMem;
                Debug.error(this.tableName + ":DBHandler:dropping " + removeCount + " records.");
                if (removeCount >= buffer.size()) {
                    removeCount -= buffer.size();
                    buffer.clear();
                }
                for (int i = 0; i < removeCount; ++i) {
                    if (!buffer.isEmpty()) {
                        buffer.remove(0);
                        continue;
                    }
                    this.recordBuffer.remove(0);
                }
                if (Agent.isRunning() && this.dbLogHandlerForMonitoring != null) {
                    this.dbLogHandlerForMonitoring.incHandlerDroppedCount(removeCount);
                }
            }
            if (buffer != this.recordBuffer && !buffer.isEmpty()) {
                for (int i = 0; i < buffer.size(); ++i) {
                    this.recordBuffer.addFirst(buffer.removeLast());
                }
            }
        }
    }

    private void createTable(String tableName) throws SQLException, UnsupportedEncodingException {
        StringBuffer sbuffer;
        block34: {
            sbuffer = new StringBuffer();
            String oracleTableName = new String(tableName.getBytes("UTF-8")).toUpperCase();
            try {
                if (!this.isMySQL) {
                    sbuffer.append("select count(table_name) from all_tables where table_name = ");
                    sbuffer.append("'").append(oracleTableName).append("'");
                } else {
                    sbuffer.append("show tables like ");
                    sbuffer.append("'").append(new String(tableName.getBytes("UTF-8"))).append("'");
                }
                Statement stmt = this.conn.createStatement();
                ResultSet rs = stmt.executeQuery(sbuffer.toString());
                boolean foundTable = false;
                if (this.isMySQL) {
                    String result = null;
                    while (rs.next()) {
                        result = rs.getString(1);
                    }
                    if (result != null && result.equalsIgnoreCase(tableName)) {
                        foundTable = true;
                    }
                } else {
                    int result = 0;
                    while (rs.next()) {
                        result = rs.getInt(1);
                    }
                    if (result == 1) {
                        foundTable = true;
                    }
                }
                try {
                    stmt.close();
                    rs.close();
                }
                catch (SQLException ex) {
                    Debug.error("DBHandler:createTable: " + ex.getMessage());
                }
                if (!foundTable) break block34;
                String getColNames = null;
                getColNames = this.isMySQL ? "show columns from " + tableName : "select column_name from USER_TAB_COLUMNS where Table_Name = '" + oracleTableName + "'";
                stmt = this.conn.createStatement();
                try {
                    rs = stmt.executeQuery(getColNames);
                }
                catch (SQLException sqe) {
                    Debug.error("DBHandler:createTable: '" + getColNames + "'; error (" + sqe.getErrorCode() + "); msg = " + sqe.getMessage());
                    return;
                }
                ResultSetMetaData rsmd = rs.getMetaData();
                int numCols = rsmd.getColumnCount();
                String colName = null;
                int tempj = 0;
                HashSet<String> colSet = new HashSet<String>();
                while (rs.next()) {
                    colName = rs.getString(1);
                    colSet.add(colName);
                    for (int i = 0; i < numCols; ++i) {
                        colName = rs.getString(i + 1);
                    }
                    ++tempj;
                }
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    Debug.error("DBHandler:createTable: " + ex.getMessage());
                }
                StringBuffer colList = new StringBuffer();
                String[] allFields = this.lmanager.getAllFields();
                boolean addedOne = false;
                String tmpx = null;
                for (int i = 2; i < allFields.length - 1; ++i) {
                    tmpx = this.isMySQL ? allFields[i] : allFields[i].toUpperCase();
                    if (colSet.contains(tmpx)) continue;
                    if (addedOne) {
                        colList.append(", ");
                    }
                    colList.append(allFields[i]).append(" varchar(255)");
                    addedOne = true;
                }
                if (colList.length() > 0) {
                    String altStr = "alter table " + tableName + " add (" + colList.toString() + ")";
                    try {
                        stmt = this.conn.createStatement();
                        stmt.execute(altStr);
                        stmt.close();
                    }
                    catch (SQLException sqle) {
                        Debug.error("DBHandler:createTable: '" + altStr + "'; error (" + sqle.getErrorCode() + "); msg = " + sqle.getMessage());
                    }
                }
                return;
            }
            catch (SQLException e) {
                Debug.error(tableName + ":DBHandler:createTable:Query:SQLException (" + e.getErrorCode() + "): " + e.getMessage());
                throw e;
            }
            catch (UnsupportedEncodingException use) {
                Debug.error(tableName + ":DBHandler:createTable:Query:UE: " + use.getMessage());
                throw use;
            }
        }
        sbuffer = new StringBuffer();
        try {
            sbuffer.append("create table ").append(new String(tableName.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException uee) {
            Debug.error(tableName + ":DBHandler: unsupported encoding exception uee", uee);
        }
        String varCharX = "varchar2";
        if (this.isMySQL) {
            sbuffer.append(" (time datetime, ");
        } else {
            sbuffer.append(" (time date, ");
        }
        if (this.isMySQL) {
            varCharX = "varchar";
            sbuffer.append(" data " + this.mysqlDataType + ", ");
        } else {
            sbuffer.append(" data " + this.oraDataType + ", ");
        }
        String[] allFields = this.lmanager.getAllFields();
        int i = 0;
        for (i = 2; i < allFields.length - 1; ++i) {
            sbuffer.append(allFields[i]).append(" " + varCharX + " (255), ");
        }
        sbuffer.append(allFields[i]).append(" " + varCharX + " (255)) ");
        String createString = sbuffer.toString();
        try {
            Statement stmt = this.conn.createStatement();
            if (Debug.messageEnabled()) {
                Debug.message(tableName + ":DBHandler: the query string for creating is " + createString);
            }
            stmt.executeUpdate(createString);
            stmt.close();
        }
        catch (SQLException sqe) {
            Debug.error(tableName + ":DBHandler:createTable:Execute:SQLEx (" + sqe.getErrorCode() + "): " + sqe.getMessage());
            throw sqe;
        }
    }

    private void startTimeBufferingThread() {
        String period = this.lmanager.getProperty("iplanet-am-logging-buffer-time-in-seconds");
        long interval = period != null || period.length() != 0 ? Long.parseLong(period) : 3600L;
        interval *= 1000L;
        if (this.bufferTask == null) {
            block5: {
                this.bufferTask = new TimeBufferingTask(interval);
                try {
                    SystemTimer.getTimer().schedule((TaskRunnable)this.bufferTask, new Date((System.currentTimeMillis() + interval) / 1000L * 1000L));
                }
                catch (IllegalArgumentException e) {
                    Debug.error(this.tableName + ":DBHandler:BuffTimeArg: " + e.getMessage());
                }
                catch (IllegalStateException e) {
                    if (!Debug.messageEnabled()) break block5;
                    Debug.message(this.tableName + ":DBHandler:BuffTimeState: " + e.getMessage());
                }
            }
            if (Debug.messageEnabled()) {
                Debug.message(this.tableName + ":DBHandler: Time Buffering Thread Started");
            }
        }
    }

    private void stopBufferTimer() {
        if (this.bufferTask != null) {
            this.bufferTask.cancel();
            this.bufferTask = null;
            if (Debug.messageEnabled()) {
                Debug.message(this.tableName + ":DBHandler: Buffer Timer Stopped");
            }
        }
    }

    private class TimeBufferingTask
    extends GeneralTaskRunnable {
        private long runPeriod;

        public TimeBufferingTask(long runPeriod) {
            this.runPeriod = runPeriod;
        }

        public void run() {
            if (Debug.messageEnabled()) {
                Debug.message(DBHandler.this.tableName + ":DBHandler:TimeBufferingTask.run() called");
            }
            DBHandler.this.nonBlockingFlush();
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean addElement(Object obj) {
            return false;
        }

        public boolean removeElement(Object obj) {
            return false;
        }

        public long getRunPeriod() {
            return this.runPeriod;
        }
    }

    private class LogTask
    implements Runnable {
        private LinkedList buffer;

        public LogTask(LinkedList buffer) {
            this.buffer = buffer;
        }

        public void run() {
            block51: {
                block46: {
                    if (DBHandler.this.conn == null || DBHandler.this.connectionToDBLost) {
                        try {
                            DBHandler.this.reconnectToDatabase();
                            Debug.error(DBHandler.this.tableName + ":DBHandler:flush:reconnectToDatabase" + " successful.");
                        }
                        catch (DriverLoadException dle) {
                            Debug.error(DBHandler.this.tableName + ":DBHandler:flush:reconnectToDatabase:DLE: " + dle.getMessage());
                            DBHandler.this.clearBuffer(this.buffer);
                            throw new AMLogException("Could not load DB driver '" + DBHandler.this.driver + "'");
                        }
                        catch (ConnectionException ce) {
                            Debug.error(DBHandler.this.tableName + ":DBHandler:flush:reconnectToDatabase:CE: " + ce.getMessage());
                            DBHandler.this.clearBuffer(this.buffer);
                            throw new AMLogException("Connection to DB failed");
                        }
                        DBHandler.this.connectionToDBLost = false;
                        try {
                            DBHandler.this.createTable(DBHandler.this.tableName);
                        }
                        catch (SQLException se) {
                            if (Debug.messageEnabled()) {
                                Debug.message(DBHandler.this.tableName + ":DBHandler:flush:reconnect:cTable:SQLE (" + se.getErrorCode() + "): " + se.getMessage());
                            }
                        }
                        catch (UnsupportedEncodingException usee) {
                            if (!Debug.messageEnabled()) break block46;
                            Debug.message(DBHandler.this.tableName + ":DBHandler:flush:reconnect:cTable:UE: " + usee.getMessage());
                        }
                    }
                }
                Statement stmt = null;
                try {
                    stmt = DBHandler.this.conn.createStatement();
                }
                catch (SQLException se) {
                    block48: {
                        block47: {
                            Debug.error(DBHandler.this.tableName + ":DBHandler:flush:cStatement:SQLE (" + se.getErrorCode() + "): " + se.getMessage());
                            try {
                                DBHandler.this.conn.close();
                            }
                            catch (SQLException ex) {
                                if (!Debug.messageEnabled()) break block47;
                                Debug.error(DBHandler.this.tableName + ":DBHandler:flush:cStatement:close:SQLE (" + ex.getErrorCode() + ")" + ex.getMessage());
                            }
                        }
                        DBHandler.this.connectionToDBLost = true;
                        try {
                            DBHandler.this.reconnectToDatabase();
                            Debug.error(DBHandler.this.tableName + ":DBHandler:flush:cStatement:reconnect" + " successful.");
                        }
                        catch (DriverLoadException dle) {
                            Debug.error(DBHandler.this.tableName + ":DBHandler:flush:cStatement:reconnect:DLE: " + dle.getMessage());
                            DBHandler.this.clearBuffer(this.buffer);
                            throw new AMLogException("Could not load DB driver '" + DBHandler.this.driver + "'");
                        }
                        catch (ConnectionException ce) {
                            Debug.error(DBHandler.this.tableName + ":DBHandler:flush:cStatement:reconnect:CE: " + ce.getMessage());
                            DBHandler.this.clearBuffer(this.buffer);
                            throw new AMLogException("Connection to DB failed");
                        }
                        DBHandler.this.connectionToDBLost = false;
                        try {
                            DBHandler.this.createTable(DBHandler.this.tableName);
                        }
                        catch (SQLException sqle) {
                            if (Debug.messageEnabled()) {
                                Debug.message(DBHandler.this.tableName + ":DBHandler:flush:cStatement:reconnect:" + "cTable:SQLE (" + sqle.getErrorCode() + "): " + sqle.getMessage());
                            }
                        }
                        catch (UnsupportedEncodingException usee) {
                            if (!Debug.messageEnabled()) break block48;
                            Debug.message(DBHandler.this.tableName + ":DBHandler:flush:cStatement:reconnect:" + "cTable:UE: " + usee.getMessage());
                        }
                    }
                    try {
                        stmt = DBHandler.this.conn.createStatement();
                    }
                    catch (SQLException sqle) {
                        Debug.error(DBHandler.this.tableName + ":DBHandler:flush:cStatement:reconnect:cSt:SQLE (" + sqle.getErrorCode() + "): " + sqle.getMessage());
                        throw new AMLogException("createStatement failure");
                    }
                }
                String vals = null;
                int rbsz = this.buffer.size();
                Formatter formatter = DBHandler.this.getFormatter();
                Iterator iter = this.buffer.iterator();
                while (iter.hasNext()) {
                    vals = formatter.format((LogRecord)iter.next());
                    if (Debug.messageEnabled()) {
                        Debug.message("values = " + vals);
                    }
                    StringBuffer insertStringBuffer = new StringBuffer(2000);
                    insertStringBuffer.append(DBHandler.this.getColString()).append(vals).append(")");
                    String insertStr = insertStringBuffer.toString();
                    if (Debug.messageEnabled()) {
                        Debug.message(DBHandler.this.tableName + ":DBHandler:insertString is: " + insertStr);
                    }
                    try {
                        stmt.executeUpdate(insertStr);
                        if (!Agent.isRunning() || DBHandler.this.dbLogHandlerForMonitoring == null) continue;
                        DBHandler.this.dbLogHandlerForMonitoring.incHandlerSuccessCount(1);
                    }
                    catch (SQLException sqle) {
                        int sqleErrCode = sqle.getErrorCode();
                        boolean tableDoesNotExist = false;
                        if (Debug.messageEnabled()) {
                            Debug.message(DBHandler.this.tableName + "DBHandler:execute:SQLException: insertStr = " + insertStr);
                            Debug.message(DBHandler.this.tableName + ":DBHandler:execute:SQLException (" + sqleErrCode + "): " + sqle.getMessage());
                        }
                        if (DBHandler.this.isMySQL && sqleErrCode == 1146 || !DBHandler.this.isMySQL && sqleErrCode == 942) {
                            try {
                                DBHandler.this.createTable(DBHandler.this.tableName);
                            }
                            catch (SQLException se) {
                                Debug.error(DBHandler.this.tableName + ":DBHandler:flush:execUpdate:cTable:SQLE (" + se.getErrorCode() + "): " + se.getMessage());
                            }
                            catch (UnsupportedEncodingException usee) {
                                Debug.error(DBHandler.this.tableName + ":DBHandler:flush:execUpdate:cTable:UE: " + usee.getMessage());
                            }
                            try {
                                stmt.executeUpdate(insertStr);
                                continue;
                            }
                            catch (SQLException sqle2) {
                                Debug.error(DBHandler.this.tableName + ":DBHandler:flush:execUpdate:exUpdate:" + "SQLE (" + sqle2.getErrorCode() + "): " + sqle2.getMessage());
                                throw new AMLogException("executeUpdate failure");
                            }
                        }
                        if (DBHandler.this.isMySQL && sqleErrCode == 0 || !DBHandler.this.isMySQL && (sqleErrCode == 17002 || sqleErrCode == 17410)) {
                            block50: {
                                try {
                                    DBHandler.this.conn.close();
                                }
                                catch (SQLException ex) {
                                    if (!Debug.messageEnabled()) break block50;
                                    Debug.message(DBHandler.this.tableName + ":DBHandler:flush:execUpdate:close:" + "SQLE (" + ex.getErrorCode() + "): " + ex.getMessage());
                                }
                            }
                            DBHandler.this.connectionToDBLost = true;
                            try {
                                DBHandler.this.reconnectToDatabase();
                                Debug.error(DBHandler.this.tableName + ":DBHandler:flush:execUpdate:" + "reconnect successful.");
                            }
                            catch (DriverLoadException dle) {
                                if (Debug.messageEnabled()) {
                                    Debug.message(DBHandler.this.tableName + ":DBHandler:flush:execUpdate:" + "reconnect:DLE: " + dle.getMessage());
                                }
                                DBHandler.this.clearBuffer(this.buffer);
                                throw new AMLogException("Reconnection to DB failed");
                            }
                            catch (ConnectionException ce) {
                                if (Debug.messageEnabled()) {
                                    Debug.message(DBHandler.this.tableName + ":DBHandler:flush:execUpdate:" + "reconnect:CE: " + ce.getMessage());
                                }
                                DBHandler.this.clearBuffer(this.buffer);
                                throw new AMLogException("Reconnection to DB failed");
                            }
                            DBHandler.this.connectionToDBLost = false;
                            try {
                                DBHandler.this.createTable(DBHandler.this.tableName);
                                stmt = DBHandler.this.conn.createStatement();
                                stmt.executeUpdate(insertStr);
                                if (!Agent.isRunning() || DBHandler.this.dbLogHandlerForMonitoring == null) continue;
                                DBHandler.this.dbLogHandlerForMonitoring.incHandlerSuccessCount(1);
                                continue;
                            }
                            catch (SQLException sqe) {
                                Debug.error(DBHandler.this.tableName + ":DBHandler:flush:executeUpd:reconnect:" + "stmt:SQE: (" + sqe.getErrorCode() + "): " + sqe.getMessage());
                                DBHandler.this.clearBuffer(this.buffer);
                                throw new AMLogException("executeUpdate failure");
                            }
                            catch (UnsupportedEncodingException usee) {
                                Debug.error(DBHandler.this.tableName + ":DBHandler:flush:execUpd:reconnect:" + "stmt:UE: " + usee.getMessage());
                                DBHandler.this.clearBuffer(this.buffer);
                                throw new AMLogException("executeUpdate failure");
                            }
                        }
                        Debug.error(DBHandler.this.tableName + ":DBHandler:flush:executeUpdate failed (" + sqleErrCode + "): " + sqle.getMessage());
                        Debug.error(DBHandler.this.tableName + ":DBHandler:execute:SQLException: insertStr = " + insertStr);
                        DBHandler.this.clearBuffer(this.buffer);
                        throw new AMLogException("executeUpdate failure");
                    }
                }
                try {
                    stmt.close();
                }
                catch (SQLException se) {
                    if (!Debug.warningEnabled()) break block51;
                    Debug.warning(DBHandler.this.tableName + ":DBHandler:close:" + "SQLException (" + se.getErrorCode() + "): ", se);
                }
            }
        }
    }
}

