/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.remote;

import com.sun.identity.policy.remote.AdvicesHandleableByAMRequest;
import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.policy.remote.PolicyListenerRequest;
import com.sun.identity.policy.remote.PolicyService;
import com.sun.identity.policy.remote.RemoveListenerRequest;
import com.sun.identity.policy.remote.ResourceResultRequest;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Node;

public class PolicyRequest {
    public static final int POLICY_REQUEST_GET_RESOURCE_RESULTS = 1;
    public static final int POLICY_REQUEST_ADD_POLICY_LISTENER = 2;
    public static final int POLICY_REQUEST_REMOVE_POLICY_LISTENER = 3;
    public static final int POLICY_REQUEST_ADVICES_HANDLEABLE_BY_AM_REQUEST = 4;
    static final String POLICY_REQUEST = "PolicyRequest";
    static final String GET_RESOURCE_RESULTS = "GetResourceResults";
    static final String ADD_POLICY_LISTENER = "AddPolicyListener";
    static final String REMOVE_POLICY_LISTENER = "RemovePolicyListener";
    static final String ADVICES_HANDLEABLE_BY_AM_REQUEST = "AdvicesHandleableByAMRequest";
    static final String APP_SSOTOKEN = "appSSOToken";
    static final String REQUEST_ID = "requestId";
    static final String CRLF = "\r\n";
    static Debug debug = PolicyService.debug;
    private ResourceResultRequest resourceResultReq = null;
    private PolicyListenerRequest policyListenerReq = null;
    private RemoveListenerRequest removeListenerReq = null;
    private AdvicesHandleableByAMRequest advicesHandleableByAMRequest = null;
    private String appSSOToken = null;
    private String requestId = null;
    private int methodID = 0;

    public int getMethodID() {
        return this.methodID;
    }

    public void setMethodID(int id) {
        this.methodID = id;
    }

    public String getAppSSOToken() {
        return this.appSSOToken;
    }

    public void setAppSSOToken(String ssoToken) {
        this.appSSOToken = ssoToken;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String reqId) {
        this.requestId = reqId;
    }

    public ResourceResultRequest getResourceResultRequest() {
        return this.resourceResultReq;
    }

    public void setResourceResultRequest(ResourceResultRequest req) {
        this.resourceResultReq = req;
    }

    public PolicyListenerRequest getPolicyListenerRequest() {
        return this.policyListenerReq;
    }

    public void setPolicyListenerRequest(PolicyListenerRequest req) {
        this.policyListenerReq = req;
    }

    public RemoveListenerRequest getRemoveListenerRequest() {
        return this.removeListenerReq;
    }

    public void setRemoveListenerRequest(RemoveListenerRequest req) {
        this.removeListenerReq = req;
    }

    public void setAdvicesHandleableByAMRequest(AdvicesHandleableByAMRequest advicesHandleableByAMRequest) {
        this.advicesHandleableByAMRequest = advicesHandleableByAMRequest;
    }

    public static PolicyRequest parseXML(Node pNode) throws PolicyEvaluationException {
        PolicyRequest preq = new PolicyRequest();
        String attr = XMLUtils.getNodeAttributeValue((Node)pNode, (String)APP_SSOTOKEN);
        if (attr == null) {
            debug.error("PolicyRequestparseXML(Node): missing attribute appSSOToken");
            Object[] objs = new String[]{APP_SSOTOKEN};
            throw new PolicyEvaluationException("amPolicy", "missing_attribute", objs, null);
        }
        preq.setAppSSOToken(attr);
        attr = XMLUtils.getNodeAttributeValue((Node)pNode, (String)REQUEST_ID);
        if (attr == null) {
            debug.error("PolicyRequest.parseXML(Node): missing attribute requestId");
            Object[] objs = new String[]{REQUEST_ID};
            throw new PolicyEvaluationException("amPolicy", "missing_attribute", objs, null);
        }
        preq.setRequestId(attr);
        Node node = XMLUtils.getChildNode((Node)pNode, (String)GET_RESOURCE_RESULTS);
        if (node != null) {
            ResourceResultRequest resourceResultReq = null;
            try {
                resourceResultReq = ResourceResultRequest.parseXML(node);
            }
            catch (PolicyEvaluationException pe) {
                throw new PolicyEvaluationException(pe, preq.getRequestId());
            }
            preq.setResourceResultRequest(resourceResultReq);
            preq.setMethodID(1);
            return preq;
        }
        node = XMLUtils.getChildNode((Node)pNode, (String)ADD_POLICY_LISTENER);
        if (node != null) {
            PolicyListenerRequest plr = null;
            try {
                plr = PolicyListenerRequest.parseXML(node);
            }
            catch (PolicyEvaluationException pe) {
                throw new PolicyEvaluationException(pe, preq.getRequestId());
            }
            preq.setPolicyListenerRequest(plr);
            preq.setMethodID(2);
            return preq;
        }
        node = XMLUtils.getChildNode((Node)pNode, (String)REMOVE_POLICY_LISTENER);
        if (node != null) {
            RemoveListenerRequest rmListenerReq = null;
            try {
                rmListenerReq = RemoveListenerRequest.parseXML(node);
            }
            catch (PolicyEvaluationException pe) {
                throw new PolicyEvaluationException(pe, preq.getRequestId());
            }
            preq.setRemoveListenerRequest(rmListenerReq);
            preq.setMethodID(3);
            return preq;
        }
        node = XMLUtils.getChildNode((Node)pNode, (String)ADVICES_HANDLEABLE_BY_AM_REQUEST);
        if (node != null) {
            preq.setAdvicesHandleableByAMRequest(new AdvicesHandleableByAMRequest());
            preq.setMethodID(4);
            return preq;
        }
        debug.error("PolicyRequest: invalid method specified");
        throw new PolicyEvaluationException("amPolicy", "invalid_policy_request_method", null, null);
    }

    public String toXMLString() {
        StringBuffer xmlsb = new StringBuffer(1000);
        xmlsb.append("<").append(POLICY_REQUEST).append(" ").append(APP_SSOTOKEN).append("=\"").append(this.appSSOToken).append("\" ").append(REQUEST_ID).append("=\"").append(this.requestId).append("\">").append(CRLF);
        if (this.methodID == 1) {
            xmlsb.append(this.resourceResultReq.toXMLString());
        } else if (this.methodID == 2) {
            xmlsb.append(this.policyListenerReq.toXMLString());
        } else if (this.methodID == 3) {
            xmlsb.append(this.removeListenerReq.toXMLString());
        } else if (this.methodID == 4) {
            xmlsb.append(this.advicesHandleableByAMRequest.toXMLString());
        }
        xmlsb.append("</").append(POLICY_REQUEST).append(">").append(CRLF);
        return xmlsb.toString();
    }
}

