/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class MergeProperties {
    private MergeProperties() {
    }

    private MergeProperties(String origProp, String prependProp, String outfile) throws IOException {
        String val;
        StringBuffer buff = new StringBuffer();
        Map p1 = this.getProperties(origProp);
        Map p2 = this.getProperties(prependProp);
        Set p1Keys = p1.keySet();
        Set p2Keys = p2.keySet();
        for (String key : p1Keys) {
            val = ((String)p1.get(key)).trim();
            if (p2Keys.contains(key)) {
                val = val.length() == 0 ? ((String)p2.get(key)).trim() : val + " " + ((String)p2.get(key)).trim();
            }
            buff.append(key).append("=").append(val).append("\n");
        }
        for (String key : p2Keys) {
            val = (String)p2.get(key);
            if (p1Keys.contains(key)) continue;
            buff.append(key).append("=").append(val).append("\n");
        }
        this.writeToFile(outfile, buff);
    }

    private Map getProperties(String propertyName) {
        HashMap<String, String> results = new HashMap<String, String>();
        ResourceBundle res = ResourceBundle.getBundle(propertyName);
        Enumeration<String> e = res.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            results.put(key, res.getString(key));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String filename, StringBuffer content) throws IOException {
        int idx = 0;
        while (idx != -1) {
            if ((idx = content.indexOf("\\", idx)) == -1) continue;
            content.insert(idx, '\\');
            idx += 2;
        }
        if (filename != null) {
            File fileHandle = new File(filename);
            FileWriter out = null;
            try {
                out = new FileWriter(filename);
                out.write(content.toString());
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            new MergeProperties(args[0], args[1], args[2]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

