/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.spi;

import com.sun.identity.authentication.spi.UserIDGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DefaultUserIDGenerator
implements UserIDGenerator {
    private static final String ATTRIBUTE_FIRST_NAME = "givenname";
    private static final String ATTRIBUTE_LAST_NAME = "sn";
    private static final String EMPTY_STRING = "";
    private static final String NAME_SEPARATOR = "_";

    public Set generateUserIDs(String orgName, Map attributes, int num) {
        HashSet<String> userIDs = new HashSet<String>();
        String lastName = this.getAttributeValue(attributes, ATTRIBUTE_LAST_NAME).toLowerCase();
        String firstName = this.getAttributeValue(attributes, ATTRIBUTE_FIRST_NAME).toLowerCase();
        if (firstName.equals(EMPTY_STRING) || lastName.equals(EMPTY_STRING)) {
            return userIDs;
        }
        if ((firstName = this.filterNonAsciiChars(firstName)).length() == 0) {
            return userIDs;
        }
        if ((lastName = this.filterNonAsciiChars(lastName)).length() == 0) {
            return userIDs;
        }
        userIDs.add(firstName + lastName);
        userIDs.add(firstName + NAME_SEPARATOR + lastName);
        userIDs.add(lastName + firstName);
        userIDs.add(lastName + NAME_SEPARATOR + firstName);
        String firstCharFirstName = firstName.substring(0, 1);
        String firstCharLastName = lastName.substring(0, 1);
        userIDs.add(firstCharFirstName + lastName);
        userIDs.add(firstCharFirstName + NAME_SEPARATOR + lastName);
        userIDs.add(firstCharLastName + firstName);
        userIDs.add(firstCharLastName + NAME_SEPARATOR + firstName);
        userIDs.add(firstName + firstCharLastName);
        userIDs.add(firstName + NAME_SEPARATOR + firstCharLastName);
        if (num == 0) {
            return userIDs;
        }
        return this.returnSet(userIDs, num);
    }

    private String filterNonAsciiChars(String userName) {
        char[] chUserName = userName.toCharArray();
        StringBuffer newUserName = new StringBuffer(EMPTY_STRING);
        for (int i = 0; i < chUserName.length; ++i) {
            if (chUserName[i] > '\u0080') continue;
            newUserName.append(chUserName[i]);
        }
        return newUserName.toString();
    }

    private String getAttributeValue(Map attrs, String attrName) {
        Iterator it;
        Set values = (Set)attrs.get(attrName);
        if (values != null && (it = values.iterator()).hasNext()) {
            return (String)it.next();
        }
        return EMPTY_STRING;
    }

    private Set returnSet(Set origSet, int num) {
        if (num < 0) {
            return Collections.EMPTY_SET;
        }
        if (num < origSet.size()) {
            Iterator it = origSet.iterator();
            HashSet<String> newSet = new HashSet<String>();
            for (int i = 0; i < num; ++i) {
                newSet.add((String)it.next());
            }
            return newSet;
        }
        return origSet;
    }
}

