/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.ResourceAttribute;
import com.sun.identity.entitlement.SubjectAttributesManager;
import com.sun.identity.entitlement.util.JSONUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAttributes
implements ResourceAttribute {
    private String propertyName;
    private Set<String> propertyValues = new HashSet<String>();
    private String pResponseProviderName;

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public Set<String> getPropertyValues() {
        return this.propertyValues;
    }

    @Override
    public Map<String, Set<String>> evaluate(Subject adminSubject, String realm, Subject subject, String resourceName, Map<String, Set<String>> environment) throws EntitlementException {
        SubjectAttributesManager sac = SubjectAttributesManager.getInstance(adminSubject, realm);
        HashSet<String> names = new HashSet<String>();
        if (this.propertyValues == null || this.propertyValues.isEmpty()) {
            names.add(this.propertyName);
        } else {
            names.addAll(this.propertyValues);
        }
        Map<String, Set<String>> values = sac.getUserAttributes(subject, names);
        HashSet tmp = new HashSet();
        if (values != null && !values.isEmpty()) {
            for (String k : values.keySet()) {
                tmp.addAll(values.get(k));
            }
        }
        HashMap<String, Set<String>> results = new HashMap<String, Set<String>>();
        results.put(this.propertyName, tmp);
        return results;
    }

    @Override
    public String getState() {
        try {
            return this.toJSONObject().toString();
        }
        catch (JSONException ex) {
            PrivilegeManager.debug.error("UserAttribute.getState", (Throwable)ex);
            return "";
        }
    }

    @Override
    public void setState(String s) {
        if (s != null && s.trim().length() > 0) {
            try {
                JSONObject json = new JSONObject(s);
                this.propertyName = json.getString("propertyName");
                this.propertyValues = JSONUtils.getSet(json, "propertyValues");
                this.pResponseProviderName = json.getString("pResponseProviderName");
            }
            catch (JSONException ex) {
                PrivilegeManager.debug.error("UserAttribute.setState", (Throwable)ex);
            }
        }
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put("propertyName", (Object)this.propertyName);
        jo.put("propertyValues", this.propertyValues);
        jo.put("pResponseProviderName", (Object)this.pResponseProviderName);
        return jo;
    }

    public String toString() {
        String s = null;
        try {
            s = this.toJSONObject().toString(2);
        }
        catch (JSONException joe) {
            PrivilegeManager.debug.error("UserESubject.toString(), JSONException:", (Throwable)joe);
        }
        return s;
    }

    @Override
    public void setPResponseProviderName(String pResponseProviderName) {
        this.pResponseProviderName = pResponseProviderName;
    }

    @Override
    public String getPResponseProviderName() {
        return this.pResponseProviderName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        UserAttributes object = (UserAttributes)obj;
        if (this.propertyName == null ? object.propertyName != null : !this.propertyName.equals(object.propertyName)) {
            return false;
        }
        if (this.propertyValues == null ? object.propertyValues != null : !((Object)this.propertyValues).equals(object.propertyValues)) {
            return false;
        }
        return !(this.pResponseProviderName == null ? object.getPResponseProviderName() != null : !this.pResponseProviderName.equals(object.getPResponseProviderName()));
    }

    public int hashCode() {
        int code = 0;
        if (this.propertyName != null) {
            code += this.propertyName.hashCode();
        }
        if (this.propertyValues != null) {
            code += ((Object)this.propertyValues).hashCode();
        }
        if (this.pResponseProviderName != null) {
            code += this.pResponseProviderName.hashCode();
        }
        return code;
    }
}

