/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.secure;

import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogReader;
import com.sun.identity.log.Logger;
import com.sun.identity.log.handlers.SecureFileHandler;
import com.sun.identity.log.secure.SecureLogHelper;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.log.spi.Token;
import com.sun.identity.log.spi.VerifierAction;
import com.sun.identity.security.keystore.AMPassword;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import java.util.logging.LogManager;

public class LogVerifier {
    private static String PREFIX = "_secure.";
    private String curMAC = null;
    private VerifyTask verifier;
    private String prevSignature = null;
    private boolean verified = true;
    private SecureLogHelper helper;
    private AMPassword verPassword;
    private String name;
    private LogManager manager = LogManagerUtil.getLogManager();
    private boolean verificationOn = false;

    public LogVerifier(String log, AMPassword verPass) {
        this.name = log;
        this.verPassword = verPass;
    }

    public boolean getVerificationFlag() {
        return this.verificationOn;
    }

    public void startLogVerifier() {
        String period = this.manager.getProperty("iplanet-am-logging-verify-period-in-seconds");
        long interval = period != null || period.length() != 0 ? Long.parseLong(period) : 3600L;
        interval *= 1000L;
        if (this.verifier == null) {
            this.verifier = new VerifyTask(interval);
            SystemTimer.getTimer().schedule((TaskRunnable)this.verifier, new Date((System.currentTimeMillis() + interval) / 1000L * 1000L));
            if (Debug.messageEnabled()) {
                Debug.message(this.name + ":Verifier Thread Started");
            }
        }
    }

    public void stopLogVerifier() {
        if (this.verifier != null) {
            this.verifier.cancel();
            this.verifier = null;
        }
    }

    private boolean verifyLogRecord(String[] record, int macPos) throws Exception {
        StringBuffer data = new StringBuffer();
        for (int m = 0; m < record.length - 2; ++m) {
            data.append(record[m]);
        }
        this.curMAC = new String(record[macPos]);
        this.verified = this.helper.verifyMAC(data.toString(), SecureLogHelper.toByteArray(this.curMAC));
        return this.verified;
    }

    private boolean verifySignature(String[] record, int signPos, int recPos) throws Exception {
        byte[] newMAC;
        String curSign = new String(record[signPos]);
        byte[] prevMAC = SecureLogHelper.toByteArray(this.curMAC);
        if (this.prevSignature == null || this.prevSignature.equals("")) {
            newMAC = new byte[prevMAC.length];
            System.arraycopy(prevMAC, 0, newMAC, 0, prevMAC.length);
        } else {
            newMAC = new byte[prevMAC.length + SecureLogHelper.toByteArray(this.prevSignature).length];
            System.arraycopy(prevMAC, 0, newMAC, 0, prevMAC.length);
            System.arraycopy(SecureLogHelper.toByteArray(this.prevSignature), 0, newMAC, prevMAC.length, SecureLogHelper.toByteArray(this.prevSignature).length);
        }
        if (recPos != 0) {
            this.prevSignature = curSign;
        }
        this.verified = this.helper.verifySignature(SecureLogHelper.toByteArray(curSign), newMAC);
        return this.verified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify() throws Exception {
        Logger logger = (Logger)Logger.getLogger(this.name);
        ArrayList fileList = new ArrayList();
        String[][] tmpResult = new String[1][1];
        Object token = new Object();
        Logger logger2 = logger;
        synchronized (logger2) {
            this.verificationOn = true;
            long start = System.currentTimeMillis();
            this.helper = SecureFileHandler.getSecureLogHelper(this.name);
            fileList = SecureFileHandler.getCurrentFileList(this.name);
            if (fileList == null) {
                Debug.error("No fileList found in handler.");
                return VerifierAction.doVerifierAction(this.name, this.verified);
            }
            token = Token.createToken("AUDITOR", new String(this.verPassword.getChars()));
            tmpResult = LogReader.read((String)fileList.get(fileList.size() - 1), token);
        }
        for (int i = 0; i < fileList.size() - 1; ++i) {
            int l;
            String[][] result = new String[1][1];
            try {
                result = LogReader.read((String)fileList.get(i), token);
            }
            catch (Exception e) {
                Debug.error("Error in reading File : " + fileList.get(i));
            }
            if (result == null || result.length == 0) {
                if (Debug.messageEnabled()) {
                    Debug.message("LogVerifier::verify::Empty return from read of " + (String)fileList.get(i) + ":" + fileList.get(i));
                }
                this.verified = false;
                break;
            }
            Vector<String> header = new Vector<String>(result[0].length);
            for (int j = 0; j < result[0].length; ++j) {
                header.add(result[0][j]);
            }
            int signPos = -1;
            int macPos = -1;
            String signFldName = "Signature";
            String macFldName = "MAC";
            for (l = 0; l < header.size(); ++l) {
                if (!((String)header.get(l)).equalsIgnoreCase(signFldName)) continue;
                signPos = l;
                break;
            }
            for (l = 0; l < header.size(); ++l) {
                if (!((String)header.get(l)).equalsIgnoreCase(macFldName)) continue;
                macPos = l;
                break;
            }
            if (signPos == -1 || macPos == -1) {
                Debug.error("Could not locate mac and sign header");
                return VerifierAction.doVerifierAction(this.name, this.verified);
            }
            for (int k = 1; k < result.length; ++k) {
                if (Debug.messageEnabled()) {
                    Debug.message(this.name + ":Start checking records " + result.length + ":" + fileList.get(i));
                }
                if (result[k][signPos].equals("-")) {
                    this.verified = this.verifyLogRecord(result[k], macPos);
                    if (!this.verified) {
                        Debug.error("Log Record Verification Failed in file:" + (String)fileList.get(i) + " at record no. " + k);
                        break;
                    }
                    if (!Debug.messageEnabled()) continue;
                    Debug.message(this.name + ":Log Record Verification Succeeded in file:" + (String)fileList.get(i) + "at record no." + k);
                    continue;
                }
                int lastRecInFile = 0;
                lastRecInFile = result.length - 1 - k;
                this.verified = this.verifySignature(result[k], signPos, lastRecInFile);
                if (!this.verified) {
                    Debug.error("Log Signature Verification Failed in file:" + (String)fileList.get(i) + " at record no. " + k);
                    break;
                }
                if (!Debug.messageEnabled()) continue;
                Debug.message("Log Signature Verification Succeeded in file:" + (String)fileList.get(i) + "at record no." + k);
            }
            if (!this.verified) break;
        }
        if (tmpResult != null && tmpResult.length != 0) {
            int l;
            Vector<String> header = new Vector<String>(tmpResult[0].length);
            for (int j = 0; j < tmpResult[0].length; ++j) {
                header.add(tmpResult[0][j]);
            }
            int signPos = -1;
            int macPos = -1;
            String signFldName = "Signature";
            String macFldName = "MAC";
            for (l = 0; l < header.size(); ++l) {
                if (!((String)header.get(l)).equalsIgnoreCase(signFldName)) continue;
                signPos = l;
                break;
            }
            for (l = 0; l < header.size(); ++l) {
                if (!((String)header.get(l)).equalsIgnoreCase(macFldName)) continue;
                macPos = l;
                break;
            }
            if (signPos == -1 || macPos == -1) {
                Debug.error("Could not locate mac and sign header");
                return VerifierAction.doVerifierAction(this.name, this.verified);
            }
            for (int k = 1; k < tmpResult.length; ++k) {
                if (Debug.messageEnabled()) {
                    Debug.message(this.name + ":Start checking records " + tmpResult.length + ":" + fileList.get(fileList.size() - 1));
                }
                if (tmpResult[k][signPos].equals("-")) {
                    this.verified = this.verifyLogRecord(tmpResult[k], macPos);
                    if (!this.verified) {
                        Debug.error("Log Record Verification Failed in file:" + (String)fileList.get(fileList.size() - 1) + " at record no. " + k);
                        break;
                    }
                    if (!Debug.messageEnabled()) continue;
                    Debug.message(this.name + ":Log Record Verification " + "Succeeded in file:" + (String)fileList.get(fileList.size() - 1) + "at record no." + k);
                    continue;
                }
                int lastRecInFile = 0;
                lastRecInFile = tmpResult.length - 1 - k;
                this.verified = this.verifySignature(tmpResult[k], signPos, lastRecInFile);
                if (!this.verified) {
                    Debug.error("Log Signature Verification Failed in file:" + (String)fileList.get(fileList.size() - 1) + " at record no. " + k);
                    break;
                }
                if (!Debug.messageEnabled()) continue;
                Debug.message("Log Signature Verification Succeeded in file:" + (String)fileList.get(fileList.size() - 1) + "at record no." + k);
            }
        } else {
            if (Debug.messageEnabled()) {
                Debug.message("LogVerifier::verify::Empty return from read of " + (String)fileList.get(fileList.size() - 1) + ":" + fileList.get(fileList.size() - 1));
            }
            this.verified = false;
        }
        this.prevSignature = null;
        this.curMAC = null;
        String path = this.manager.getProperty("iplanet-am-logging-location");
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        String verKeyStoreName = path + PREFIX + "ver." + this.name;
        this.helper.setLastLineforVerifier(true);
        boolean intrusion = this.helper.isIntrusionTrue();
        if (intrusion) {
            Debug.error(this.name + " Last Line check in Verifier failed." + " Possible intrusion detected");
            this.verified = false;
        }
        this.helper.setLastLineforVerifier(false);
        this.helper.reinitializeVerifier(verKeyStoreName, this.verPassword);
        if (Debug.messageEnabled()) {
            Debug.message(this.name + ":Done Verifying");
        }
        return VerifierAction.doVerifierAction(this.name, this.verified);
    }

    class VerifyTask
    extends GeneralTaskRunnable {
        private long runPeriod;

        public VerifyTask(long runPeriod) {
            this.runPeriod = runPeriod;
        }

        public void run() {
            try {
                LogVerifier.this.verify();
            }
            catch (Exception e) {
                Debug.error(LogVerifier.this.name + ":Error running verifier thread", e);
            }
            LogVerifier.this.verificationOn = false;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean addElement(Object obj) {
            return false;
        }

        public boolean removeElement(Object obj) {
            return false;
        }

        public long getRunPeriod() {
            return this.runPeriod;
        }
    }
}

