/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.setup.AMSetupServlet;
import com.sun.identity.setup.ServicesDefaultValues;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;

public class ConfigureData {
    private String baseDir;
    private SSOToken ssoToken;
    private String hostname;
    private ServletContext sctx;

    public ConfigureData(String baseDir, ServletContext sctx, String hostname, SSOToken ssoToken) {
        this.baseDir = baseDir;
        this.sctx = sctx;
        this.hostname = hostname;
        this.ssoToken = ssoToken;
    }

    public void configure() throws SMSException, SSOException, IOException, PolicyException {
        this.modifyClientDataService();
        this.modifyClientDetectionService();
        this.createRealmAndPolicies();
        this.setRealmAttributes();
    }

    private void modifyClientDataService() throws SMSException, SSOException, IOException {
        HashMap<String, Set> map = new HashMap<String, Set>();
        map.put("profileManagerXML", this.getFileContentInSet("SunAMClientData.xml"));
        this.modifySchemaDefaultValues("SunAMClientData", SchemaType.GLOBAL, null, map);
    }

    private void modifyClientDetectionService() throws SMSException, SSOException, IOException {
        HashMap map = new HashMap();
        HashSet<String> set1 = new HashSet<String>(2);
        set1.add("Active");
        map.put("iplanet-am-client-detection-enabled", set1);
        HashSet<String> set2 = new HashSet<String>(2);
        set2.add("com.sun.mobile.cdm.FEDIClientDetector");
        map.put("iplanet-am-client-detection-class", set2);
        this.modifySchemaDefaultValues("iPlanetAMClientDetection", SchemaType.GLOBAL, null, map);
    }

    private void createRealmAndPolicies() throws SMSException, SSOException, PolicyException, IOException, FileNotFoundException {
        this.createRealm("/sunamhiddenrealmdelegationservicepermissions");
        this.createPolicies("/sunamhiddenrealmdelegationservicepermissions", this.baseDir + "/defaultDelegationPolicies.xml");
    }

    private void setRealmAttributes() throws SMSException {
        OrganizationConfigManager ocm = new OrganizationConfigManager(this.ssoToken, "/");
        HashMap map = new HashMap();
        HashSet<String> set1 = new HashSet<String>(2);
        set1.add("Active");
        map.put("sunOrganizationStatus", set1);
        HashSet<String> set2 = new HashSet<String>(2);
        Map defaultValues = ServicesDefaultValues.getDefaultValues();
        set2.add(ConfigureData.DNToName((String)defaultValues.get("ROOT_SUFFIX")));
        map.put("sunOrganizationAliases", set2);
        ocm.setAttributes("sunIdentityRepositoryService", map);
    }

    private static String DNToName(String dn) {
        String ret = dn;
        if (DN.isDN((String)dn)) {
            String[] comps = LDAPDN.explodeDN((String)dn, (boolean)true);
            ret = comps[0];
        }
        return ret;
    }

    private void createPolicies(String realmName, String xmlFile) throws FileNotFoundException, PolicyException, SSOException, IOException {
        int len;
        PolicyManager pm = new PolicyManager(this.ssoToken, realmName);
        InputStreamReader fin = new InputStreamReader(AMSetupServlet.getResourceAsStream(this.sctx, xmlFile));
        StringBuffer sbuf = new StringBuffer();
        char[] cbuf = new char[1024];
        while ((len = fin.read(cbuf)) > 0) {
            sbuf.append(cbuf, 0, len);
        }
        String data = ServicesDefaultValues.tagSwap(sbuf.toString(), true);
        ByteArrayInputStream bis = new ByteArrayInputStream(data.getBytes());
        PolicyUtils.createPolicies(pm, bis);
    }

    private void modifySchemaDefaultValues(String serviceName, SchemaType schemaType, String subSchema, Map values) throws SMSException, SSOException, IOException {
        ServiceSchema ss = this.getServiceSchema(serviceName, schemaType, subSchema);
        ss.setAttributeDefaults(values);
    }

    private ServiceSchema getServiceSchema(String serviceName, SchemaType schemaType, String subSchema) throws SMSException, SSOException {
        ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, this.ssoToken);
        ServiceSchema ss = ssm.getSchema(schemaType);
        if (subSchema != null) {
            boolean done = false;
            StringTokenizer st = new StringTokenizer(subSchema, "/");
            while (st.hasMoreTokens() && !done) {
                String str = st.nextToken();
                if (str != null) {
                    if ((ss = ss.getSubSchema(str)) != null) continue;
                    throw new RuntimeException("SubSchema" + str + "does not exist");
                }
                done = true;
            }
        }
        return ss;
    }

    private Set getFileContentInSet(String fileName) throws IOException {
        HashSet<String> set = new HashSet<String>(2);
        set.add(this.getFileContent(fileName));
        return set;
    }

    private String getFileContent(String fileName) throws IOException {
        int len;
        StringBuffer sbuf = new StringBuffer();
        InputStreamReader fin = new InputStreamReader(AMSetupServlet.getResourceAsStream(this.sctx, this.baseDir + "/" + fileName));
        char[] cbuf = new char[1024];
        while ((len = fin.read(cbuf)) > 0) {
            sbuf.append(cbuf, 0, len);
        }
        return sbuf.toString();
    }

    private void createRealm(String realmName) throws SMSException {
        String parentRealm = ConfigureData.getParentRealm(realmName);
        String childRealm = ConfigureData.getChildRealm(realmName);
        OrganizationConfigManager ocm = new OrganizationConfigManager(this.ssoToken, parentRealm);
        ocm.createSubOrganization(childRealm, null);
    }

    private static String getParentRealm(String path) {
        int idx;
        String parent = "/";
        if ((path = ConfigureData.normalizeRealm(path)) != null && path.length() > 0 && (idx = path.lastIndexOf(47)) > 0) {
            parent = path.substring(0, idx);
        }
        return parent;
    }

    private static String getChildRealm(String path) {
        int idx;
        String child = "/";
        if ((path = ConfigureData.normalizeRealm(path)) != null && path.length() > 0 && (idx = path.lastIndexOf(47)) != -1) {
            child = path.substring(idx + 1);
        }
        return child;
    }

    private static String normalizeRealm(String path) {
        if (path != null && (path = path.trim()).length() > 0) {
            while (path.indexOf("//") != -1) {
                path = path.replaceAll("//", "/");
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path.trim();
    }
}

