/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.monitoring;

import com.sun.identity.monitoring.Agent;
import com.sun.identity.monitoring.SsoServerSAML1CacheEntryImpl;
import com.sun.identity.monitoring.SsoServerSAML1EndPointEntryImpl;
import com.sun.identity.monitoring.SsoServerSAML1Svc;
import com.sun.identity.shared.debug.Debug;
import com.sun.management.snmp.agent.SnmpMib;
import javax.management.MBeanServer;

public class SsoServerSAML1SvcImpl
extends SsoServerSAML1Svc {
    private static Debug debug = null;
    private static String myMibName;
    protected SsoServerSAML1CacheEntryImpl assertCache = null;
    protected SsoServerSAML1CacheEntryImpl artifactCache = null;
    protected SsoServerSAML1EndPointEntryImpl soapEP = null;
    protected SsoServerSAML1EndPointEntryImpl pprofEP = null;
    protected SsoServerSAML1EndPointEntryImpl samlAwareEP = null;
    public static final String ASSERTIONS = "Assertions";
    public static final String ARTIFACTS = "Artifacts";
    public static final String CREAD = "Read";
    public static final String CWRITE = "Write";
    public static final String CHIT = "Hit";
    public static final String CMISS = "Miss";
    public static final String SOAPRCVR = "SAMLSOAPReceiver";
    public static final String POSTPROFILE = "SAMLPostProfile";
    public static final String SAMLAWARE = "SAMLAware";
    public static final String EPRQTIN = "RqtIn";
    public static final String EPRQTOUT = "RqtOut";
    public static final String EPRQTFAILED = "RqtFailed";
    public static final String EPRQTABORTED = "RqtAborted";

    public SsoServerSAML1SvcImpl(SnmpMib myMib) {
        super(myMib);
        myMibName = myMib.getMibName();
        this.init(myMib, null);
    }

    public SsoServerSAML1SvcImpl(SnmpMib myMib, MBeanServer server) {
        super(myMib, server);
        myMibName = myMib.getMibName();
        this.init(myMib, server);
    }

    private void init(SnmpMib myMib, MBeanServer server) {
        if (debug == null) {
            debug = Debug.getInstance((String)"amMonitoring");
        }
    }

    public void incSAML1Cache(String assertOrArtifact, String rWHM) {
        String classModule = "SsoServerSAML1SvcImpl.incSAML1Cache:";
        if (!Agent.isRunning()) {
            return;
        }
        SsoServerSAML1CacheEntryImpl ce = null;
        if (assertOrArtifact.equals(ASSERTIONS)) {
            ce = this.assertCache;
        } else if (assertOrArtifact.equals(ARTIFACTS)) {
            ce = this.artifactCache;
        } else {
            debug.error(classModule + "no such cache: " + assertOrArtifact);
            return;
        }
        if (rWHM.equals(CREAD)) {
            long li = ce.SsoServerSAML1CacheReads;
            ce.SsoServerSAML1CacheReads = ++li;
        } else if (rWHM.equals(CWRITE)) {
            long li = ce.SsoServerSAML1CacheWrites;
            ce.SsoServerSAML1CacheWrites = ++li;
        } else if (rWHM.equals(CHIT)) {
            long li = ce.SsoServerSAML1CacheHits;
            ce.SsoServerSAML1CacheHits = ++li;
        } else if (rWHM.equals(CMISS)) {
            long li = ce.SsoServerSAML1CacheMisses;
            ce.SsoServerSAML1CacheMisses = ++li;
        } else {
            debug.error(classModule + "no such cache action: " + rWHM);
            return;
        }
    }

    public void incSAML1EndPoint(String endPoint, String rType) {
        String classModule = "SsoServerSAML1SvcImpl.incSAML1EndPoint:";
        if (!Agent.isRunning()) {
            return;
        }
        SsoServerSAML1EndPointEntryImpl ee = null;
        if (endPoint.equals(SOAPRCVR)) {
            ee = this.soapEP;
        } else if (endPoint.equals(POSTPROFILE)) {
            ee = this.pprofEP;
        } else if (endPoint.equals(SAMLAWARE)) {
            ee = this.samlAwareEP;
        } else {
            debug.error(classModule + "no such endpoint: " + endPoint);
            return;
        }
        if (rType.equals(EPRQTIN)) {
            long li = ee.SsoServerSAML1EndPointRqtIn;
            ee.SsoServerSAML1EndPointRqtIn = ++li;
        } else if (rType.equals(EPRQTOUT)) {
            long li = ee.SsoServerSAML1EndPointRqtOut;
            ee.SsoServerSAML1EndPointRqtOut = ++li;
        } else if (rType.equals(EPRQTFAILED)) {
            long li = ee.SsoServerSAML1EndPointRqtFailed;
            ee.SsoServerSAML1EndPointRqtFailed = ++li;
        } else if (rType.equals(EPRQTABORTED)) {
            long li = ee.SsoServerSAML1EndPointRqtAborted;
            ee.SsoServerSAML1EndPointRqtAborted = ++li;
        } else {
            debug.error(classModule + "no such counter: " + rType);
            return;
        }
    }

    public void setSAML1EndPointOperational(String endPoint) {
        String classModule = "SsoServerSAML1SvcImpl.setSAML1EndPointOperational:";
        if (!Agent.isRunning()) {
            return;
        }
        SsoServerSAML1EndPointEntryImpl ee = null;
        if (endPoint.equals(SOAPRCVR)) {
            ee = this.soapEP;
        } else if (endPoint.equals(POSTPROFILE)) {
            ee = this.pprofEP;
        } else if (endPoint.equals(SAMLAWARE)) {
            ee = this.samlAwareEP;
        } else {
            debug.error(classModule + "no such endpoint: " + endPoint);
            return;
        }
        ee.SsoServerSAML1EndPointStatus = "operational";
    }
}

