/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.workflow;

import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.saml2.jaxb.metadata.IDPSSODescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.SPSSODescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.SingleLogoutServiceElement;
import com.sun.identity.saml2.jaxb.metadata.SingleSignOnServiceElement;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.workflow.WorkflowException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ValidateSAML2 {
    private static final String LOGIN_URL = "/UI/Login";
    private static final String LOGOUT_URL = "/UI/Logout";
    private String realm;
    private String idpEntityId;
    private String spEntityId;
    private String idpMetaAlias;
    private String spMetaAlias;
    private String idpBaseURL;
    private String spBaseURL;
    private boolean bFedlet = false;

    public ValidateSAML2(String realm, String idp, String sp) throws WorkflowException {
        this.realm = realm;
        this.setIDPEntityId(idp);
        this.setSPEntityId(sp);
        this.validateIDP();
        this.validateSP();
    }

    private void validateIDP() throws WorkflowException {
        try {
            SAML2MetaManager mm = SAML2Utils.getSAML2MetaManager();
            IDPSSODescriptorElement elt = mm.getIDPSSODescriptor(this.realm, this.idpEntityId);
            if (elt == null) {
                Object[] param = new Object[]{this.idpEntityId};
                throw new WorkflowException("cannot.locate.idp", param);
            }
            if (this.idpMetaAlias != null) {
                IDPSSOConfigElement idpConfig = mm.getIDPSSOConfig(this.realm, this.idpEntityId);
                if (idpConfig == null) {
                    Object[] param = new Object[]{this.idpEntityId};
                    throw new WorkflowException("cannot.locate.idp", param);
                }
                if (!idpConfig.getMetaAlias().equals(this.idpMetaAlias)) {
                    Object[] param = new Object[]{this.idpEntityId};
                    throw new WorkflowException("cannot.locate.idp", param);
                }
            }
            List ssoServiceList = elt.getSingleSignOnService();
            this.idpBaseURL = this.getIDPBaseURL(ssoServiceList);
            if (this.idpBaseURL == null) {
                Object[] param = new Object[]{this.idpEntityId};
                throw new WorkflowException("cannot.locate.idp.loginURL", param);
            }
            this.validateURL(this.idpBaseURL);
        }
        catch (SAML2MetaException ex) {
            Object[] param = new Object[]{this.idpEntityId};
            throw new WorkflowException("cannot.locate.idp", param);
        }
    }

    private String getIDPBaseURL(List ssoServiceList) {
        String url = null;
        if (ssoServiceList != null && !ssoServiceList.isEmpty()) {
            Iterator i = ssoServiceList.iterator();
            while (i.hasNext() && url == null) {
                String ssoURL;
                int loc;
                SingleSignOnServiceElement sso = (SingleSignOnServiceElement)i.next();
                if (sso == null || sso.getBinding() == null || (loc = (ssoURL = sso.getLocation()).indexOf("/metaAlias/")) == -1) continue;
                String tmp = ssoURL.substring(0, loc);
                loc = tmp.lastIndexOf("/");
                url = tmp.substring(0, loc);
            }
        }
        return url;
    }

    private void validateSP() throws WorkflowException {
        try {
            SAML2MetaManager mm = SAML2Utils.getSAML2MetaManager();
            SPSSODescriptorElement elt = mm.getSPSSODescriptor(this.realm, this.spEntityId);
            if (elt == null) {
                Object[] param = new Object[]{this.spEntityId};
                throw new WorkflowException("cannot.locate.sp", param);
            }
            if (this.spMetaAlias != null) {
                SPSSOConfigElement spConfig = mm.getSPSSOConfig(this.realm, this.spEntityId);
                if (spConfig == null) {
                    Object[] param = new Object[]{this.spEntityId};
                    throw new WorkflowException("cannot.locate.sp", param);
                }
                if (!spConfig.getMetaAlias().equals(this.spMetaAlias)) {
                    Object[] param = new Object[]{this.spEntityId};
                    throw new WorkflowException("cannot.locate.sp", param);
                }
            }
            List sloServiceList = elt.getSingleLogoutService();
            this.spBaseURL = this.getSPBaseURL(sloServiceList);
            if (this.spBaseURL == null) {
                this.bFedlet = true;
            } else {
                this.validateURL(this.spBaseURL);
            }
        }
        catch (SAML2MetaException ex) {
            Object[] param = new Object[]{this.spEntityId};
            throw new WorkflowException("cannot.locate.sp", param);
        }
    }

    private void validateURL(String strUrl) throws WorkflowException {
        try {
            URL url = new URL(strUrl);
            URLConnection connection = url.openConnection();
            connection.connect();
        }
        catch (MalformedURLException ex) {
            Object[] params = new Object[]{strUrl};
            throw new WorkflowException("cannot.reach.url", params);
        }
        catch (IOException ex) {
            Object[] params = new Object[]{strUrl};
            throw new WorkflowException("cannot.reach.url", params);
        }
    }

    private String getSPBaseURL(List sloServiceList) {
        String url = null;
        if (sloServiceList != null && !sloServiceList.isEmpty()) {
            Iterator i = sloServiceList.iterator();
            while (i.hasNext() && url == null) {
                String ssoURL;
                int loc;
                SingleLogoutServiceElement sso = (SingleLogoutServiceElement)i.next();
                if (sso == null || sso.getBinding() == null || (loc = (ssoURL = sso.getLocation()).indexOf("/metaAlias/")) == -1) continue;
                String tmp = ssoURL.substring(0, loc);
                loc = tmp.lastIndexOf("/");
                url = tmp.substring(0, loc);
            }
        }
        return url;
    }

    private void setIDPEntityId(String idp) {
        int idx = idp.indexOf("(");
        if (idx != -1) {
            int idx1 = idp.indexOf(")", idx);
            if (idx1 != -1) {
                this.idpEntityId = idp.substring(0, idx);
                this.idpMetaAlias = idp.substring(idx + 1, idx1);
            } else {
                this.idpEntityId = idp;
            }
        } else {
            this.idpEntityId = idp;
        }
    }

    private void setSPEntityId(String sp) {
        int idx = sp.indexOf("(");
        if (idx != -1) {
            int idx1 = sp.indexOf(")", idx);
            if (idx1 != -1) {
                this.spEntityId = sp.substring(0, idx);
                this.spMetaAlias = sp.substring(idx + 1, idx1);
            } else {
                this.spEntityId = sp;
            }
        } else {
            this.spEntityId = sp;
        }
    }

    public static String getMessage(String key, String locale) {
        try {
            ResourceBundle rb = ResourceBundle.getBundle("workflowMessages", Locale.getLocale((String)locale));
            return rb.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public String getIDPEntityId() {
        return this.idpEntityId;
    }

    public String getSPEntityId() {
        return this.spEntityId;
    }

    public String getIDPLoginURL() {
        return this.idpBaseURL + LOGIN_URL;
    }

    public String getSPLoginURL() {
        return this.spBaseURL + LOGIN_URL;
    }

    public String getIDPLogoutURL() {
        return this.idpBaseURL + LOGOUT_URL;
    }

    public String getSPLogoutURL() {
        return this.spBaseURL + LOGOUT_URL;
    }

    public boolean isFedlet() {
        return this.bFedlet;
    }

    public boolean isIDPHosted() {
        return this.idpMetaAlias != null && this.idpMetaAlias.length() > 0;
    }

    public String getSSOURL() {
        if (this.idpMetaAlias != null) {
            try {
                if (this.bFedlet) {
                    String url = this.idpBaseURL + "/idpssoinit?" + "NameIDFormat=" + URLEncoder.encode("urn:oasis:names:tc:SAML:2.0:nameid-format:transient", "UTF-8") + "&metaAlias=" + URLEncoder.encode(this.idpMetaAlias, "UTF-8") + "&spEntityID=" + URLEncoder.encode(this.spEntityId, "UTF-8") + "&binding=" + URLEncoder.encode("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", "UTF-8");
                    return url;
                }
                return this.idpBaseURL + "/idpssoinit?metaAlias=" + URLEncoder.encode(this.idpMetaAlias, "UTF-8") + "&spEntityID=" + URLEncoder.encode(this.spEntityId, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                return "";
            }
        }
        try {
            return this.spBaseURL + "/spssoinit?metaAlias=" + URLEncoder.encode(this.spMetaAlias, "UTF-8") + "&idpEntityID=" + URLEncoder.encode(this.idpEntityId, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return "";
        }
    }

    public String getSLOURL() {
        if (this.idpMetaAlias != null) {
            try {
                return this.idpBaseURL + "/saml2/jsp/idpSingleLogoutInit.jsp?metaAlias=" + URLEncoder.encode(this.idpMetaAlias, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                return "";
            }
        }
        try {
            return this.spBaseURL + "/saml2/jsp/spSingleLogoutInit.jsp?metaAlias=" + URLEncoder.encode(this.spMetaAlias, "UTF-8") + "&idpEntityID=" + URLEncoder.encode(this.idpEntityId, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return "";
        }
    }

    public String getAccountTerminationURL() {
        if (this.idpMetaAlias != null) {
            try {
                return this.idpBaseURL + "/saml2/jsp/idpMNIRequestInit.jsp?metaAlias=" + URLEncoder.encode(this.idpMetaAlias, "UTF-8") + "&spEntityID=" + URLEncoder.encode(this.spEntityId, "UTF-8") + "&requestType=Terminate";
            }
            catch (UnsupportedEncodingException ex) {
                return "";
            }
        }
        try {
            return this.spBaseURL + "/saml2/jsp/spMNIRequestInit.jsp?metaAlias=" + URLEncoder.encode(this.spMetaAlias, "UTF-8") + "&idpEntityID=" + URLEncoder.encode(this.idpEntityId, "UTF-8") + "&requestType=Terminate";
        }
        catch (UnsupportedEncodingException ex) {
            return "";
        }
    }
}

