/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMEventManagerException;
import com.iplanet.am.sdk.AMObjectListenerImpl;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.common.IComplianceServices;
import com.iplanet.am.sdk.common.IDCTreeServices;
import com.iplanet.am.sdk.common.IDirectoryServices;
import com.iplanet.am.sdk.common.IDirectoryServicesProvider;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.ServiceManager;
import java.security.AccessController;
import java.security.ProviderException;

public class AMDirectoryAccessFactory {
    private static IDirectoryServices dsServicesImpl;
    private static IDCTreeServices dcTreeServicesImpl;
    private static IComplianceServices complianceServicesImpl;
    private static Debug debug;
    private static boolean isInitialized;
    private static final String CONFIGURED_SDK_PACKAGE_PROPERTY = "com.iplanet.am.sdk.package";
    private static final String LDAP_SDK_PACKAGE = "com.iplanet.am.sdk.ldap";
    private static final String REMOTE_SDK_PACKAGE = "com.iplanet.am.sdk.remote";
    private static final String DS_SERVICES_PROVIDER_CLASS = "DirectoryServicesProviderImpl";
    private static final String REMOTE_SERVICES_PROVIDER_CLASS = "RemoteServicesProviderImpl";
    private static final String PACKAGE_SEPARATOR = ".";

    private static void initialize() {
        if (!ServiceManager.isAMSDKEnabled()) {
            debug.error("AMDirectoryAccessFactory.initialize() AM.SDK not configured");
            throw new RuntimeException("AMSDK NOT configured");
        }
        String configuredSDK = SystemProperties.get(CONFIGURED_SDK_PACKAGE_PROPERTY);
        boolean isCriticalErrorIfClassNotFound = true;
        if (configuredSDK == null || configuredSDK.equals(LDAP_SDK_PACKAGE)) {
            try {
                isCriticalErrorIfClassNotFound = false;
                AMDirectoryAccessFactory.instantiateImpls(LDAP_SDK_PACKAGE, DS_SERVICES_PROVIDER_CLASS, isCriticalErrorIfClassNotFound);
            }
            catch (ProviderException pe) {
                if (debug.messageEnabled()) {
                    debug.message("AMDirectoryAccessFactory.static{} - Initializing the server packages failed. Hence trying the remote client sdk pacakage");
                }
                isCriticalErrorIfClassNotFound = true;
                AMDirectoryAccessFactory.instantiateImpls(REMOTE_SDK_PACKAGE, REMOTE_SERVICES_PROVIDER_CLASS, isCriticalErrorIfClassNotFound);
            }
        } else if (configuredSDK.equals(REMOTE_SDK_PACKAGE)) {
            AMDirectoryAccessFactory.instantiateImpls(REMOTE_SDK_PACKAGE, REMOTE_SERVICES_PROVIDER_CLASS, isCriticalErrorIfClassNotFound);
        } else {
            AMDirectoryAccessFactory.instantiateImpls(LDAP_SDK_PACKAGE, DS_SERVICES_PROVIDER_CLASS, isCriticalErrorIfClassNotFound);
        }
        isInitialized = true;
    }

    private static void instantiateImpls(String packageName, String className, boolean isCriticalErrorIfClassNotFound) {
        String providerClass = packageName + PACKAGE_SEPARATOR + className;
        try {
            IDirectoryServicesProvider dsServicesProvider = (IDirectoryServicesProvider)Class.forName(providerClass).newInstance();
            dsServicesImpl = dsServicesProvider.getDirectoryServicesImpl();
            dcTreeServicesImpl = dsServicesProvider.getDCTreeServicesImpl();
            complianceServicesImpl = dsServicesProvider.getComplianceServicesImpl();
            AMDirectoryAccessFactory.initListener();
        }
        catch (InstantiationException e) {
            debug.error("AMDirectoryAccessFactory.instantiateImpls()- Initializing Impls from package: " + packageName + " FAILED!", (Throwable)e);
            throw new ProviderException(AMSDKBundle.getString("300"));
        }
        catch (IllegalAccessException e) {
            debug.error("AMDirectoryAccessFactory.instantiateImpls()- Initializing Impls from package: " + packageName + " FAILED!", (Throwable)e);
            throw new ProviderException(AMSDKBundle.getString("300"));
        }
        catch (ClassNotFoundException e) {
            String message = "AMDirectoryAccessFactory.instantiateImpls()- Initializing Impls from package: " + packageName + " FAILED!";
            if (isCriticalErrorIfClassNotFound) {
                debug.error(message, (Throwable)e);
            } else {
                debug.warning(message, (Throwable)e);
            }
            throw new ProviderException(AMSDKBundle.getString("300"));
        }
        catch (AMEventManagerException ame) {
            debug.error("AMDirectoryAccessFactory.instantiateImpls()- Initializing Impls from package: " + packageName + "FAILED!", (Throwable)ame);
            throw new ProviderException(AMSDKBundle.getString("300"));
        }
        if (debug.messageEnabled()) {
            debug.message("AMDirectoryAccessFactory.instantiateImpls() - Successfully initialized Impls Using Impl Package: " + packageName + " for accessing Directory Services");
        }
    }

    private static void initListener() throws AMEventManagerException {
        SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        AMObjectListenerImpl amListener = new AMObjectListenerImpl();
        if (debug.messageEnabled()) {
            debug.message("AMDirectoryAccessFactory.initListener() - adding listener: " + amListener.getClass().getName());
        }
        dsServicesImpl.addListener(token, amListener, null);
    }

    private static boolean isInitialized() {
        return isInitialized;
    }

    public static IDirectoryServices getDirectoryServices() {
        if (!AMDirectoryAccessFactory.isInitialized()) {
            AMDirectoryAccessFactory.initialize();
        }
        return dsServicesImpl;
    }

    public static IDCTreeServices getDCTreeServices() {
        if (!AMDirectoryAccessFactory.isInitialized()) {
            AMDirectoryAccessFactory.initialize();
        }
        return dcTreeServicesImpl;
    }

    public static IComplianceServices getComplianceServices() {
        if (!AMDirectoryAccessFactory.isInitialized()) {
            AMDirectoryAccessFactory.initialize();
        }
        return complianceServicesImpl;
    }

    static {
        debug = AMCommonUtils.debug;
        isInitialized = false;
    }
}

