/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.BaseRole;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.DataLayer;
import com.iplanet.ums.Guid;
import com.iplanet.ums.IFilteredMembership;
import com.iplanet.ums.IUMSConstants;
import com.iplanet.ums.InvalidSearchFilterException;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import java.security.Principal;

public class FilteredRole
extends BaseRole
implements IFilteredMembership,
IUMSConstants {
    public static final String FILTER_ATTR_NAME = "nsRoleFilter";
    public static final String[] FILTEREDROLE_OBJECTCLASSES = new String[]{"top", "ldapsubentry", "nsroledefinition", "nscomplexroledefinition", "nsfilteredroledefinition"};
    public static final String[] FILTEREDROLE_ATTRIBUTES = new String[]{"cn", "nsRoleFilter"};
    private static I18n i18n = I18n.getInstance("amSDK");
    private static final Class _class = FilteredRole.class;

    public FilteredRole() {
    }

    public FilteredRole(String name, String filter) throws UMSException {
        this(new AttrSet(new Attr("cn", name)));
    }

    FilteredRole(AttrSet attrSet) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet);
    }

    public FilteredRole(CreationTemplate template, AttrSet attrSet) throws UMSException {
        super(template, attrSet);
    }

    public void setFilter(String filter) throws UMSException {
        this.setAttribute(new Attr(FILTER_ATTR_NAME, filter));
    }

    public String getFilter() throws UMSException {
        return this.getAttribute(FILTER_ATTR_NAME).getValue();
    }

    protected SearchResults getMembers(String[] attributes) throws UMSException {
        Guid guid = this.getGuid();
        String base = guid.getDn();
        int index = base.indexOf(",");
        if (index > 0) {
            base = base.substring(index + 1);
        }
        Guid bguid = new Guid(base);
        Principal principal = this.getPrincipal();
        if (principal == null) {
            throw new IllegalArgumentException(i18n.getString("ums-bad-principal-hdl"));
        }
        return DataLayer.getInstance().search(principal, bguid, 2, this.getFilter(), attributes, false, null);
    }

    protected SearchResults getMembers(String[] attributes, String filter) throws InvalidSearchFilterException, UMSException {
        Guid guid = this.getGuid();
        String base = guid.getDn();
        int index = base.indexOf(",");
        if (index > 0) {
            base = base.substring(index + 1);
        }
        Guid bguid = new Guid(base);
        return DataLayer.getInstance().search(this.getPrincipal(), bguid, 2, " ( &  ( " + this.getFilter() + ")" + " ( " + filter + " ) " + " ) ", attributes, false, null);
    }

    public SearchResults getMemberIDs() throws UMSException {
        String[] attributesToGet = new String[]{"objectclass"};
        return this.getMembers(attributesToGet);
    }

    public SearchResults getMemberIDs(String filter) throws UMSException {
        String[] attributesToGet = new String[]{"objectclass"};
        return this.getMembers(attributesToGet, filter);
    }

    public int getMemberCount() throws UMSException {
        int count = 0;
        String[] attributesToGet = new String[]{"dn"};
        SearchResults searchResults = this.getMembers(attributesToGet);
        while (searchResults.hasMoreElements()) {
            searchResults.next().getDN();
            ++count;
        }
        return count;
    }

    public Guid getMemberIDAt(int index) throws UMSException {
        if (index < 0) {
            throw new IllegalArgumentException(Integer.toString(index));
        }
        String[] attributesToGet = new String[]{"dn"};
        SearchResults searchResults = this.getMembers(attributesToGet);
        int srIndex = 0;
        while (searchResults.hasMoreElements()) {
            String s = searchResults.next().getDN();
            if (srIndex == index) {
                searchResults.abandon();
                return new Guid(s);
            }
            ++srIndex;
        }
        throw new ArrayIndexOutOfBoundsException(Integer.toString(index));
    }

    public boolean hasMember(Guid guid) throws UMSException {
        Principal principal = this.getPrincipal();
        if (principal == null) {
            throw new IllegalArgumentException(i18n.getString("ums-bad-principal-hdl"));
        }
        PersistentObject member = UMSObject.getObject(principal, guid);
        return this.hasMember(member);
    }
}

