/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.agentconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.configuration.AgentConfiguration;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.shared.FQDNUrl;
import com.sun.identity.sm.SMSException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class CreateAgentGroup
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        boolean webJ2EEAgent;
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String groupName = this.getStringOptionValue("agentgroupname");
        String agentType = this.getStringOptionValue("agenttype");
        String datafile = this.getStringOptionValue("datafile");
        List attrValues = rc.getOption("attributevalues");
        Map attributeValues = Collections.EMPTY_MAP;
        if (datafile != null || attrValues != null) {
            attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, attrValues);
        }
        String serverURL = this.getStringOptionValue("serverurl");
        boolean bl = webJ2EEAgent = agentType.equals("WebAgent") || agentType.equals("J2EEAgent");
        if (!webJ2EEAgent && serverURL != null) {
            throw new CLIException(this.getResourceString("does-not-support-server-url"), 127);
        }
        String[] params = new String[]{realm, agentType, groupName};
        this.writeLog(0, Level.INFO, "ATTEMPT_CREATE_AGENT_GROUP", params);
        try {
            AMIdentityRepository amir = new AMIdentityRepository(adminSSOToken, realm);
            Set set = amir.getAllowedIdOperations(IdType.AGENTGROUP);
            if (!set.contains(IdOperation.CREATE)) {
                String[] args = new String[]{realm};
                throw new CLIException(MessageFormat.format(this.getResourceString("does-not-support-agent-group-creation"), args), 127);
            }
            if (webJ2EEAgent) {
                FQDNUrl fqdnServerURL = null;
                try {
                    if (serverURL != null) {
                        fqdnServerURL = new FQDNUrl(serverURL);
                    }
                }
                catch (MalformedURLException e) {
                    throw new CLIException(this.getResourceString("server-url-invalid"), 127);
                }
                if (fqdnServerURL != null) {
                    Map map = AgentConfiguration.getDefaultValues(agentType, true);
                    map.putAll(attributeValues);
                    AgentConfiguration.tagswapAttributeValues(map, agentType, fqdnServerURL, null);
                    AgentConfiguration.createAgentGroup(adminSSOToken, realm, groupName, agentType, map);
                } else {
                    AgentConfiguration.createAgentGroup(adminSSOToken, realm, groupName, agentType, attributeValues);
                }
            } else {
                AgentConfiguration.createAgentGroup(adminSSOToken, realm, groupName, agentType, attributeValues);
            }
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("create-agent-group-succeeded"), params));
            this.writeLog(0, Level.INFO, "SUCCEED_CREATE_AGENT_GROUP", params);
        }
        catch (ConfigurationException e) {
            String[] args = new String[]{realm, agentType, groupName, e.getMessage()};
            this.debugError("CreateAgentGroup.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_CREATE_AGENT_GROUP", args);
            throw new CLIException(e, 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{realm, agentType, groupName, e.getMessage()};
            this.debugError("CreateAgentGroup.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_CREATE_AGENT_GROUP", args);
            throw new CLIException(e, 127);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, agentType, groupName, e.getMessage()};
            this.debugError("CreateAgentGroup.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_CREATE_AGENT_GROUP", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, agentType, groupName, e.getMessage()};
            this.debugError("CreateAgentGroup.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_CREATE_AGENT_GROUP", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

