/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.idrepo;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.idrepo.IdentityCommand;
import com.sun.identity.console.idm.model.BackwardCompSupport;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class GetAttributes
extends IdentityCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String idName = this.getStringOptionValue("idname");
        String type = this.getStringOptionValue("idtype");
        List attributeNames = rc.getOption("attributenames");
        IdType idType = this.convert2IdType(type);
        String[] params = new String[]{realm, type, idName};
        try {
            this.writeLog(0, Level.INFO, "ATTEMPT_IDREPO_GET_ATTRIBUTES", params);
            AMIdentity amid = new AMIdentity(adminSSOToken, idName, idType, realm, null);
            Set attrSchemas = this.getAttributeSchemas(type, adminSSOToken);
            Map rawValues = null;
            if (attributeNames != null && !attributeNames.isEmpty()) {
                HashSet attrNames = new HashSet();
                attrNames.addAll(attributeNames);
                rawValues = amid.getAttributes(attrNames);
            } else {
                rawValues = amid.getAttributes();
            }
            Object[] args = new Object[]{idName};
            if (rawValues != null && !rawValues.isEmpty()) {
                String msg = this.getResourceString("idrepo-attribute-result");
                String[] arg = new String[]{"", ""};
                for (String attrName : rawValues.keySet()) {
                    Set attrValues = (Set)rawValues.get(attrName);
                    arg[0] = attrName;
                    arg[1] = this.isPassword(attrSchemas, attrName) ? "********" : this.tokenize(attrValues);
                    outputWriter.printlnMessage(MessageFormat.format(msg, arg));
                }
            } else {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("idrepo-no-attributes"), args));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_IDREPO_GET_ATTRIBUTES", params);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, type, idName, e.getMessage()};
            this.debugError("GetAttributes.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_IDREPO_GET_ATTRIBUTES", args);
            throw new CLIException(e, 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{realm, type, idName, e.getMessage()};
            this.debugError("GetAttributes.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_IDREPO_GET_ATTRIBUTES", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, type, idName, e.getMessage()};
            this.debugError("GetAttributes.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_IDREPO_GET_ATTRIBUTES", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }

    private boolean isPassword(Set attrSchemas, String attrName) {
        boolean isPwd = false;
        for (AttributeSchema as : attrSchemas) {
            if (!attrName.equals(as.getName())) continue;
            AttributeSchema.Syntax syntax = as.getSyntax();
            isPwd = syntax != null && syntax == AttributeSchema.Syntax.PASSWORD;
            break;
        }
        return isPwd;
    }

    private Set getAttributeSchemas(String idType, SSOToken token) throws SMSException, SSOException, IdRepoException {
        ServiceSchemaManager svcSchemaMgr;
        ServiceSchema svcSchema;
        Set attributeSchemas = Collections.EMPTY_SET;
        String serviceName = this.getSvcNameForIdType(idType);
        if (serviceName != null && (svcSchema = (svcSchemaMgr = new ServiceSchemaManager(serviceName, token)).getSchema(idType)) != null) {
            attributeSchemas = svcSchema.getAttributeSchemas();
        }
        Iterator i = attributeSchemas.iterator();
        while (i.hasNext()) {
            AttributeSchema as = (AttributeSchema)i.next();
            String i18nKey = as.getI18NKey();
            if (i18nKey != null && i18nKey.trim().length() != 0) continue;
            i.remove();
        }
        return attributeSchemas;
    }

    private String getSvcNameForIdType(String idType) throws IdRepoException {
        String serviceName = IdUtils.getServiceName(IdUtils.getType(idType));
        if ((serviceName == null || serviceName.trim().length() == 0) && ServiceManager.isCoexistenceMode()) {
            BackwardCompSupport support = BackwardCompSupport.getInstance();
            serviceName = support.getServiceName(idType);
        }
        return serviceName;
    }
}

