/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.realm;

import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;

public class GetSupportedAuthModules
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String[] params = new String[]{};
        this.writeLog(0, Level.INFO, "ATTEMPT_GET_SUPPORTED_AUTH_MODULES", params);
        try {
            AMAuthenticationManager mgr = new AMAuthenticationManager(adminSSOToken, "/");
            Set types = mgr.getAuthenticationTypes();
            if (types != null && !types.isEmpty()) {
                TreeSet sorted = new TreeSet();
                sorted.addAll(types);
                for (String type : sorted) {
                    outputWriter.printlnMessage(type);
                }
            } else {
                outputWriter.printlnMessage(this.getResourceString("get-supported-no-supported-authtype"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_GET_SUPPORTED_AUTH_MODULES", params);
        }
        catch (AMConfigurationException e) {
            String[] args = new String[]{e.getMessage()};
            this.debugError("GetSupportedAuthModules.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_GET_SUPPORTED_AUTH_MODULES", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

