/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.realm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicyUtils;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import java.util.logging.Level;

public class RealmCreatePolicy
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String datafile = this.getStringOptionValue("xmlfile");
        IOutput outputWriter = this.getOutputWriter();
        CommandManager mgr = this.getCommandManager();
        String url = mgr.getWebEnabledURL();
        String[] params = new String[]{realm};
        this.writeLog(0, Level.INFO, "ATTEMPT_CREATE_POLICY_IN_REALM", params);
        try {
            PolicyManager pm = new PolicyManager(adminSSOToken, realm);
            if (url != null && url.length() > 0) {
                ByteArrayInputStream bis = new ByteArrayInputStream(datafile.getBytes());
                PolicyUtils.createPolicies(pm, bis);
            } else {
                FileInputStream fis = new FileInputStream(datafile);
                PolicyUtils.createPolicies(pm, fis);
            }
            this.writeLog(0, Level.INFO, "SUCCEED_CREATE_POLICY_IN_REALM", params);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("create-policy-in-realm-succeed"), params));
        }
        catch (PolicyException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmCreatePolicy.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_CREATE_POLICY_IN_REALM", args);
            throw new CLIException(e, 127);
        }
        catch (FileNotFoundException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmCreatePolicy.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_CREATE_POLICY_IN_REALM", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmCreatePolicy.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_CREATE_POLICY_IN_REALM", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

