/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso;

import com.sun.identity.entitlement.ResourceSaveIndexes;
import com.sun.identity.entitlement.ResourceSearchIndexes;
import com.sun.identity.entitlement.opensso.Cache;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexCache {
    private int size = 1000000;
    private Cache subjectIndexCache;
    private Cache hostIndexCache;
    private Cache pathIndexCache;
    private Cache parentPathIndexCache;
    private ReadWriteLock rwlock = new ReentrantReadWriteLock();

    public IndexCache(int size) {
        this.size = size;
        this.clearCaches();
    }

    public void cache(ResourceSaveIndexes indexes, Set<String> subjectIndexes, String dn) {
        if (subjectIndexes != null) {
            this.cache(dn, subjectIndexes, this.subjectIndexCache);
        }
        this.cache(dn, indexes.getHostIndexes(), this.hostIndexCache);
        this.cache(dn, indexes.getPathIndexes(), this.pathIndexCache);
        this.cache(dn, indexes.getParentPathIndexes(), this.parentPathIndexCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cache(String dn, Set<String> indexes, Cache cache) {
        this.rwlock.writeLock().lock();
        try {
            for (String s : indexes) {
                HashSet<String> setDNs = (HashSet<String>)cache.get(s);
                if (setDNs == null) {
                    setDNs = new HashSet<String>();
                    cache.put(s, setDNs);
                }
                setDNs.add(dn);
            }
        }
        finally {
            this.rwlock.writeLock().unlock();
        }
    }

    public void clear(ResourceSaveIndexes indexes, String dn) {
        if (indexes != null) {
            this.clear(dn, indexes.getHostIndexes(), this.hostIndexCache);
            this.clear(dn, indexes.getPathIndexes(), this.pathIndexCache);
            this.clear(dn, indexes.getParentPathIndexes(), this.parentPathIndexCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(String dn, Set<String> indexes, Cache cache) {
        this.rwlock.writeLock().lock();
        try {
            for (String s : indexes) {
                Set setDNs = (Set)cache.get(s);
                if (setDNs == null) continue;
                setDNs.remove(dn);
            }
        }
        finally {
            this.rwlock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void clearCaches() {
        this.rwlock.writeLock().lock();
        try {
            this.subjectIndexCache = new Cache(this.size);
            this.hostIndexCache = new Cache(this.size);
            this.pathIndexCache = new Cache(this.size);
            this.parentPathIndexCache = new Cache(this.size);
        }
        finally {
            this.rwlock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getMatchingEntries(ResourceSearchIndexes indexes, Set<String> subjectIndexes, boolean bSubTree) {
        this.rwlock.readLock().lock();
        try {
            boolean hasSubjectIndexes;
            HashSet<String> results = new HashSet<String>();
            boolean bl = hasSubjectIndexes = subjectIndexes != null && !subjectIndexes.isEmpty();
            if (hasSubjectIndexes) {
                for (String i : subjectIndexes) {
                    Set r = (Set)this.subjectIndexCache.get(i);
                    if (r == null) continue;
                    results.addAll(r);
                }
                results.retainAll(this.getHostIndexes(indexes));
            } else {
                results.addAll(this.getHostIndexes(indexes));
            }
            if (bSubTree) {
                results.retainAll(this.getPathParentIndexes(indexes));
            } else {
                results.retainAll(this.getPathIndexes(indexes));
            }
            HashSet<String> hashSet = results;
            return hashSet;
        }
        finally {
            this.rwlock.readLock().unlock();
        }
    }

    private Set<String> getPathParentIndexes(ResourceSearchIndexes indexes) {
        Set<String> parentPathIndexes = indexes.getParentPathIndexes();
        HashSet<String> results = new HashSet<String>();
        for (String i : parentPathIndexes) {
            Set r = (Set)this.parentPathIndexCache.get(i);
            if (r == null) continue;
            results.addAll(r);
        }
        return results;
    }

    private Set<String> getPathIndexes(ResourceSearchIndexes indexes) {
        Set<String> pathIndexes = indexes.getPathIndexes();
        HashSet<String> results = new HashSet<String>();
        for (String i : pathIndexes) {
            Set r = (Set)this.pathIndexCache.get(i);
            if (r == null) continue;
            results.addAll(r);
        }
        return results;
    }

    private Set<String> getHostIndexes(ResourceSearchIndexes indexes) {
        HashSet<String> results = new HashSet<String>();
        Set<String> hostIndexes = indexes.getHostIndexes();
        for (String i : hostIndexes) {
            Set r = (Set)this.hostIndexCache.get(i);
            if (r == null) continue;
            results.addAll(r);
        }
        return results;
    }
}

