/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.shared.debug.Debug;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class SimpleTimeCondition
implements Condition {
    public static final String REQUEST_TIME = "requestTime";
    private static final Debug DEBUG = Debug.getInstance((String)"amPolicy");
    private static final String DATE_FORMAT = "yyyy:MM:dd";
    private static final String[] DAYS_OF_WEEK = new String[]{"", "sun", "mon", "tue", "wed", "thu", "fri", "sat"};
    private Map properties;
    private int startTime = -1;
    private int startHour = -1;
    private int startMinute;
    private int endTime = -1;
    private int endHour = -1;
    private int endMinute;
    private int startDay = -1;
    private int endDay = -1;
    private int[] startDate = new int[]{-1, 0, 0};
    private int[] endDate = new int[]{-1, 0, 0};
    private TimeZone enforcementTimeZone;
    private static List propertyNames = new ArrayList(7);

    public List getPropertyNames() {
        return new ArrayList(propertyNames);
    }

    public Syntax getPropertySyntax(String property) {
        return Syntax.NONE;
    }

    public String getDisplayName(String property, Locale locale) throws PolicyException {
        return "";
    }

    public Set getValidValues(String property) throws PolicyException {
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map properties) throws PolicyException {
        this.properties = properties;
        this.startTime = -1;
        this.startHour = -1;
        this.endTime = -1;
        this.endHour = -1;
        this.startDay = -1;
        this.endDay = -1;
        this.startDate[0] = -1;
        this.endDate[0] = -1;
        this.validateProperties();
    }

    public Map getProperties() {
        return this.properties == null ? null : Collections.unmodifiableMap(this.properties);
    }

    private boolean validateProperties() throws PolicyException {
        if (this.properties == null || this.properties.keySet() == null) {
            throw new PolicyException("amPolicy", "properties_not_initialized", null, null);
        }
        Set keySet = this.properties.keySet();
        if (!(keySet.contains("StartTime") || keySet.contains("StartDay") || keySet.contains("StartDate") || keySet.contains(DAYS_OF_WEEK))) {
            Object[] args = new String[]{"StartDate,StartTime,StartDay"};
            throw new PolicyException("amPolicy", "at_least_one_of_the_properties_should_be_defined", args, null);
        }
        for (String key : keySet) {
            if ("StartTime".equals(key) || "StartDay".equals(key) || "StartDate".equals(key) || "EndTime".equals(key) || "EndDay".equals(key) || "EndDate".equals(key) || DAYS_OF_WEEK.equals(key) || "EnforcementTimeZone".equals(key)) continue;
            Object[] args = new String[]{key};
            throw new PolicyException("amPolicy", "attempt_to_set_invalid_property", args, null);
        }
        Set enforcementTimeZoneSet = (Set)this.properties.get("EnforcementTimeZone");
        if (enforcementTimeZoneSet != null && !enforcementTimeZoneSet.isEmpty()) {
            String enforcementTimeZoneString = (String)enforcementTimeZoneSet.iterator().next();
            this.enforcementTimeZone = TimeZone.getTimeZone(enforcementTimeZoneString);
        }
        Set startTimeSet = (Set)this.properties.get("StartTime");
        Set endTimeSet = (Set)this.properties.get("EndTime");
        if (startTimeSet != null && endTimeSet == null) {
            Object[] args = new String[]{"StartTime", "EndTime"};
            throw new PolicyException("amPolicy", "pair_property_not_defined", args, null);
        }
        if (startTimeSet == null && endTimeSet != null) {
            Object[] args = new String[]{"EndTime", "StartTime"};
            throw new PolicyException("amPolicy", "pair_property_not_defined", args, null);
        }
        if (startTimeSet != null) {
            this.validateTimes(startTimeSet, endTimeSet);
        }
        Set startDaySet = (Set)this.properties.get("StartDay");
        Set endDaySet = (Set)this.properties.get("EndDay");
        if (startDaySet != null && endDaySet == null) {
            Object[] args = new String[]{"StartDay", "EndDay"};
            throw new PolicyException("amPolicy", "pair_property_not_defined", args, null);
        }
        if (startDaySet == null && endDaySet != null) {
            Object[] args = new String[]{"EndDay", "StartDay"};
            throw new PolicyException("amPolicy", "pair_property_not_defined", args, null);
        }
        if (startDaySet != null) {
            this.validateDays(startDaySet, endDaySet);
        }
        Set startDateSet = (Set)this.properties.get("StartDate");
        Set endDateSet = (Set)this.properties.get("EndDate");
        if (startDateSet != null && endDateSet == null) {
            Object[] args = new String[]{"StartDate", "EndDate"};
            throw new PolicyException("amPolicy", "pair_property_not_defined", args, null);
        }
        if (startDateSet == null && endDateSet != null) {
            Object[] args = new String[]{"EndDate", "StartDate"};
            throw new PolicyException("amPolicy", "pair_property_not_defined", args, null);
        }
        if (startDateSet != null) {
            this.validateDates(startDateSet, endDateSet);
        }
        return true;
    }

    private boolean validateDays(Set startDaySet, Set endDaySet) throws PolicyException {
        if (startDaySet.size() != 1) {
            Object[] args = new String[]{"StartDay"};
            throw new PolicyException("amPolicy", "property_does_not_allow_multiple_values", args, null);
        }
        if (endDaySet.size() != 1) {
            Object[] args = new String[]{"EndDay"};
            throw new PolicyException("amPolicy", "property_does_not_allow_multiple_values", args, null);
        }
        String startDayString = (String)startDaySet.iterator().next();
        this.startDay = this.parseDayString(startDayString);
        String endDayString = (String)endDaySet.iterator().next();
        this.endDay = this.parseDayString(endDayString);
        return true;
    }

    private boolean validateDates(Set startDateSet, Set endDateSet) throws PolicyException {
        if (startDateSet.size() != 1) {
            Object[] args = new String[]{"StartDate"};
            throw new PolicyException("amPolicy", "property_does_not_allow_multiple_values", args, null);
        }
        if (endDateSet.size() != 1) {
            Object[] args = new String[]{"EndDate"};
            throw new PolicyException("amPolicy", "property_does_not_allow_multiple_values", args, null);
        }
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        df.setLenient(false);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        String startDateString = (String)startDateSet.iterator().next();
        String endDateString = (String)endDateSet.iterator().next();
        Date date1 = null;
        Date date2 = null;
        try {
            date1 = df.parse(startDateString);
        }
        catch (Exception e) {
            Object[] args = new String[]{"StartDate", startDateString};
            throw new PolicyException("amPolicy", "invalid_property_value", args, e);
        }
        try {
            date2 = df.parse(endDateString);
        }
        catch (Exception e) {
            Object[] args = new String[]{"EndDate", endDateString};
            throw new PolicyException("amPolicy", "invalid_property_value", args, e);
        }
        if (date1.getTime() > date2.getTime()) {
            throw new PolicyException("amPolicy", "start_date_can_not_be_larger_than_end_date", null, null);
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        cal.setTime(date1);
        this.startDate[0] = cal.get(1);
        this.startDate[1] = cal.get(2);
        this.startDate[2] = cal.get(5);
        cal.setTime(date2);
        this.endDate[0] = cal.get(1);
        this.endDate[1] = cal.get(2);
        this.endDate[2] = cal.get(5);
        return true;
    }

    private boolean validateTimes(Set startTimeSet, Set endTimeSet) throws PolicyException {
        if (startTimeSet.size() != 1) {
            Object[] args = new String[]{"StartTime"};
            throw new PolicyException("amPolicy", "property_does_not_allow_multiple_values", args, null);
        }
        if (endTimeSet.size() != 1) {
            Object[] args = new String[]{"EndTime"};
            throw new PolicyException("amPolicy", "property_does_not_allow_multiple_values", args, null);
        }
        String startTimeString = (String)startTimeSet.iterator().next();
        this.startTime = this.parseTimeString(startTimeString);
        this.startHour = this.startTime / 60;
        this.startMinute = this.startTime - this.startHour * 60;
        String endTimeString = (String)endTimeSet.iterator().next();
        this.endTime = this.parseTimeString(endTimeString);
        this.endHour = this.endTime / 60;
        this.endMinute = this.endTime - this.endHour * 60;
        return true;
    }

    int parseTimeString(String timeString) throws PolicyException {
        StringTokenizer st = new StringTokenizer(timeString, ":");
        if (st.countTokens() != 2) {
            Object[] args = new String[]{"time", timeString};
            throw new PolicyException("amPolicy", "invalid_property_value", args, null);
        }
        String token1 = st.nextToken();
        String token2 = st.nextToken();
        int hour = -1;
        int minute = -1;
        try {
            hour = Integer.parseInt(token1);
            minute = Integer.parseInt(token2);
        }
        catch (Exception e) {
            Object[] args = new String[]{"time", timeString};
            throw new PolicyException("amPolicy", "invalid_property_value", args, null);
        }
        if (hour < 0 || hour > 24 || minute < 0 || minute > 59) {
            Object[] args = new String[]{"time", timeString};
            throw new PolicyException("amPolicy", "invalid_property_value", args, null);
        }
        return hour * 60 + minute;
    }

    int parseDayString(String dayString) throws PolicyException {
        int day = -1;
        String dayStringLc = dayString.toLowerCase();
        for (int i = 1; i < 8; ++i) {
            if (!DAYS_OF_WEEK[i].equals(dayStringLc)) continue;
            day = i;
            break;
        }
        if (day == -1) {
            Object[] args = new String[]{"day", dayString};
            throw new PolicyException("amPolicy", "invalid_property_value", args, null);
        }
        return day;
    }

    public Object clone() {
        SimpleTimeCondition theClone = null;
        try {
            theClone = (SimpleTimeCondition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this.startDate != null) {
            theClone.startDate = new int[this.startDate.length];
            System.arraycopy(this.startDate, 0, theClone.startDate, 0, this.startDate.length);
        }
        if (this.endDate != null) {
            theClone.endDate = new int[this.endDate.length];
            System.arraycopy(this.endDate, 0, theClone.endDate, 0, this.endDate.length);
        }
        if (this.enforcementTimeZone != null) {
            theClone.enforcementTimeZone = (TimeZone)this.enforcementTimeZone.clone();
        }
        if (this.properties != null) {
            theClone.properties = new HashMap();
            for (Object o : this.properties.keySet()) {
                HashSet values = new HashSet();
                values.addAll((Set)this.properties.get(o));
                theClone.properties.put(o, values);
            }
        }
        return theClone;
    }

    private long[] getEffectiveRange(long currentGmt, TimeZone timeZone) {
        long rangeEnd;
        long rangeStart;
        long[] effectiveRange = new long[2];
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        calendar.setTime(new Date(currentGmt));
        long timeStart = Long.MIN_VALUE;
        if (this.startHour != -1) {
            calendar.set(11, this.startHour);
            calendar.set(12, this.startMinute);
            calendar.set(13, 0);
            calendar.set(14, 0);
            timeStart = calendar.getTime().getTime();
        }
        long timeEnd = Long.MAX_VALUE;
        if (this.endHour != -1) {
            calendar.set(11, this.endHour);
            calendar.set(12, this.endMinute);
            calendar.set(13, 0);
            calendar.set(14, 0);
            timeEnd = calendar.getTime().getTime();
        }
        if (timeEnd < timeStart) {
            GregorianCalendar cal = new GregorianCalendar(timeZone);
            if (currentGmt < timeStart) {
                cal.setTime(new Date(timeStart));
                ((Calendar)cal).roll(6, false);
                timeStart = cal.getTime().getTime();
            } else {
                cal.setTime(new Date(timeEnd));
                ((Calendar)cal).roll(6, true);
                timeEnd = cal.getTime().getTime();
            }
        }
        long dayStart = Long.MIN_VALUE;
        calendar.setTime(new Date(currentGmt));
        if (this.startDay != -1) {
            calendar.set(7, this.startDay);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            dayStart = calendar.getTime().getTime();
        }
        long dayEnd = Long.MAX_VALUE;
        if (this.endDay != -1) {
            calendar.set(7, this.endDay);
            calendar.set(11, 24);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            dayEnd = calendar.getTime().getTime();
        }
        if (dayEnd <= dayStart) {
            GregorianCalendar cal = new GregorianCalendar(timeZone);
            if (currentGmt < dayStart) {
                cal.setTime(new Date(dayStart));
                ((Calendar)cal).roll(3, false);
                dayStart = cal.getTime().getTime();
            } else {
                cal.setTime(new Date(dayEnd));
                ((Calendar)cal).roll(3, true);
                dayEnd = cal.getTime().getTime();
            }
        }
        long dateStart = Long.MIN_VALUE;
        if (this.startDate[0] != -1) {
            calendar.set(1, this.startDate[0]);
            calendar.set(2, this.startDate[1]);
            calendar.set(5, this.startDate[2]);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            dateStart = calendar.getTime().getTime();
        }
        long dateEnd = Long.MAX_VALUE;
        if (this.endDate[0] != -1) {
            calendar.set(1, this.endDate[0]);
            calendar.set(2, this.endDate[1]);
            calendar.set(5, this.endDate[2]);
            calendar.set(11, 24);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            dateEnd = calendar.getTime().getTime();
        }
        if (timeStart > (rangeStart = Long.MIN_VALUE)) {
            rangeStart = timeStart;
        }
        if (dayStart > rangeStart) {
            rangeStart = dayStart;
        }
        if (dateStart > rangeStart) {
            rangeStart = dateStart;
        }
        if (timeEnd < (rangeEnd = Long.MAX_VALUE)) {
            rangeEnd = timeEnd;
        }
        if (dayEnd < rangeEnd) {
            rangeEnd = dayEnd;
        }
        if (dateEnd < rangeEnd) {
            rangeEnd = dateEnd;
        }
        effectiveRange[0] = rangeStart;
        effectiveRange[1] = rangeEnd;
        return effectiveRange;
    }

    public ConditionDecision getConditionDecision(SSOToken token, Map env) throws PolicyException, SSOException {
        TimeZone timeZone;
        Long currentGmtLong;
        boolean allowed = false;
        long currentGmt = System.currentTimeMillis();
        if (env != null && (currentGmtLong = (Long)env.get(REQUEST_TIME)) != null) {
            currentGmt = currentGmtLong;
        }
        if ((timeZone = this.enforcementTimeZone) == null && env != null && (timeZone = (TimeZone)env.get("requestTimeZone")) == null) {
            timeZone = TimeZone.getDefault();
        }
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        long[] effectiveRange = this.getEffectiveRange(currentGmt, timeZone);
        if (DEBUG.messageEnabled()) {
            DEBUG.message("At SimpleTimeCondition.getConditionDecision(): effectiveRange = " + new Date(effectiveRange[0]) + "," + new Date(effectiveRange[1]));
        }
        long timeToLive = Long.MAX_VALUE;
        if (currentGmt >= effectiveRange[0] && currentGmt <= effectiveRange[1]) {
            allowed = true;
            timeToLive = effectiveRange[1];
        } else if (currentGmt < effectiveRange[0]) {
            timeToLive = effectiveRange[0];
        }
        return new ConditionDecision(allowed, timeToLive);
    }

    static {
        propertyNames.add("StartTime");
        propertyNames.add("EndTime");
        propertyNames.add("StartDay");
        propertyNames.add("EndDay");
        propertyNames.add("StartDate");
        propertyNames.add("EndDate");
        propertyNames.add("EnforcementTimeZone");
    }
}

