/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.components.view.html.SerializedField;
import com.sun.identity.console.dm.GroupPropertiesBase;
import com.sun.identity.console.dm.NewUserViewBean;
import com.sun.identity.console.dm.SearchGroupsViewBean;
import com.sun.identity.console.dm.SearchUsersViewBean;
import com.sun.identity.console.dm.model.GroupModel;
import com.sun.identity.console.dm.model.GroupModelImpl;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class GroupMembersViewBean
extends GroupPropertiesBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/dm/GroupMembers.jsp";
    protected static final String TF_FILTER = "tfFilter";
    protected static final String BTN_SEARCH = "btnSearch";
    protected static final String BTN_SHOW = "btnShowMenu";
    protected static final String PAGE_TITLE = "pgtitle";
    protected static final String TBL_SEARCH = "tblSearch";
    protected static final String TBL_COL_NAME = "tblColName";
    protected static final String TBL_TYPE_IMG = "tblTypeImg";
    protected static final String TBL_DATA_NAME = "tblDataName";
    protected static final String TBL_DATA_PATH = "tblDataPath";
    protected static final String TBL_COL_PATH = "tblColPath";
    protected static final String ACTION_MENU = "actionMenu";
    protected CCActionTableModel tblModel = null;
    private static final String SELECT_ACTION = "group.members.action.menu";
    private static final String SPACER = "group.members.action.spacer";
    private static final String ADD_USERS = "group.members.add.user";
    private static final String ADD_GROUPS = "group.members.add.group";
    private static final String CREATE_USER = "group.members.create.user";
    private static final String REMOVE_MEMBERS = "group.members.remove.member";
    private static final String DELETE_MEMBERS = "group.members.delete.member";
    private static final String GROUP_IMG = "<img width=16 height=16 src=\"../console/images/LrlGroup.gif\" />";
    private static final String USER_IMG = "<img width=16 height=16 src=\"../console/images/LrlUser.gif\" />";

    public GroupMembersViewBean() {
        super("GroupMembers");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.createPageTitleModel();
        this.createTableModel();
        this.registerChildren();
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PAGE_TITLE, CCPageTitle.class);
        this.registerChild(TBL_SEARCH, CCActionTable.class);
        this.registerChild(TF_FILTER, CCTextField.class);
        this.registerChild(BTN_SEARCH, CCButton.class);
        this.registerChild(BTN_SHOW, CCButton.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.tblModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        if (name.equals(TBL_SEARCH)) {
            SerializedField szCache = (SerializedField)this.getChild("szCache");
            this.populateTableModel((List)szCache.getSerializedObj());
            view = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tblModel, name);
        } else {
            view = name.equals(PAGE_TITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (this.tblModel.isChildSupported(name) ? this.tblModel.createChild((View)this, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name)));
        }
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.populateTableModel(this.getEntries());
        this.setMemberActions();
        this.setPageTitle("page.title.group.members");
    }

    protected AMModel getModelInternal() {
        RequestContext rc = RequestManager.getRequestContext();
        return new GroupModelImpl(rc.getRequest(), this.getPageSessionAttributes());
    }

    protected void setMemberActions() {
        GroupModel model = (GroupModel)this.getModel();
        OptionList actions = new OptionList();
        String groupName = (String)this.getPageSessionAttribute("CurrentProfileView");
        actions.add(model.getLocalizedString(SELECT_ACTION), "");
        if (!model.isDynamicGroup(groupName)) {
            actions.add(model.getLocalizedString(CREATE_USER), CREATE_USER);
            actions.add(model.getLocalizedString(SPACER), "");
            actions.add(model.getLocalizedString(ADD_USERS), ADD_USERS);
        }
        actions.add(model.getLocalizedString(ADD_GROUPS), ADD_GROUPS);
        actions.add(model.getLocalizedString(SPACER), "");
        actions.add(model.getLocalizedString(REMOVE_MEMBERS), REMOVE_MEMBERS);
        actions.add(model.getLocalizedString(DELETE_MEMBERS), DELETE_MEMBERS);
        CCDropDownMenu cb = (CCDropDownMenu)this.getChild(ACTION_MENU);
        cb.setOptions(actions);
    }

    protected Set getEntries() {
        Set members = Collections.EMPTY_SET;
        try {
            CCTextField tf = (CCTextField)this.getChild(TF_FILTER);
            String filter = (String)tf.getValue();
            if (filter == null || filter.length() == 0) {
                filter = "*";
            }
            String group = (String)this.getPageSessionAttribute("CurrentProfileView");
            GroupModel model = (GroupModel)this.getModel();
            members = model.getMembers(filter, group);
        }
        catch (AMConsoleException a) {
            debug.error("problem getting the members", (Throwable)a);
        }
        return members;
    }

    protected void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/oneBtnPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)this.getBackButtonLabel());
    }

    private void createTableModel() {
        this.tblModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblGroupMembers.xml"));
        this.tblModel.setTitleLabel("label.items");
        this.tblModel.setActionValue(TBL_COL_NAME, (Object)"name.column");
        this.tblModel.setActionValue(TBL_COL_PATH, (Object)"table.dm.path.column.name");
    }

    protected void populateTableModel(Collection members) {
        this.tblModel.clearAll();
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        GroupModel model = (GroupModel)this.getModel();
        this.tblModel.setMaxRows(model.getPageSize());
        if (members != null && !members.isEmpty()) {
            ArrayList<String> cache = new ArrayList<String>(members.size());
            boolean firstEntry = true;
            String groupName = (String)this.getPageSessionAttribute("CurrentProfileView");
            boolean dynamicGroupProfile = model.isDynamicGroup(groupName);
            int rowIdx = 0;
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    this.tblModel.appendRow();
                }
                String entry = (String)iter.next();
                if (model.isUser(entry)) {
                    if (dynamicGroupProfile) {
                        this.tblModel.setSelectionVisible(rowIdx, false);
                    }
                    this.tblModel.setValue(TBL_TYPE_IMG, (Object)USER_IMG);
                    this.tblModel.setValue(TBL_DATA_NAME, (Object)model.getUserDisplayValue(entry));
                } else {
                    this.tblModel.setValue(TBL_TYPE_IMG, (Object)GROUP_IMG);
                    this.tblModel.setValue(TBL_DATA_NAME, (Object)model.DNToName(entry, true));
                }
                this.tblModel.setValue(TBL_DATA_PATH, (Object)model.getDisplayPath(entry));
                cache.add(entry);
                ++rowIdx;
            }
            szCache.setValue(cache);
        } else {
            szCache.setValue(null);
        }
    }

    public void handleBtnShowMenuRequest(RequestInvocationEvent event) {
        String action = (String)this.getDisplayFieldValue(ACTION_MENU);
        this.setPageSessionAttribute("returnToViewBean", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
        if (action.equals(ADD_USERS)) {
            SearchUsersViewBean vb = (SearchUsersViewBean)this.getViewBean(SearchUsersViewBean.class);
            this.unlockPageTrail();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        } else if (action.equals(CREATE_USER)) {
            NewUserViewBean vb = (NewUserViewBean)this.getViewBean(NewUserViewBean.class);
            this.unlockPageTrail();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        } else if (action.equals(REMOVE_MEMBERS)) {
            this.removeMembers(true);
        } else if (action.equals(DELETE_MEMBERS)) {
            this.removeMembers(false);
        } else if (action.equals(ADD_GROUPS)) {
            SearchGroupsViewBean vb = (SearchGroupsViewBean)this.getViewBean(SearchGroupsViewBean.class);
            this.unlockPageTrail();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        } else {
            this.forwardTo();
        }
    }

    private void removeMembers(boolean remove) {
        GroupModel model = (GroupModel)this.getModel();
        try {
            CCActionTable table = (CCActionTable)this.getChild(TBL_SEARCH);
            table.restoreStateData();
        }
        catch (ModelControlException m) {
            debug.error("GroupMembersViewBean.removeMembers ", (Throwable)m);
        }
        Integer[] selected = this.tblModel.getSelectedRows();
        if (selected.length < 1) {
            this.setInlineAlertMessage("info", "message.information", model.getLocalizedString("no.entries.selected"));
        } else {
            SerializedField szCache = (SerializedField)this.getChild("szCache");
            List cache = (List)szCache.getSerializedObj();
            HashSet names = new HashSet(selected.length * 2);
            for (int i = 0; i < selected.length; ++i) {
                names.add(cache.get(selected[i]));
            }
            try {
                String group = (String)this.getPageSessionAttribute("CurrentProfileView");
                if (remove) {
                    model.removeMembers(group, names);
                } else {
                    model.deleteObject(names);
                }
                String message = "message.delete.entries";
                this.setInlineAlertMessage("info", "message.information", model.getLocalizedString(message));
            }
            catch (AMConsoleException a) {
                this.setInlineAlertMessage("error", "message.error", a.getMessage());
            }
        }
        this.forwardTo();
    }

    public void handleTblDataActionHrefRequest(RequestInvocationEvent event) throws ModelControlException {
        this.forwardTo();
    }

    public void handleButton1Request(RequestInvocationEvent event) {
        this.forwardToGroupView(event);
    }

    public void handleBtnSearchRequest(RequestInvocationEvent event) {
        this.forwardTo();
    }
}

