/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.ChoiceValues;
import com.sun.identity.sm.SMSEntry;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ConfiguredIdentityTypes
extends ChoiceValues {
    AMIdentityRepository amIdRepo = null;
    private static Hashtable choiceValues = new Hashtable();

    public Map getChoiceValues() {
        return this.getChoiceValues(Collections.EMPTY_MAP);
    }

    public Map getChoiceValues(Map envParams) {
        Map<String, String> answer = new HashMap<String, String>();
        String orgDN = null;
        String installTime = SystemProperties.get("installTime");
        if (installTime != null && installTime.equals("true")) {
            answer.put(IdType.USER.getName(), IdType.USER.getName());
            answer.put(IdType.AGENT.getName(), IdType.AGENT.getName());
            return answer;
        }
        if (envParams != null) {
            orgDN = (String)envParams.get("organization_name");
        }
        if (orgDN == null || orgDN.length() == 0) {
            orgDN = SMSEntry.getRootSuffix();
        }
        if (choiceValues != null && !choiceValues.isEmpty() && (answer = (Map)choiceValues.get(orgDN)) != null && !answer.isEmpty()) {
            return answer;
        }
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        Set idTypes = Collections.EMPTY_SET;
        try {
            this.amIdRepo = new AMIdentityRepository(adminToken, orgDN);
            idTypes = this.amIdRepo.getSupportedIdTypes();
        }
        catch (IdRepoException e) {
        }
        catch (SSOException sso) {
            // empty catch block
        }
        if (idTypes != null && !idTypes.isEmpty()) {
            Iterator idTypeIterator = idTypes.iterator();
            String strIdType = null;
            if (answer == null) {
                answer = new HashMap(idTypes.size() * 2);
            }
            while (idTypeIterator.hasNext()) {
                strIdType = ((IdType)idTypeIterator.next()).getName();
                answer.put(strIdType, strIdType);
            }
        } else {
            answer.put(IdType.USER.getName(), IdType.USER.getName());
            answer.put(IdType.AGENT.getName(), IdType.AGENT.getName());
        }
        choiceValues.put(orgDN, answer);
        return answer;
    }
}

