/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.server;

import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.common.DNUtils;
import com.sun.identity.common.ShutdownListener;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.delegation.DelegationEvaluator;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationManager;
import com.sun.identity.delegation.DelegationPermission;
import com.sun.identity.delegation.DelegationPrivilege;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepo;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdRepoFatalException;
import com.sun.identity.idm.IdRepoUnsupportedOpException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdServices;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.idm.RepoSearchResults;
import com.sun.identity.idm.common.IdRepoUtils;
import com.sun.identity.idm.plugins.internal.SpecialRepo;
import com.sun.identity.idm.server.IdRepoPluginsCache;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.datastruct.OrderedSet;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;

public class IdServicesImpl
implements IdServices {
    private static final String DELEGATION_ATTRS_NAME = "attributes";
    protected static Debug debug = Debug.getInstance((String)"amIdm");
    protected Set specialIdentityNames;
    protected IdSearchResults specialIdentities;
    protected IdSearchResults emptyUserIdentities = new IdSearchResults(IdType.USER, "");
    private IdRepoPluginsCache idrepoCache = new IdRepoPluginsCache();
    protected static volatile boolean shutdownCalled;
    private static HashSet READ_ACTION;
    private static HashSet WRITE_ACTION;
    private static IdServices _instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized IdServices getInstance() {
        if (_instance == null) {
            IdServicesImpl.getDebug().message("IdServicesImpl.getInstance(): Creating new Instance of IdServicesImpl()");
            ShutdownManager shutdownMan = ShutdownManager.getInstance();
            if (shutdownMan.acquireValidLock()) {
                try {
                    _instance = new IdServicesImpl();
                    shutdownMan.addShutdownListener(new ShutdownListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void shutdown() {
                            IdServices idServices = _instance;
                            synchronized (idServices) {
                                shutdownCalled = true;
                            }
                            _instance.clearIdRepoPlugins();
                        }
                    });
                }
                finally {
                    shutdownMan.releaseLockAndNotify();
                }
            }
        }
        return _instance;
    }

    protected IdServicesImpl() {
    }

    protected static Debug getDebug() {
        return debug;
    }

    public void reinitialize() {
        this.idrepoCache.initializeListeners();
    }

    public static boolean isShutdownCalled() {
        return shutdownCalled;
    }

    public Set getFullyQualifiedNames(SSOToken token, IdType type, String name, String orgName) throws IdRepoException, SSOException {
        if (IdServicesImpl.getDebug().messageEnabled()) {
            IdServicesImpl.getDebug().message("IdServicesImpl::getFullyQualifiedNames called for type: " + type + " name: " + name + " org: " + orgName);
        }
        Set repos = this.idrepoCache.getIdRepoPlugins(orgName, IdOperation.READ, type);
        CaseInsensitiveHashSet answer = new CaseInsensitiveHashSet();
        if (this.isSpecialIdentity(token, name, type, orgName)) {
            for (IdRepo idRepo : repos) {
                if (!idRepo.getClass().getName().equals("com.sun.identity.idm.plugins.internal.SpecialRepo")) continue;
                answer.add(idRepo.getFullyQualifiedName(token, type, name));
            }
            return answer;
        }
        IdRepoException firstException = null;
        if (repos != null && !repos.isEmpty()) {
            for (IdRepo idRepo : repos) {
                if (idRepo.getClass().getName().equals("com.sun.identity.idm.plugins.internal.SpecialRepo")) continue;
                try {
                    String fqn = idRepo.getFullyQualifiedName(token, type, name);
                    if (fqn == null) continue;
                    answer.add(fqn);
                }
                catch (IdRepoException ide) {
                    if (firstException != null) continue;
                    firstException = ide;
                }
            }
        }
        if (firstException != null && answer.isEmpty()) {
            throw firstException;
        }
        return answer;
    }

    public boolean authenticate(String orgName, Callback[] credentials) throws IdRepoException, AuthLoginException {
        if (IdServicesImpl.getDebug().messageEnabled()) {
            IdServicesImpl.getDebug().message("IdServicesImpl.authenticate: called for org: " + orgName);
        }
        IdRepoException firstException = null;
        AuthLoginException authException = null;
        Set cPlugins = null;
        try {
            cPlugins = this.idrepoCache.getIdRepoPlugins(orgName);
        }
        catch (SSOException ex) {
            if (IdServicesImpl.getDebug().messageEnabled()) {
                IdServicesImpl.getDebug().message("IdServicesImpl.authenticate: Error obtaining IdRepo plugins for the org: " + orgName);
            }
            return false;
        }
        String name = null;
        for (int i = 0; i < credentials.length; ++i) {
            if (!(credentials[i] instanceof NameCallback)) continue;
            name = ((NameCallback)credentials[i]).getName();
            if (!DN.isDN((String)name)) break;
            name = LDAPDN.explodeDN((String)name, (boolean)true)[0];
            break;
        }
        SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            if (name != null && this.isSpecialIdentity(token, name, IdType.USER, orgName)) {
                for (IdRepo idRepo : cPlugins) {
                    if (!idRepo.getClass().getName().equals("com.sun.identity.idm.plugins.internal.SpecialRepo")) continue;
                    if (idRepo.authenticate(credentials)) {
                        if (debug.messageEnabled()) {
                            debug.message("IdServicesImpl.authenticate: AuthN success using special repo " + idRepo.getClass().getName() + " user: " + name);
                        }
                        return true;
                    }
                    debug.error("IdServicesImpl.authenticate: AuthN failed using special repo " + idRepo.getClass().getName() + " user: " + name);
                    return false;
                }
            }
        }
        catch (SSOException ssoe) {
            debug.error("IdServicesImpl.authenticate: AuthN failed checking for special users", (Throwable)((Object)ssoe));
            return false;
        }
        for (IdRepo idRepo : cPlugins) {
            if (idRepo.supportsAuthentication()) {
                if (IdServicesImpl.getDebug().messageEnabled()) {
                    IdServicesImpl.getDebug().message("IdServicesImpl.authenticate: AuthN to " + idRepo.getClass().getName() + " in org: " + orgName);
                }
                try {
                    if (!idRepo.authenticate(credentials)) continue;
                    if (IdServicesImpl.getDebug().messageEnabled()) {
                        IdServicesImpl.getDebug().message("IdServicesImpl.authenticate: AuthN success for " + idRepo.getClass().getName());
                    }
                    return true;
                }
                catch (IdRepoException ide) {
                    if (firstException != null) continue;
                    firstException = ide;
                    continue;
                }
                catch (AuthLoginException authex) {
                    if (authException != null) continue;
                    authException = authex;
                    continue;
                }
            }
            if (!IdServicesImpl.getDebug().messageEnabled()) continue;
            IdServicesImpl.getDebug().message("IdServicesImpl.authenticate: AuthN not supported by " + idRepo.getClass().getName());
        }
        if (authException != null) {
            throw authException;
        }
        if (firstException != null) {
            throw firstException;
        }
        return false;
    }

    private AMIdentity getRealmIdentity(SSOToken token, String orgDN) throws IdRepoException {
        String universalId = "id=ContainerDefaultTemplateRole,ou=realm," + orgDN;
        return IdUtils.getIdentity(token, universalId);
    }

    private AMIdentity getSubRealmIdentity(SSOToken token, String subRealmName, String parentRealmName) throws IdRepoException, SSOException {
        String realmName = parentRealmName;
        if (DN.isDN((String)parentRealmName)) {
            realmName = DNMapper.orgNameToRealmName(parentRealmName);
        }
        String fullRealmName = realmName + "/" + subRealmName;
        String subOrganizationDN = DNMapper.orgNameToDN(fullRealmName);
        return this.getRealmIdentity(token, subOrganizationDN);
    }

    private AMIdentity createRealmIdentity(SSOToken token, IdType type, String name, Map attrMap, String orgName) throws IdRepoException, SSOException {
        try {
            OrganizationConfigManager orgMgr = new OrganizationConfigManager(token, orgName);
            HashMap<String, Map> serviceAttrsMap = new HashMap<String, Map>();
            serviceAttrsMap.put("sunIdentityRepositoryService", attrMap);
            orgMgr.createSubOrganization(name, serviceAttrsMap);
            return this.getSubRealmIdentity(token, name, orgName);
        }
        catch (SMSException sme) {
            debug.error("AMIdentityRepository.createIdentity() - Error occurred while creating " + type.getName() + ":" + name, (Throwable)sme);
            throw new IdRepoException(sme.getMessage());
        }
    }

    public AMIdentity create(SSOToken token, IdType type, String name, Map attrMap, String amOrgName) throws IdRepoException, SSOException {
        if (type.equals(IdType.REALM)) {
            return this.createRealmIdentity(token, type, name, attrMap, amOrgName);
        }
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, attrMap.keySet(), IdOperation.CREATE, type);
        String amsdkdn = null;
        Set configuredPluginClasses = this.idrepoCache.getIdRepoPlugins(amOrgName, IdOperation.CREATE, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            try {
                Map cMap = idRepo.getConfiguration();
                attrMap = this.mapAttributeNames(attrMap, cMap);
                String representation = idRepo.create(token, type, name, attrMap);
                if (!idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo")) continue;
                amsdkdn = representation;
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.create: Unable to create identity in the following repository " + idRepo.getClass().getName() + ":: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.create: Create: Fatal Exception", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.create: Unable to create identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
        }
        AMIdentity id = new AMIdentity(token, name, type, amOrgName, amsdkdn);
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.create: Unable to create identity " + type.getName() + " :: " + name + " in any of the configured data stores", (Throwable)origEx);
            }
            throw origEx;
        }
        return id;
    }

    private void deleteRealmIdentity(SSOToken token, String realmName, String orgDN) throws IdRepoException {
        try {
            String parentRealmName = DNMapper.orgNameToRealmName(orgDN);
            OrganizationConfigManager orgMgr = new OrganizationConfigManager(token, parentRealmName);
            orgMgr.deleteSubOrganization(realmName, true);
        }
        catch (SMSException sme) {
            throw new IdRepoException(sme.getMessage());
        }
    }

    public void delete(SSOToken token, IdType type, String name, String orgName, String amsdkDN) throws IdRepoException, SSOException {
        if (type.equals(IdType.REALM)) {
            this.deleteRealmIdentity(token, name, orgName);
            return;
        }
        IdRepoException origEx = null;
        this.checkPermission(token, orgName, name, null, IdOperation.DELETE, type);
        Set configuredPluginClasses = this.idrepoCache.getIdRepoPlugins(orgName, IdOperation.DELETE, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            try {
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null) {
                    idRepo.delete(token, type, amsdkDN);
                    continue;
                }
                idRepo.delete(token, type, name);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.delete: Unable to delete identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.delete: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.delete: Unable to delete identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                if (ide.getErrorCode().equalsIgnoreCase("220") && origEx != null) continue;
                origEx = ide;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.delete: Unable to delete identity " + type.getName() + " :: " + name + " in any of the configured data stores", (Throwable)origEx);
            }
            throw origEx;
        }
        this.removeIdentityFromPrivileges(name, type, amsdkDN, orgName);
    }

    private void removeIdentityFromPrivileges(String name, IdType type, String amsdkDN, String orgName) {
        SSOToken superAdminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        AMIdentity id = new AMIdentity(superAdminToken, name, type, orgName, amsdkDN);
        String uid = id.getUniversalId();
        try {
            DelegationManager mgr = new DelegationManager(superAdminToken, orgName);
            Set privilegeObjects = mgr.getPrivileges();
            for (DelegationPrivilege p : privilegeObjects) {
                Set subjects = p.getSubjects();
                if (!subjects.contains(uid)) continue;
                subjects.remove(uid);
                mgr.addPrivilege(p);
            }
        }
        catch (SSOException ex) {
            debug.warning("IdServicesImpl.removeIdentityFromPrivileges", (Throwable)((Object)ex));
        }
        catch (DelegationException ex) {
            debug.warning("IdServicesImpl.removeIdentityFromPrivileges", (Throwable)ex);
        }
    }

    public Map getAttributes(SSOToken token, IdType type, String name, Set attrNames, String amOrgName, String amsdkDN, boolean isString) throws IdRepoException, SSOException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, attrNames, IdOperation.READ, type);
        Set configuredPluginClasses = this.idrepoCache.getIdRepoPlugins(amOrgName, IdOperation.READ, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        HashSet<Map> attrMapsSet = new HashSet<Map>();
        if (this.isSpecialIdentity(token, name, type, amOrgName)) {
            try {
                for (IdRepo idRepo : configuredPluginClasses) {
                    if (!idRepo.getClass().getName().equals("com.sun.identity.idm.plugins.internal.SpecialRepo")) continue;
                    attrMapsSet.add(idRepo.getAttributes(token, type, name, attrNames));
                    return this.combineAttrMaps(attrMapsSet, true);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            try {
                Map cMap = idRepo.getConfiguration();
                attrNames = this.mapAttributeNames(attrNames, cMap);
                Map aMap = null;
                aMap = idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null ? (isString ? idRepo.getAttributes(token, type, amsdkDN, attrNames) : idRepo.getBinaryAttributes(token, type, amsdkDN, attrNames)) : (isString ? idRepo.getAttributes(token, type, name, attrNames) : idRepo.getBinaryAttributes(token, type, name, attrNames));
                aMap = this.reverseMapAttributeNames(aMap, cMap);
                attrMapsSet.add(aMap);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getAttributes: Unable to read identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("GetAttributes: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getAttributes: Unable to read identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("idServicesImpl.getAttributes: Unable to get attributes for identity " + type.getName() + ", " + name + " in any configured data store", (Throwable)origEx);
            }
            throw origEx;
        }
        return this.combineAttrMaps(attrMapsSet, isString);
    }

    public Map getAttributes(SSOToken token, IdType type, String name, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, null, IdOperation.READ, type);
        Set configuredPluginClasses = this.idrepoCache.getIdRepoPlugins(amOrgName, IdOperation.READ, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        HashSet<Map> attrMapsSet = new HashSet<Map>();
        if (this.isSpecialIdentity(token, name, type, amOrgName)) {
            try {
                for (IdRepo idRepo : configuredPluginClasses) {
                    if (!idRepo.getClass().getName().equals("com.sun.identity.idm.plugins.internal.SpecialRepo")) continue;
                    attrMapsSet.add(idRepo.getAttributes(token, type, name));
                    return this.combineAttrMaps(attrMapsSet, true);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            try {
                Map cMap = idRepo.getConfiguration();
                Map aMap = null;
                aMap = idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null ? idRepo.getAttributes(token, type, amsdkDN) : idRepo.getAttributes(token, type, name);
                if (IdServicesImpl.getDebug().messageEnabled()) {
                    IdServicesImpl.getDebug().message("IdServicesImpl.getAttributes: before reverseMapAttributeNames aMap=" + IdRepoUtils.getAttrMapWithoutPasswordAttrs(aMap, null));
                }
                aMap = this.reverseMapAttributeNames(aMap, cMap);
                attrMapsSet.add(aMap);
                if (!IdServicesImpl.getDebug().messageEnabled()) continue;
                for (Map attrMap : attrMapsSet) {
                    IdServicesImpl.getDebug().message("IdServicesImpl.getAttributes: after before reverseMapAttributeNames attrMapsSet=" + IdRepoUtils.getAttrMapWithoutPasswordAttrs(attrMap, null));
                }
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getAttributes: Unable to read identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.getAttributes: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getAttributes: Unable to read identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.getAttributes: Unable to get attributes for identity " + type.getName() + "::" + name + " in any configured data store", (Throwable)origEx);
            }
            throw origEx;
        }
        Map returnMap = this.combineAttrMaps(attrMapsSet, true);
        IdServicesImpl.getDebug().warning("IdServicesImpl.getAttributes exit: returnMap=" + IdRepoUtils.getAttrMapWithoutPasswordAttrs(returnMap, null));
        return returnMap;
    }

    public Set getMembers(SSOToken token, IdType type, String name, String amOrgName, IdType membersType, String amsdkDN) throws IdRepoException, SSOException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, null, IdOperation.READ, type);
        Set configuredPluginClasses = this.idrepoCache.getIdRepoPlugins(amOrgName, IdOperation.READ, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        HashSet<Set> membersSet = new HashSet<Set>();
        HashSet amsdkMembers = new HashSet();
        boolean amsdkIncluded = false;
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            if (!idRepo.getSupportedTypes().contains(membersType) || idRepo.getClass().getName().equals("com.sun.identity.idm.plugins.internal.SpecialRepo")) {
                --noOfSuccess;
                continue;
            }
            try {
                Set members;
                boolean isAMSDK = idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo");
                Set set = members = isAMSDK && amsdkDN != null ? idRepo.getMembers(token, type, amsdkDN, membersType) : idRepo.getMembers(token, type, name, membersType);
                if (isAMSDK) {
                    amsdkMembers.addAll(members);
                    amsdkIncluded = true;
                    continue;
                }
                membersSet.add(members);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getMembers: Unable to read identity members in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.getMembers: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getMembers: Unable to read identity members in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.getMembers: Unable to get members for identity " + type.getName() + "::" + name + " in any configured data store", origEx);
            }
            if (origEx != null) {
                throw origEx;
            }
            return Collections.EMPTY_SET;
        }
        Set results = this.combineMembers(token, membersSet, membersType, amOrgName, amsdkIncluded, amsdkMembers);
        return results;
    }

    public Set getMemberships(SSOToken token, IdType type, String name, IdType membershipType, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, null, IdOperation.READ, type);
        Set configuredPluginClasses = this.idrepoCache.getIdRepoPlugins(amOrgName, IdOperation.READ, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        if (this.isSpecialIdentity(token, name, type, amOrgName)) {
            try {
                for (IdRepo idRepo : configuredPluginClasses) {
                    if (!idRepo.getClass().getName().equals("com.sun.identity.idm.plugins.internal.SpecialRepo")) continue;
                    return idRepo.getMemberships(token, type, name, membershipType);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        HashSet<Set> membershipsSet = new HashSet<Set>();
        HashSet amsdkMemberShips = new HashSet();
        boolean amsdkIncluded = false;
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            if (!idRepo.getSupportedTypes().contains(membershipType) || idRepo.getClass().getName().equals("com.sun.identity.idm.plugins.internal.SpecialRepo")) {
                --noOfSuccess;
                continue;
            }
            try {
                Set members;
                boolean isAMSDK = idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo");
                Set set = members = isAMSDK && amsdkDN != null ? idRepo.getMemberships(token, type, amsdkDN, membershipType) : idRepo.getMemberships(token, type, name, membershipType);
                if (isAMSDK) {
                    amsdkMemberShips.addAll(members);
                    amsdkIncluded = true;
                    continue;
                }
                membershipsSet.add(members);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getMemberships: Unable to get memberships in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.getMemberships: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getMemberships: Unable to read identity in the following repository " + idRepo.getClass().getName(), (Throwable)ide);
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.getMemberships: Unable to get members for identity " + type.getName() + "::" + name + " in any configured data store", origEx);
            }
            if (origEx != null) {
                throw origEx;
            }
            return Collections.EMPTY_SET;
        }
        Set results = this.combineMembers(token, membershipsSet, membershipType, amOrgName, amsdkIncluded, amsdkMemberShips);
        return results;
    }

    public boolean isExists(SSOToken token, IdType type, String name, String amOrgName) throws SSOException, IdRepoException {
        this.checkPermission(token, amOrgName, name, null, IdOperation.READ, type);
        Set configuredPluginClasses = this.idrepoCache.getIdRepoPlugins(amOrgName, IdOperation.READ, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        if (this.isSpecialIdentity(token, name, type, amOrgName)) {
            try {
                for (IdRepo idRepo : configuredPluginClasses) {
                    if (!idRepo.getClass().getName().equals("com.sun.identity.idm.plugins.internal.SpecialRepo")) continue;
                    return idRepo.isExists(token, type, name);
                }
            }
            catch (Exception idm) {
                // empty catch block
            }
        }
        Iterator it = configuredPluginClasses.iterator();
        boolean exists = false;
        try {
            IdRepo idRepo;
            while (it.hasNext() && !(exists = (idRepo = (IdRepo)it.next()).isExists(token, type, name))) {
            }
        }
        catch (Exception idm) {
            // empty catch block
        }
        return exists;
    }

    public boolean isActive(SSOToken token, IdType type, String name, String amOrgName, String amsdkDN) throws SSOException, IdRepoException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, null, IdOperation.READ, type);
        Set configuredPluginClasses = this.idrepoCache.getIdRepoPlugins(amOrgName, IdOperation.READ, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        if (this.isSpecialIdentity(token, name, type, amOrgName)) {
            try {
                for (IdRepo idRepo : configuredPluginClasses) {
                    if (!idRepo.getClass().getName().equals("com.sun.identity.idm.plugins.internal.SpecialRepo")) continue;
                    return idRepo.isActive(token, type, name);
                }
            }
            catch (Exception idm) {
                // empty catch block
            }
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        boolean active = false;
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            try {
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null) {
                    active = idRepo.isActive(token, type, amsdkDN);
                } else {
                    if (idRepo.getClass().getName().equals("com.sun.identity.idm.plugins.internal.SpecialRepo")) {
                        --noOfSuccess;
                        continue;
                    }
                    active = idRepo.isActive(token, type, name);
                }
                if (!active) continue;
                break;
            }
            catch (IdRepoFatalException idf) {
                debug.error("IdServicesImpl.isActive: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    debug.warning("IdServicesImpl.isActive: Unable to check isActive identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.isActive: Unable to check if identity is active " + type.getName() + "::" + name + " in any configured data store", (Throwable)origEx);
            }
            if (origEx != null) {
                throw origEx;
            }
            Object[] args = new Object[]{"isActive", IdOperation.READ.getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
        }
        return active;
    }

    public void setActiveStatus(SSOToken token, IdType type, String name, String amOrgName, String amsdkDN, boolean active) throws SSOException, IdRepoException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, null, IdOperation.EDIT, type);
        Set configuredPluginClasses = this.idrepoCache.getIdRepoPlugins(amOrgName, IdOperation.EDIT, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            try {
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null) {
                    idRepo.setActiveStatus(token, type, amsdkDN, active);
                    continue;
                }
                idRepo.setActiveStatus(token, type, name, active);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl:setActiveStatus: Unable to set attributes in the following repository" + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IsActive: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to setActiveStatus in the following repository" + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                if (ide.getErrorCode().equalsIgnoreCase("220") && origEx != null) continue;
                origEx = ide;
            }
        }
        if (noOfSuccess == 0) {
            IdServicesImpl.getDebug().error("Unable to setActiveStatus for identity " + type.getName() + "::" + name + " in any configured " + "datastore", (Throwable)origEx);
            throw origEx;
        }
    }

    private void validateMembers(SSOToken token, Set members, IdType type, String amOrgName) throws IdRepoException, SSOException {
        for (String name : members) {
            if (this.isExists(token, type, name, amOrgName)) continue;
            Object[] args = new Object[]{name, type.getName()};
            throw new IdRepoException("amIdRepo", "223", args);
        }
    }

    public void modifyMemberShip(SSOToken token, IdType type, String name, Set members, IdType membersType, int operation, String amOrgName) throws IdRepoException, SSOException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, null, IdOperation.EDIT, type);
        Set configuredPluginClasses = this.idrepoCache.getIdRepoPlugins(amOrgName, IdOperation.EDIT, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        if (!this.isExists(token, type, name, amOrgName)) {
            Object[] args = new Object[]{name, type.getName()};
            throw new IdRepoException("amIdRepo", "223", args);
        }
        this.validateMembers(token, members, membersType, amOrgName);
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            if (!idRepo.getSupportedTypes().contains(membersType) || idRepo.getClass().getName().equals("com.sun.identity.idm.plugins.internal.SpecialRepo")) {
                --noOfSuccess;
                continue;
            }
            try {
                idRepo.modifyMemberShip(token, type, name, members, membersType, operation);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.modifyMembership: Unable to modify memberships  in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.modifyMembership: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().error("IdServicesImpl.modifyMembership: Unable to modify memberships in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.modifyMemberShip: Unable to modify members for identity " + type.getName() + "::" + name + " in any configured data store", origEx);
            }
            if (origEx != null) {
                throw origEx;
            }
            Object[] args = new Object[]{"modifyMemberShip", IdOperation.EDIT.getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
        }
    }

    public void removeAttributes(SSOToken token, IdType type, String name, Set attrNames, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, attrNames, IdOperation.EDIT, type);
        Set configuredPluginClasses = this.idrepoCache.getIdRepoPlugins(amOrgName, IdOperation.EDIT, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            try {
                Map cMap = idRepo.getConfiguration();
                attrNames = this.mapAttributeNames(attrNames, cMap);
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null) {
                    idRepo.removeAttributes(token, type, amsdkDN, attrNames);
                    continue;
                }
                idRepo.removeAttributes(token, type, name, attrNames);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.removeAttributes: Unable to modify identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
            catch (IdRepoFatalException idf) {
                debug.error("IdServicesImpl.removeAttributes: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.removeAttributes: Unable to remove attributes in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                if (ide.getErrorCode().equalsIgnoreCase("220") && origEx != null) continue;
                origEx = ide;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.removeAttributes: Unable to remove attributes  for identity " + type.getName() + "::" + name + " in any configured data store", (Throwable)origEx);
            }
            throw origEx;
        }
    }

    public IdSearchResults search(SSOToken token, IdType type, String pattern, IdSearchControl ctrl, String amOrgName) throws IdRepoException, SSOException {
        IdRepoException origEx = null;
        boolean checkPermissionOnObjects = false;
        SSOToken userToken = token;
        try {
            this.checkPermission(token, amOrgName, null, null, IdOperation.READ, type);
        }
        catch (IdRepoException ire) {
            Map filter = ctrl.getSearchModifierMap();
            if (!ire.getErrorCode().equals("402") || filter == null || filter.isEmpty()) {
                throw ire;
            }
            checkPermissionOnObjects = true;
            token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        Set configuredPluginClasses = this.idrepoCache.getIdRepoPlugins(amOrgName, IdOperation.READ, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        Object[][] amsdkResults = new Object[1][2];
        boolean amsdkIncluded = false;
        Object[][] arrayOfResult = new Object[noOfSuccess][2];
        int iterNo = 0;
        int maxTime = ctrl.getTimeOut();
        int maxResults = ctrl.getMaxResults();
        Set returnAttrs = ctrl.getReturnAttributes();
        boolean returnAllAttrs = ctrl.isGetAllReturnAttributesEnabled();
        IdSearchOpModifier modifier = ctrl.getSearchModifier();
        int filterOp = -1;
        if (modifier.equals(IdSearchOpModifier.AND)) {
            filterOp = 1;
        } else if (modifier.equals(IdSearchOpModifier.OR)) {
            filterOp = 0;
        }
        Map avPairs = ctrl.getSearchModifierMap();
        boolean recursive = ctrl.isRecursive();
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            try {
                Map cMap = idRepo.getConfiguration();
                RepoSearchResults results = idRepo.search(token, type, pattern, maxTime, maxResults, returnAttrs, returnAllAttrs, filterOp, avPairs, recursive);
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo")) {
                    amsdkResults[0][0] = results;
                    amsdkResults[0][1] = cMap;
                    amsdkIncluded = true;
                    continue;
                }
                arrayOfResult[iterNo][0] = results;
                arrayOfResult[iterNo][1] = cMap;
                ++iterNo;
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.search: Unable to search in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.search: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.search: Unable to search identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.search: Unable to search for identity " + type.getName() + "::" + pattern + " in any configured data store", (Throwable)origEx);
            }
            throw origEx;
        }
        IdSearchResults res = this.combineSearchResults(token, arrayOfResult, iterNo, type, amOrgName, amsdkIncluded, amsdkResults);
        if (checkPermissionOnObjects) {
            IdSearchResults newRes = new IdSearchResults(type, amOrgName);
            Map idWithAttrs = res.getResultAttributes();
            for (AMIdentity id : idWithAttrs.keySet()) {
                try {
                    this.checkPermission(userToken, amOrgName, id.getName(), returnAttrs, IdOperation.READ, type);
                    newRes.addResult(id, (Map)idWithAttrs.get(id));
                }
                catch (Exception e) {}
            }
            res = newRes;
        }
        return res;
    }

    public IdSearchResults getSpecialIdentities(SSOToken token, IdType type, String orgName) throws IdRepoException, SSOException {
        OrderedSet pluginClasses = new OrderedSet();
        if (ServiceManager.isConfigMigratedTo70() && ServiceManager.getBaseDN().equalsIgnoreCase(orgName)) {
            if (this.specialIdentities != null) {
                return this.specialIdentities;
            }
            Set repos = this.idrepoCache.getIdRepoPlugins(orgName);
            for (IdRepo repo : repos) {
                if (!(repo instanceof SpecialRepo)) continue;
                pluginClasses.add(repo);
            }
        }
        if (pluginClasses.isEmpty()) {
            return this.emptyUserIdentities;
        }
        IdRepo specialRepo = (IdRepo)pluginClasses.iterator().next();
        RepoSearchResults res = specialRepo.search(token, type, "*", 0, 0, Collections.EMPTY_SET, false, 0, Collections.EMPTY_MAP, false);
        Object[][] obj = new Object[1][2];
        obj[0][0] = res;
        obj[0][1] = Collections.EMPTY_MAP;
        this.specialIdentities = this.combineSearchResults(token, obj, 1, type, orgName, false, null);
        return this.specialIdentities;
    }

    protected boolean isSpecialIdentity(SSOToken token, String name, IdType type, String orgName) throws IdRepoException, SSOException {
        if (ServiceManager.isConfigMigratedTo70() && ServiceManager.getBaseDN().equalsIgnoreCase(orgName) && type.equals(IdType.USER)) {
            if (this.specialIdentityNames == null) {
                CaseInsensitiveHashSet spIds = new CaseInsensitiveHashSet();
                Set repos = this.idrepoCache.getIdRepoPlugins(orgName);
                for (IdRepo repo : repos) {
                    if (!(repo instanceof SpecialRepo)) continue;
                    RepoSearchResults res = repo.search(token, type, "*", 0, 0, Collections.EMPTY_SET, false, 0, Collections.EMPTY_MAP, false);
                    Set identities = res.getSearchResults();
                    Iterator ids = identities.iterator();
                    while (ids.hasNext()) {
                        spIds.add(ids.next());
                    }
                }
                this.specialIdentityNames = spIds;
            }
            if (this.specialIdentityNames != null && !this.specialIdentityNames.isEmpty()) {
                return this.specialIdentityNames.contains(name);
            }
        }
        return false;
    }

    public void setAttributes(SSOToken token, IdType type, String name, Map attributes, boolean isAdd, String amOrgName, String amsdkDN, boolean isString) throws IdRepoException, SSOException {
        Set configuredPluginClasses;
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, attributes.keySet(), IdOperation.EDIT, type);
        Set set = configuredPluginClasses = attributes.containsKey("objectclass") ? this.idrepoCache.getIdRepoPlugins(amOrgName, IdOperation.SERVICE, type) : this.idrepoCache.getIdRepoPlugins(amOrgName, IdOperation.EDIT, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            try {
                Map cMap = idRepo.getConfiguration();
                attributes = this.mapAttributeNames(attributes, cMap);
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null) {
                    if (isString) {
                        idRepo.setAttributes(token, type, amsdkDN, attributes, isAdd);
                        continue;
                    }
                    idRepo.setBinaryAttributes(token, type, amsdkDN, attributes, isAdd);
                    continue;
                }
                if (isString) {
                    idRepo.setAttributes(token, type, name, attributes, isAdd);
                    continue;
                }
                idRepo.setBinaryAttributes(token, type, name, attributes, isAdd);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().messageEnabled()) {
                    IdServicesImpl.getDebug().message("IdServicesImpl.setAttributes: Unable to set attributes in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.setAttributes: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.setAttributes: Unable to modify identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                if (ide.getErrorCode().equalsIgnoreCase("220") && origEx != null) continue;
                origEx = ide;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.setAttributes: Unable to set attributes  for identity " + type.getName() + "::" + name + " in any configured data" + " store", (Throwable)origEx);
            }
            throw origEx;
        }
    }

    public void changePassword(SSOToken token, IdType type, String name, String oldPassword, String newPassword, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        String attrName = "userPassword";
        Set attrNames = new HashSet<String>();
        attrNames.add(attrName);
        this.checkPermission(token, amOrgName, name, attrNames, IdOperation.EDIT, type);
        Set configuredPluginClasses = this.idrepoCache.getIdRepoPlugins(amOrgName, IdOperation.EDIT, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        IdRepoException origEx = null;
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            Map cMap = idRepo.getConfiguration();
            if ((attrNames = this.mapAttributeNames(attrNames, cMap)) != null && !attrNames.isEmpty()) {
                attrName = (String)attrNames.iterator().next();
            }
            try {
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null) {
                    idRepo.changePassword(token, type, amsdkDN, attrName, oldPassword, newPassword);
                    continue;
                }
                idRepo.changePassword(token, type, name, attrName, oldPassword, newPassword);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().messageEnabled()) {
                    IdServicesImpl.getDebug().message("IdServicesImpl.changePassword: Unable to change password in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.changePassword: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.changePassword: Unable to change password following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                if (ide.getErrorCode().equalsIgnoreCase("220") && origEx != null) continue;
                origEx = ide;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.changePassword: Unable to change password  for identity " + type.getName() + "::" + name + " in any configured data" + " store", (Throwable)origEx);
            }
            throw origEx;
        }
    }

    public Set getAssignedServices(SSOToken token, IdType type, String name, Map mapOfServiceNamesAndOCs, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, null, IdOperation.READ, type);
        Set configuredPluginClasses = this.idrepoCache.getIdRepoPlugins(amOrgName, IdOperation.SERVICE, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            if (ServiceManager.getBaseDN().equalsIgnoreCase(amOrgName) && type.equals(IdType.REALM)) {
                return configuredPluginClasses;
            }
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        Object idRepo = null;
        HashSet resultsSet = new HashSet();
        while (it.hasNext()) {
            IdRepo repo = (IdRepo)it.next();
            try {
                Set services = null;
                services = repo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null ? repo.getAssignedServices(token, type, amsdkDN, mapOfServiceNamesAndOCs) : repo.getAssignedServices(token, type, name, mapOfServiceNamesAndOCs);
                if (services == null || services.isEmpty()) continue;
                resultsSet.addAll(services);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().messageEnabled()) {
                    IdServicesImpl.getDebug().message("IdServicesImpl.getAssignedServices: Services not supported for repository " + repo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.getAssignedServices: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getAssignedServices: Unable to get services for identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.getAssignedServices: Unable to get assigned services for identity " + type.getName() + "::" + name + " in any configured data store", (Throwable)origEx);
            }
            throw origEx;
        }
        return resultsSet;
    }

    public void assignService(SSOToken token, IdType type, String name, String serviceName, SchemaType stype, Map attrMap, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, null, IdOperation.SERVICE, type);
        Set configuredPluginClasses = this.idrepoCache.getIdRepoPlugins(amOrgName, IdOperation.SERVICE, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        Object idRepo = null;
        while (it.hasNext()) {
            IdRepo repo = (IdRepo)it.next();
            Map cMap = repo.getConfiguration();
            try {
                attrMap = this.mapAttributeNames(attrMap, cMap);
                if (repo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null) {
                    repo.assignService(token, type, amsdkDN, serviceName, stype, attrMap);
                    continue;
                }
                repo.assignService(token, type, name, serviceName, stype, attrMap);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().messageEnabled()) {
                    IdServicesImpl.getDebug().message("IdServicesImpl.assignService: Assign Services not supported for repository " + repo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.assignService: FatalException ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.assignService: Unable to assign Service identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.assignService: Unable to assign service for identity " + type.getName() + "::" + name + " in any configured data store ", (Throwable)origEx);
            }
            throw origEx;
        }
    }

    public void unassignService(SSOToken token, IdType type, String name, String serviceName, Map attrMap, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, null, IdOperation.SERVICE, type);
        Set configuredPluginClasses = this.idrepoCache.getIdRepoPlugins(amOrgName, IdOperation.SERVICE, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        Object idRepo = null;
        while (it.hasNext()) {
            IdRepo repo = (IdRepo)it.next();
            Map cMap = repo.getConfiguration();
            try {
                attrMap = this.mapAttributeNames(attrMap, cMap);
                if (repo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null) {
                    repo.unassignService(token, type, amsdkDN, serviceName, attrMap);
                    continue;
                }
                repo.unassignService(token, type, name, serviceName, attrMap);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().messageEnabled()) {
                    IdServicesImpl.getDebug().message("IdServicesImpl.unassignService: Unassign Service not supported for repository " + repo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.unassignService: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.unassignService: Unable to unassign service in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.unassignService: Unable to unassign Service for identity " + type.getName() + "::" + name + " in any configured " + "data store ", (Throwable)origEx);
            }
            throw origEx;
        }
    }

    public Map getServiceAttributesAscending(SSOToken token, IdType type, String name, String serviceName, Set attrNames, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        HashMap<String, Set<Object>> finalResult;
        block25: {
            finalResult = new HashMap<String, Set<Object>>();
            HashSet<String> finalAttrName = new HashSet<String>();
            String nextName = name;
            String nextAmOrgName = amOrgName;
            String nextAmsdkDN = amsdkDN;
            IdType nextType = type;
            HashSet<String> missingAttr = new HashSet<String>(attrNames);
            do {
                block24: {
                    try {
                        Map serviceResult = this.getServiceAttributes(token, nextType, nextName, serviceName, missingAttr, nextAmOrgName, nextAmsdkDN);
                        if (IdServicesImpl.getDebug().messageEnabled()) {
                            IdServicesImpl.getDebug().message("IdServicesImpl.getServiceAttributesAscending: nextType=" + nextType + "; nextName=" + nextName + "; serviceName=" + serviceName + "; missingAttr=" + missingAttr + "; nextAmOrgName=" + nextAmOrgName + "; nextAmsdkDN=" + nextAmsdkDN);
                            IdServicesImpl.getDebug().message("  getServiceAttributesAscending: serviceResult=" + serviceResult);
                            IdServicesImpl.getDebug().message("  getServiceAttributesAscending:  finalResult=" + finalResult);
                            IdServicesImpl.getDebug().message("  getServiceAttributesAscending:  finalAttrName=" + finalAttrName);
                        }
                        if (serviceResult != null) {
                            Set srvNameReturned = serviceResult.keySet();
                            for (String attr : srvNameReturned) {
                                Set attrValue = (Set)serviceResult.get(attr);
                                if (attrValue.isEmpty()) continue;
                                finalResult.put(attr, attrValue);
                                finalAttrName.add(attr);
                            }
                            if (IdServicesImpl.getDebug().messageEnabled()) {
                                IdServicesImpl.getDebug().message("    getServiceAttributesAscending: serviceResult=" + serviceResult);
                                IdServicesImpl.getDebug().message("    getServiceAttributesAscending: finalResult=" + finalResult);
                            }
                        }
                        if (finalAttrName.containsAll(attrNames)) {
                            if (IdServicesImpl.getDebug().messageEnabled()) {
                                IdServicesImpl.getDebug().message("exit getServiceAttributesAscending: finalResult=" + finalResult);
                            }
                            return finalResult;
                        }
                        missingAttr.clear();
                        for (String attrName : attrNames) {
                            if (finalAttrName.contains(attrName)) continue;
                            missingAttr.add(attrName);
                        }
                    }
                    catch (IdRepoException idrepo) {
                        if (IdServicesImpl.getDebug().warningEnabled()) {
                            IdServicesImpl.getDebug().warning("  getServiceAttributesAscending: idrepoerr", (Throwable)idrepo);
                        }
                    }
                    catch (SSOException ssoex) {
                        if (!IdServicesImpl.getDebug().warningEnabled()) break block24;
                        IdServicesImpl.getDebug().warning("  getServiceAttributesAscending: ssoex", (Throwable)((Object)ssoex));
                    }
                }
                try {
                    if (nextType.equals(IdType.USER) || nextType.equals(IdType.AGENT)) {
                        nextAmsdkDN = nextAmOrgName;
                        nextType = IdType.REALM;
                        continue;
                    }
                    OrganizationConfigManager ocm = new OrganizationConfigManager(token, nextAmOrgName);
                    OrganizationConfigManager parentOCM = ocm.getParentOrgConfigManager();
                    String tmpParentName = parentOCM.getOrganizationName();
                    String parentName = DNMapper.realmNameToAMSDKName(tmpParentName);
                    if (IdServicesImpl.getDebug().messageEnabled()) {
                        IdServicesImpl.getDebug().message("  getServiceAttributesAscending:  tmpParentName=" + tmpParentName + " parentName=" + parentName);
                    }
                    nextType = IdType.REALM;
                    if (nextAmOrgName.equalsIgnoreCase(parentName)) {
                        nextName = null;
                    } else {
                        nextAmOrgName = parentName;
                    }
                    nextAmOrgName = parentName;
                    nextAmsdkDN = parentName;
                }
                catch (SMSException smse) {
                    if (IdServicesImpl.getDebug().warningEnabled()) {
                        IdServicesImpl.getDebug().warning("  getServiceAttributesAscending: smserror", (Throwable)smse);
                    }
                    nextName = null;
                }
            } while (nextName != null);
            if (!missingAttr.isEmpty()) {
                try {
                    ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, token);
                    ServiceSchema schema = ssm.getDynamicSchema();
                    Map gAttrs = schema.getAttributeDefaults();
                    for (String missingAttrName : missingAttr) {
                        finalResult.put(missingAttrName, (Set<Object>)gAttrs.get(missingAttrName));
                    }
                }
                catch (SMSException smse) {
                    if (!IdServicesImpl.getDebug().messageEnabled()) break block25;
                    IdServicesImpl.getDebug().message("IdServicesImpl(): getServiceAttributeAscending  Failed to get global default.", (Throwable)smse);
                }
            }
        }
        if (IdServicesImpl.getDebug().messageEnabled()) {
            IdServicesImpl.getDebug().message("exit end  getServiceAttributesAscending:  finalResult=" + finalResult);
        }
        return finalResult;
    }

    public Map getServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        return this.getServiceAttributes(token, type, name, serviceName, attrNames, amOrgName, amsdkDN, true);
    }

    public Map getBinaryServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        return this.getServiceAttributes(token, type, name, serviceName, attrNames, amOrgName, amsdkDN, false);
    }

    public Map getServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames, String amOrgName, String amsdkDN, boolean isString) throws IdRepoException, SSOException {
        this.checkPermission(token, amOrgName, name, attrNames, IdOperation.READ, type);
        Set configuredPluginClasses = this.idrepoCache.getIdRepoPlugins(amOrgName, IdOperation.SERVICE, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        Object idRepo = null;
        HashSet<Map> resultsSet = new HashSet<Map>();
        IdRepoException origEx = null;
        while (it.hasNext()) {
            IdRepo repo = (IdRepo)it.next();
            Map cMap = repo.getConfiguration();
            try {
                Map attrs = null;
                attrs = repo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null ? (isString ? repo.getServiceAttributes(token, type, amsdkDN, serviceName, attrNames) : repo.getBinaryServiceAttributes(token, type, amsdkDN, serviceName, attrNames)) : (isString ? repo.getServiceAttributes(token, type, name, serviceName, attrNames) : repo.getBinaryServiceAttributes(token, type, name, serviceName, attrNames));
                attrs = this.reverseMapAttributeNames(attrs, cMap);
                resultsSet.add(attrs);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().messageEnabled()) {
                    IdServicesImpl.getDebug().message("IdServicesImpl.getServiceAttributes: Services not supported for repository " + repo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.getServiceAttributes: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getServiceAttributes: Unable to get service attributes for the repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = origEx == null ? ide : origEx;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.getServiceAttributes: Unable to get service attributes for identity " + type.getName() + "::" + name + " in any configured data store", (Throwable)origEx);
            }
            throw origEx;
        }
        Map resultsMap = this.combineAttrMaps(resultsSet, isString);
        return resultsMap;
    }

    public void modifyService(SSOToken token, IdType type, String name, String serviceName, SchemaType stype, Map attrMap, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        this.checkPermission(token, amOrgName, name, attrMap.keySet(), IdOperation.SERVICE, type);
        Set configuredPluginClasses = this.idrepoCache.getIdRepoPlugins(amOrgName, IdOperation.SERVICE, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        Object idRepo = null;
        while (it.hasNext()) {
            IdRepo repo = (IdRepo)it.next();
            Map cMap = repo.getConfiguration();
            try {
                attrMap = this.mapAttributeNames(attrMap, cMap);
                if (repo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null) {
                    repo.modifyService(token, type, amsdkDN, serviceName, stype, attrMap);
                    continue;
                }
                repo.modifyService(token, type, name, serviceName, stype, attrMap);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().messageEnabled()) {
                    IdServicesImpl.getDebug().message("IdServicesImpl.modifyService: Modify Services not supported for repository " + repo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.modifyService: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.modifyService: Unable to modify service in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.modifyService: Unable to modify service attributes for identity " + type.getName() + "::" + name + " in any configured data store");
            }
            Object[] args = new Object[]{IdOperation.SERVICE.toString()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "302", args);
        }
    }

    public Set getSupportedTypes(SSOToken token, String amOrgName) throws IdRepoException, SSOException {
        HashSet unionSupportedTypes = new HashSet();
        Set configuredPluginClasses = this.idrepoCache.getIdRepoPlugins(amOrgName);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        for (IdRepo repo : configuredPluginClasses) {
            Set supportedTypes = repo.getSupportedTypes();
            if (supportedTypes == null || supportedTypes.isEmpty()) continue;
            unionSupportedTypes.addAll(supportedTypes);
        }
        unionSupportedTypes.retainAll(IdUtils.supportedTypes);
        return unionSupportedTypes;
    }

    public Set getSupportedOperations(SSOToken token, IdType type, String amOrgName) throws IdRepoException, SSOException {
        HashSet unionSupportedOps = new HashSet();
        Set configuredPluginClasses = this.idrepoCache.getIdRepoPlugins(amOrgName);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        for (IdRepo repo : configuredPluginClasses) {
            Set supportedOps = repo.getSupportedOperations(type);
            if (supportedOps == null || supportedOps.isEmpty()) continue;
            unionSupportedOps.addAll(supportedOps);
        }
        return unionSupportedOps;
    }

    private Map combineAttrMaps(Set setOfMaps, boolean isString) {
        AMHashMap resultMap = new AMHashMap(!isString);
        for (Map currMap : setOfMaps) {
            if (currMap == null) continue;
            for (String thisAttr : currMap.keySet()) {
                Object thisSet;
                Object resultSet;
                if (isString) {
                    resultSet = (Set)resultMap.get(thisAttr);
                    thisSet = (Set)currMap.get(thisAttr);
                    if (resultSet != null) {
                        resultSet.addAll(thisSet);
                        continue;
                    }
                    resultSet = new HashSet((Set)currMap.get(thisAttr));
                    resultMap.put(thisAttr, resultSet);
                    continue;
                }
                resultSet = (byte[][])resultMap.get(thisAttr);
                thisSet = (byte[][])currMap.get(thisAttr);
                int combinedSize = ((Object)thisSet).length;
                if (resultSet != null) {
                    int i;
                    combinedSize = ((Object)resultSet).length + ((Object)thisSet).length;
                    byte[][] tmpSet = new byte[combinedSize][];
                    for (i = 0; i < ((Object)resultSet).length; ++i) {
                        tmpSet[i] = (byte[])resultSet[i];
                    }
                    for (i = 0; i < ((Object)thisSet).length; ++i) {
                        tmpSet[i] = (byte[])thisSet[i];
                    }
                    resultSet = tmpSet;
                } else {
                    resultSet = (byte[][])thisSet.clone();
                }
                resultMap.put(thisAttr, resultSet);
            }
        }
        return resultMap;
    }

    private Map mapAttributeNames(Map attrMap, Map configMap) {
        Map resultMap;
        if (attrMap == null || attrMap.isEmpty()) {
            return attrMap;
        }
        Map[] mapArray = this.getAttributeNameMap(configMap);
        if (mapArray == null) {
            resultMap = attrMap;
        } else {
            resultMap = new CaseInsensitiveHashMap();
            Map forwardMap = mapArray[0];
            for (String curr : attrMap.keySet()) {
                if (forwardMap.containsKey(curr)) {
                    resultMap.put((String)forwardMap.get(curr), (Set)attrMap.get(curr));
                    continue;
                }
                resultMap.put(curr, (Set)attrMap.get(curr));
            }
        }
        return resultMap;
    }

    private Set mapAttributeNames(Set attrNames, Map configMap) {
        Set resultSet;
        if (attrNames == null || attrNames.isEmpty()) {
            return attrNames;
        }
        Map[] mapArray = this.getAttributeNameMap(configMap);
        if (mapArray == null) {
            resultSet = attrNames;
        } else {
            resultSet = new CaseInsensitiveHashSet();
            Map forwardMap = mapArray[0];
            for (String curr : attrNames) {
                if (forwardMap.containsKey(curr)) {
                    resultSet.add((String)forwardMap.get(curr));
                    continue;
                }
                resultSet.add(curr);
            }
        }
        return resultSet;
    }

    private Map reverseMapAttributeNames(Map attrMap, Map configMap) {
        Map resultMap;
        if (attrMap == null || attrMap.isEmpty()) {
            return attrMap;
        }
        Map[] mapArray = this.getAttributeNameMap(configMap);
        if (mapArray == null) {
            resultMap = attrMap;
        } else {
            resultMap = new CaseInsensitiveHashMap();
            Map reverseMap = mapArray[1];
            for (String curr : attrMap.keySet()) {
                if (reverseMap.containsKey(curr)) {
                    resultMap.put((String)reverseMap.get(curr), attrMap.get(curr));
                    continue;
                }
                resultMap.put(curr, attrMap.get(curr));
            }
        }
        return resultMap;
    }

    private Set combineMembers(SSOToken token, Set membersSet, IdType type, String orgName, boolean amsdkIncluded, Set amsdkMemberships) {
        HashSet<AMIdentity> results = new HashSet<AMIdentity>();
        CaseInsensitiveHashMap resultsMap = new CaseInsensitiveHashMap();
        if (amsdkIncluded && amsdkMemberships != null) {
            for (String m : amsdkMemberships) {
                String mname = DNUtils.DNtoName(m);
                AMIdentity id = new AMIdentity(token, mname, type, orgName, m);
                results.add(id);
                resultsMap.put(mname, id);
            }
        }
        for (Set first : membersSet) {
            if (first == null) continue;
            for (String m : first) {
                String mname = DNUtils.DNtoName(m);
                if (resultsMap.containsKey(mname)) continue;
                AMIdentity id = new AMIdentity(token, mname, type, orgName, null);
                results.add(id);
                resultsMap.put(mname, id);
            }
        }
        return results;
    }

    private IdSearchResults combineSearchResults(SSOToken token, Object[][] arrayOfResult, int sizeOfArray, IdType type, String orgName, boolean amsdkIncluded, Object[][] amsdkResults) {
        CaseInsensitiveHashMap amsdkDNs = new CaseInsensitiveHashMap();
        CaseInsensitiveHashMap resultsMap = new CaseInsensitiveHashMap();
        int errorCode = 0;
        if (amsdkIncluded) {
            RepoSearchResults amsdkRepoRes = (RepoSearchResults)amsdkResults[0][0];
            Set results = amsdkRepoRes.getSearchResults();
            Map attrResults = amsdkRepoRes.getResultAttributes();
            for (String dn : results) {
                String name = LDAPDN.explodeDN((String)dn, (boolean)true)[0];
                amsdkDNs.put(name, dn);
                HashSet<Map> attrMaps = new HashSet<Map>();
                attrMaps.add((Map)attrResults.get(dn));
                resultsMap.put(name, attrMaps);
            }
            errorCode = amsdkRepoRes.getErrorCode();
        }
        for (int i = 0; i < sizeOfArray; ++i) {
            RepoSearchResults current = (RepoSearchResults)arrayOfResult[i][0];
            Map configMap = (Map)arrayOfResult[i][1];
            Iterator it = current.getSearchResults().iterator();
            Map allAttrMaps = current.getResultAttributes();
            while (it.hasNext()) {
                String m = (String)it.next();
                String mname = DNUtils.DNtoName(m, false);
                Map attrMap = (Map)allAttrMaps.get(m);
                attrMap = this.reverseMapAttributeNames(attrMap, configMap);
                HashSet<Map> attrMaps = (HashSet<Map>)resultsMap.get(mname);
                if (attrMaps == null) {
                    attrMaps = new HashSet<Map>();
                }
                attrMaps.add(attrMap);
                resultsMap.put(mname, attrMaps);
            }
        }
        IdSearchResults results = new IdSearchResults(type, orgName);
        for (String mname : resultsMap.keySet()) {
            Map combinedMap = this.combineAttrMaps((Set)resultsMap.get(mname), true);
            AMIdentity id = new AMIdentity(token, mname, type, orgName, (String)amsdkDNs.get(mname));
            results.addResult(id, combinedMap);
        }
        results.setErrorCode(errorCode);
        return results;
    }

    private Map[] getAttributeNameMap(Map configMap) {
        Set attributeMap = (Set)configMap.get("sunIdRepoAttributeMapping");
        if (attributeMap == null || attributeMap.isEmpty()) {
            return null;
        }
        Map[] returnArray = new Map[2];
        int size = attributeMap.size();
        returnArray[0] = new CaseInsensitiveHashMap(size);
        returnArray[1] = new CaseInsensitiveHashMap(size);
        for (String mapString : attributeMap) {
            int eqIndex = mapString.indexOf(61);
            if (eqIndex > -1) {
                String first = mapString.substring(0, eqIndex);
                String second = mapString.substring(eqIndex + 1);
                returnArray[0].put(first, second);
                returnArray[1].put(second, first);
                continue;
            }
            returnArray[0].put(mapString, mapString);
            returnArray[1].put(mapString, mapString);
        }
        return returnArray;
    }

    private boolean checkPermission(SSOToken token, String realm, String name, Set attrs, IdOperation op, IdType type) throws IdRepoException, SSOException {
        if (!ServiceManager.isConfigMigratedTo70()) {
            return true;
        }
        HashSet thisAction = null;
        thisAction = op.equals(IdOperation.READ) ? READ_ACTION : WRITE_ACTION;
        try {
            DelegationEvaluator de = new DelegationEvaluator();
            String resource = type.getName();
            if (name != null) {
                resource = resource + "/" + name;
            }
            DelegationPermission dp = new DelegationPermission(realm, "sunIdentityRepositoryService", "1.0", "application", resource, thisAction, Collections.EMPTY_MAP);
            HashMap<String, Set> envMap = Collections.EMPTY_MAP;
            if (attrs != null) {
                envMap = new HashMap<String, Set>();
                envMap.put(DELEGATION_ATTRS_NAME, attrs);
            }
            if (!de.isAllowed(token, dp, envMap)) {
                Object[] args = new Object[]{op.getName(), token.getPrincipal().getName()};
                throw new IdRepoException("amIdRepo", "402", args);
            }
            return true;
        }
        catch (DelegationException dex) {
            IdServicesImpl.getDebug().error("IdServicesImpl.checkPermission Got Delegation Exception: ", (Throwable)dex);
            Object[] args = new Object[]{op.getName(), token.getPrincipal().getName()};
            throw new IdRepoException("amIdRepo", "402", args);
        }
    }

    protected void clearSpecialIdentityCache() {
        this.specialIdentityNames = null;
        this.specialIdentities = null;
    }

    public void clearIdRepoPlugins() {
        this.idrepoCache.clearIdRepoPluginsCache();
    }

    public void clearIdRepoPlugins(String orgName, String serviceComponent, int type) {
        this.idrepoCache.clearIdRepoPluginsCache();
    }

    public void reloadIdRepoServiceSchema() {
        this.idrepoCache.clearIdRepoPluginsCache();
    }

    static {
        READ_ACTION = new HashSet(2);
        WRITE_ACTION = new HashSet(2);
        READ_ACTION.add("READ");
        WRITE_ACTION.add("MODIFY");
    }
}

