/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.injection.core.module;

import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivityModule {
    private final Log LOG = ExoLogger.getLogger(ActivityModule.class);
    private IdentityManager identityManager_;
    private ActivityManager activityManager_;

    public ActivityModule(IdentityManager identityManager, ActivityManager activityManager) {
        this.identityManager_ = identityManager;
        this.activityManager_ = activityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushActivities(JSONArray activities) {
        for (int i = 0; i < activities.length(); ++i) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                JSONObject activity = activities.getJSONObject(i);
                this.pushActivity(activity);
                continue;
            }
            catch (JSONException e) {
                this.LOG.error((Object)("Syntax error on activity n\u00b0" + i), (Throwable)e);
                continue;
            }
            catch (Exception e) {
                this.LOG.error((Object)("Error when creating activity n\u00b0" + i), (Throwable)e);
                continue;
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    private void pushActivity(JSONObject activityJSON) throws Exception {
        String from = activityJSON.getString("from");
        Identity identity = this.identityManager_.getOrCreateIdentity("organization", from, false);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setBody(activityJSON.getString("body"));
        activity.setTitle(activityJSON.getString("body"));
        activity.setUserId(identity.getId());
        activity.setType("DEFAULT_ACTIVITY");
        this.activityManager_.saveActivityNoReturn(identity, (ExoSocialActivity)activity);
        Thread.sleep(1000L);
        JSONArray likes = activityJSON.getJSONArray("likes");
        for (int i = 0; i < likes.length(); ++i) {
            String like = likes.getString(i);
            Identity identityLike = this.identityManager_.getOrCreateIdentity("organization", like, false);
            try {
                this.activityManager_.saveLike((ExoSocialActivity)activity, identityLike);
                continue;
            }
            catch (Exception e) {
                this.LOG.error((Object)("Error when liking an activity with " + like), (Throwable)e);
            }
        }
        JSONArray comments = activityJSON.getJSONArray("comments");
        for (int i = 0; i < comments.length(); ++i) {
            JSONObject commentJSON = comments.getJSONObject(i);
            Thread.sleep(1000L);
            Identity identityComment = this.identityManager_.getOrCreateIdentity("organization", commentJSON.getString("from"), false);
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
            comment.setTitle(commentJSON.getString("body"));
            comment.setUserId(identityComment.getId());
            this.activityManager_.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        }
    }

    private void deleteActivity(JSONObject activityJSON) throws Exception {
        Object listAccess = null;
        List activities = null;
        String from = activityJSON.getString("from");
        Identity identity = this.identityManager_.getOrCreateIdentity("organization", from, false);
        RealtimeListAccess allActivities = this.activityManager_.getActivityFeedWithListAccess(identity);
        activities = allActivities.loadAsList(0, allActivities.getSize());
        activities.forEach(a -> this.activityManager_.deleteActivity(a));
    }
}

