/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.injection.core.module;

import java.io.IOException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.injection.helper.InjectorUtils;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.WikiService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xwiki.rendering.syntax.Syntax;

public class WikiModule {
    private final Log LOG = ExoLogger.getLogger(WikiModule.class);
    protected WikiService wikiService;

    public WikiModule(WikiService wikiService) {
        this.wikiService = wikiService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createUserWiki(JSONArray wikis, String defaultDataFolderPath) {
        for (int i = 0; i < wikis.length(); ++i) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                JSONObject wiki = wikis.getJSONObject(i);
                this.createOrEditPage(wiki, wiki.has("parent") ? wiki.getString("parent") : "", defaultDataFolderPath);
                continue;
            }
            catch (JSONException e) {
                this.LOG.error((Object)("Syntax error on wiki n\u00b0" + i), (Throwable)e);
                continue;
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    private void createOrEditPage(JSONObject wiki, String parentTitle, String defaultDataFolderPath) throws JSONException {
        String type;
        boolean forceNew = wiki.has("new") && wiki.getBoolean("new");
        String title = wiki.getString("title");
        String filename = wiki.has("filename") ? wiki.getString("filename") : "";
        String parent = parentTitle;
        String string = type = wiki.has("type") ? wiki.getString("type") : "";
        type = "group".equals(type) ? PortalConfig.GROUP_TYPE : ("portal".equals(type) ? PortalConfig.PORTAL_TYPE : PortalConfig.USER_TYPE);
        String owner = wiki.has("owner") ? wiki.getString("owner") : "";
        try {
            if (this.wikiService.getWikiByTypeAndOwner(type, owner) == null) {
                this.wikiService.createWiki(type, owner);
            }
            if (forceNew && !title.equals("WikiHome") && this.wikiService.isExisting(type, owner, TitleResolver.getId((String)title, (boolean)false))) {
                this.wikiService.deletePage(type, owner, TitleResolver.getId((String)title, (boolean)false));
            }
            Page page = this.wikiService.isExisting(type, owner, TitleResolver.getId((String)title, (boolean)false)) ? this.wikiService.getPageOfWikiByName(type, owner, TitleResolver.getId((String)title, (boolean)false)) : this.wikiService.createPage(new Wiki(type, owner), TitleResolver.getId((String)parent, (boolean)false), new Page(title, title));
            String content = "= " + title + " =";
            if (filename != null && !filename.equals("")) {
                content = InjectorUtils.getWikiPage(filename, defaultDataFolderPath);
            }
            page.setContent(content);
            page.setSyntax(Syntax.XWIKI_2_1.toIdString());
            this.wikiService.updatePage(page, null);
            if (wiki.has("wikis") && wiki.getJSONArray("wikis").length() > 0) {
                for (int j = 0; j < wiki.getJSONArray("wikis").length(); ++j) {
                    JSONObject childWiki = wiki.getJSONArray("wikis").getJSONObject(j);
                    this.createOrEditPage(childWiki, wiki.getString("title"), defaultDataFolderPath);
                }
            }
        }
        catch (WikiException e) {
            this.LOG.error((Object)"Error when creating wiki page", (Throwable)e);
        }
        catch (IOException e) {
            this.LOG.error((Object)"Error when reading wiki content", (Throwable)e);
        }
    }
}

