/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.injection.client.ws;

import java.util.HashMap;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.injection.services.DataInjector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="data/injection/")
public class DataInjectorREST
implements ResourceContainer {
    private static final Log log = ExoLogger.getLogger(DataInjectorREST.class);
    private DataInjector dataInjector;
    private static final CacheControl cacheControl_ = new CacheControl();

    public DataInjectorREST(DataInjector dataInjector) {
        this.dataInjector = dataInjector;
    }

    @GET
    @Path(value="inject")
    @RolesAllowed(value={"administrators"})
    public Response inject(@Context SecurityContext sc, @Context UriInfo uriInfo) throws Exception {
        try {
            this.dataInjector.inject(new HashMap<String, Integer>());
        }
        catch (Exception e) {
            log.error((Object)"Data Injection Failed", (Throwable)e);
            return Response.serverError().entity((Object)String.format("Data injection failed due to %1$s", e.getMessage())).build();
        }
        return Response.ok((Object)String.format("Data has been injected successfully!!!", new Object[0]), (String)"text/plain").cacheControl(cacheControl_).build();
    }

    @GET
    @Path(value="purge")
    @RolesAllowed(value={"administrators"})
    public Response purge(@Context SecurityContext sc, @Context UriInfo uriInfo) throws Exception {
        try {
            this.dataInjector.purge(new HashMap<String, Integer>());
        }
        catch (Exception e) {
            log.error((Object)"Data purging failed", (Throwable)e);
            return Response.serverError().entity((Object)String.format("Purge data failed due to %1$s", e.getMessage())).build();
        }
        return Response.ok((Object)String.format("Data has been purged successfully!!!", new Object[0]), (String)"text/plain").cacheControl(cacheControl_).build();
    }

    static {
        cacheControl_.setNoCache(true);
        cacheControl_.setNoStore(true);
    }
}

