/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.injection.core.module;

import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.forum.common.jcr.KSDataLocation;
import org.exoplatform.forum.common.jcr.PropertyReader;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.filter.model.ForumFilter;
import org.exoplatform.forum.service.impl.model.PostFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ForumModule {
    private final Log LOG = ExoLogger.getLogger(ForumModule.class);
    protected ForumService forumService;
    protected KSDataLocation ksDataLocation;

    public ForumModule(ForumService forumService, KSDataLocation ksDataLocation) {
        this.forumService = forumService;
        this.ksDataLocation = ksDataLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createForumContents(JSONArray forumContent) {
        for (int i = 0; i < forumContent.length(); ++i) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                JSONObject category = forumContent.getJSONObject(i);
                this.createCategory(category);
                continue;
            }
            catch (JSONException e) {
                this.LOG.error((Object)("Syntax error on space n\u00b0" + i), (Throwable)e);
                continue;
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    public void createCategory(JSONObject categoryJSON) throws JSONException {
        String title = categoryJSON.getString("categoryTitle");
        String description = categoryJSON.getString("description");
        String owner = categoryJSON.getString("owner");
        List categories = this.forumService.getCategories();
        String categoryId = "";
        for (Category category : categories) {
            if (!category.getCategoryName().equals(title)) continue;
            categoryId = category.getId();
            break;
        }
        if (categoryId.equals("")) {
            Category category = new Category();
            category.setCategoryName(title);
            category.setDescription(description);
            category.setOwner(owner);
            try {
                this.forumService.saveCategory(category, true);
                categoryId = category.getId();
            }
            catch (Exception e) {
                this.LOG.error((Object)("Exception when creating category " + title + " in forum"), (Throwable)e);
            }
        }
        if (categoryJSON.has("forums")) {
            JSONArray forums = categoryJSON.getJSONArray("forums");
            for (int i = 0; i < forums.length(); ++i) {
                try {
                    JSONObject forum = forums.getJSONObject(i);
                    this.createForum(forum, categoryId);
                    continue;
                }
                catch (JSONException e) {
                    this.LOG.error((Object)("Syntax error on forum n\u00b0" + i), (Throwable)e);
                }
            }
        }
    }

    private void createForum(JSONObject forumJSON, String categoryId) throws JSONException {
        String title = forumJSON.getString("forumTitle");
        String description = forumJSON.getString("description");
        String owner = forumJSON.getString("owner");
        ForumFilter filter = new ForumFilter(categoryId, true);
        List forums = this.forumService.getForums(filter);
        String forumId = "";
        for (Forum forum : forums) {
            if (!forum.getForumName().equals(title)) continue;
            forumId = forum.getId();
            break;
        }
        if (forumId.equals("")) {
            Forum forum = new Forum();
            forum.setForumName(title);
            forum.setDescription(description);
            forum.setOwner(owner);
            try {
                this.forumService.saveForum(categoryId, forum, true);
                forumId = forum.getId();
            }
            catch (Exception e) {
                this.LOG.error((Object)("Exception when creating forum " + title), (Throwable)e);
            }
        }
        if (forumJSON.has("topics")) {
            JSONArray topics = forumJSON.getJSONArray("topics");
            for (int i = 0; i < topics.length(); ++i) {
                try {
                    JSONObject topic = topics.getJSONObject(i);
                    this.createTopic(topic, forumId, categoryId);
                    continue;
                }
                catch (JSONException e) {
                    this.LOG.error((Object)("Syntax error on topic n\u00b0" + i), (Throwable)e);
                }
            }
        }
    }

    private void createTopic(JSONObject topicJSON, String forumId, String categoryId) throws JSONException {
        String title = topicJSON.getString("topicTitle");
        String content = topicJSON.getString("content");
        String owner = topicJSON.getString("owner");
        try {
            List topics = this.forumService.getTopics(categoryId, forumId);
            String topicId = "";
            for (Topic topic : topics) {
                if (!topic.getTopicName().equals(title)) continue;
                topicId = topic.getId();
                break;
            }
            if (topicId.equals("")) {
                Topic topic = new Topic();
                topic.setTopicName(title);
                topic.setDescription(content);
                topic.setOwner(owner);
                topic.setIcon("classNameIcon");
                try {
                    this.forumService.saveTopic(categoryId, forumId, topic, true, false, new MessageBuilder());
                    topicId = topic.getId();
                }
                catch (Exception e) {
                    this.LOG.error((Object)("Exception when creating topic " + title), (Throwable)e);
                }
            }
            if (topicJSON.has("posts")) {
                JSONArray posts = topicJSON.getJSONArray("posts");
                for (int i = 0; i < posts.length(); ++i) {
                    try {
                        JSONObject post = posts.getJSONObject(i);
                        this.createPost(post, topicId, forumId, categoryId, title);
                        continue;
                    }
                    catch (JSONException e) {
                        this.LOG.error((Object)("Syntax error on forum n\u00b0" + i), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)"Error when reading topics lists");
        }
    }

    private void createPost(JSONObject postJSON, String topicId, String forumId, String categoryId, String topicTitle) throws JSONException {
        String content = postJSON.getString("content");
        String owner = postJSON.getString("owner");
        try {
            PostFilter postFilter = new PostFilter(categoryId, forumId, topicId, null, null, null, null);
            ListAccess posts = this.forumService.getPosts(postFilter);
            Post[] postArray = (Post[])posts.load(0, posts.getSize());
            String postId = "";
            for (Post post : postArray) {
                if (!post.getMessage().equals(content)) continue;
                postId = post.getId();
            }
            if (postId.equals("")) {
                Post newPost = new Post();
                newPost.setOwner(owner);
                newPost.setMessage(content);
                newPost.setName(topicTitle);
                this.forumService.savePost(categoryId, forumId, topicId, newPost, true, new MessageBuilder());
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)"Error when reading posts lists");
        }
    }

    public void createPosts(String username) {
        String forumName = "Public Discussions";
        try {
            Forum forum = this.getForumByName(forumName);
            Category cat = this.getCategoryByForumName(forumName);
            List topics = this.forumService.getTopics(cat.getId(), forum.getId());
            if (topics.size() > 0) {
                return;
            }
            Topic topicNew = new Topic();
            topicNew.setOwner(username);
            topicNew.setTopicName("General");
            topicNew.setCreatedDate(new Date());
            topicNew.setModifiedBy(username);
            topicNew.setModifiedDate(new Date());
            topicNew.setLastPostBy(username);
            topicNew.setLastPostDate(new Date());
            topicNew.setDescription("General Topic");
            topicNew.setPostCount(0L);
            topicNew.setViewCount(0L);
            topicNew.setIsNotifyWhenAddPost("");
            topicNew.setIsModeratePost(false);
            topicNew.setIsClosed(false);
            topicNew.setIsLock(false);
            topicNew.setIsWaiting(false);
            topicNew.setIsActive(true);
            topicNew.setIcon("classNameIcon");
            topicNew.setIsApproved(true);
            topicNew.setCanView(new String[0]);
            topicNew.setCanPost(new String[0]);
            this.forumService.saveTopic(cat.getId(), forum.getId(), topicNew, true, false, new MessageBuilder());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Forum getForumByName(String forumName) throws Exception {
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.ksDataLocation.getForumCategoriesLocation()).append("//element(*,");
        sb.append("exo:forum").append(")[jcr:like(exo:name, '%").append(forumName).append("%')]");
        NodeIterator iter = this.forumService.search(sb.toString());
        if (iter.hasNext()) {
            Node forumNode = (Node)iter.next();
            Forum forum = new Forum();
            PropertyReader reader = new PropertyReader(forumNode);
            forum.setId(forumNode.getName());
            forum.setPath(forumNode.getPath());
            forum.setOwner(reader.string("exo:owner"));
            forum.setForumName(reader.string("exo:name"));
            forum.setViewer(reader.strings("exo:viewer"));
            return forum;
        }
        return null;
    }

    private Category getCategoryByForumName(String forumName) throws Exception {
        Node forumNode;
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.ksDataLocation.getForumCategoriesLocation()).append("//element(*,");
        sb.append("exo:forum").append(")[jcr:like(exo:name, '%").append(forumName).append("%')]");
        NodeIterator iter = this.forumService.search(sb.toString());
        if (iter.hasNext() && (forumNode = (Node)iter.next()).getParent() != null) {
            Node cateNode = forumNode.getParent();
            Category cat = new Category(cateNode.getName());
            cat.setPath(cateNode.getPath());
            PropertyReader reader = new PropertyReader(cateNode);
            cat.setOwner(reader.string("exo:owner"));
            cat.setCategoryName(reader.string("exo:name"));
            return cat;
        }
        return null;
    }
}

