/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.ext.impl;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.impl.CalendarEventListener;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.cs.ext.impl.CalendarUIActivity;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.common.ExoSocialException;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webui.application.WebuiRequestContext;

public class CalendarSpaceActivityPublisher
extends CalendarEventListener {
    private static final Log LOG = ExoLogger.getLogger(CalendarSpaceActivityPublisher.class);
    public static final String CALENDAR_APP_ID = "cs-calendar:spaces";
    public static final String EVENT_ADDED = "EventAdded".intern();
    public static final String EVENT_UPDATED = "EventUpdated".intern();
    public static final String EVENT_ID_KEY = "EventID".intern();
    public static final String CALENDAR_ID_KEY = "CalendarID".intern();
    public static final String TASK_ADDED = "TaskAdded".intern();
    public static final String TASK_UPDATED = "TaskUpdated".intern();
    public static final String EVENT_TYPE_KEY = "EventType".intern();
    public static final String EVENT_SUMMARY_KEY = "EventSummary".intern();
    public static final String EVENT_TITLE_KEY = "EventTitle".intern();
    public static final String EVENT_DESCRIPTION_KEY = "EventDescription".intern();
    public static final String EVENT_LOCALE_KEY = "EventLocale".intern();
    public static final String EVENT_STARTTIME_KEY = "EventStartTime".intern();
    public static final String EVENT_ENDTIME_KEY = "EventEndTime".intern();
    public static final String EVENT_LINK_KEY = "EventLink";
    public static final String INVITATION_DETAIL = "/invitation/detail/";
    public static final String CALENDAR_FIELDS_CHANGED = "CALENDAR_FIELDS_CHANGED";
    public static final String SUMMARY_UPDATED = "summary_updated";
    public static final String DESCRIPTION_UPDATED = "description_updated";
    public static final String FROM_UPDATED = "fromDateTime_updated";
    public static final String TO_UPDATED = "toDateTime_updated";
    public static final String LOCATION_UPDATED = "location_updated";
    public static final String ALLDAY_UPDATED = "allDay_updated";
    public static final String REPEAT_UPDATED = "repeatType_updated";
    public static final String ATTACH_UPDATED = "attachment_updated";
    public static final String CATEGORY_UPDATED = "eventCategoryName_updated";
    public static final String CALENDAR_UPDATED = "calendarId_updated";
    public static final String PRIORITY_UPDATED = "priority_updated";
    private static final String RP_END_BYDATE = "endByDate";
    private static final String RP_END_AFTER = "endAfter";
    private static final String RP_END_NEVER = "neverEnd";
    private static final String RP_MONTHLY_BYDAY = "monthlyByDay";
    private static final String RP_MONTHLY_BYMONTHDAY = "monthlyByMonthDay";
    private static final String REPEAT_EVENT_INSTANCE_REMOVED = "repeatEvent_instance_removed";
    public static final String NAME_UPDATED = "name_updated";
    public static final String NOTE_UPDATED = "note_updated";
    public static final String TASK_CATEGORY_UPDATED = "taskCategoryName_updated";
    public static final String TASK_CALENDAR_UPDATED = "task_CalendarId_updated";
    public static final String TASK_ATTACH_UPDATED = "task_attachment_updated";
    public static final String TASK_NEED_ACTION = CalendarEvent.NEEDS_ACTION;
    public static final String TASK_IN_PROCESS_ACTION = CalendarEvent.IN_PROCESS;
    public static final String TASK_COMPLETED_ACTION = CalendarEvent.COMPLETED;
    public static final String TASK_CANCELLED_ACTION = CalendarEvent.CANCELLED;
    private CalendarService calService_;

    private String makeEventLink(CalendarEvent event) {
        StringBuffer sb = new StringBuffer("");
        PortalRequestContext requestContext = Util.getPortalRequestContext();
        sb.append(requestContext.getPortalURI()).append(requestContext.getNodePath()).append(INVITATION_DETAIL).append(ConversationState.getCurrent().getIdentity().getUserId()).append("/").append(event.getId()).append("/").append(event.getCalType());
        return sb.toString();
    }

    private Map<String, String> makeActivityParams(CalendarEvent event, String calendarId, String eventType) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(EVENT_TYPE_KEY, eventType);
        params.put(EVENT_ID_KEY, event.getId());
        params.put(CALENDAR_ID_KEY, calendarId);
        params.put(EVENT_SUMMARY_KEY, event.getSummary());
        params.put(EVENT_LOCALE_KEY, event.getLocation() != null ? event.getLocation() : "");
        params.put(EVENT_DESCRIPTION_KEY, event.getDescription() != null ? event.getDescription() : "");
        params.put(EVENT_STARTTIME_KEY, String.valueOf(event.getFromDateTime().getTime()));
        params.put(EVENT_ENDTIME_KEY, String.valueOf(event.getToDateTime().getTime()));
        params.put(EVENT_LINK_KEY, this.makeEventLink(event));
        return params;
    }

    private void publishActivity(CalendarEvent event, String calendarId, String eventType) {
        block7: {
            try {
                Class.forName("org.exoplatform.social.core.space.spi.SpaceService");
            }
            catch (ClassNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"eXo Social components not found!", (Throwable)e);
                }
                return;
            }
            if (calendarId == null || calendarId.indexOf("_space_calendar") < 0) {
                return;
            }
            try {
                IdentityManager identityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
                ActivityManager activityM = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
                SpaceService spaceService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
                String spaceId = calendarId.split("_space_calendar")[0];
                Space space = spaceService.getSpaceById(spaceId);
                if (space != null) {
                    String userId = ConversationState.getCurrent().getIdentity().getUserId();
                    Identity spaceIdentity = identityM.getOrCreateIdentity("space", space.getPrettyName(), false);
                    Identity userIdentity = identityM.getOrCreateIdentity("organization", userId, false);
                    ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
                    activity.setUserId(userIdentity.getId());
                    activity.setTitle(event.getSummary());
                    activity.setBody(event.getDescription());
                    activity.setType(CALENDAR_APP_ID);
                    activity.setTemplateParams(this.makeActivityParams(event, calendarId, eventType));
                    activityM.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
                    event.setActivityId(activity.getId());
                }
            }
            catch (ExoSocialException e) {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.error((Object)"Can not record Activity for space when event added ", (Throwable)e);
            }
        }
    }

    private void updateToActivity(CalendarEvent event, String calendarId, String eventType, Map<String, String> messagesParams) {
        block9: {
            try {
                Class.forName("org.exoplatform.social.core.space.spi.SpaceService");
            }
            catch (ClassNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"eXo Social components not found!", (Throwable)e);
                }
                return;
            }
            if (calendarId == null || calendarId.indexOf("_space_calendar") < 0) {
                return;
            }
            try {
                IdentityManager identityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
                ActivityManager activityM = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
                SpaceService spaceService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
                String spaceId = calendarId.split("_space_calendar")[0];
                Space space = spaceService.getSpaceById(spaceId);
                if (space != null && event.getActivityId() != null) {
                    String userId = ConversationState.getCurrent().getIdentity().getUserId();
                    Identity spaceIdentity = identityM.getOrCreateIdentity("space", space.getPrettyName(), false);
                    Identity userIdentity = identityM.getOrCreateIdentity("organization", userId, false);
                    ExoSocialActivity activity = activityM.getActivity(event.getActivityId());
                    if (activity == null) {
                        ExoSocialActivityImpl newActivity = new ExoSocialActivityImpl();
                        newActivity.setUserId(userIdentity.getId());
                        newActivity.setTitle(event.getSummary());
                        newActivity.setBody(event.getDescription());
                        newActivity.setType(CALENDAR_APP_ID);
                        newActivity.setTemplateParams(this.makeActivityParams(event, calendarId, eventType));
                        activityM.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)newActivity);
                        ExoSocialActivity newComment = this.createComment(userIdentity.getId(), messagesParams);
                        activityM.saveComment((ExoSocialActivity)newActivity, newComment);
                        event.setActivityId(newActivity.getId());
                        LOG.info((Object)String.format("[CALENDAR] successfully re-created activity for event: %s", event.getSummary()));
                    } else {
                        activity.setTitle(event.getSummary());
                        activity.setBody(event.getDescription());
                        activity.setTemplateParams(this.makeActivityParams(event, calendarId, eventType));
                        activityM.updateActivity(activity);
                        ExoSocialActivity newComment = this.createComment(userIdentity.getId(), messagesParams);
                        activityM.saveComment(activity, newComment);
                        LOG.info((Object)String.format("[CALENDAR] successfully added comment to activity of event: %s", event.getSummary()));
                    }
                }
            }
            catch (ExoSocialException e) {
                if (!LOG.isDebugEnabled()) break block9;
                LOG.error((Object)"Can not update Activity for space when event modified ", (Throwable)e);
            }
        }
    }

    private ExoSocialActivity createComment(String userId, Map<String, String> messagesParams) {
        ExoSocialActivityImpl newComment = new ExoSocialActivityImpl();
        newComment.isComment(true);
        newComment.setUserId(userId);
        newComment.setType("CALENDAR_ACTIVITY");
        StringBuilder fields = new StringBuilder();
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        for (String field : messagesParams.keySet()) {
            String value = messagesParams.get(field);
            data.put(field, value);
            fields.append("," + field);
        }
        String fieldsChanged = fields.toString().substring(1);
        data.put(CALENDAR_FIELDS_CHANGED, fieldsChanged);
        newComment.setTitleId(fieldsChanged);
        newComment.setTemplateParams(data);
        return newComment;
    }

    private void deleteActivity(CalendarEvent event, String calendarId, String eventType) {
        block7: {
            try {
                Class.forName("org.exoplatform.social.core.space.spi.SpaceService");
            }
            catch (ClassNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"eXo Social components not found!", (Throwable)e);
                }
                return;
            }
            if (calendarId == null || calendarId.indexOf("_space_calendar") < 0) {
                return;
            }
            try {
                ActivityManager activityM = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
                SpaceService spaceService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
                String spaceId = calendarId.split("_space_calendar")[0];
                Space space = spaceService.getSpaceById(spaceId);
                if (space != null && event.getActivityId() != null) {
                    activityM.deleteActivity(event.getActivityId());
                }
            }
            catch (ExoSocialException e) {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.error((Object)"Can not delete Activity for space when event deleted ", (Throwable)e);
            }
        }
    }

    private Map<String, String> buildParams(CalendarEvent oldEvent, CalendarEvent newEvent) {
        LinkedHashMap<String, String> messagesParams;
        block37: {
            messagesParams = new LinkedHashMap<String, String>();
            try {
                if (CalendarEvent.TYPE_EVENT.equals(newEvent.getEventType())) {
                    if (!oldEvent.getSummary().equals(newEvent.getSummary())) {
                        messagesParams.put(SUMMARY_UPDATED, newEvent.getSummary());
                    }
                    if (newEvent.getDescription() != null && !newEvent.getDescription().equals(oldEvent.getDescription())) {
                        messagesParams.put(DESCRIPTION_UPDATED, newEvent.getDescription());
                    }
                    if (newEvent.getLocation() != null && !newEvent.getLocation().equals(oldEvent.getLocation())) {
                        messagesParams.put(LOCATION_UPDATED, newEvent.getLocation());
                    }
                    if (newEvent.getPriority() != null && !newEvent.getPriority().equals(oldEvent.getPriority())) {
                        messagesParams.put(PRIORITY_UPDATED, newEvent.getPriority());
                    }
                    if (newEvent.getAttachment() != null) {
                        if (oldEvent.getAttachment() == null) {
                            messagesParams.put(ATTACH_UPDATED, "");
                        } else if (newEvent.getAttachment().size() != oldEvent.getAttachment().size()) {
                            messagesParams.put(ATTACH_UPDATED, "");
                        }
                    }
                    if (this.isAllDayEvent(newEvent) && !this.isAllDayEvent(oldEvent) && CalendarEvent.TYPE_EVENT.equals(oldEvent.getEventType())) {
                        messagesParams.put(ALLDAY_UPDATED, "");
                    } else if (!this.isAllDayEvent(newEvent)) {
                        if (newEvent.getFromDateTime().compareTo(oldEvent.getFromDateTime()) != 0) {
                            messagesParams.put(FROM_UPDATED, String.valueOf(newEvent.getFromDateTime().getTime()));
                        }
                        if (newEvent.getToDateTime().compareTo(oldEvent.getToDateTime()) != 0) {
                            messagesParams.put(TO_UPDATED, String.valueOf(newEvent.getToDateTime().getTime()));
                        }
                    }
                    String repeatSummary = this.buildRepeatSummary(newEvent);
                    if (!repeatSummary.equals(this.buildRepeatSummary(oldEvent))) {
                        messagesParams.put(REPEAT_UPDATED, repeatSummary);
                    }
                    if (!newEvent.getActivityId().equals(oldEvent.getActivityId())) {
                        messagesParams.put(REPEAT_EVENT_INSTANCE_REMOVED, this.getDateFormattedAfterUserSetting(oldEvent.getRecurrenceId()));
                    }
                } else {
                    if (!oldEvent.getSummary().equals(newEvent.getSummary())) {
                        messagesParams.put(NAME_UPDATED, newEvent.getSummary());
                    }
                    if (newEvent.getDescription() != null && !newEvent.getDescription().equals(oldEvent.getDescription())) {
                        messagesParams.put(NOTE_UPDATED, newEvent.getDescription());
                    }
                    if (!this.isAllDayEvent(newEvent)) {
                        if (newEvent.getFromDateTime().compareTo(oldEvent.getFromDateTime()) != 0) {
                            messagesParams.put(FROM_UPDATED, String.valueOf(newEvent.getFromDateTime().getTime()));
                        }
                        if (newEvent.getToDateTime().compareTo(oldEvent.getToDateTime()) != 0) {
                            messagesParams.put(TO_UPDATED, String.valueOf(newEvent.getToDateTime().getTime()));
                        }
                    }
                    if (newEvent.getPriority() != null && !newEvent.getPriority().equals(oldEvent.getPriority())) {
                        messagesParams.put(PRIORITY_UPDATED, newEvent.getPriority());
                    }
                    if (newEvent.getAttachment() != null) {
                        if (oldEvent.getAttachment() == null) {
                            messagesParams.put(TASK_ATTACH_UPDATED, "");
                        } else if (newEvent.getAttachment().size() != oldEvent.getAttachment().size()) {
                            messagesParams.put(TASK_ATTACH_UPDATED, "");
                        }
                    }
                    if (newEvent.getEventState() != null && !newEvent.getEventState().equals(oldEvent.getEventState())) {
                        if (CalendarEvent.NEEDS_ACTION.equals(newEvent.getEventState())) {
                            messagesParams.put(TASK_NEED_ACTION, newEvent.getEventState());
                        } else if (CalendarEvent.IN_PROCESS.equals(newEvent.getEventState())) {
                            messagesParams.put(TASK_IN_PROCESS_ACTION, newEvent.getEventState());
                        } else if (CalendarEvent.COMPLETED.equals(newEvent.getEventState())) {
                            messagesParams.put(TASK_COMPLETED_ACTION, newEvent.getEventState());
                        } else if (CalendarEvent.CANCELLED.equals(newEvent.getEventState())) {
                            messagesParams.put(TASK_CANCELLED_ACTION, newEvent.getEventState());
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block37;
                LOG.error((Object)"Can not build message for space when event updated ", (Throwable)e);
            }
        }
        return messagesParams;
    }

    private String getDateFormattedAfterUserSetting(String date) {
        try {
            String userId = ConversationState.getCurrent().getIdentity().getUserId();
            this.calService_ = (CalendarService)PortalContainer.getInstance().getComponentInstance(CalendarService.class);
            CalendarSetting calSetting = this.calService_.getCalendarSetting(userId);
            WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            Locale locale = requestContext.getParentAppRequestContext().getLocale();
            SimpleDateFormat format = new SimpleDateFormat(calSetting.getDateFormat(), locale);
            SimpleDateFormat format1 = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            Date eventDate = format1.parse(date);
            return format.format(eventDate);
        }
        catch (Exception e) {
            LOG.debug((Object)e.getMessage());
            return null;
        }
    }

    public String buildRepeatSummary(CalendarEvent repeatEvent) {
        if (repeatEvent == null) {
            return "";
        }
        String repeatType = repeatEvent.getRepeatType();
        if (CalendarEvent.RP_NOREPEAT.equals(repeatType) || repeatType == null) {
            return "";
        }
        try {
            String userId = ConversationState.getCurrent().getIdentity().getUserId();
            this.calService_ = (CalendarService)PortalContainer.getInstance().getComponentInstance(CalendarService.class);
            CalendarSetting calSetting = this.calService_.getCalendarSetting(userId);
            WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            Locale locale = requestContext.getParentAppRequestContext().getLocale();
            SimpleDateFormat format = new SimpleDateFormat(calSetting.getDateFormat(), locale);
            DateFormatSymbols symbols = new DateFormatSymbols(locale);
            String[] dayOfWeeks = symbols.getWeekdays();
            int interval = (int)repeatEvent.getRepeatInterval();
            int count = (int)repeatEvent.getRepeatCount();
            Date until = repeatEvent.getRepeatUntilDate();
            String endType = RP_END_NEVER;
            if (count > 0) {
                endType = RP_END_AFTER;
            }
            if (until != null) {
                endType = RP_END_BYDATE;
            }
            StringBuilder pattern = new StringBuilder("");
            if (repeatType.equals(CalendarEvent.RP_DAILY)) {
                if (interval == 1) {
                    pattern.append(CalendarUIActivity.getUICalendarLabel("daily"));
                } else {
                    pattern.append(CalendarUIActivity.getUICalendarLabel("every-day"));
                }
                if (endType.equals(RP_END_AFTER)) {
                    pattern.append(", " + CalendarUIActivity.getUICalendarLabel("count-times"));
                }
                if (endType.equals(RP_END_BYDATE)) {
                    pattern.append(", " + CalendarUIActivity.getUICalendarLabel("until"));
                }
                return new String(pattern).replace("{interval}", String.valueOf(interval)).replace("{count}", String.valueOf(repeatEvent.getRepeatCount())).replace("{until}", repeatEvent.getRepeatUntilDate() == null ? "" : format.format(repeatEvent.getRepeatUntilDate()));
            }
            if (repeatType.equals(CalendarEvent.RP_WEEKLY)) {
                if (interval == 1) {
                    pattern.append(CalendarUIActivity.getUICalendarLabel("weekly"));
                } else {
                    pattern.append(CalendarUIActivity.getUICalendarLabel("every-week"));
                }
                if (endType.equals(RP_END_AFTER)) {
                    pattern.append(", " + CalendarUIActivity.getUICalendarLabel("count-times"));
                }
                if (endType.equals(RP_END_BYDATE)) {
                    pattern.append(", " + CalendarUIActivity.getUICalendarLabel("until"));
                }
                String[] weeklyByDays = repeatEvent.getRepeatByDay();
                StringBuffer byDays = new StringBuffer();
                for (int i = 0; i < weeklyByDays.length; ++i) {
                    if (i == 0) {
                        byDays.append(dayOfWeeks[CalendarSpaceActivityPublisher.convertToDayOfWeek(weeklyByDays[0])]);
                        continue;
                    }
                    byDays.append(", ");
                    byDays.append(dayOfWeeks[CalendarSpaceActivityPublisher.convertToDayOfWeek(weeklyByDays[i])]);
                }
                return new String(pattern).replace("{interval}", String.valueOf(interval)).replace("{count}", String.valueOf(repeatEvent.getRepeatCount())).replace("{until}", repeatEvent.getRepeatUntilDate() == null ? "" : format.format(repeatEvent.getRepeatUntilDate())).replace("{byDays}", byDays.toString());
            }
            if (repeatType.equals(CalendarEvent.RP_MONTHLY)) {
                String monthlyType = RP_MONTHLY_BYMONTHDAY;
                if (repeatEvent.getRepeatByDay() != null && repeatEvent.getRepeatByDay().length > 0) {
                    monthlyType = RP_MONTHLY_BYDAY;
                }
                if (interval == 1) {
                    pattern.append(CalendarUIActivity.getUICalendarLabel("monthly"));
                } else {
                    pattern.append(CalendarUIActivity.getUICalendarLabel("every-month"));
                }
                if (monthlyType.equals(RP_MONTHLY_BYDAY)) {
                    pattern.append(" " + CalendarUIActivity.getUICalendarLabel("monthly-by-day"));
                } else {
                    pattern.append(" " + CalendarUIActivity.getUICalendarLabel("monthly-by-month-day"));
                }
                if (endType.equals(RP_END_AFTER)) {
                    pattern.append(", " + CalendarUIActivity.getUICalendarLabel("count-times"));
                }
                if (endType.equals(RP_END_BYDATE)) {
                    pattern.append(", " + CalendarUIActivity.getUICalendarLabel("until"));
                }
                String theNumber = "";
                String theDay = "";
                if (monthlyType.equals(RP_MONTHLY_BYDAY)) {
                    Calendar temp = CalendarSpaceActivityPublisher.getCalendarInstanceBySetting(calSetting);
                    temp.setTime(repeatEvent.getFromDateTime());
                    int weekOfMonth = temp.get(4);
                    Calendar temp2 = CalendarSpaceActivityPublisher.getCalendarInstanceBySetting(calSetting);
                    temp2.setTime(temp.getTime());
                    temp2.add(5, 7);
                    if (temp2.get(2) != temp.get(2)) {
                        weekOfMonth = 5;
                    }
                    int dayOfWeek = temp.get(7);
                    String[] weekOfMonths = new String[]{CalendarUIActivity.getUICalendarLabel("summary-the-first"), CalendarUIActivity.getUICalendarLabel("summary-the-second"), CalendarUIActivity.getUICalendarLabel("summary-the-third"), CalendarUIActivity.getUICalendarLabel("summary-the-fourth"), CalendarUIActivity.getUICalendarLabel("summary-the-last")};
                    theNumber = weekOfMonths[weekOfMonth - 1];
                    theDay = dayOfWeeks[dayOfWeek];
                } else {
                    Calendar temp = CalendarSpaceActivityPublisher.getCalendarInstanceBySetting(calSetting);
                    temp.setTime(repeatEvent.getFromDateTime());
                    int dayOfMonth = temp.get(5);
                    theDay = String.valueOf(dayOfMonth);
                }
                return new String(pattern).replace("{interval}", String.valueOf(interval)).replace("{count}", String.valueOf(repeatEvent.getRepeatCount())).replace("{until}", repeatEvent.getRepeatUntilDate() == null ? "" : format.format(repeatEvent.getRepeatUntilDate())).replace("{theDay}", theDay).replace("{theNumber}", theNumber);
            }
            if (repeatType.equals(CalendarEvent.RP_YEARLY)) {
                if (interval == 1) {
                    pattern.append(CalendarUIActivity.getUICalendarLabel("yearly"));
                } else {
                    pattern.append(CalendarUIActivity.getUICalendarLabel("every-year"));
                }
                if (endType.equals(RP_END_AFTER)) {
                    pattern.append(", " + CalendarUIActivity.getUICalendarLabel("count-times"));
                }
                if (endType.equals(RP_END_BYDATE)) {
                    pattern.append(", " + CalendarUIActivity.getUICalendarLabel("until"));
                }
                String theDay = format.format(repeatEvent.getFromDateTime());
                return new String(pattern).replace("{interval}", String.valueOf(interval)).replace("{count}", String.valueOf(repeatEvent.getRepeatCount())).replace("{until}", repeatEvent.getRepeatUntilDate() == null ? "" : format.format(repeatEvent.getRepeatUntilDate())).replace("{theDay}", theDay);
            }
        }
        catch (Exception e) {
            LOG.info((Object)e.getLocalizedMessage());
        }
        return null;
    }

    public static int convertToDayOfWeek(String day) {
        int dayOfWeek = day.equals("MO") ? 2 : (day.equals("TU") ? 3 : (day.equals("WE") ? 4 : (day.equals("TH") ? 5 : (day.equals("FR") ? 6 : (day.equals("SA") ? 7 : (day.equals("SU") ? 1 : 0))))));
        return dayOfWeek;
    }

    public static Calendar getCalendarInstanceBySetting(CalendarSetting calendarSetting) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        calendar.setTimeZone(TimeZone.getTimeZone(calendarSetting.getTimeZone()));
        calendar.setFirstDayOfWeek(Integer.parseInt(calendarSetting.getWeekStartOn()));
        calendar.setMinimalDaysInFirstWeek(4);
        return calendar;
    }

    private boolean isAllDayEvent(CalendarEvent eventCalendar) {
        try {
            TimeZone tz = this.getUserTimeZone();
            GregorianCalendar cal1 = new GregorianCalendar(tz);
            GregorianCalendar cal2 = new GregorianCalendar(tz);
            cal1.setLenient(false);
            cal1.setTime(eventCalendar.getFromDateTime());
            cal2.setLenient(false);
            cal2.setTime(eventCalendar.getToDateTime());
            return cal1.get(11) == 0 && cal1.get(12) == 0 && cal2.get(11) == ((Calendar)cal2).getActualMaximum(11) && cal2.get(12) == ((Calendar)cal2).getActualMaximum(12);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)"Can not check all day event when event updated ", (Throwable)e);
            }
            return false;
        }
    }

    private TimeZone getUserTimeZone() {
        try {
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            CalendarService calService = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
            CalendarSetting setting = calService.getCalendarSetting(username);
            return TimeZone.getTimeZone(setting.getTimeZone());
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)"Can not get time zone from user setting ", (Throwable)e);
            }
            return null;
        }
    }

    public void savePublicEvent(CalendarEvent event, String calendarId) {
        String eventType = event.getEventType().equalsIgnoreCase(CalendarEvent.TYPE_EVENT) ? EVENT_ADDED : TASK_ADDED;
        this.publishActivity(event, calendarId, eventType);
    }

    public void updatePublicEvent(CalendarEvent oldEvent, CalendarEvent newEvent, String calendarId) {
        String eventType = newEvent.getEventType().equalsIgnoreCase(CalendarEvent.TYPE_EVENT) ? EVENT_ADDED : TASK_ADDED;
        Map<String, String> messagesParams = this.buildParams(oldEvent, newEvent);
        if (messagesParams.size() > 0) {
            this.updateToActivity(newEvent, calendarId, eventType, messagesParams);
        }
    }

    public void updatePublicEvent(CalendarEvent newEvent, String calendarId) {
        String eventType = newEvent.getEventType().equalsIgnoreCase(CalendarEvent.TYPE_EVENT) ? EVENT_ADDED : TASK_ADDED;
        this.publishActivity(newEvent, calendarId, eventType);
    }

    public void deletePublicEvent(CalendarEvent event, String calendarId) {
        String eventType = event.getEventType().equalsIgnoreCase(CalendarEvent.TYPE_EVENT) ? EVENT_ADDED : TASK_ADDED;
        this.deleteActivity(event, calendarId, eventType);
    }
}

