/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.portlet.PortletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.friendly.FriendlyService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.SpaceStorageException;
import org.exoplatform.social.plugin.doc.UIDocViewer;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.social.webui.composer.PopupContainer;
import org.exoplatform.wcm.ext.component.activity.listener.Utils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/ecm/social-integration/plugin/space/FileUIActivity.gtmpl", events={@EventConfig(listeners={ViewDocumentActionListener.class}), @EventConfig(listeners={BaseUIActivity.LoadLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class})})
public class FileUIActivity
extends BaseUIActivity {
    private static final String NEW_DATE_FORMAT = "hh:mm:ss MMM d, yyyy";
    private static final Log LOG = ExoLogger.getLogger(FileUIActivity.class);
    public static final String ACTIVITY_TYPE = "CONTENT_ACTIVITY";
    public static final String ID = "id";
    public static final String CONTENT_LINK = "contenLink";
    public static final String MESSAGE = "message";
    public static final String REPOSITORY = "repository";
    public static final String WORKSPACE = "workspace";
    public static final String CONTENT_NAME = "contentName";
    public static final String IMAGE_PATH = "imagePath";
    public static final String MIME_TYPE = "mimeType";
    public static final String STATE = "state";
    public static final String AUTHOR = "author";
    public static final String DATE_CREATED = "dateCreated";
    public static final String LAST_MODIFIED = "lastModified";
    public static final String DOCUMENT_TYPE_LABEL = "docTypeLabel";
    public static final String DOCUMENT_TITLE = "docTitle";
    public static final String DOCUMENT_VERSION = "docVersion";
    public static final String DOCUMENT_SUMMARY = "docSummary";
    public static final String IS_SYSTEM_COMMENT = "isSystemComment";
    public static final String SYSTEM_COMMENT = "systemComment";
    private String contentLink;
    private String message;
    private String contentName;
    private String imagePath;
    private String mimeType;
    private String nodeUUID;
    private String state;
    private String author;
    private String dateCreated;
    private String lastModified;
    private Node contentNode;
    private NodeLocation nodeLocation;
    private String docTypeName;
    private String docTitle;
    private String docVersion;
    private String docSummary;
    public String docPath;
    public String repository;
    public String workspace;

    public String getContentLink() {
        return this.contentLink;
    }

    public void setContentLink(String contentLink) {
        this.contentLink = contentLink;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getContentName() {
        return this.contentName;
    }

    public void setContentName(String contentName) {
        this.contentName = contentName;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getNodeUUID() {
        return this.nodeUUID;
    }

    public void setNodeUUID(String nodeUUID) {
        this.nodeUUID = nodeUUID;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getDocTypeName() {
        return this.docTypeName;
    }

    public String getDocTitle() {
        return this.docTitle;
    }

    public String getDocVersion() {
        return this.docVersion;
    }

    public String getDocSummary() {
        return this.docSummary;
    }

    public String getTitle(Node node) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getTitle((Node)node);
    }

    private String convertDateFormat(String strDate, String strOldFormat, String strNewFormat) throws ParseException {
        if (strDate == null || strDate.length() <= 0) {
            return "";
        }
        Locale locale = Util.getPortalRequestContext().getLocale();
        SimpleDateFormat sdfSource = new SimpleDateFormat(strOldFormat);
        SimpleDateFormat sdfDestination = new SimpleDateFormat(strNewFormat, locale);
        Date date = sdfSource.parse(strDate);
        return sdfDestination.format(date);
    }

    public String getDateCreated() throws ParseException {
        return this.convertDateFormat(this.dateCreated, "yyyy-MM-dd'T'HH:mm:ss", NEW_DATE_FORMAT);
    }

    public void setDateCreated(String dateCreated) {
        this.dateCreated = dateCreated;
    }

    public String getLastModified() throws ParseException {
        return this.convertDateFormat(this.lastModified, "yyyy-MM-dd'T'HH:mm:ss", NEW_DATE_FORMAT);
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public Node getContentNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.nodeLocation);
    }

    public void setContentNode(Node contentNode) {
        this.nodeLocation = NodeLocation.getNodeLocationByNode((Node)contentNode);
    }

    public NodeLocation getNodeLocation() {
        return this.nodeLocation;
    }

    public void setNodeLocation(NodeLocation nodeLocation) {
        this.nodeLocation = nodeLocation;
    }

    public String getSummary(Node node) {
        return Utils.getSummary(node);
    }

    public String getDocumentSummary(Map<String, String> activityParams) {
        return activityParams.get(DOCUMENT_SUMMARY);
    }

    public String getUserFullName(String userId) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityManager identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        return identityManager.getOrCreateIdentity("organization", userId, true).getProfile().getFullName();
    }

    protected String getSize(Node node) {
        double size = 0.0;
        try {
            if (node.hasNode("jcr:content")) {
                Node contentNode = node.getNode("jcr:content");
                if (contentNode.hasProperty("jcr:data")) {
                    size = contentNode.getProperty("jcr:data").getLength();
                }
                return FileUtils.byteCountToDisplaySize((long)((long)size));
            }
        }
        catch (PathNotFoundException e) {
            return "";
        }
        catch (ValueFormatException e) {
            return "";
        }
        catch (RepositoryException e) {
            return "";
        }
        catch (NullPointerException e) {
            return "";
        }
        return "";
    }

    protected double getFileSize(Node node) {
        double fileSize = 0.0;
        try {
            Node contentNode;
            if (node.hasNode("jcr:content") && (contentNode = node.getNode("jcr:content")).hasProperty("jcr:data")) {
                fileSize = contentNode.getProperty("jcr:data").getLength();
            }
        }
        catch (Exception ex) {
            fileSize = 0.0;
        }
        return fileSize;
    }

    protected int getImageWidth(Node node) {
        int imageWidth = 0;
        try {
            if (node.hasNode("jcr:content")) {
                node = node.getNode("jcr:content");
            }
            ImageReader reader = ImageIO.getImageReadersByMIMEType(this.mimeType).next();
            ImageInputStream iis = ImageIO.createImageInputStream(node.getProperty("jcr:data").getStream());
            reader.setInput(iis, true);
            imageWidth = reader.getWidth(0);
            iis.close();
            reader.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imageWidth;
    }

    protected int getImageHeight(Node node) {
        int imageHeight = 0;
        try {
            if (node.hasNode("jcr:content")) {
                node = node.getNode("jcr:content");
            }
            ImageReader reader = ImageIO.getImageReadersByMIMEType(this.mimeType).next();
            ImageInputStream iis = ImageIO.createImageInputStream(node.getProperty("jcr:data").getStream());
            reader.setInput(iis, true);
            imageHeight = reader.getHeight(0);
            iis.close();
            reader.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imageHeight;
    }

    protected int getVersion(Node node) {
        String currentVersion = null;
        try {
            currentVersion = this.contentNode.getBaseVersion().getName();
            if (currentVersion.contains("jcr:rootVersion")) {
                currentVersion = "0";
            }
        }
        catch (Exception e) {
            currentVersion = "0";
        }
        return Integer.parseInt(currentVersion);
    }

    public String getUserProfileUri(String userId) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityManager identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        return identityManager.getOrCreateIdentity("organization", userId, true).getProfile().getUrl();
    }

    public String getUserAvatarImageSource(String userId) {
        return this.getOwnerIdentity().getProfile().getAvatarUrl();
    }

    public String getSpaceAvatarImageSource(String spaceIdentityId) {
        try {
            String spaceId = this.getOwnerIdentity().getRemoteId();
            SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
            Space space = spaceService.getSpaceById(spaceId);
            if (space != null) {
                return space.getAvatarUrl();
            }
        }
        catch (SpaceStorageException e) {
            LOG.warn((Object)("Failed to getSpaceById: " + spaceIdentityId), (Throwable)e);
        }
        return null;
    }

    public void setUIActivityData(Map<String, String> activityParams) {
        this.contentLink = activityParams.get(CONTENT_LINK);
        this.nodeUUID = activityParams.get(ID);
        this.state = activityParams.get(STATE);
        this.author = activityParams.get(AUTHOR);
        this.dateCreated = activityParams.get(DATE_CREATED);
        this.lastModified = activityParams.get(LAST_MODIFIED);
        this.contentName = activityParams.get(CONTENT_NAME);
        this.message = activityParams.get(MESSAGE);
        this.mimeType = activityParams.get(MIME_TYPE);
        this.imagePath = activityParams.get(IMAGE_PATH);
        this.docTypeName = activityParams.get(DOCUMENT_TYPE_LABEL);
        this.docTitle = activityParams.get(DOCUMENT_TITLE);
        this.docVersion = activityParams.get(DOCUMENT_VERSION);
        this.docSummary = activityParams.get(DOCUMENT_SUMMARY);
    }

    public String getWebdavURL() throws Exception {
        this.contentNode = this.getContentNode();
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest portletRequest = portletRequestContext.getRequest();
        String repository = this.nodeLocation.getRepository();
        String workspace = this.nodeLocation.getWorkspace();
        String baseURI = portletRequest.getScheme() + "://" + portletRequest.getServerName() + ":" + String.format("%s", portletRequest.getServerPort());
        FriendlyService friendlyService = (FriendlyService)WCMCoreUtils.getService(FriendlyService.class);
        String link = "#";
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        if (this.contentNode.isNodeType("nt:frozenNode")) {
            String uuid = this.contentNode.getProperty("jcr:frozenUuid").getString();
            Node originalNode = this.contentNode.getSession().getNodeByUUID(uuid);
            link = baseURI + "/" + portalName + "/" + restContextName + "/jcr/" + repository + "/" + workspace + originalNode.getPath() + "?version=" + this.contentNode.getParent().getName();
        } else {
            link = baseURI + "/" + portalName + "/" + restContextName + "/jcr/" + repository + "/" + workspace + this.contentNode.getPath();
        }
        return friendlyService.getFriendlyUri(link);
    }

    public String[] getSystemCommentBundle(Map<String, String> activityParams) {
        if (activityParams == null) {
            return null;
        }
        String tmp = activityParams.get(IS_SYSTEM_COMMENT);
        if (tmp == null) {
            return null;
        }
        try {
            String commentMessage;
            if (Boolean.parseBoolean(tmp) && !StringUtils.isEmpty((String)(commentMessage = activityParams.get(MESSAGE)))) {
                if (commentMessage.indexOf(ActivityCommonService.VALUE_SEPERATOR) >= 0) {
                    String[] result = commentMessage.split(ActivityCommonService.VALUE_SEPERATOR);
                    return result;
                }
                return new String[]{commentMessage};
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public String[] getSystemCommentTitle(Map<String, String> activityParams) {
        if (activityParams == null) {
            return null;
        }
        String commentValue = activityParams.get(SYSTEM_COMMENT);
        if (!StringUtils.isEmpty((String)commentValue)) {
            if (commentValue.indexOf(ActivityCommonService.VALUE_SEPERATOR) >= 0) {
                String[] result = commentValue.split(ActivityCommonService.VALUE_SEPERATOR);
                return result;
            }
            return new String[]{commentValue};
        }
        return null;
    }

    public String getViewLink() {
        try {
            return org.exoplatform.wcm.webui.Utils.getEditLink((Node)this.getContentNode(), (boolean)false, (boolean)false);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getEditLink() {
        try {
            return org.exoplatform.wcm.webui.Utils.getEditLink((Node)this.getContentNode(), (boolean)true, (boolean)false);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getActivityEditLink() {
        try {
            return org.exoplatform.wcm.webui.Utils.getActivityEditLink((Node)this.getContentNode());
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getDownloadLink() {
        try {
            return org.exoplatform.wcm.webui.Utils.getDownloadLink((Node)this.getContentNode());
        }
        catch (Exception e) {
            return "";
        }
    }

    public static class DownloadDocumentActionListener
    extends EventListener<FileUIActivity> {
        public void execute(Event<FileUIActivity> event) throws Exception {
            FileUIActivity uiComp = (FileUIActivity)((Object)event.getSource());
            String downloadLink = null;
            if (this.getRealNode(uiComp.getContentNode()).getPrimaryNodeType().getName().equals("nt:file")) {
                downloadLink = org.exoplatform.ecm.webui.utils.Utils.getDownloadRestServiceLink((Node)uiComp.getContentNode());
            }
            event.getRequestContext().getJavascriptManager().addJavascript((CharSequence)("ajaxRedirect('" + downloadLink + "');"));
        }

        private Node getRealNode(Node node) throws Exception {
            if (node.isNodeType("nt:frozenNode")) {
                String uuid = node.getProperty("jcr:frozenUuid").getString();
                return node.getSession().getNodeByUUID(uuid);
            }
            return node;
        }
    }

    public static class ViewDocumentActionListener
    extends EventListener<FileUIActivity> {
        public void execute(Event<FileUIActivity> event) throws Exception {
            FileUIActivity docActivity = (FileUIActivity)((Object)event.getSource());
            UIActivitiesContainer activitiesContainer = (UIActivitiesContainer)docActivity.getParent();
            PopupContainer popupContainer = activitiesContainer.getPopupContainer();
            UIDocViewer docViewer = (UIDocViewer)popupContainer.createUIComponent(UIDocViewer.class, null, "DocViewer");
            docViewer.docPath = docActivity.docPath;
            docViewer.repository = docActivity.repository;
            docViewer.workspace = docActivity.workspace;
            Node docNode = docActivity.getContentNode();
            docViewer.setOriginalNode(docNode);
            docViewer.setNode(docNode);
            popupContainer.activate((UIComponent)docViewer, 800, 600, true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupContainer);
        }
    }
}

