/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity.listener;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Value;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.ext.component.activity.listener.Utils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;

public class FileUpdateActivityListener
extends Listener<Node, String> {
    private static final Log LOG = ExoLogger.getLogger(FileUpdateActivityListener.class);
    private String[] editedField = new String[]{"exo:title", "exo:summary", "exo:language", "dc:title", "dc:description", "dc:creator", "dc:source", "jcr:data"};
    private String[] bundleMessage = new String[]{"SocialIntegration.messages.editName", "SocialIntegration.messages.editSummary", "SocialIntegration.messages.editLanguage", "SocialIntegration.messages.editTitle", "SocialIntegration.messages.editDescription", "SocialIntegration.messages.singleCreator", "SocialIntegration.messages.addSource", "SocialIntegration.messages.editFile"};
    private String[] bundleRemoveMessage = new String[]{"SocialIntegration.messages.removeName", "SocialIntegration.messages.removeSummary", "SocialIntegration.messages.removeLanguage", "SocialIntegration.messages.removeTitle", "SocialIntegration.messages.removeDescription", "SocialIntegration.messages.removeCreator", "SocialIntegration.messages.addSource", "SocialIntegration.messages.editFile"};
    private boolean[] needUpdate = new boolean[]{true, true, false, true, true, false, false, true};
    private int consideredFieldCount = this.editedField.length;

    public void onEvent(Event<Node, String> event) throws Exception {
        CmsService cmsService = (CmsService)WCMCoreUtils.getService(CmsService.class);
        Map properties = cmsService.getPreProperties();
        Node currentNode = (Node)event.getSource();
        String nodeUUID = "";
        nodeUUID = currentNode.isNodeType("mix:referenceable") ? currentNode.getUUID() : currentNode.getName();
        String propertyName = (String)event.getData();
        String oldValue = "";
        String newValue = "";
        String commentValue = "";
        try {
            if (!propertyName.equals("jcr:data")) {
                if (currentNode.getProperty(propertyName).getDefinition().isMultiple()) {
                    Value[] values = currentNode.getProperty(propertyName).getValues();
                    if (values != null && values.length > 0) {
                        for (Value value : values) {
                            newValue = new StringBuffer(newValue).append(value.getString()).append(ActivityCommonService.METADATA_VALUE_SEPERATOR).toString();
                            commentValue = new StringBuffer(commentValue).append(value.getString()).append(", ").toString();
                        }
                        if (newValue.length() >= ActivityCommonService.METADATA_VALUE_SEPERATOR.length()) {
                            newValue = newValue.substring(0, newValue.length() - ActivityCommonService.METADATA_VALUE_SEPERATOR.length());
                        }
                        if (commentValue.length() >= 2) {
                            commentValue = commentValue.substring(0, commentValue.length() - 2);
                        }
                    }
                    if ((values = (Value[])properties.get(nodeUUID + "_" + propertyName)) != null && values.length > 0) {
                        for (Value value : values) {
                            oldValue = oldValue + value.getString() + ActivityCommonService.METADATA_VALUE_SEPERATOR;
                        }
                        if (oldValue.length() >= ActivityCommonService.METADATA_VALUE_SEPERATOR.length()) {
                            oldValue = oldValue.substring(0, oldValue.length() - ActivityCommonService.METADATA_VALUE_SEPERATOR.length());
                        }
                    }
                } else {
                    commentValue = newValue = currentNode.getProperty(propertyName).getString();
                    if (properties.containsKey(nodeUUID + "_" + propertyName)) {
                        oldValue = properties.get(nodeUUID + "_" + propertyName).toString();
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.info((Object)"Cannot get old value");
        }
        newValue = newValue.trim();
        oldValue = oldValue.trim();
        commentValue = commentValue.trim();
        if (currentNode.isNodeType("nt:resource")) {
            currentNode = currentNode.getParent();
        }
        String resourceBundle = "";
        boolean hit = false;
        for (int i = 0; i < this.consideredFieldCount; ++i) {
            if (!propertyName.equals(this.editedField[i])) continue;
            hit = true;
            if (newValue.length() > 0) {
                String itemsAdded;
                StringBuffer sb;
                int addedCount;
                int removedCount;
                String itemsRemoved;
                List<String> lstNew;
                resourceBundle = this.bundleMessage[i];
                if (propertyName.equals("dc:creator")) {
                    List<String> lstOld = Arrays.asList(oldValue.split(ActivityCommonService.METADATA_VALUE_SEPERATOR));
                    lstNew = Arrays.asList(newValue.split(ActivityCommonService.METADATA_VALUE_SEPERATOR));
                    itemsRemoved = "";
                    removedCount = 0;
                    addedCount = 0;
                    sb = new StringBuffer();
                    for (String item : lstOld) {
                        if (lstNew.contains(item)) continue;
                        sb.append(item).append(", ");
                        ++removedCount;
                    }
                    if (sb.length() > 0) {
                        itemsRemoved = sb.toString();
                        itemsRemoved = itemsRemoved.substring(0, itemsRemoved.length() - 2);
                    }
                    sb.delete(0, sb.length());
                    itemsAdded = "";
                    for (String item : lstNew) {
                        if (lstOld.contains(item)) continue;
                        sb.append(item).append(", ");
                        ++addedCount;
                    }
                    if (sb.length() > 0) {
                        itemsAdded = sb.toString();
                        itemsAdded = itemsAdded.substring(0, itemsAdded.length() - 2);
                    }
                    if (itemsRemoved.length() > 0 && itemsAdded.length() > 0) {
                        resourceBundle = removedCount > 1 ? "SocialIntegration.messages.removeMultiCreator" : "SocialIntegration.messages.removeCreator";
                        Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, itemsRemoved);
                        resourceBundle = lstNew.size() > 1 ? "SocialIntegration.messages.multiCreator" : "SocialIntegration.messages.singleCreator";
                        Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, commentValue);
                        break;
                    }
                    if (itemsRemoved.length() > 0) {
                        resourceBundle = removedCount > 1 ? "SocialIntegration.messages.removeMultiCreator" : "SocialIntegration.messages.removeCreator";
                        newValue = itemsRemoved;
                        Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, newValue);
                        break;
                    }
                    if (itemsAdded.length() > 0) {
                        resourceBundle = commentValue.split(",").length > 1 ? "SocialIntegration.messages.multiCreator" : "SocialIntegration.messages.singleCreator";
                        Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, commentValue);
                        break;
                    }
                }
                if (propertyName.equals("dc:source")) {
                    List<String> lstOld = Arrays.asList(oldValue.split(ActivityCommonService.METADATA_VALUE_SEPERATOR));
                    lstNew = Arrays.asList(newValue.split(ActivityCommonService.METADATA_VALUE_SEPERATOR));
                    itemsRemoved = "";
                    removedCount = 0;
                    addedCount = 0;
                    sb = new StringBuffer();
                    for (String item : lstOld) {
                        if (lstNew.contains(item)) continue;
                        sb.append(item).append(", ");
                        ++removedCount;
                    }
                    if (sb.length() > 0) {
                        itemsRemoved = sb.toString();
                        itemsRemoved = itemsRemoved.substring(0, itemsRemoved.length() - 2);
                    }
                    sb.delete(0, sb.length());
                    itemsAdded = "";
                    for (String item : lstNew) {
                        if (lstOld.contains(item)) continue;
                        sb.append(item).append(", ");
                        ++addedCount;
                    }
                    if (sb.length() > 0) {
                        itemsAdded = sb.toString();
                        itemsAdded = itemsAdded.substring(0, itemsAdded.length() - 2);
                    }
                    if (itemsRemoved.length() > 0 && itemsAdded.length() > 0) {
                        resourceBundle = removedCount > 1 ? "SocialIntegration.messages.removeMultiSource" : "SocialIntegration.messages.removeSource";
                        Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, itemsRemoved);
                        resourceBundle = addedCount > 1 ? "SocialIntegration.messages.addMultiSource" : "SocialIntegration.messages.addSource";
                        Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, itemsAdded);
                        break;
                    }
                    if (itemsRemoved.length() > 0) {
                        resourceBundle = removedCount > 1 ? "SocialIntegration.messages.removeMultiSource" : "SocialIntegration.messages.removeSource";
                        newValue = itemsRemoved;
                        Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, newValue);
                        break;
                    }
                    if (itemsAdded.length() > 0) {
                        resourceBundle = addedCount > 1 ? "SocialIntegration.messages.addMultiSource" : "SocialIntegration.messages.addSource";
                        newValue = itemsAdded;
                        Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, newValue);
                        break;
                    }
                }
                Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, commentValue);
                break;
            }
            if (propertyName.equals("exo:language")) break;
            resourceBundle = this.bundleRemoveMessage[i];
            if (propertyName.equals("dc:creator")) {
                resourceBundle = oldValue.split(ActivityCommonService.METADATA_VALUE_SEPERATOR).length > 1 ? "SocialIntegration.messages.removeMultiCreator" : "SocialIntegration.messages.removeCreator";
            } else if (propertyName.equals("dc:source")) {
                String string = resourceBundle = oldValue.split(ActivityCommonService.METADATA_VALUE_SEPERATOR).length > 1 ? "SocialIntegration.messages.removeMultiSource" : "SocialIntegration.messages.removeSource";
            }
            if (propertyName.equals("dc:source") || propertyName.equals("dc:creator")) {
                commentValue = oldValue.replaceAll(ActivityCommonService.METADATA_VALUE_SEPERATOR, ", ");
            }
            Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, commentValue);
            break;
        }
        if (!hit && propertyName.startsWith("dc:") && !propertyName.equals("dc:date")) {
            PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            String dcProperty = propertyName;
            try {
                dcProperty = portletRequestContext.getApplicationResourceBundle().getString("ElementSet.dialog.label." + propertyName.substring(propertyName.lastIndexOf(":") + 1, propertyName.length()));
            }
            catch (Exception ex) {
                LOG.info((Object)"Cannot get propertyName");
            }
            resourceBundle = newValue.length() > 0 ? "SocialIntegration.messages.updateMetadata" : "SocialIntegration.messages.removeMetadata";
            resourceBundle = portletRequestContext.getApplicationResourceBundle().getString(resourceBundle);
            resourceBundle = resourceBundle.replace("{0}", dcProperty);
            resourceBundle = resourceBundle.replace("{1}", commentValue);
            Utils.postFileActivity(currentNode, resourceBundle, false, true, commentValue);
        }
    }
}

