/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.document.service;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.ecm.utils.permission.PermissionUtil;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.wcm.ext.component.activity.listener.Utils;
import org.exoplatform.wcm.ext.component.document.service.IShareDocumentService;
import org.picocontainer.Startable;

public class ShareDocumentService
implements IShareDocumentService,
Startable {
    private static final Log LOG = ExoLogger.getLogger(ShareDocumentService.class);
    public static final String MIX_PRIVILEGEABLE = "exo:privilegeable";
    private RepositoryService repoService;
    private SessionProviderService sessionProviderService;
    private LinkManager linkManager;

    public ShareDocumentService(RepositoryService _repoService, LinkManager _linkManager, SessionProviderService _sessionProviderService) {
        this.repoService = _repoService;
        this.sessionProviderService = _sessionProviderService;
        this.linkManager = _linkManager;
    }

    @Override
    public String publicDocumentToSpace(String space, Node currentNode, String comment, String perm) {
        block13: {
            Node rootSpace = null;
            Node shared = null;
            try {
                String tempPerms;
                SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
                ManageableRepository repository = this.repoService.getCurrentRepository();
                Session session = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
                NodeHierarchyCreator nodeCreator = (NodeHierarchyCreator)WCMCoreUtils.getService(NodeHierarchyCreator.class);
                nodeCreator.getJcrPath("groupsPath");
                rootSpace = (Node)session.getItem(nodeCreator.getJcrPath("groupsPath") + space);
                rootSpace = rootSpace.getNode("Documents");
                shared = !rootSpace.hasNode("Shared") ? rootSpace.addNode("Shared") : rootSpace.getNode("Shared");
                if (currentNode.isNodeType("exo:symlink")) {
                    currentNode = this.linkManager.getTarget(currentNode);
                }
                if (!(tempPerms = perm.toString()).equals("read")) {
                    tempPerms = "read,add_node,set_property";
                }
                if (PermissionUtil.canChangePermission((Node)currentNode)) {
                    if (!currentNode.getPath().contains(space)) {
                        this.setPermission(currentNode, space, tempPerms.split(","));
                    }
                } else if (PermissionUtil.canRead((Node)currentNode)) {
                    SessionProvider systemSessionProvider = SessionProvider.createSystemProvider();
                    Session systemSession = systemSessionProvider.getSession(session.getWorkspace().getName(), repository);
                    Node _node = (Node)systemSession.getItem(currentNode.getPath());
                    this.setPermission(_node, space, tempPerms.split(","));
                }
                currentNode.getSession().save();
                Node link = this.linkManager.createLink(shared, currentNode);
                rootSpace.save();
                try {
                    ExoSocialActivity activity = null;
                    activity = currentNode.getPrimaryNodeType().getName().equals("nt:file") ? Utils.createShareActivity(link, "", "sharefiles:spaces", comment) : Utils.createShareActivity(link, "", "sharecontents:spaces", comment);
                    link.save();
                    return activity.getId();
                }
                catch (Exception e1) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                }
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block13;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return "";
    }

    private String getMimeType(Node node) {
        block3: {
            try {
                if (node.getPrimaryNodeType().getName().equals("nt:file") && node.hasNode("jcr:content")) {
                    return node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return "";
    }

    private void setPermission(Node currentNode, String memberShip, String[] permissions) throws Exception {
        ExtendedNode node = (ExtendedNode)currentNode;
        if (node.canAddMixin(MIX_PRIVILEGEABLE)) {
            node.addMixin(MIX_PRIVILEGEABLE);
        }
        node.setPermission("*:" + memberShip, permissions);
        node.save();
    }

    public void start() {
    }

    public void stop() {
    }
}

