/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.utils.permission.PermissionUtil;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIWhoHasAccess;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wcm.ext.component.document.service.IShareDocumentService;
import org.exoplatform.wcm.notification.plugin.ShareFileToSpacePlugin;
import org.exoplatform.wcm.notification.plugin.ShareFileToUserPlugin;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.cssfile.CssClassManager;
import org.exoplatform.webui.cssfile.CssClassUtils;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/ecm/social-integration/share-document/UIShareDocuments.gtmpl", events={@EventConfig(listeners={ConfirmActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={TextChangeActionListener.class}), @EventConfig(listeners={ChangeActionListener.class}), @EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={ChangePermissionActionListener.class})})
public class UIShareDocuments
extends UIForm
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getLogger(UIShareDocuments.class);
    private static final String SHARECONTENT_BUNDLE_LOCATION = "locale.extension.SocialIntegration";
    private static final String SHARE_OPTION_CANVEW = "UIShareDocuments.label.option.read";
    private static final String SHARE_OPTION_CANMODIFY = "UIShareDocuments.label.option.modify";
    private static final String SHARE_PERMISSION_VIEW = "read";
    private static final String SHARE_PERMISSION_MODIFY = "modify";
    private static final String SPACE_PREFIX1 = "space::";
    private static final String SPACE_PREFIX2 = "*:/spaces/";
    private static final String LOGIN_INITIALURI = "/login?initialURI=/";
    private String permission = "read";
    private boolean permDropDown = false;
    private String nodePath;
    List<String> entries = new ArrayList<String>();
    public String comment = "";
    private NodeLocation node;
    private static final String USER_SUGGESTER = "userSuggester";
    private Map<String, String> permissions;

    public boolean hasPermissionDropDown() {
        return this.permDropDown;
    }

    public void setPermissionDropDown(boolean permDropDown) {
        this.permDropDown = permDropDown;
    }

    public void removePermission(String id) {
        this.permissions.remove(id);
        if (this.entries.contains(id)) {
            this.entries.remove(id);
        }
    }

    public void updatePermission(String id, String permission) {
        this.permissions.put(id, permission);
    }

    public boolean isGroupType(String name) {
        return name != null && name.startsWith("*:/") && !name.startsWith(SPACE_PREFIX2);
    }

    public static String getPortalLoginRedirectURL() {
        String portal = PortalContainer.getCurrentPortalContainerName();
        return new StringBuffer(CommonsUtils.getCurrentDomain()).append("/").append(portal).append(LOGIN_INITIALURI).append(portal).append("/").toString();
    }

    private void setPermission(String permission) {
        this.permission = permission;
    }

    private String getPermission() {
        return this.permission;
    }

    private static boolean isExisting(String name) {
        if (name.contains(SPACE_PREFIX1)) {
            SpaceService service = (SpaceService)WCMCoreUtils.getService(SpaceService.class);
            return service.getSpaceByPrettyName(name.split("::")[1]) != null;
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityManager identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        return identityManager.getOrCreateIdentity("organization", name, true) != null;
    }

    private boolean hasPermission(String name, String permission) {
        if (this.permissions.containsKey(name)) {
            return this.permissions.get(name).equals(permission);
        }
        return false;
    }

    public String getValue() {
        return (String)this.getUIStringInput(USER_SUGGESTER).getValue();
    }

    public void init() {
        block4: {
            try {
                this.addChild(UIWhoHasAccess.class, null, null);
                ((UIWhoHasAccess)this.getChild(UIWhoHasAccess.class)).init();
                this.addChild((UIComponent)new UIFormTextAreaInput("textAreaInput", "textAreaInput", ""));
                ExtendedNode currentNode = this.getNode();
                ResourceBundleService resourceBundleService = (ResourceBundleService)WCMCoreUtils.getService(ResourceBundleService.class);
                ResourceBundle resourceBundle = resourceBundleService.getResourceBundle(SHARECONTENT_BUNDLE_LOCATION, Util.getPortalRequestContext().getLocale());
                String canView = resourceBundle.getString(SHARE_OPTION_CANVEW);
                String canModify = resourceBundle.getString(SHARE_OPTION_CANMODIFY);
                ArrayList itemOptions = new ArrayList();
                if (PermissionUtil.canSetProperty((Node)currentNode)) {
                    this.setPermissionDropDown(true);
                } else {
                    this.setPermissionDropDown(false);
                }
                this.addUIFormInput((UIFormInput)new UIFormStringInput(USER_SUGGESTER, null, null));
                this.permissions = this.getAllPermissions();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getDocumentName() {
        String[] arr = this.nodePath.split("/");
        return arr[arr.length - 1];
    }

    public ExtendedNode getNode() {
        ExtendedNode node = (ExtendedNode)NodeLocation.getNodeByLocation((NodeLocation)this.node);
        try {
            if (node.isNodeType("exo:symlink") && node.hasProperty("exo:uuid")) {
                LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
                return (ExtendedNode)linkManager.getTarget((Node)node);
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return node;
    }

    public String getIconURL() {
        try {
            return Utils.getNodeTypeIcon((Node)this.getNode(), (String)"uiIcon24x24");
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public void setSelectedNode(NodeLocation node) {
        this.node = node;
        this.nodePath = node.getPath();
    }

    public Set<String> getWhoHasAccess() {
        HashSet<String> set = new HashSet<String>();
        try {
            for (AccessControlEntry t : this.getNode().getACL().getPermissionEntries()) {
                set.add(t.getIdentity());
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return set;
    }

    public boolean canEdit(String username) {
        try {
            AccessControlList controlList = this.getNode().getACL();
            return controlList.getPermissions(username).contains("add_node") && controlList.getPermissions(username).contains("set_property");
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean canEdit(Identity identity) {
        try {
            AccessManager accessManager = ((SessionImpl)this.getNode().getSession()).getAccessManager();
            return accessManager.hasPermission(this.getNode().getACL(), new String[]{"add_node", "set_property"}, identity);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public String getPermission(String name) {
        return this.canEdit(name) ? SHARE_PERMISSION_MODIFY : SHARE_PERMISSION_VIEW;
    }

    public boolean isOwner(String username) {
        try {
            return username.equals(this.getNode().getACL().getOwner());
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public String getOwner() {
        try {
            return this.getNode().getACL().getOwner();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Map<String, String> getAllPermissions() {
        return this.getWhoHasAccess().stream().filter(identity -> !IdentityConstants.ANY.equals(identity) && !IdentityConstants.SYSTEM.equals(identity) && !this.isOwner((String)identity)).filter(identity -> !this.isGroupType((String)identity)).collect(Collectors.toMap(Function.identity(), identity -> this.getPermission((String)identity)));
    }

    public String getRestURL() {
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(PortalContainer.getCurrentRestContextName()).append("/social/people/suggest.json?");
        builder.append("currentUser=").append(RequestContext.getCurrentInstance().getRemoteUser());
        builder.append("&typeOfRelation=").append("share_document");
        return builder.toString();
    }

    public String getComment() {
        if (this.comment == null) {
            return "";
        }
        return this.comment;
    }

    private String getDefaultThumbnail(Node node) throws Exception {
        String baseURI = CommonsUtils.getCurrentDomain();
        String cssClass = CssClassUtils.getCSSClassByFileNameAndFileType((String)node.getName(), (String)this.getMimeType(node), (CssClassManager.ICON_SIZE)CssClassManager.ICON_SIZE.ICON_64);
        if (cssClass.indexOf("FileDefault") > 0) {
            return baseURI + "/eXoSkin/skin/images/themes/default/Icons/TypeIcons/EmailNotificationIcons/" + "uiIcon64x64Templatent_file.png";
        }
        return baseURI + "/eXoSkin/skin/images/themes/default/Icons/TypeIcons/EmailNotificationIcons/" + cssClass.split(" ")[0] + ".png";
    }

    private String getMimeType(Node node) throws Exception {
        return DMSMimeTypeResolver.getInstance().getMimeType(node.getName());
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public static class ChangePermissionActionListener
    extends EventListener<UIShareDocuments> {
        public void execute(Event<UIShareDocuments> event) throws Exception {
            UIShareDocuments uicomponent = (UIShareDocuments)((Object)event.getSource());
            if (uicomponent.getPermission().equals(UIShareDocuments.SHARE_PERMISSION_MODIFY)) {
                uicomponent.setPermission(UIShareDocuments.SHARE_PERMISSION_VIEW);
            } else {
                uicomponent.setPermission(UIShareDocuments.SHARE_PERMISSION_MODIFY);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uicomponent);
            event.getRequestContext().getJavascriptManager().require("SHARED/share-content", "shareContent").addScripts("eXo.ecm.ShareContent.checkSelectedEntry();");
        }
    }

    public static class AddActionListener
    extends EventListener<UIShareDocuments> {
        public void execute(Event<UIShareDocuments> event) throws Exception {
            UIShareDocuments uicomponent = (UIShareDocuments)((Object)event.getSource());
            List<String> entries = uicomponent.entries;
            UIFormStringInput input = uicomponent.getUIStringInput(UIShareDocuments.USER_SUGGESTER);
            String value = (String)input.getValue();
            input.setValue(null);
            if (value == null || value.trim().isEmpty()) {
                UIApplication uiApp = (UIApplication)uicomponent.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIShareDocuments.label.NoSpace", null, 1));
            }
            if (value != null) {
                String[] selectedIdentities = value.split(",");
                String name = null;
                Identity identity = ConversationState.getCurrent().getIdentity();
                if (uicomponent.hasPermissionDropDown() && (uicomponent.canEdit(identity) || uicomponent.isOwner(identity.getUserId()))) {
                    String permission = uicomponent.getPermission();
                    LinkedList<String> notFound = new LinkedList<String>();
                    boolean i = false;
                    if (selectedIdentities != null) {
                        for (int idx = 0; idx < selectedIdentities.length; ++idx) {
                            name = selectedIdentities[idx].trim();
                            if (name.length() <= 0) continue;
                            if (UIShareDocuments.isExisting(name) && !uicomponent.isOwner(name)) {
                                if (name.startsWith(UIShareDocuments.SPACE_PREFIX1)) {
                                    name = name.replace(UIShareDocuments.SPACE_PREFIX1, UIShareDocuments.SPACE_PREFIX2);
                                }
                                if (uicomponent.hasPermission(name, permission)) continue;
                                uicomponent.updatePermission(name, permission);
                                ((UIWhoHasAccess)uicomponent.getChild(UIWhoHasAccess.class)).update(name, permission);
                                if (entries.contains(name)) continue;
                                entries.add(name);
                                continue;
                            }
                            if (uicomponent.isOwner(name)) {
                                UIApplication uiApp = (UIApplication)uicomponent.getAncestorOfType(UIApplication.class);
                                uiApp.addMessage(new ApplicationMessage("UIShareDocuments.label.InvalidOwner", null, 1));
                                continue;
                            }
                            notFound.add(name);
                        }
                    }
                    if (notFound.size() > 0) {
                        UIApplication uiApp = (UIApplication)uicomponent.getAncestorOfType(UIApplication.class);
                        uiApp.addMessage(new ApplicationMessage("UIShareDocuments.label.Invalid", (Object[])new String[]{((Object)notFound).toString().replace("[", "").replace("]", "")}, 1));
                    }
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uicomponent);
                    event.getRequestContext().getJavascriptManager().require("SHARED/share-content", "shareContent").addScripts("eXo.ecm.ShareContent.checkSelectedEntry('" + entries + "');");
                } else {
                    UIApplication uiApp = (UIApplication)uicomponent.getAncestorOfType(UIApplication.class);
                    uiApp.addMessage(new ApplicationMessage("UIShareDocuments.label.NoPermission", null, 1));
                }
            }
        }
    }

    public static class ConfirmActionListener
    extends EventListener<UIShareDocuments> {
        public void execute(Event<UIShareDocuments> event) throws Exception {
            UIShareDocuments uiform = (UIShareDocuments)((Object)event.getSource());
            IShareDocumentService service = (IShareDocumentService)WCMCoreUtils.getService(IShareDocumentService.class);
            SpaceService spaceService = (SpaceService)WCMCoreUtils.getService(SpaceService.class);
            DocumentService documentService = (DocumentService)WCMCoreUtils.getService(DocumentService.class);
            List<String> entries = uiform.entries;
            Map permissions = uiform.permissions;
            Set<String> accessList = uiform.getWhoHasAccess();
            ExtendedNode node = uiform.getNode();
            String message = "";
            Identity identity = ConversationState.getCurrent().getIdentity();
            boolean isShared = false;
            if (uiform.isOwner(identity.getUserId()) || uiform.canEdit(identity)) {
                NotificationContext ctx;
                String perm;
                if (((UIFormTextAreaInput)uiform.getChild(UIFormTextAreaInput.class)).getValue() != null) {
                    message = (String)((UIFormTextAreaInput)uiform.getChild(UIFormTextAreaInput.class)).getValue();
                }
                for (String name : accessList) {
                    try {
                        if (IdentityConstants.ANY.equals(name) || IdentityConstants.SYSTEM.equals(name) || uiform.hasPermission(name, uiform.getPermission(name)) || uiform.isOwner(name) || uiform.isGroupType(name)) continue;
                        if (permissions.containsKey(name)) {
                            perm = (String)permissions.get(name);
                            if (!name.startsWith(UIShareDocuments.SPACE_PREFIX2)) {
                                service.unpublishDocumentToUser(name, node);
                                service.publishDocumentToUser(name, (Node)node, message, perm);
                                NotificationContext ctx2 = NotificationContextImpl.cloneInstance().append(ShareFileToUserPlugin.NODE, (Object)node).append(ShareFileToUserPlugin.SENDER, (Object)ConversationState.getCurrent().getIdentity().getUserId()).append(ShareFileToUserPlugin.NODEID, (Object)node.getUUID()).append(ShareFileToUserPlugin.URL, (Object)documentService.getDocumentUrlInPersonalDocuments((Node)node, name)).append(ShareFileToUserPlugin.RECEIVER, (Object)name).append(ShareFileToUserPlugin.PERM, (Object)perm).append(ShareFileToUserPlugin.ICON, (Object)uiform.getDefaultThumbnail((Node)node)).append(ShareFileToUserPlugin.MIMETYPE, (Object)uiform.getMimeType((Node)node)).append(ShareFileToUserPlugin.MESSAGE, (Object)message);
                                ctx2.getNotificationExecutor().with(ctx2.makeCommand(PluginKey.key((String)"ShareFileToUserPlugin"))).execute(ctx2);
                                isShared = true;
                                continue;
                            }
                            String groupId = name.substring("*:".length());
                            service.unpublishDocumentToSpace(groupId, node);
                            String activityId = service.publishDocumentToSpace(groupId, (Node)node, message, perm);
                            ctx = NotificationContextImpl.cloneInstance().append(ShareFileToSpacePlugin.NODE, (Object)node).append(ShareFileToSpacePlugin.SENDER, (Object)ConversationState.getCurrent().getIdentity().getUserId()).append(ShareFileToSpacePlugin.NODEID, (Object)node.getUUID()).append(ShareFileToUserPlugin.URL, (Object)documentService.getDocumentUrlInSpaceDocuments((Node)node, groupId)).append(ShareFileToSpacePlugin.RECEIVER, (Object)groupId).append(ShareFileToSpacePlugin.PERM, (Object)perm).append(ShareFileToSpacePlugin.ICON, (Object)uiform.getDefaultThumbnail((Node)node)).append(ShareFileToSpacePlugin.MIMETYPE, (Object)uiform.getMimeType((Node)node)).append(ShareFileToSpacePlugin.ACTIVITY_ID, (Object)activityId).append(ShareFileToSpacePlugin.MESSAGE, (Object)message);
                            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"ShareFileToSpacePlugin"))).execute(ctx);
                            isShared = true;
                            continue;
                        }
                        if (!name.startsWith(UIShareDocuments.SPACE_PREFIX2)) {
                            service.unpublishDocumentToUser(name, node);
                            continue;
                        }
                        String groupId = name.substring("*:".length());
                        service.unpublishDocumentToSpace(groupId, node);
                    }
                    catch (RepositoryException e) {
                        UIApplication uiApp = (UIApplication)uiform.getAncestorOfType(UIApplication.class);
                        uiApp.addMessage(new ApplicationMessage("UIShareDocuments.label.InvalidEntry", null, 1));
                    }
                }
                if (entries.size() > 0) {
                    for (String entry : entries) {
                        if (entry.equals("") || uiform.isOwner(entry)) continue;
                        perm = (String)permissions.get(entry);
                        String activityId = "";
                        if (entry.startsWith(UIShareDocuments.SPACE_PREFIX2)) {
                            String groupId = spaceService.getSpaceByPrettyName(entry.substring(UIShareDocuments.SPACE_PREFIX2.length())).getGroupId();
                            activityId = service.publishDocumentToSpace(groupId, (Node)node, message, perm);
                            ctx = NotificationContextImpl.cloneInstance().append(ShareFileToSpacePlugin.NODE, (Object)node).append(ShareFileToSpacePlugin.SENDER, (Object)ConversationState.getCurrent().getIdentity().getUserId()).append(ShareFileToSpacePlugin.NODEID, (Object)node.getUUID()).append(ShareFileToUserPlugin.URL, (Object)documentService.getDocumentUrlInSpaceDocuments((Node)node, groupId)).append(ShareFileToSpacePlugin.RECEIVER, (Object)groupId).append(ShareFileToSpacePlugin.PERM, (Object)perm).append(ShareFileToSpacePlugin.ICON, (Object)uiform.getDefaultThumbnail((Node)node)).append(ShareFileToSpacePlugin.MIMETYPE, (Object)uiform.getMimeType((Node)node)).append(ShareFileToSpacePlugin.ACTIVITY_ID, (Object)activityId).append(ShareFileToSpacePlugin.MESSAGE, (Object)message);
                            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"ShareFileToSpacePlugin"))).execute(ctx);
                            isShared = true;
                            continue;
                        }
                        service.publishDocumentToUser(entry, (Node)node, message, perm);
                        String oldSharedURL = documentService.getDocumentUrlInPersonalDocuments((Node)node, entry);
                        String newSharedURL = UIShareDocuments.getPortalLoginRedirectURL() + oldSharedURL.replace(CommonsUtils.getCurrentDomain() + "/", "");
                        NotificationContext ctx3 = NotificationContextImpl.cloneInstance().append(ShareFileToUserPlugin.NODE, (Object)node).append(ShareFileToUserPlugin.SENDER, (Object)ConversationState.getCurrent().getIdentity().getUserId()).append(ShareFileToUserPlugin.NODEID, (Object)node.getUUID()).append(ShareFileToUserPlugin.URL, (Object)newSharedURL).append(ShareFileToUserPlugin.RECEIVER, (Object)entry).append(ShareFileToUserPlugin.PERM, (Object)perm).append(ShareFileToUserPlugin.ICON, (Object)uiform.getDefaultThumbnail((Node)node)).append(ShareFileToUserPlugin.MIMETYPE, (Object)uiform.getMimeType((Node)node)).append(ShareFileToUserPlugin.MESSAGE, (Object)message);
                        ctx3.getNotificationExecutor().with(ctx3.makeCommand(PluginKey.key((String)"ShareFileToUserPlugin"))).execute(ctx3);
                        isShared = true;
                    }
                }
                if (isShared) {
                    UIApplication uiApp = (UIApplication)uiform.getAncestorOfType(UIApplication.class);
                    uiApp.addMessage(new ApplicationMessage("UIShareDocuments.label.success", null, 2));
                }
                ((UIJCRExplorer)uiform.getAncestorOfType(UIJCRExplorer.class)).cancelAction();
            } else {
                UIApplication uiApp = (UIApplication)uiform.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIShareDocuments.label.NoPermission", null, 1));
            }
        }
    }

    public static class TextChangeActionListener
    extends EventListener<UIShareDocuments> {
        public void execute(Event<UIShareDocuments> event) throws Exception {
            UIShareDocuments uiform = (UIShareDocuments)((Object)event.getSource());
            uiform.comment = (String)((UIFormTextAreaInput)((UIShareDocuments)((Object)event.getSource())).getChild(UIFormTextAreaInput.class)).getValue();
            event.getRequestContext().addUIComponentToUpdateByAjax(((UIShareDocuments)((Object)event.getSource())).getChild(UIFormTextAreaInput.class));
        }
    }

    public static class CancelActionListener
    extends EventListener<UIShareDocuments> {
        public void execute(Event<UIShareDocuments> event) throws Exception {
            ((UIJCRExplorer)((UIShareDocuments)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class)).cancelAction();
        }
    }

    public static class ChangeActionListener
    extends EventListener<UIShareDocuments> {
        public void execute(Event<UIShareDocuments> event) throws Exception {
            String permission = UIShareDocuments.SHARE_PERMISSION_VIEW;
            UIShareDocuments uiform = (UIShareDocuments)((Object)event.getSource());
            if (((String)((UIFormSelectBox)uiform.getChild(UIFormSelectBox.class)).getValue()).equals(UIShareDocuments.SHARE_PERMISSION_MODIFY)) {
                ((UIFormSelectBox)uiform.getChild(UIFormSelectBox.class)).setValue(UIShareDocuments.SHARE_PERMISSION_VIEW);
            } else {
                ((UIFormSelectBox)uiform.getChild(UIFormSelectBox.class)).setValue(UIShareDocuments.SHARE_PERMISSION_MODIFY);
                permission = UIShareDocuments.SHARE_PERMISSION_MODIFY;
            }
            UIWhoHasAccess uiWhoHasAccess = (UIWhoHasAccess)uiform.getParent();
            uiWhoHasAccess.updateEntry(uiform.getId(), permission);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiform);
        }
    }
}

