/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity;

import com.ibm.icu.util.Calendar;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.portlet.PortletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.friendly.FriendlyService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.SpaceStorageException;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.social.webui.composer.PopupContainer;
import org.exoplatform.wcm.ext.component.activity.ActivityFileAttachment;
import org.exoplatform.wcm.ext.component.activity.ActivityFilesDownloadResource;
import org.exoplatform.wcm.ext.component.activity.UIDocumentPreview;
import org.exoplatform.wcm.ext.component.activity.listener.Utils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/ecm/social-integration/plugin/space/FileUIActivity.gtmpl", events={@EventConfig(listeners={ViewDocumentActionListener.class}), @EventConfig(listeners={BaseUIActivity.LoadLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}), @EventConfig(listeners={OpenFileActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.EditActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.EditCommentActionListener.class}), @EventConfig(listeners={DownloadDocumentActionListener.class})})})
public class FileUIActivity
extends BaseUIActivity {
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final String SEPARATOR_REGEX = "\\|@\\|";
    private static final String NEW_DATE_FORMAT = "hh:mm:ss MMM d, yyyy";
    private static final Log LOG = ExoLogger.getLogger(FileUIActivity.class);
    public static final String ID = "id";
    public static final String CONTENT_LINK = "contenLink";
    public static final String MESSAGE = "message";
    public static final String ACTIVITY_STATUS = "MESSAGE";
    public static final String CONTENT_NAME = "contentName";
    public static final String IMAGE_PATH = "imagePath";
    public static final String MIME_TYPE = "mimeType";
    public static final String STATE = "state";
    public static final String AUTHOR = "author";
    public static final String DATE_CREATED = "dateCreated";
    public static final String LAST_MODIFIED = "lastModified";
    public static final String DOCUMENT_TYPE_LABEL = "docTypeLabel";
    public static final String DOCUMENT_TITLE = "docTitle";
    public static final String DOCUMENT_VERSION = "docVersion";
    public static final String DOCUMENT_SUMMARY = "docSummary";
    public static final String IS_SYSTEM_COMMENT = "isSystemComment";
    public static final String SYSTEM_COMMENT = "systemComment";
    private String message;
    private LinkedHashMap<String, String>[] folderPathWithLinks;
    private String activityStatus;
    public int filesCount = 0;
    private String activityTitle;
    private DateTimeFormatter dateTimeFormatter;
    private DocumentService documentService;
    private SpaceService spaceService;
    private OrganizationService organizationService;
    private TrashService trashService;
    private List<ActivityFileAttachment> activityFileAttachments = new ArrayList<ActivityFileAttachment>();
    private String downloadLink = null;
    private String downloadResourceId = null;

    public FileUIActivity() throws Exception {
        if (WebuiRequestContext.getCurrentInstance() != null) {
            this.addChild(UIPopupContainer.class, null, "UIDocViewerPopupContainer");
        }
    }

    protected void editActivity(String message) {
        super.editActivity(message);
        this.setMessage(message);
        this.setActivityTitle(message.replace("</br></br>", ""));
    }

    public String getActivityTitle() {
        return this.activityTitle;
    }

    public void setActivityTitle(String activityTitle) {
        this.activityTitle = activityTitle;
    }

    public String getContentLink(int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return null;
        }
        return this.activityFileAttachments.get(i).getContentLink();
    }

    public void setContentLink(int i, String contentLink) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        activityFileAttachment.setContentLink(contentLink);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getContentName(int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return null;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        String contentName = null;
        try {
            contentName = activityFileAttachment == null || activityFileAttachment.getContentNode() == null ? null : activityFileAttachment.getContentNode().getName();
        }
        catch (RepositoryException e) {
            LOG.debug((Object)("Can't retrieve file name of attachment with path " + activityFileAttachment.getDocPath()), (Throwable)e);
        }
        if (StringUtils.isBlank((String)contentName)) {
            contentName = activityFileAttachment.getContentName();
        }
        return contentName;
    }

    public void setContentName(String contentName, int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        activityFileAttachment.setContentName(contentName);
    }

    public String getImagePath(int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return null;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        return activityFileAttachment.getImagePath();
    }

    public void setImagePath(String imagePath, int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        activityFileAttachment.setImagePath(imagePath);
    }

    public String getMimeType(int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return null;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        return activityFileAttachment.getMimeType();
    }

    public void setMimeType(String mimeType, int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        activityFileAttachment.setMimeType(mimeType);
    }

    public String getNodeUUID(int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return null;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        return activityFileAttachment.getNodeUUID();
    }

    public void setNodeUUID(String nodeUUID, int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        activityFileAttachment.setNodeUUID(nodeUUID);
    }

    public String getState(int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return null;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        return activityFileAttachment.getState();
    }

    public void setState(String state, int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        activityFileAttachment.setState(state);
    }

    public String getAuthor(int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return null;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        return activityFileAttachment.getAuthor();
    }

    public void setAuthor(String author, int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        activityFileAttachment.setAuthor(author);
    }

    public String getDocTypeName(int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return null;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        return activityFileAttachment.getDocTypeName();
    }

    public String getDocTitle(int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return null;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        return activityFileAttachment.getDocTitle();
    }

    public String getDocVersion(int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return null;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        return activityFileAttachment.getDocVersion();
    }

    public String getDocSummary(int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return null;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        return activityFileAttachment.getDocSummary();
    }

    public boolean isSymlink(int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return false;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        return activityFileAttachment.isSymlink();
    }

    public String getTitle(Node node) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getTitle((Node)node);
    }

    private String convertDateFormat(String strDate, String strOldFormat, String strNewFormat) throws ParseException {
        if (strDate == null || strDate.length() <= 0) {
            return "";
        }
        Locale locale = Util.getPortalRequestContext().getLocale();
        SimpleDateFormat sdfSource = new SimpleDateFormat(strOldFormat);
        SimpleDateFormat sdfDestination = new SimpleDateFormat(strNewFormat, locale);
        Date date = sdfSource.parse(strDate);
        return sdfDestination.format(date);
    }

    private String convertDateUsingFormat(Calendar date, String format) throws ParseException {
        Locale locale = Util.getPortalRequestContext().getLocale();
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        return dateFormat.format(date.getTime());
    }

    public String getDateCreated(int i) throws ParseException {
        if (i + 1 > this.activityFileAttachments.size()) {
            return null;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        return this.convertDateFormat(activityFileAttachment.getDateCreated(), "yyyy-MM-dd'T'HH:mm:ss", NEW_DATE_FORMAT);
    }

    public void setDateCreated(String dateCreated, int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        activityFileAttachment.setDateCreated(dateCreated);
    }

    public String getLastModified(int i) throws ParseException {
        if (i + 1 > this.activityFileAttachments.size()) {
            return null;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        return this.convertDateFormat(activityFileAttachment.getLastModified(), "yyyy-MM-dd'T'HH:mm:ss", NEW_DATE_FORMAT);
    }

    public void setLastModified(String lastModified, int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        activityFileAttachment.setLastModified(lastModified);
    }

    public Node getContentNode(int i) {
        Node tmpContentNode;
        ActivityFileAttachment activityFileAttachment;
        block4: {
            if (i + 1 > this.activityFileAttachments.size()) {
                return null;
            }
            activityFileAttachment = this.activityFileAttachments.get(i);
            tmpContentNode = activityFileAttachment.getContentNode();
            try {
                if (!(activityFileAttachment.getNodeLocation() == null || tmpContentNode != null && tmpContentNode.getSession().isLive())) {
                    tmpContentNode = NodeLocation.getNodeByLocation((NodeLocation)activityFileAttachment.getNodeLocation());
                }
            }
            catch (RepositoryException e) {
                if (activityFileAttachment.getNodeLocation() == null) break block4;
                tmpContentNode = NodeLocation.getNodeByLocation((NodeLocation)activityFileAttachment.getNodeLocation());
            }
        }
        activityFileAttachment.setContentNode(tmpContentNode);
        return tmpContentNode;
    }

    public void setContentNode(Node contentNode, int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        activityFileAttachment.setContentNode(contentNode);
        activityFileAttachment.setNodeLocation(NodeLocation.getNodeLocationByNode((Node)contentNode));
    }

    public NodeLocation getNodeLocation(int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return null;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        return activityFileAttachment.getNodeLocation();
    }

    public void setNodeLocation(NodeLocation nodeLocation, int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        activityFileAttachment.setNodeLocation(nodeLocation);
    }

    public String getSummary(Node node) {
        return Utils.getSummary(node);
    }

    public String getDocumentSummary(Map<String, String> activityParams) {
        return activityParams.get(DOCUMENT_SUMMARY);
    }

    public String getUserFullName(String userId) {
        User user;
        String currentUser;
        if (StringUtils.isEmpty((String)userId)) {
            return "";
        }
        ConversationState currentUserState = ConversationState.getCurrent();
        Identity currentUserIdentity = currentUserState.getIdentity();
        if (currentUserIdentity != null && (currentUser = currentUserIdentity.getUserId()) != null && currentUser.equals(userId) && (user = (User)currentUserState.getAttribute("UserProfile")) != null) {
            return user.getDisplayName();
        }
        try {
            User user2 = this.getOrganizationService().getUserHandler().findUserByName(userId);
            if (user2 != null) {
                return user2.getDisplayName();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot get information of user " + userId + " : " + e.getMessage()), (Throwable)e);
        }
        return "";
    }

    protected String getSize(Node node) {
        double size = 0.0;
        try {
            if (node.hasNode("jcr:content")) {
                Node contentNode = node.getNode("jcr:content");
                if (contentNode.hasProperty("jcr:data")) {
                    size = contentNode.getProperty("jcr:data").getLength();
                }
                return FileUtils.byteCountToDisplaySize((long)((long)size));
            }
        }
        catch (PathNotFoundException e) {
            return "";
        }
        catch (ValueFormatException e) {
            return "";
        }
        catch (RepositoryException e) {
            return "";
        }
        catch (NullPointerException e) {
            return "";
        }
        return "";
    }

    protected double getFileSize(Node node) {
        double fileSize = 0.0;
        try {
            Node contentNode;
            if (node.isNodeType("exo:symlink")) {
                node = org.exoplatform.ecm.webui.utils.Utils.getNodeSymLink((Node)node);
            }
            if (node.hasNode("jcr:content") && (contentNode = node.getNode("jcr:content")).hasProperty("jcr:data")) {
                fileSize = contentNode.getProperty("jcr:data").getLength();
            }
        }
        catch (Exception ex) {
            fileSize = 0.0;
        }
        return fileSize;
    }

    protected int getImageWidth(Node node, int i) {
        int imageWidth;
        block7: {
            if (i + 1 > this.activityFileAttachments.size()) {
                return 0;
            }
            ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
            imageWidth = 0;
            try {
                if (node.isNodeType("exo:symlink")) {
                    node = org.exoplatform.ecm.webui.utils.Utils.getNodeSymLink((Node)node);
                }
                if (node.hasNode("jcr:content")) {
                    node = node.getNode("jcr:content");
                }
                ImageReader reader = ImageIO.getImageReadersByMIMEType(activityFileAttachment.getMimeType()).next();
                ImageInputStream iis = ImageIO.createImageInputStream(node.getProperty("jcr:data").getStream());
                reader.setInput(iis, true);
                imageWidth = reader.getWidth(0);
                iis.close();
                reader.dispose();
            }
            catch (Exception e) {
                if (!LOG.isTraceEnabled()) break block7;
                String nodePath = null;
                try {
                    nodePath = node.getPath();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LOG.trace((Object)("Cannot get image from node " + nodePath), (Throwable)e);
            }
        }
        return imageWidth;
    }

    protected int getImageHeight(Node node, int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return 0;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        int imageHeight = 0;
        try {
            if (node.isNodeType("exo:symlink")) {
                node = org.exoplatform.ecm.webui.utils.Utils.getNodeSymLink((Node)node);
            }
            if (node.hasNode("jcr:content")) {
                node = node.getNode("jcr:content");
            }
            ImageReader reader = ImageIO.getImageReadersByMIMEType(activityFileAttachment.getMimeType()).next();
            ImageInputStream iis = ImageIO.createImageInputStream(node.getProperty("jcr:data").getStream());
            reader.setInput(iis, true);
            imageHeight = reader.getHeight(0);
            iis.close();
            reader.dispose();
        }
        catch (Exception e) {
            LOG.info((Object)"Cannot get node");
        }
        return imageHeight;
    }

    protected String getDocUpdateDate(Node node) {
        String docUpdatedDate = "";
        try {
            if (node != null && node.hasProperty("exo:lastModifiedDate")) {
                String rawDocUpdatedDate = node.getProperty("exo:lastModifiedDate").getString();
                LocalDateTime parsedDate = LocalDateTime.parse(rawDocUpdatedDate, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                docUpdatedDate = parsedDate.format(this.getDateTimeFormatter());
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Cannot get document updated date : " + e.getMessage()), (Throwable)e);
        }
        return docUpdatedDate;
    }

    protected DateTimeFormatter getDateTimeFormatter() {
        if (this.dateTimeFormatter == null) {
            this.dateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM);
            Locale locale = WebuiRequestContext.getCurrentInstance().getLocale();
            if (locale != null) {
                this.dateTimeFormatter = this.dateTimeFormatter.withLocale(locale);
            }
        }
        return this.dateTimeFormatter;
    }

    protected String getDocLastModifier(Node node) {
        String docLastModifier = "";
        try {
            if (node.isNodeType("exo:symlink")) {
                String uuid = node.getProperty("exo:uuid").getString();
                node = node.getSession().getNodeByUUID(uuid);
            }
            if (node != null && node.hasProperty("exo:lastModifier")) {
                String docLastModifierUsername = node.getProperty("exo:lastModifier").getString();
                docLastModifier = this.getUserFullName(docLastModifierUsername);
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Cannot get document last modifier : " + e.getMessage()), (Throwable)e);
        }
        return docLastModifier;
    }

    protected int getVersion(Node node) {
        String currentVersion = null;
        try {
            if (node.isNodeType("mix:versionDisplayName") && node.hasProperty("exo:maxVersion")) {
                int max = (int)node.getProperty("exo:maxVersion").getLong();
                return max - 1;
            }
            currentVersion = node.getBaseVersion().getName();
            if (currentVersion.contains("jcr:rootVersion")) {
                currentVersion = "0";
            }
        }
        catch (Exception e) {
            currentVersion = "0";
        }
        return Integer.parseInt(currentVersion);
    }

    public String getUserProfileUri(String userId) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityManager identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        return identityManager.getOrCreateIdentity("organization", userId, true).getProfile().getUrl();
    }

    public String getUserAvatarImageSource(String userId) {
        return this.getOwnerIdentity().getProfile().getAvatarUrl();
    }

    public String getSpaceAvatarImageSource(String spaceIdentityId) {
        try {
            String spaceId = this.getOwnerIdentity().getRemoteId();
            SpaceService spaceService = this.getSpaceService();
            Space space = spaceService.getSpaceById(spaceId);
            if (space != null) {
                return space.getAvatarUrl();
            }
        }
        catch (SpaceStorageException e) {
            LOG.warn((Object)("Failed to getSpaceById: " + spaceIdentityId), (Throwable)e);
        }
        return null;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    public String getActivityStatus() {
        if (this.message == null) {
            return this.activityStatus;
        }
        return this.message;
    }

    public int getFilesCount() {
        return this.filesCount;
    }

    public void setUIActivityData(Map<String, String> activityParams) {
        int i;
        String[] docPaths;
        this.activityFileAttachments.clear();
        this.message = activityParams.get(MESSAGE);
        this.activityStatus = activityParams.get(ACTIVITY_STATUS);
        String[] nodeUUIDs = this.getParameterValues(activityParams, ID);
        String[] repositories = this.getParameterValues(activityParams, "REPOSITORY");
        String[] workspaces = this.getParameterValues(activityParams, "WORKSPACE");
        if ((nodeUUIDs == null || nodeUUIDs.length == 0) && (docPaths = this.getParameterValues(activityParams, "DOCPATH")) != null && docPaths.length > 0) {
            nodeUUIDs = new String[docPaths.length];
            for (int i2 = 0; i2 < docPaths.length; ++i2) {
                String docPath;
                NodeLocation nodeLocation;
                Node node;
                String repository = "repository";
                if (repositories != null && repositories.length == docPaths.length && StringUtils.isNotBlank((String)repositories[i2])) {
                    repository = repositories[i2];
                }
                String workspace = "collaboration";
                if (workspaces != null && workspaces.length == docPaths.length && StringUtils.isNotBlank((String)workspaces[i2])) {
                    workspace = workspaces[i2];
                }
                if ((node = NodeLocation.getNodeByLocation((NodeLocation)(nodeLocation = new NodeLocation(repository, workspace, docPath = docPaths[i2])))) == null) continue;
                try {
                    nodeUUIDs[i2] = node.getUUID();
                    continue;
                }
                catch (RepositoryException e) {
                    LOG.error((Object)"can not get UUID", (Throwable)e);
                }
            }
        }
        this.filesCount = nodeUUIDs == null ? 0 : nodeUUIDs.length;
        String[] contentLink = this.getParameterValues(activityParams, CONTENT_LINK);
        String[] state = this.getParameterValues(activityParams, STATE);
        String[] author = this.getParameterValues(activityParams, AUTHOR);
        String[] dateCreated = this.getParameterValues(activityParams, DATE_CREATED);
        String[] lastModified = this.getParameterValues(activityParams, LAST_MODIFIED);
        String[] contentName = this.getParameterValues(activityParams, CONTENT_NAME);
        String[] mimeType = this.getParameterValues(activityParams, MIME_TYPE);
        String[] imagePath = this.getParameterValues(activityParams, IMAGE_PATH);
        String[] docTypeName = this.getParameterValues(activityParams, DOCUMENT_TYPE_LABEL);
        String[] docTitle = this.getParameterValues(activityParams, DOCUMENT_TITLE);
        String[] docVersion = this.getParameterValues(activityParams, DOCUMENT_VERSION);
        String[] docSummary = this.getParameterValues(activityParams, DOCUMENT_SUMMARY);
        String[] docPath = this.getParameterValues(activityParams, "DOCPATH");
        Boolean[] isSymlink = null;
        String[] isSymlinkParams = this.getParameterValues(activityParams, "isSymlink");
        if (isSymlinkParams != null) {
            isSymlink = new Boolean[isSymlinkParams.length];
            for (i = 0; i < isSymlinkParams.length; ++i) {
                isSymlink[i] = Boolean.parseBoolean(isSymlinkParams[i]);
            }
        }
        for (i = 0; i < this.filesCount; ++i) {
            ManageableRepository repository;
            ActivityFileAttachment fileAttachment = new ActivityFileAttachment();
            String repositoryName = this.getValueFromArray(i, repositories);
            String workspaceName = this.getValueFromArray(i, workspaces);
            if (StringUtils.isBlank((String)repositoryName)) {
                repository = WCMCoreUtils.getRepository();
                String string = repositoryName = repository == null ? null : repository.getConfiguration().getName();
            }
            if (StringUtils.isBlank((String)workspaceName)) {
                repository = WCMCoreUtils.getRepository();
                workspaceName = repository == null ? null : repository.getConfiguration().getDefaultWorkspaceName();
            }
            fileAttachment.setNodeUUID(nodeUUIDs[i]).setRepository(repositoryName).setWorkspace(workspaceName).setContentLink(this.getValueFromArray(i, contentLink)).setContentName(this.getValueFromArray(i, contentName)).setState(this.getValueFromArray(i, state)).setAuthor(this.getValueFromArray(i, author)).setDateCreated(this.getValueFromArray(i, dateCreated)).setLastModified(this.getValueFromArray(i, lastModified)).setMimeType(this.getValueFromArray(i, mimeType)).setImagePath(this.getValueFromArray(i, imagePath)).setDocTypeName(this.getValueFromArray(i, docTypeName)).setDocTitle(this.getValueFromArray(i, docTitle)).setDocVersion(this.getValueFromArray(i, docVersion)).setDocSummary(this.getValueFromArray(i, docSummary)).setSymlink(this.getValueFromArray(i, isSymlink)).setDocPath(this.getValueFromArray(i, docPath));
            Node contentNode = NodeLocation.getNodeByLocation((NodeLocation)fileAttachment.getNodeLocation());
            if (contentNode == null) continue;
            try {
                if (this.getTrashService().isInTrash(contentNode)) continue;
                this.activityFileAttachments.add(fileAttachment);
                continue;
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Error while testing if the content is in trash", (Throwable)e);
            }
        }
        this.filesCount = this.activityFileAttachments.size();
    }

    private <T> T getValueFromArray(int index, T ... valuesArray) {
        return valuesArray == null || index > valuesArray.length - 1 ? null : (T)valuesArray[index];
    }

    private String[] getParameterValues(Map<String, String> activityParams, String paramName) {
        String[] values = null;
        String value = activityParams.get(paramName);
        if (value == null) {
            value = activityParams.get(paramName.toLowerCase());
        }
        if (value != null) {
            values = value.split(SEPARATOR_REGEX);
        }
        if (LOG.isDebugEnabled() && this.filesCount != 0 && (values == null || values.length != this.filesCount)) {
            LOG.debug("Parameter '{}' hasn't same length as other activity parmameters", new Object[]{paramName});
        }
        return values;
    }

    public String getWebdavURL(int i) throws Exception {
        if (i + 1 > this.activityFileAttachments.size()) {
            return null;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        if (activityFileAttachment.getWebdavURL() != null) {
            return activityFileAttachment.getWebdavURL();
        }
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest portletRequest = portletRequestContext.getRequest();
        String repository = activityFileAttachment.getRepository();
        String workspace = activityFileAttachment.getWorkspace();
        String baseURI = portletRequest.getScheme() + "://" + portletRequest.getServerName() + ":" + String.format("%s", portletRequest.getServerPort());
        FriendlyService friendlyService = (FriendlyService)WCMCoreUtils.getService(FriendlyService.class);
        String link = "#";
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        Node tmpContentNode = this.getContentNode(i);
        if (tmpContentNode.isNodeType("nt:frozenNode")) {
            String uuid = tmpContentNode.getProperty("jcr:frozenUuid").getString();
            Node originalNode = tmpContentNode.getSession().getNodeByUUID(uuid);
            link = baseURI + "/" + portalName + "/" + restContextName + "/jcr/" + repository + "/" + workspace + originalNode.getPath() + "?version=" + this.getContentNode(i).getParent().getName();
        } else {
            link = baseURI + "/" + portalName + "/" + restContextName + "/jcr/" + repository + "/" + workspace + tmpContentNode.getPath();
        }
        activityFileAttachment.setWebdavURL(friendlyService.getFriendlyUri(link));
        return activityFileAttachment.getWebdavURL();
    }

    public String[] getSystemCommentBundle(Map<String, String> activityParams) {
        return Utils.getSystemCommentBundle(activityParams);
    }

    public String[] getSystemCommentTitle(Map<String, String> activityParams) {
        return Utils.getSystemCommentTitle(activityParams);
    }

    public DriveData getDocDrive(int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return null;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        if (activityFileAttachment.getDocDrive() != null) {
            return activityFileAttachment.getDocDrive();
        }
        NodeLocation nodeLocation = activityFileAttachment.getNodeLocation();
        if (nodeLocation != null) {
            try {
                String userId = ConversationState.getCurrent().getIdentity().getUserId();
                activityFileAttachment.setDocDrive(this.documentService.getDriveOfNode(nodeLocation.getPath(), "placeholder_user_name", org.exoplatform.ecm.webui.utils.Utils.getMemberships()));
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot get drive of node " + nodeLocation.getPath() + " : " + e.getMessage()), (Throwable)e);
            }
        }
        return activityFileAttachment.getDocDrive();
    }

    public String getDefaultIconClass(int i) {
        String iconClass = "uiBgdFile";
        String contentName = this.getContentName(i);
        if (StringUtils.isNotBlank((String)contentName)) {
            if (contentName.toLowerCase().contains(".pdf")) {
                iconClass = "uiBgdFilePDF";
            } else if (contentName.toLowerCase().contains(".doc")) {
                iconClass = "uiBgdFileWord";
            } else if (contentName.toLowerCase().contains(".xls")) {
                iconClass = "uiBgdFileExcel";
            } else if (contentName.toLowerCase().contains(".ppt")) {
                iconClass = "uiBgdFilePPT";
            }
        }
        return iconClass;
    }

    public String getDocFileBreadCrumb(int i) {
        LinkedHashMap<String, String> docFolderBreadCrumb = this.getDocFolderRelativePathWithLinks(i);
        String breadCrumbContent = "";
        if (docFolderBreadCrumb != null) {
            int breadCrumbSize = docFolderBreadCrumb.size();
            int folderIndex = 0;
            for (String folderName : docFolderBreadCrumb.keySet()) {
                String folderPath = docFolderBreadCrumb.get(folderName);
                folderName = folderName.replaceAll("_" + (breadCrumbSize - folderIndex - 1) + "$", "");
                if (folderIndex < breadCrumbSize - 1) {
                    if (folderIndex > 0) {
                        breadCrumbContent = breadCrumbContent + ",";
                    }
                    breadCrumbContent = breadCrumbContent + "'" + folderName.replace("'", "\\'") + "': '" + folderPath + "'";
                    breadCrumbContent = breadCrumbContent.replace("%27", "\\'");
                }
                ++folderIndex;
            }
        }
        return breadCrumbContent;
    }

    public String getDocFilePath(int i) {
        LinkedHashMap<String, String> folderRelativePathWithLinks = this.getDocFolderRelativePathWithLinks(i);
        if (folderRelativePathWithLinks != null && !folderRelativePathWithLinks.isEmpty()) {
            String[] nodeNames = folderRelativePathWithLinks.values().toArray(EMPTY_ARRAY);
            return nodeNames[nodeNames.length - 1];
        }
        return null;
    }

    public LinkedHashMap<String, String> getDocFolderRelativePathWithLinks(int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return null;
        }
        if (this.folderPathWithLinks == null) {
            this.folderPathWithLinks = new LinkedHashMap[this.filesCount];
        }
        if (this.folderPathWithLinks[i] == null) {
            this.folderPathWithLinks[i] = new LinkedHashMap();
            LinkedHashMap<String, String> reversedFolderPathWithLinks = new LinkedHashMap<String, String>();
            DriveData drive = this.getDocDrive(i);
            if (drive != null) {
                try {
                    String parentPath;
                    String driveName;
                    block27: {
                        Map parameters = drive.getParameters();
                        driveName = drive.getName();
                        if (parameters != null) {
                            String userId;
                            if (parameters.containsKey("groupId")) {
                                String groupId = (String)parameters.get("groupId");
                                if (StringUtils.isNotBlank((String)groupId)) {
                                    try {
                                        groupId = groupId.replaceAll("\\.", "/");
                                        if (groupId.startsWith("/spaces")) {
                                            SpaceService spaceService = this.getSpaceService();
                                            Space space = spaceService.getSpaceByGroupId(groupId);
                                            if (space != null) {
                                                driveName = space.getDisplayName();
                                            }
                                            break block27;
                                        }
                                        Group group = this.getOrganizationService().getGroupHandler().findGroupById(groupId);
                                        driveName = group == null ? driveName : group.getLabel();
                                    }
                                    catch (Exception e) {
                                        LOG.warn((Object)("Can't get drive name for group with id '" + groupId + "'"), (Throwable)e);
                                    }
                                }
                            } else if (parameters.containsKey("userId") && StringUtils.isNotBlank((String)(userId = (String)parameters.get("userId")))) {
                                try {
                                    userId = userId.indexOf("/") >= 0 ? userId.substring(userId.lastIndexOf("/") + 1) : userId;
                                    User user = this.getOrganizationService().getUserHandler().findUserByName(userId);
                                    if (user != null) {
                                        driveName = user.getDisplayName();
                                    }
                                }
                                catch (Exception e) {
                                    LOG.warn((Object)("Can't get drive name for user with id '" + userId + "'"), (Throwable)e);
                                }
                            }
                        }
                    }
                    String driveHomePath = drive.getResolvedHomePath();
                    String drivePublicFolderHomePath = null;
                    if ("Personal Documents".equals(drive.getName())) {
                        drivePublicFolderHomePath = driveHomePath.replace("/Private", "/Public");
                    }
                    for (Node parentContentNode = this.getContentNode(i); parentContentNode != null && (parentPath = parentContentNode.getPath()).contains(driveHomePath) && (driveHomePath.equals("/") || !parentPath.equals("/")); parentContentNode = parentContentNode.getParent()) {
                        if (drivePublicFolderHomePath != null && parentPath.equals(drivePublicFolderHomePath)) {
                            reversedFolderPathWithLinks.put("Public", this.getDocOpenUri(parentPath, i));
                        } else {
                            String nodeName = parentPath.equals(driveHomePath) ? driveName : (parentContentNode.hasProperty("exo:title") ? parentContentNode.getProperty("exo:title").getString() : parentContentNode.getName());
                            reversedFolderPathWithLinks.put(nodeName + "_" + reversedFolderPathWithLinks.size(), this.getDocOpenUri(parentPath, i));
                            if (!parentPath.equals("/")) {
                                continue;
                            }
                        }
                        break;
                    }
                }
                catch (AccessDeniedException e) {
                    LOG.debug((Object)e.getMessage());
                }
                catch (RepositoryException re) {
                    ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
                    LOG.error((Object)("Cannot retrieve path of doc " + activityFileAttachment.getDocPath() + " : " + re.getMessage()), (Throwable)re);
                }
            }
            if (reversedFolderPathWithLinks.size() > 1) {
                ArrayList entries = new ArrayList(reversedFolderPathWithLinks.entrySet());
                for (int j = entries.size() - 1; j >= 0; --j) {
                    Map.Entry entry = (Map.Entry)entries.get(j);
                    this.folderPathWithLinks[i].put(StringEscapeUtils.escapeHtml4((String)((String)entry.getKey())), (String)entry.getValue());
                }
            } else {
                this.folderPathWithLinks[i] = reversedFolderPathWithLinks;
            }
        }
        return this.folderPathWithLinks[i];
    }

    private OrganizationService getOrganizationService() {
        if (this.organizationService == null) {
            this.organizationService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        }
        return this.organizationService;
    }

    private DocumentService getDocumentService() {
        if (this.documentService == null) {
            this.documentService = (DocumentService)this.getApplicationComponent(DocumentService.class);
        }
        return this.documentService;
    }

    private TrashService getTrashService() {
        if (this.trashService == null) {
            this.trashService = (TrashService)this.getApplicationComponent(TrashService.class);
        }
        return this.trashService;
    }

    public String getDocFolderRelativePath(int i) {
        StringBuilder folderRelativePath = new StringBuilder();
        Set<String> relativePaths = this.getDocFolderRelativePathWithLinks(i).keySet();
        int pathSize = relativePaths.size();
        Iterator<String> relativePathIterator = relativePaths.iterator();
        int folderIndex = 0;
        while (relativePathIterator.hasNext()) {
            String folderName = relativePathIterator.next();
            if (relativePathIterator.hasNext()) {
                folderName = folderName.replaceAll("_" + (pathSize - folderIndex - 1) + "$", "");
                folderRelativePath.append(folderName).append("/");
            }
            ++folderIndex;
        }
        if (folderRelativePath.length() > 1) {
            folderRelativePath.deleteCharAt(folderRelativePath.length() - 1);
        }
        return folderRelativePath.toString();
    }

    public String getCurrentDocOpenUri(int i) {
        if (i + 1 > this.activityFileAttachments.size()) {
            return null;
        }
        ActivityFileAttachment activityFileAttachment = this.activityFileAttachments.get(i);
        String uri = "";
        if (activityFileAttachment.getNodeLocation() != null) {
            uri = this.getDocOpenUri(activityFileAttachment.getDocPath(), i);
        }
        return uri;
    }

    public String getDocOpenUri(String nodePath, int i) {
        String uri = "";
        if (nodePath != null) {
            try {
                if (nodePath.endsWith("/")) {
                    nodePath = nodePath.replaceAll("/$", "");
                }
                uri = this.getDocumentService().getLinkInDocumentsApp(nodePath, this.getDocDrive(i));
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot get document open URI of node " + nodePath + " : " + e.getMessage()), (Throwable)e);
                uri = "";
            }
        }
        return uri;
    }

    public String getEditLink(int i) {
        try {
            return org.exoplatform.wcm.webui.Utils.getEditLink((Node)this.getContentNode(i), (boolean)true, (boolean)false);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getActivityEditLink(int i) {
        try {
            return org.exoplatform.wcm.webui.Utils.getActivityEditLink((Node)this.getContentNode(i));
        }
        catch (Exception e) {
            return "";
        }
    }

    protected String getCssClassIconFile(String fileName, String fileType, int i) {
        try {
            return org.exoplatform.ecm.webui.utils.Utils.getNodeTypeIcon((Node)this.getContentNode(i), (String)"uiBgd64x64");
        }
        catch (RepositoryException e) {
            return "uiBgd64x64FileDefault";
        }
    }

    protected String getContainerName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public String getDownloadAllLink() {
        DownloadResource downloadResource;
        if (this.activityFileAttachments.isEmpty()) {
            return null;
        }
        DownloadService dservice = (DownloadService)WCMCoreUtils.getService(DownloadService.class);
        if (this.downloadResourceId != null && this.downloadLink != null && (downloadResource = dservice.getDownloadResource(this.downloadResourceId)) != null) {
            return this.downloadLink;
        }
        NodeLocation[] nodeLocations = new NodeLocation[this.activityFileAttachments.size()];
        for (int i = 0; i < this.activityFileAttachments.size(); ++i) {
            nodeLocations[i] = this.activityFileAttachments.get(i).getNodeLocation();
        }
        String fileName = this.getDownloadAllFileName();
        return this.getDownloadURL(dservice, fileName, this.downloadResourceId, this.downloadLink, nodeLocations);
    }

    private String getDownloadAllFileName() {
        String fileName = "activity_" + this.getActivity().getId() + "_";
        Long postedTime = this.getActivity().getPostedTime();
        if (postedTime != null) {
            Calendar postedDate = Calendar.getInstance();
            try {
                fileName = fileName + this.convertDateUsingFormat(postedDate, "yyyy-MM-dd").replaceAll("/", "-");
            }
            catch (ParseException e) {
                LOG.warn((Object)"Error while generating date format for file name", (Throwable)e);
            }
        }
        return fileName + ".zip";
    }

    public String getDownloadLink(int i) {
        if (i >= this.activityFileAttachments.size()) {
            return null;
        }
        DownloadService dservice = (DownloadService)WCMCoreUtils.getService(DownloadService.class);
        NodeLocation[] nodeLocations = new NodeLocation[]{this.activityFileAttachments.get(i).getNodeLocation()};
        String contentName = this.activityFileAttachments.get(i).getContentName();
        return this.getDownloadURL(dservice, contentName, null, null, nodeLocations);
    }

    public boolean isFileSupportPreview(Node data) throws Exception {
        if (data != null && data.isNodeType("nt:file")) {
            UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
            List extensions = manager.getUIExtensions("org.exoplatform.ecm.dms.FileViewer");
            HashMap<String, String> context = new HashMap<String, String>();
            context.put(MIME_TYPE, data.getNode("jcr:content").getProperty("jcr:mimeType").getString());
            for (UIExtension extension : extensions) {
                if (!manager.accept("org.exoplatform.ecm.dms.FileViewer", extension.getName(), context) || "Text".equals(extension.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private String getDownloadURL(DownloadService dservice, String fileName, String resourceId, String resourceLink, NodeLocation[] nodelocations) {
        try {
            DownloadResource downloadResource;
            if (resourceId != null && resourceLink != null && (downloadResource = dservice.getDownloadResource(this.downloadResourceId)) != null) {
                return resourceLink;
            }
            ActivityFilesDownloadResource dresource = new ActivityFilesDownloadResource(nodelocations);
            dresource.setDownloadName(fileName);
            return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)"An error occurred while generating download URL", (Throwable)e);
            } else {
                LOG.warn("An error occurred while generating download URL: {}", new Object[]{e.getMessage()});
            }
            return "";
        }
    }

    public boolean canEditDocument(Node data) {
        try {
            ((ExtendedNode)data.getParent()).checkPermission("add_node");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class OpenFileActionListener
    extends EventListener<FileUIActivity> {
        public void execute(Event<FileUIActivity> event) throws Exception {
            FileUIActivity fileUIActivity = (FileUIActivity)((Object)event.getSource());
            String index = event.getRequestContext().getRequestParameter("objectId");
            int i = 0;
            if (!StringUtils.isBlank((String)index)) {
                i = Integer.parseInt(index);
            }
            Node currentNode = fileUIActivity.getContentNode(i);
            FileUIActivity docActivity = (FileUIActivity)((Object)event.getSource());
            UIActivitiesContainer activitiesContainer = (UIActivitiesContainer)docActivity.getAncestorOfType(UIActivitiesContainer.class);
            PopupContainer popupContainer = activitiesContainer.getPopupContainer();
            org.exoplatform.ecm.webui.utils.Utils.openDocumentInDesktop((Node)currentNode, (UIPopupContainer)popupContainer, event);
        }
    }

    public static class DownloadDocumentActionListener
    extends EventListener<FileUIActivity> {
        public void execute(Event<FileUIActivity> event) throws Exception {
            FileUIActivity uiComp = (FileUIActivity)((Object)event.getSource());
            String index = event.getRequestContext().getRequestParameter("objectId");
            if (StringUtils.isBlank((String)index) && uiComp.getFilesCount() > 1) {
                String downloadLink = uiComp.getDownloadAllLink();
                event.getRequestContext().getJavascriptManager().addJavascript((CharSequence)("ajaxRedirect('" + downloadLink + "');"));
            } else {
                if (StringUtils.isBlank((String)index)) {
                    index = "0";
                }
                String downloadLink = uiComp.getDownloadLink(Integer.parseInt(index));
                event.getRequestContext().getJavascriptManager().addJavascript((CharSequence)("ajaxRedirect('" + downloadLink + "');"));
            }
        }
    }

    public static class ViewDocumentActionListener
    extends EventListener<FileUIActivity> {
        public void execute(Event<FileUIActivity> event) throws Exception {
            FileUIActivity fileUIActivity = (FileUIActivity)((Object)event.getSource());
            String index = event.getRequestContext().getRequestParameter("objectId");
            int i = Integer.parseInt(index);
            UIActivitiesContainer uiActivitiesContainer = (UIActivitiesContainer)fileUIActivity.getAncestorOfType(UIActivitiesContainer.class);
            PopupContainer uiPopupContainer = uiActivitiesContainer.getPopupContainer();
            UIDocumentPreview uiDocumentPreview = (UIDocumentPreview)uiPopupContainer.createUIComponent(UIDocumentPreview.class, null, "UIDocumentPreview");
            uiDocumentPreview.setBaseUIActivity(fileUIActivity);
            if (i + 1 > fileUIActivity.activityFileAttachments.size()) {
                return;
            }
            ActivityFileAttachment activityFileAttachment = (ActivityFileAttachment)fileUIActivity.activityFileAttachments.get(i);
            uiDocumentPreview.setContentInfo(activityFileAttachment.getDocPath(), activityFileAttachment.getRepository(), activityFileAttachment.getWorkspace(), fileUIActivity.getContentNode(i));
            uiPopupContainer.activate((UIComponent)uiDocumentPreview, 0, 0, true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
        }
    }
}

