/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity.listener;

import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ActivityTypeUtils;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.wcm.ext.component.activity.listener.Utils;

public class TagActivityListener
extends Listener<Node, String> {
    private static String TAG_ADDED_BUNDLE = "SocialIntegration.messages.tagAdded";
    private static String TAG_REMOVED_BUNDLE = "SocialIntegration.messages.tagRemoved";
    private static String TAGS_ADDED_BUNDLE = "SocialIntegration.messages.tagsAdded";
    private static String TAGS_REMOVED_BUNDLE = "SocialIntegration.messages.tagsRemoved";

    public void onEvent(Event<Node, String> event) throws Exception {
        boolean isMultiple;
        String eventName = event.getEventName();
        if (!eventName.equals(ActivityCommonService.TAG_ADDED_ACTIVITY) && !eventName.equals(ActivityCommonService.TAG_REMOVED_ACTIVITY)) {
            return;
        }
        Node currentNode = (Node)event.getSource();
        String tagValue = (String)event.getData();
        int tagSepIndex = tagValue.indexOf(",");
        boolean bl = isMultiple = tagSepIndex > 0 && !tagValue.endsWith(",");
        String bundleMessage = isMultiple ? (ActivityCommonService.TAG_ADDED_ACTIVITY.equals(eventName) ? TAGS_ADDED_BUNDLE : TAGS_REMOVED_BUNDLE) : (ActivityCommonService.TAG_ADDED_ACTIVITY.equals(eventName) ? TAG_ADDED_BUNDLE : TAG_REMOVED_BUNDLE);
        Utils.postActivity(currentNode, bundleMessage, false, true, tagValue, "");
        LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
        List links = linkManager.getAllLinks(currentNode, "exo:symlink");
        for (Node link : links) {
            ExoSocialActivity linkTagActivity;
            if (!link.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO) || (linkTagActivity = Utils.postActivity(link, bundleMessage, false, true, tagValue, "")) == null) continue;
            ActivityTypeUtils.attachActivityId((Node)link, (String)linkTagActivity.getId());
        }
    }
}

