/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.ext.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.bbcode.core.ExtendedBBCodeProvider;
import org.exoplatform.forum.common.TransformHTML;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumEventListener;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class ForumSpaceActivityPublisher
extends ForumEventListener {
    public static final String FORUM_APP_ID = "ks-forum:spaces";
    public static final String FORUM_ID_KEY = "ForumId";
    public static final String CATE_ID_KEY = "CateId";
    public static final String ACTIVITY_TYPE_KEY = "ActivityType";
    public static final String POST_TYPE = "Post";
    public static final String POST_ID_KEY = "PostId";
    public static final String POST_OWNER_KEY = "PostOwner";
    public static final String POST_LINK_KEY = "PostLink";
    public static final String POST_NAME_KEY = "PostName";
    public static final String TOPIC_ID_KEY = "TopicId";
    public static final String TOPIC_OWNER_KEY = "TopicOwner";
    public static final String TOPIC_LINK_KEY = "TopicLink";
    public static final String TOPIC_NAME_KEY = "TopicName";
    private static final int TYPE_PRIVATE = 2;
    private static final Log LOG = ExoLogger.getExoLogger(ForumSpaceActivityPublisher.class);

    public void saveCategory(Category category) {
    }

    public void saveForum(Forum forum) {
    }

    private void saveActivity(Identity ownerStream, ExoSocialActivity activity) throws Exception {
        ActivityManager activityM = (ActivityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ActivityManager.class);
        activityM.saveActivityNoReturn(ownerStream, activity);
    }

    private ExoSocialActivity activity(Identity author, String title, String body, String forumId, String categoryId, String topicId, String type, Map<String, String> templateParams) throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        body = StringEscapeUtils.unescapeHtml((String)TransformHTML.getTitleInHTMLCode((String)body, new ArrayList(new ExtendedBBCodeProvider().getSupportedBBCodes())));
        activity.setUserId(author.getId());
        title = StringEscapeUtils.unescapeHtml((String)title);
        activity.setTitle(title);
        activity.setBody(body);
        activity.setType(FORUM_APP_ID);
        templateParams.put(FORUM_ID_KEY, forumId);
        templateParams.put(CATE_ID_KEY, categoryId);
        templateParams.put(TOPIC_ID_KEY, topicId);
        templateParams.put(ACTIVITY_TYPE_KEY, type);
        activity.setTemplateParams(templateParams);
        return activity;
    }

    private Map<String, String> updateTemplateParams(Map<String, String> templateParams, String id, String link, String owner, String name, ACTIVITYTYPE type) throws Exception {
        if (type.name().indexOf(POST_TYPE) > 0) {
            templateParams.put(POST_ID_KEY, id);
            templateParams.put(POST_LINK_KEY, link);
            templateParams.put(POST_NAME_KEY, name);
            templateParams.put(POST_OWNER_KEY, owner);
        } else {
            templateParams.put(TOPIC_ID_KEY, id);
            templateParams.put(TOPIC_LINK_KEY, link);
            templateParams.put(TOPIC_NAME_KEY, name);
            templateParams.put(TOPIC_OWNER_KEY, owner);
        }
        return templateParams;
    }

    private boolean isCategoryPublic(Category category) {
        return category != null && Utils.isEmpty((String[])category.getViewer()) && Utils.isEmpty((String[])category.getUserPrivate());
    }

    private boolean isForumPublic(Forum forum) {
        return forum != null && !forum.getIsClosed() && Utils.isEmpty((String[])forum.getViewer());
    }

    private boolean isTopicPublic(Topic topic) {
        return topic != null && topic.getIsActive() && topic.getIsApproved() && !topic.getIsWaiting() && !topic.getIsClosed() && Utils.isEmpty((String[])topic.getCanView());
    }

    private boolean isPostPublic(Post post) {
        return post != null && post.getUserPrivate().length != 2 && !post.getIsWaiting() && !post.getIsHidden() && post.getIsActiveByTopic() && post.getIsApproved();
    }

    private boolean hasSpace(String forumId) throws Exception {
        return !Utils.isEmpty((String)forumId) && forumId.indexOf(Utils.FORUM_SPACE_ID_PREFIX) >= 0;
    }

    private Identity getSpaceIdentity(String forumId) {
        IdentityManager identityM = (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
        SpaceService spaceS = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
        String prettyname = forumId.replaceFirst(Utils.FORUM_SPACE_ID_PREFIX, "");
        Space space = spaceS.getSpaceByPrettyName(prettyname);
        Identity spaceIdentity = null;
        if (space != null) {
            spaceIdentity = identityM.getOrCreateIdentity("space", space.getPrettyName(), false);
        }
        return spaceIdentity;
    }

    private void saveActivityForPost(Post post, String categoryId, String forumId, String topicId, ACTIVITYTYPE type) {
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        IdentityManager identityM = (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
        if (this.isPostPublic(post)) {
            try {
                Identity userIdentity = identityM.getOrCreateIdentity("organization", post.getOwner(), false);
                Identity ownerStream = null;
                Identity author = userIdentity;
                Topic topic = forumService.getTopic(categoryId, forumId, topicId, "");
                if (this.isTopicPublic(topic)) {
                    if (this.hasSpace(forumId)) {
                        ownerStream = this.getSpaceIdentity(forumId);
                    }
                    if (ownerStream == null && this.isCategoryPublic(forumService.getCategory(categoryId)) && this.isForumPublic(forumService.getForum(categoryId, forumId))) {
                        ownerStream = userIdentity;
                    }
                    if (ownerStream != null) {
                        Map<String, String> templateParams = this.updateTemplateParams(new HashMap<String, String>(), post.getId(), post.getLink(), post.getOwner(), post.getName(), type);
                        this.saveActivity(ownerStream, this.activity(author, post.getName(), post.getMessage(), forumId, categoryId, topicId, type.name(), templateParams));
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Can not record Activity for space when post " + post.getId()), (Throwable)e);
            }
        }
    }

    private void saveActivityForTopic(Topic topic, String categoryId, String forumId, ACTIVITYTYPE type) {
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        IdentityManager identityM = (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
        Identity userIdentity = identityM.getOrCreateIdentity("organization", topic.getOwner(), false);
        Identity ownerStream = null;
        Identity author = userIdentity;
        if (this.isTopicPublic(topic)) {
            try {
                if (this.hasSpace(forumId)) {
                    ownerStream = this.getSpaceIdentity(forumId);
                }
                if (ownerStream == null && this.isCategoryPublic(forumService.getCategory(categoryId)) && this.isForumPublic(forumService.getForum(categoryId, forumId))) {
                    ownerStream = userIdentity;
                }
                if (ownerStream != null) {
                    Map<String, String> templateParams = this.updateTemplateParams(new HashMap<String, String>(), topic.getId(), topic.getLink(), topic.getOwner(), topic.getTopicName(), type);
                    this.saveActivity(ownerStream, this.activity(author, topic.getTopicName(), topic.getDescription(), forumId, categoryId, topic.getId(), type.name(), templateParams));
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Can not record Activity for space when add topic " + e.getMessage()));
            }
        }
    }

    public void addPost(Post post, String categoryId, String forumId, String topicId) {
        this.saveActivityForPost(post, categoryId, forumId, topicId, ACTIVITYTYPE.AddPost);
    }

    public void addTopic(Topic topic, String categoryId, String forumId) {
        this.saveActivityForTopic(topic, categoryId, forumId, ACTIVITYTYPE.AddTopic);
    }

    public void updatePost(Post post, String categoryId, String forumId, String topicId) {
        this.saveActivityForPost(post, categoryId, forumId, topicId, ACTIVITYTYPE.UpdatePost);
    }

    public void updateTopic(Topic topic, String categoryId, String forumId) {
        this.saveActivityForTopic(topic, categoryId, forumId, ACTIVITYTYPE.UpdateTopic);
    }

    public static enum ACTIVITYTYPE {
        AddPost,
        AddTopic,
        UpdatePost,
        UpdateTopic;

    }
}

