/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.ext.impl;

import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.service.impl.AnswerEventListener;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.TransformHTML;
import org.exoplatform.forum.ext.activity.ForumActivityBuilder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.processor.I18NActivityUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class AnswersSpaceActivityPublisher
extends AnswerEventListener {
    public static final String SPACE_APP_ID = "ks-answer:spaces";
    public static final String ANSWER_APP_ID = "answer:spaces";
    public static final String QUESTION_ID = "Id";
    public static final String LINK_KEY = "Link";
    public static final String LANGUAGE_KEY = "Language";
    public static final String QUESTION_RATING = "QuestionRating";
    public static final String NUMBER_OF_ANSWERS = "NumberOfAnswers";
    public static final String NUMBER_OF_COMMENTS = "NumberOfComments";
    public static final String SPACE_GROUP_ID = "SpaceGroupId";
    private static final Log LOG = ExoLogger.getExoLogger(AnswersSpaceActivityPublisher.class);

    private Identity getSpaceIdentity(String categoryId) {
        String spaceGroupId = this.getSpaceGroupId(categoryId);
        if ("".equals(spaceGroupId)) {
            return null;
        }
        IdentityManager identityM = (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
        SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
        Space space = spaceService.getSpaceByGroupId(spaceGroupId);
        if (space != null) {
            return identityM.getOrCreateIdentity("space", space.getPrettyName(), false);
        }
        return null;
    }

    private String getSpaceGroupId(String categoryId) {
        String spaceGroupId = "";
        if (categoryId.indexOf(Utils.CATE_SPACE_ID_PREFIX) < 0) {
            return "";
        }
        String prettyname = categoryId.split(Utils.CATE_SPACE_ID_PREFIX)[1];
        spaceGroupId = "/spaces" + CommonUtils.SLASH + prettyname;
        return spaceGroupId;
    }

    private ExoSocialActivity newActivity(Identity author, String title, String body, Map<String, String> templateParams) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(title);
        activity.setBody(body);
        activity.setType(SPACE_APP_ID);
        activity.setTemplateParams(templateParams);
        activity.setUserId(author.getId());
        return activity;
    }

    private Map<String, String> updateTemplateParams(Map<String, String> templateParams, String questionId, String questionRate, String nbAnswers, String nbComments, String language, String link) {
        templateParams.put(QUESTION_RATING, questionRate);
        templateParams.put(NUMBER_OF_ANSWERS, nbAnswers);
        templateParams.put(NUMBER_OF_COMMENTS, nbComments);
        templateParams.put(LINK_KEY, link);
        templateParams.put(LANGUAGE_KEY, language);
        templateParams.put(QUESTION_ID, questionId);
        return templateParams;
    }

    private ExoSocialActivity createCommentForAnswer(Identity userIdentity, Answer answer) {
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        StringBuilder commentTitle = new StringBuilder();
        comment.setUserId(userIdentity.getId());
        comment.setType(ANSWER_APP_ID);
        String prefix = "";
        for (PropertyChangeEvent pce : answer.getChangeEvent()) {
            commentTitle.append(prefix);
            prefix = "\n";
            commentTitle.append(this.getAnswerMessage(pce, answer, (ExoSocialActivity)comment));
        }
        comment.setTitle(commentTitle.toString());
        return comment;
    }

    private ExoSocialActivity createCommentWhenUpdateQuestion(Identity userIdentity, Question question) {
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setType(ANSWER_APP_ID);
        comment.setUserId(userIdentity.getId());
        StringBuilder commentTitle = new StringBuilder();
        String prefix = "";
        for (PropertyChangeEvent pce : question.getChangeEvent()) {
            commentTitle.append(prefix);
            prefix = "\n";
            commentTitle.append(this.getQuestionMessage(pce, question, (ExoSocialActivity)comment));
        }
        comment.setTitle(commentTitle.toString());
        return comment;
    }

    public void saveAnswer(String questionId, Answer answer, boolean isNew) {
        try {
            ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
            IdentityManager identityM = (IdentityManager)exoContainer.getComponentInstanceOfType(IdentityManager.class);
            ActivityManager activityM = (ActivityManager)exoContainer.getComponentInstanceOfType(ActivityManager.class);
            FAQService faqS = (FAQService)exoContainer.getComponentInstanceOfType(FAQService.class);
            Question question = faqS.getQuestionById(questionId);
            Identity userIdentity = identityM.getOrCreateIdentity("organization", answer.getResponseBy(), false);
            String activityId = faqS.getActivityIdForQuestion(questionId);
            if (activityId != null) {
                try {
                    String answerContent;
                    ExoSocialActivity activity = activityM.getActivity(activityId);
                    ExoSocialActivity comment = this.createCommentForAnswer(userIdentity, answer);
                    if (!comment.getTitle().equals("")) {
                        answerContent = ForumActivityBuilder.getFourFirstLines(answer.getResponses());
                        String promotedAnswer = "Comment " + answerContent + " has been promoted as an answer";
                        if (promotedAnswer.equals(comment.getTitle())) {
                            this.updateCommentTemplateParms(comment, answer.getId());
                            activityM.saveComment(activity, comment);
                            faqS.saveActivityIdForAnswer(questionId, answer, comment.getId());
                            Map<String, String> activityTemplateParams = this.updateTemplateParams(new HashMap<String, String>(), question.getId(), this.getQuestionRate(question), this.getNbOfAnswers(question), this.getNbOfComments(question), question.getLanguage(), question.getLink());
                            activity.setTemplateParams(activityTemplateParams);
                            activityM.updateActivity(activity);
                        } else {
                            activityM.saveComment(activity, comment);
                            String answerActivityId = faqS.getActivityIdForAnswer(questionId, answer);
                            faqS.saveActivityIdForAnswer(questionId, answer, answerActivityId + "," + comment.getId());
                        }
                    } else {
                        answerContent = ForumActivityBuilder.getFourFirstLines(answer.getResponses());
                        comment.setTitle("Answer has been submitted: " + answerContent);
                        I18NActivityUtils.addResourceKey((ExoSocialActivity)comment, (String)"answer-add", (String[])new String[]{answerContent});
                        Map<String, String> activityTemplateParams = this.updateTemplateParams(new HashMap<String, String>(), question.getId(), this.getQuestionRate(question), this.getNbOfAnswers(question), this.getNbOfComments(question), question.getLanguage(), question.getLink());
                        activity.setTemplateParams(activityTemplateParams);
                        activity.setBody(ForumActivityBuilder.getFourFirstLines(question.getDetail()));
                        activityM.updateActivity(activity);
                        this.updateCommentTemplateParms(comment, answer.getId());
                        activityM.saveComment(activity, comment);
                        faqS.saveActivityIdForAnswer(questionId, answer, comment.getId());
                    }
                }
                catch (Exception e) {
                    LOG.debug((Object)"Run in case of activity deleted and reupdate");
                    activityId = null;
                }
            }
            if (activityId == null) {
                this.saveQuestion(question, false);
                String newActivityId = faqS.getActivityIdForQuestion(question.getId());
                ExoSocialActivity activity = activityM.getActivity(newActivityId);
                ExoSocialActivity comment = this.createCommentForAnswer(userIdentity, answer);
                if (comment.getTitle().equals("")) {
                    String answerContent = ForumActivityBuilder.getFourFirstLines(answer.getResponses());
                    comment.setTitle("Answer has been submitted: " + answerContent);
                    I18NActivityUtils.addResourceKey((ExoSocialActivity)comment, (String)"answer-add", (String[])new String[]{answerContent});
                    this.updateCommentTemplateParms(comment, answer.getId());
                }
                activityM.saveComment(activity, comment);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Can not record Activity for space when post answer ", (Throwable)e);
        }
    }

    public void saveComment(String questionId, Comment cm, String language) {
        try {
            HashMap<String, String> commentTemplateParams;
            ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
            IdentityManager identityM = (IdentityManager)exoContainer.getComponentInstanceOfType(IdentityManager.class);
            ActivityManager activityM = (ActivityManager)exoContainer.getComponentInstanceOfType(ActivityManager.class);
            FAQService faqS = (FAQService)exoContainer.getComponentInstanceOfType(FAQService.class);
            Question question = faqS.getQuestionById(questionId);
            Identity userIdentity = identityM.getOrCreateIdentity("organization", cm.getCommentBy(), false);
            String activityId = faqS.getActivityIdForQuestion(questionId);
            if (activityId != null) {
                try {
                    ExoSocialActivity activity = activityM.getActivity(activityId);
                    ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
                    String commentActivityId = faqS.getActivityIdForComment(questionId, cm.getId(), language);
                    commentTemplateParams = new HashMap<String, String>();
                    commentTemplateParams.put(LINK_KEY, cm.getId());
                    if (commentActivityId != null) {
                        ExoSocialActivityImpl oldComment = (ExoSocialActivityImpl)activityM.getActivity(commentActivityId);
                        if (oldComment != null) {
                            comment = oldComment;
                            comment.setTitle(StringEscapeUtils.unescapeHtml((String)TransformHTML.cleanHtmlCode((String)cm.getComments(), (List)Collections.EMPTY_LIST)));
                            activityM.updateActivity((ExoSocialActivity)comment);
                        } else {
                            commentActivityId = null;
                        }
                    }
                    if (commentActivityId == null) {
                        comment.setTemplateParams(commentTemplateParams);
                        comment.setTitle(StringEscapeUtils.unescapeHtml((String)TransformHTML.cleanHtmlCode((String)cm.getComments(), (List)Collections.EMPTY_LIST)));
                        comment.setUserId(userIdentity.getId());
                        Map<String, String> activityTemplateParams = this.updateTemplateParams(new HashMap<String, String>(), question.getId(), this.getQuestionRate(question), this.getNbOfAnswers(question), this.getNbOfComments(question), question.getLanguage(), question.getLink());
                        activity.setTemplateParams(activityTemplateParams);
                        activity.setBody(ForumActivityBuilder.getFourFirstLines(question.getDetail()));
                        activityM.updateActivity(activity);
                        activityM.saveComment(activity, (ExoSocialActivity)comment);
                        faqS.saveActivityIdForComment(questionId, cm.getId(), language, comment.getId());
                    }
                }
                catch (Exception e) {
                    LOG.debug((Object)"Run in case of activity deleted and reupdate");
                    activityId = null;
                }
            }
            if (activityId == null) {
                this.saveQuestion(question, false);
                String newActivityId = faqS.getActivityIdForQuestion(questionId);
                ExoSocialActivity activity = activityM.getActivity(newActivityId);
                ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
                comment.setUserId(userIdentity.getId());
                commentTemplateParams = new HashMap();
                commentTemplateParams.put(LINK_KEY, cm.getId());
                comment.setTitle(StringEscapeUtils.unescapeHtml((String)TransformHTML.cleanHtmlCode((String)cm.getComments(), (List)Collections.EMPTY_LIST)));
                comment.setTemplateParams(commentTemplateParams);
                activityM.saveComment(activity, (ExoSocialActivity)comment);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Can not record Activity for space when post comment ", (Throwable)e);
        }
    }

    public void saveQuestion(Question question, boolean isNew) {
        try {
            ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
            IdentityManager identityM = (IdentityManager)exoContainer.getComponentInstanceOfType(IdentityManager.class);
            ActivityManager activityM = (ActivityManager)exoContainer.getComponentInstanceOfType(ActivityManager.class);
            FAQService faqS = (FAQService)exoContainer.getComponentInstanceOfType(FAQService.class);
            Identity userIdentity = identityM.getOrCreateIdentity("organization", question.getAuthor(), false);
            Map<String, String> templateParams = this.updateTemplateParams(new HashMap<String, String>(), question.getId(), this.getQuestionRate(question), this.getNbOfAnswers(question), this.getNbOfComments(question), question.getLanguage(), question.getLink());
            String activityId = faqS.getActivityIdForQuestion(question.getId());
            boolean isUpdate = false;
            if (activityId != null) {
                isUpdate = true;
                try {
                    ExoSocialActivity activity = activityM.getActivity(activityId);
                    activity.setTitle(question.getQuestion());
                    activity.setBody(ForumActivityBuilder.getFourFirstLines(question.getDetail()));
                    activity.setTemplateParams(templateParams);
                    activityM.updateActivity(activity);
                    ExoSocialActivity comment = this.createCommentWhenUpdateQuestion(userIdentity, question);
                    if (!"".equals(comment.getTitle())) {
                        activityM.saveComment(activity, comment);
                    }
                }
                catch (Exception e) {
                    LOG.debug((Object)"Run in case of activity deleted and reupdate");
                    activityId = null;
                }
            }
            if (activityId == null) {
                ExoSocialActivity comment;
                Identity streamOwner = null;
                String catId = (String)faqS.readQuestionProperty(question.getId(), "exo:categoryId", String.class);
                Identity spaceIdentity = this.getSpaceIdentity(catId);
                if (spaceIdentity != null) {
                    streamOwner = spaceIdentity;
                    templateParams.put(SPACE_GROUP_ID, this.getSpaceGroupId(catId));
                }
                List categoryIds = faqS.getCategoryPath(catId);
                Collections.reverse(categoryIds);
                if (streamOwner == null) {
                    streamOwner = userIdentity;
                }
                ExoSocialActivity activity = this.newActivity(userIdentity, question.getQuestion(), ForumActivityBuilder.getFourFirstLines(question.getDetail()), templateParams);
                activityM.saveActivityNoReturn(streamOwner, activity);
                faqS.saveActivityIdForQuestion(question.getId(), activity.getId());
                if (isUpdate && !"".equals((comment = this.createCommentWhenUpdateQuestion(userIdentity, question)).getTitle())) {
                    activityM.saveComment(activity, comment);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Can not record Activity for space when add new question ", (Throwable)e);
        }
    }

    public void saveAnswer(String questionId, Answer[] answers, boolean isNew) {
        block4: {
            try {
                Class.forName("org.exoplatform.social.core.manager.IdentityManager");
                if (answers != null) {
                    for (Answer a : answers) {
                        this.saveAnswer(questionId, a, isNew);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)("Please check the integrated project does the social deploy? " + e.getMessage()));
            }
        }
    }

    public void voteQuestion(String questionId) {
        try {
            ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
            FAQService faqS = (FAQService)exoContainer.getComponentInstanceOfType(FAQService.class);
            Question question = faqS.getQuestionById(questionId);
            question.setEditedQuestionRating(question.getMarkVote());
            this.saveQuestion(question, false);
        }
        catch (Exception e) {
            LOG.debug((Object)("Fail to vote question " + e.getMessage()));
        }
    }

    public void unVoteQuestion(String questionId) {
        try {
            ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
            FAQService faqS = (FAQService)exoContainer.getComponentInstanceOfType(FAQService.class);
            Question question = faqS.getQuestionById(questionId);
            question.setEditedQuestionRating(question.getMarkVote());
            this.saveQuestion(question, false);
        }
        catch (Exception e) {
            LOG.debug((Object)("Fail to unvote question " + e.getMessage()));
        }
    }

    public void removeQuestion(String questionActivityId) {
        try {
            ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
            ActivityManager activityM = (ActivityManager)exoContainer.getComponentInstanceOfType(ActivityManager.class);
            ExoSocialActivity activity = activityM.getActivity(questionActivityId);
            activityM.deleteActivity(activity);
        }
        catch (Exception e) {
            LOG.debug((Object)("Fail to remove activity when remove question " + e.getMessage()));
        }
    }

    public void removeAnswer(String questionPath, String answerActivityId) {
        try {
            ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
            FAQService faqS = (FAQService)exoContainer.getComponentInstanceOfType(FAQService.class);
            String questionActivityId = faqS.getActivityIdForQuestion(questionPath);
            ActivityManager activityM = (ActivityManager)exoContainer.getComponentInstanceOfType(ActivityManager.class);
            for (String id : answerActivityId.split(",")) {
                ExoSocialActivity activity = activityM.getActivity(id);
                if (activity == null) continue;
                activityM.deleteComment(questionActivityId, id);
            }
            this.refreshActivity(questionPath, questionActivityId);
        }
        catch (Exception e) {
            LOG.debug((Object)("Fail to remove comment when remove question's answer " + e.getMessage()));
        }
    }

    public void removeComment(String questionActivityId, String commentActivityId, String questionPath) {
        try {
            ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
            ActivityManager activityM = (ActivityManager)exoContainer.getComponentInstanceOfType(ActivityManager.class);
            activityM.deleteComment(questionActivityId, commentActivityId);
            this.refreshActivity(questionPath, questionActivityId);
        }
        catch (Exception e) {
            LOG.debug((Object)("Fail to remove comment when remove question's comment " + e.getMessage()));
        }
    }

    private String getQuestionRate(Question question) {
        return String.valueOf(question.getMarkVote());
    }

    private String getNbOfComments(Question question) {
        int nbComments = question.getComments() != null ? question.getComments().length : 0;
        return String.valueOf(nbComments);
    }

    private String getNbOfAnswers(Question question) {
        int nbAnswers = question.getAnswers() != null ? question.getAnswers().length : 0;
        return String.valueOf(nbAnswers);
    }

    private String getQuestionMessage(PropertyChangeEvent e, Question question, ExoSocialActivity comment) {
        if ("questionName".equals(e.getPropertyName())) {
            I18NActivityUtils.addResourceKey((ExoSocialActivity)comment, (String)"question-update-title", (String[])new String[]{question.getQuestion()});
            return "Title has been updated to: " + question.getQuestion();
        }
        if ("questionDetail".equals(e.getPropertyName())) {
            I18NActivityUtils.addResourceKey((ExoSocialActivity)comment, (String)"question-update-detail", (String[])new String[]{ForumActivityBuilder.getFourFirstLines(question.getDetail())});
            return "Details has been edited to: " + ForumActivityBuilder.getFourFirstLines(question.getDetail());
        }
        if ("questionActivated".equals(e.getPropertyName())) {
            if (question.isActivated()) {
                I18NActivityUtils.addResourceKey((ExoSocialActivity)comment, (String)"question-activated", null);
                return "Question has been activated.";
            }
            I18NActivityUtils.addResourceKey((ExoSocialActivity)comment, (String)"question-unactivated", null);
            return "Question has been unactivated.";
        }
        if ("questionAttachment".equals(e.getPropertyName())) {
            I18NActivityUtils.addResourceKey((ExoSocialActivity)comment, (String)"question-add-attachment", null);
            return "Attachment(s) has been added.";
        }
        int length = question.getMultiLanguages().length;
        I18NActivityUtils.addResourceKey((ExoSocialActivity)comment, (String)"question-add-language", (String[])new String[]{question.getMultiLanguages()[length - 1].getLanguage()});
        return "Question has been added in " + question.getMultiLanguages()[length - 1].getLanguage();
    }

    private String getAnswerMessage(PropertyChangeEvent e, Answer answer, ExoSocialActivity comment) {
        String answerContent = ForumActivityBuilder.getFourFirstLines(answer.getResponses());
        if ("answerEdit".equals(e.getPropertyName())) {
            I18NActivityUtils.addResourceKey((ExoSocialActivity)comment, (String)"answer-update-content", (String[])new String[]{answerContent});
            return "Answer has been edited to: " + answerContent;
        }
        if ("answerPromoted".equals(e.getPropertyName())) {
            I18NActivityUtils.addResourceKey((ExoSocialActivity)comment, (String)"answer-promoted", (String[])new String[]{answerContent});
            return "Comment " + answerContent + " has been promoted as an answer";
        }
        if ("answerActivated".equals(e.getPropertyName())) {
            if (answer.getActivateAnswers()) {
                I18NActivityUtils.addResourceKey((ExoSocialActivity)comment, (String)"answer-activated", (String[])new String[]{answerContent});
                return "Answer has been activated: " + answerContent + ".";
            }
            I18NActivityUtils.addResourceKey((ExoSocialActivity)comment, (String)"answer-unactivated", (String[])new String[]{answerContent});
            return "Answer has been unactivated: " + answerContent + ".";
        }
        if (answer.getApprovedAnswers()) {
            I18NActivityUtils.addResourceKey((ExoSocialActivity)comment, (String)"answer-approved", (String[])new String[]{answerContent});
            return "Answer has been approved: " + answerContent + ".";
        }
        I18NActivityUtils.addResourceKey((ExoSocialActivity)comment, (String)"answer-disapproved", (String[])new String[]{answerContent});
        return "Answer has been disapproved: " + answerContent + ".";
    }

    private void refreshActivity(String questionId, String questionActivityId) {
        try {
            ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
            FAQService faqS = (FAQService)exoContainer.getComponentInstanceOfType(FAQService.class);
            Question question = faqS.getQuestionById(questionId);
            ActivityManager activityM = (ActivityManager)exoContainer.getComponentInstanceOfType(ActivityManager.class);
            ExoSocialActivity activity = activityM.getActivity(questionActivityId);
            Map<String, String> templateParams = this.updateTemplateParams(new HashMap<String, String>(), question.getId(), this.getQuestionRate(question), this.getNbOfAnswers(question), this.getNbOfComments(question), question.getLanguage(), question.getLink());
            activity.setTemplateParams(templateParams);
            activity.setBody(ForumActivityBuilder.getFourFirstLines(question.getDetail()));
            activityM.updateActivity(activity);
        }
        catch (Exception e) {
            LOG.debug((Object)("Fail to refresh activity " + e.getMessage()));
        }
    }

    private void updateCommentTemplateParms(ExoSocialActivity comment, String link) {
        HashMap<String, String> commentTemplateParams = comment.getTemplateParams();
        if (commentTemplateParams == null) {
            commentTemplateParams = new HashMap<String, String>();
        }
        commentTemplateParams.put(LINK_KEY, link);
        comment.setTemplateParams(commentTemplateParams);
    }
}

