/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.ext.impl;

import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.webui.WebUIUtils;
import org.exoplatform.forum.ext.activity.BuildLinkUtils;
import org.exoplatform.forum.ext.activity.ForumActivityBuilder;
import org.exoplatform.forum.ext.activity.ForumActivityContext;
import org.exoplatform.forum.ext.activity.ForumActivityUtils;
import org.exoplatform.forum.ext.impl.BaseKSActivity;
import org.exoplatform.forum.ext.impl.ForumSpaceActivityPublisher;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.processor.I18NActivityProcessor;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormTextAreaInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/forum/social-integration/plugin/space/ForumUIActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.LoadLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.EditActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.EditCommentActionListener.class})})
public class ForumUIActivity
extends BaseKSActivity {
    private static final Log LOG = ExoLogger.getLogger(ForumUIActivity.class);
    private static final String SPACE_GROUP_ID = "SpaceGroupId";

    protected String getReplyLink() {
        String viewLink = this.buildLink();
        StringBuffer sb = new StringBuffer(viewLink);
        if (sb.lastIndexOf("/") == -1 || sb.lastIndexOf("/") != sb.length() - 1) {
            sb.append("/");
        }
        sb.append("lastpost/false");
        return sb.toString();
    }

    private String buildLink() {
        String topicId = this.getActivityParamValue("TopicId");
        String forumId = this.getActivityParamValue("ForumId");
        try {
            return BuildLinkUtils.buildLink(forumId, topicId, BuildLinkUtils.PORTLET_INFO.FORUM);
        }
        catch (Exception ex) {
            return "";
        }
    }

    private String getLink(String tagLink, String nameLink) {
        String link = this.buildLink();
        return String.format(tagLink, link, nameLink);
    }

    public String getViewLink() {
        return this.buildLink();
    }

    public String getLastReplyLink() {
        String viewLink = this.buildLink();
        return Utils.isEmpty((String)viewLink) ? "" : viewLink.concat("/lastpost");
    }

    protected String getViewPostLink(ExoSocialActivity activity) {
        String topicView = this.buildLink();
        Map templateParams = activity.getTemplateParams();
        if (templateParams != null && templateParams.containsKey("PostId")) {
            return topicView.concat("/").concat((String)templateParams.get("PostId"));
        }
        return "";
    }

    protected String getActivityContentTitle(WebuiBindingContext _ctx, String herf) throws Exception {
        String title = this.getActivity().getTitle();
        String linkTag = "";
        try {
            linkTag = this.getLink(herf, title);
        }
        catch (Exception e) {
            LOG.debug((Object)"Failed to get activity content and title ", (Throwable)e);
        }
        return linkTag;
    }

    public String getNumberOfReplies() {
        String got = this.getActivityParamValue("NumberOfReplies");
        if (Utils.isEmpty((String)got) && this.getTopic() != null) {
            got = "" + this.getTopic().getPostCount();
        }
        int nbReplies = Integer.parseInt(Utils.isEmpty((String)got) ? "0" : got);
        switch (nbReplies) {
            case 0: {
                return WebUIUtils.getLabel(null, (String)"ForumUIActivity.label.noReply");
            }
            case 1: {
                return WebUIUtils.getLabel(null, (String)"ForumUIActivity.label.oneReply").replace("{0}", got);
            }
        }
        return WebUIUtils.getLabel(null, (String)"ForumUIActivity.label.replies").replace("{0}", got);
    }

    public double getRate() {
        String got = this.getActivityParamValue("TopicVoteRate");
        if (Utils.isEmpty((String)got) && this.getTopic() != null) {
            got = "" + this.getTopic().getVoteRating();
        }
        try {
            return Double.parseDouble(got);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private Topic getTopic() {
        String topicId = this.getActivityParamValue("TopicId");
        try {
            String categoryId = this.getActivityParamValue("CateId");
            String forumId = this.getActivityParamValue("ForumId");
            return ForumActivityUtils.getForumService().getTopic(categoryId, forumId, topicId, "");
        }
        catch (Exception e) {
            try {
                return (Topic)ForumActivityUtils.getForumService().getObjectNameById(topicId, Utils.TOPIC);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public boolean isTopicActivity() {
        return !Utils.isEmpty((String)this.getActivityParamValue("TopicId"));
    }

    public boolean isLockedOrClosed() {
        Topic topic = this.getTopic();
        if (topic == null || topic.getIsClosed() || topic.getIsLock()) {
            return true;
        }
        Forum forum = ForumActivityUtils.getForumService().getForum(topic.getCategoryId(), topic.getForumId());
        if (forum == null) {
            return true;
        }
        return forum.getIsClosed() || forum.getIsLock();
    }

    public Post createPost(String message, Post parentPost, WebuiRequestContext requestContext) {
        try {
            Topic topic = this.getTopic();
            Post post = new Post();
            post.setOwner(requestContext.getRemoteUser());
            post.setIcon("IconsView");
            post.setName("Re: " + topic.getTopicName());
            post.setLink(topic.getLink());
            PortalRequestContext context = Util.getPortalRequestContext();
            String remoteAddr = context.getRequest().getRemoteAddr();
            post.setRemoteAddr(remoteAddr);
            post.setModifiedBy(requestContext.getRemoteUser());
            message = message.replace("<p>", "").replace("</p>", "\n");
            post.setMessage(message);
            ((ForumService)this.getApplicationComponent(ForumService.class)).savePost(topic.getCategoryId(), topic.getForumId(), topic.getId(), post, true, new MessageBuilder());
            ExoSocialActivity activity = this.getActivity();
            activity = ForumActivityBuilder.updateNumberOfReplies(activity, false);
            ForumActivityUtils.updateActivities(activity);
            return post;
        }
        catch (Exception e) {
            return null;
        }
    }

    private ExoSocialActivity saveComment(String parentId, String message) {
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setUserId(org.exoplatform.social.webui.Utils.getViewerIdentity().getId());
        comment.setTitle(message);
        comment.setBody(message);
        comment.setParentCommentId(parentId);
        ForumActivityUtils.getActivityManager().saveComment(this.getActivity(), (ExoSocialActivity)comment);
        return comment;
    }

    protected ExoSocialActivity getI18N(ExoSocialActivity activity) {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        I18NActivityProcessor i18NActivityProcessor = (I18NActivityProcessor)this.getApplicationComponent(I18NActivityProcessor.class);
        if (activity.getTitleId() != null) {
            Locale userLocale = requestContext.getLocale();
            activity = i18NActivityProcessor.processKeys(activity, userLocale);
        }
        if (!CommonUtils.isEmpty((String)activity.getTitle())) {
            String title = activity.getTitle().replaceAll("&amp;", "&");
            if (title.indexOf("<script") >= 0) {
                title = title.replace("<script", "&lt;script").replace("</script>", "&lt;/script&gt;");
            }
            activity.setTitle(title);
        }
        if (!CommonUtils.isEmpty((String)activity.getBody()) && !activity.isComment()) {
            activity.setBody(activity.getBody().replaceAll("&amp;", "&"));
        }
        return activity;
    }

    public String getSpaceGroupId() {
        return this.getActivityParamValue(SPACE_GROUP_ID);
    }

    public static class PostCommentActionListener
    extends BaseUIActivity.PostCommentActionListener {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            ExoSocialActivity parentActivity;
            ForumUIActivity uiActivity = (ForumUIActivity)((Object)event.getSource());
            if (!uiActivity.isTopicActivity()) {
                super.execute(event);
                return;
            }
            String commentId = event.getRequestContext().getRequestParameter("objectId");
            commentId = StringUtils.isBlank((String)commentId) ? null : commentId;
            WebuiRequestContext requestContext = event.getRequestContext();
            UIFormTextAreaInput uiFormComment = (UIFormTextAreaInput)uiActivity.getChild(UIFormTextAreaInput.class);
            String message = (String)uiFormComment.getValue();
            uiFormComment.reset();
            ExoSocialActivity newComment = uiActivity.saveComment(commentId, message);
            Post parentPost = null;
            String postMessage = newComment.getBody();
            if (StringUtils.isNotBlank((String)commentId) && (parentPost = ForumActivityUtils.getPost(parentActivity = ForumActivityUtils.getActivityManager().getActivity(commentId))) != null) {
                String parentPostUserFullName = ForumActivityUtils.getForumService().getScreenName(parentPost.getOwner());
                postMessage = parentPost.getMessage().replaceAll("<br/>((\\r)?(\\n)?( )*(\\&nbsp;)*)*<br/>", "");
                postMessage = "[QUOTE=" + parentPostUserFullName + "]" + HTMLSanitizer.sanitize((String)postMessage) + "[/QUOTE]" + newComment.getBody();
            }
            ForumSpaceActivityPublisher.ACTIVITY_COMMENT_CREATED.set(true);
            Post post = uiActivity.createPost(postMessage, parentPost, requestContext);
            if (post != null) {
                post.setMessage(newComment.getBody());
                ForumActivityContext ctx = ForumActivityContext.makeContextForAddPost(post);
                newComment = ForumActivityBuilder.updateActivityComment(newComment, ctx.getPost(), ctx);
                newComment.setTitle(post.getMessage());
                newComment.setBody(post.getMessage());
                ForumActivityUtils.updateActivities(newComment);
                ForumActivityUtils.takeCommentBack(post, newComment);
                uiActivity.refresh();
            }
            uiActivity.setCommentFormFocused(true);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiActivity);
            uiActivity.getAndSetUpdatedCommentId(commentId);
            uiActivity.focusToComment(newComment.getId());
            uiActivity.getParent().broadcast(event, event.getExecutionPhase());
        }
    }
}

