/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.ext.common;

import java.util.List;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ks.common.user.CommonContact;
import org.exoplatform.ks.common.user.ContactProvider;
import org.exoplatform.ks.common.user.DefaultContactProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;

public class SocialContactProvider
implements ContactProvider {
    private static Log log = ExoLogger.getLogger(SocialContactProvider.class);

    public CommonContact getCommonContact(String userId) {
        CommonContact contact = new CommonContact();
        try {
            String str;
            List profiles;
            IdentityManager identityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
            Identity userIdentity = identityM.getOrCreateIdentity("organization", userId, true);
            Profile profile = userIdentity.getProfile();
            contact.setEmailAddress(profile.getEmail());
            contact.setFullName(profile.getFullName());
            contact.setAvatarUrl(profile.getAvatarUrl());
            if (profile.contains("firstName")) {
                contact.setFirstName(profile.getProperty("firstName").toString());
            }
            if (profile.contains("lastName")) {
                contact.setLastName(profile.getProperty("lastName").toString());
            }
            if (profile.contains("gender")) {
                contact.setGender(profile.getProperty("gender").toString());
            }
            if (profile.contains("phones")) {
                profiles = (List)profile.getProperty("phones");
                for (Map mapInfo : profiles) {
                    try {
                        str = (String)mapInfo.get("key");
                        if (str == null || str.length() <= 0) continue;
                        if (str.equals("Work")) {
                            str = (String)mapInfo.get("value");
                            if (contact.getWorkPhone().length() > 0) {
                                str = contact.getWorkPhone() + ", " + str;
                            }
                            contact.setWorkPhone(str);
                            continue;
                        }
                        if (!str.equals("Home")) continue;
                        str = (String)mapInfo.get("value");
                        if (contact.getHomePhone().length() > 0) {
                            str = contact.getHomePhone() + ", " + str;
                        }
                        contact.setHomePhone(str);
                    }
                    catch (Exception e) {}
                }
            }
            if (profile.contains("urls")) {
                profiles = (List)profile.getProperty("urls");
                for (Map mapInfo : profiles) {
                    try {
                        str = (String)mapInfo.get("key");
                        if (str == null || str.length() <= 0 || !str.equals("url")) continue;
                        str = (String)mapInfo.get("value");
                        if (contact.getWebSite().length() > 0) {
                            str = contact.getWebSite() + "," + str;
                        }
                        contact.setWebSite(str);
                    }
                    catch (Exception e) {}
                }
            } else {
                contact.setWebSite(LinkProvider.getProfileUri((String)userId));
            }
        }
        catch (Exception e) {
            log.warn((Object)("Could not retrieve forum user profile for " + userId + " by SocialContactProvider, DefaultContactProvider will be used.\nCaused by:"), (Throwable)e);
            OrganizationService orgService = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
            DefaultContactProvider provider = new DefaultContactProvider(orgService);
            contact = provider.getCommonContact(userId);
        }
        return contact;
    }
}

